 /*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @flow
 */

import {AbstractCrudObject} from './../abstract-crud-object';

/**
 * AdCreativeLinkDataCallToActionValue
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */
export default class AdCreativeLinkDataCallToActionValue extends AbstractCrudObject {
  static get Fields (): Object {
    return Object.freeze({
      android_url: 'android_url',
      app_destination: 'app_destination',
      app_link: 'app_link',
      application: 'application',
      event_id: 'event_id',
      ios_url: 'ios_url',
      land_on_whatsapp_catalog: 'land_on_whatsapp_catalog',
      land_on_whatsapp_profile: 'land_on_whatsapp_profile',
      lead_gen_form_id: 'lead_gen_form_id',
      link: 'link',
      link_caption: 'link_caption',
      link_format: 'link_format',
      object_store_urls: 'object_store_urls',
      page: 'page',
      product_link: 'product_link',
      whatsapp_number: 'whatsapp_number',
    });
  }

}
