 /*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @flow
 */

import {AbstractCrudObject} from './../abstract-crud-object';

/**
 * CatalogSubVerticalList
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */
export default class CatalogSubVerticalList extends AbstractCrudObject {
  static get Fields (): Object {
    return Object.freeze({
      appliances: 'appliances',
      baby_feeding: 'baby_feeding',
      baby_transport: 'baby_transport',
      beauty: 'beauty',
      bedding: 'bedding',
      cameras: 'cameras',
      cameras_and_photos: 'cameras_and_photos',
      cell_phones_and_smart_watches: 'cell_phones_and_smart_watches',
      cleaning_supplies: 'cleaning_supplies',
      clo_offer: 'clo_offer',
      clothing: 'clothing',
      clothing_accessories: 'clothing_accessories',
      computer_components: 'computer_components',
      computers_and_tablets: 'computers_and_tablets',
      computers_laptops_and_tablets: 'computers_laptops_and_tablets',
      diapering_and_potty_training: 'diapering_and_potty_training',
      electronic_accessories_and_cables: 'electronic_accessories_and_cables',
      electronics_accessories: 'electronics_accessories',
      furniture: 'furniture',
      health: 'health',
      home: 'home',
      home_goods: 'home_goods',
      household_and_cleaning_supplies: 'household_and_cleaning_supplies',
      jewelry: 'jewelry',
      large_appliances: 'large_appliances',
      local_service_business_item: 'local_service_business_item',
      local_service_business_restaurant: 'local_service_business_restaurant',
      loyalty_offer: 'loyalty_offer',
      nursery: 'nursery',
      printers_and_scanners: 'printers_and_scanners',
      printers_scanners_and_fax_machines: 'printers_scanners_and_fax_machines',
      product_discount: 'product_discount',
      projectors: 'projectors',
      shoes: 'shoes',
      shoes_and_footwear: 'shoes_and_footwear',
      software: 'software',
      televisions_and_monitors: 'televisions_and_monitors',
      test_child_sub_vertical: 'test_child_sub_vertical',
      test_grand_child_sub_vertical: 'test_grand_child_sub_vertical',
      test_sub_vertical: 'test_sub_vertical',
      test_sub_vertical_alias: 'test_sub_vertical_alias',
      test_sub_vertical_data_object: 'test_sub_vertical_data_object',
      third_party_electronics: 'third_party_electronics',
      third_party_toys_and_games: 'third_party_toys_and_games',
      toys: 'toys',
      toys_and_games: 'toys_and_games',
      tvs_and_monitors: 'tvs_and_monitors',
      vehicle_manufacturer: 'vehicle_manufacturer',
      video_game_consoles_and_video_games: 'video_game_consoles_and_video_games',
      video_games_and_consoles: 'video_games_and_consoles',
      video_projectors: 'video_projectors',
      watches: 'watches',
    });
  }

}
