 /*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @flow
 */

import {AbstractCrudObject} from './../abstract-crud-object';
import AbstractObject from './../abstract-object';
import Cursor from './../cursor';

/**
 * IGUserExportForCAM
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */
export default class IGUserExportForCAM extends AbstractCrudObject {
  static get Fields (): Object {
    return Object.freeze({
      age_bucket: 'age_bucket',
      biography: 'biography',
      country: 'country',
      email: 'email',
      gender: 'gender',
      has_brand_partnership_experience: 'has_brand_partnership_experience',
      id: 'id',
      is_account_verified: 'is_account_verified',
      is_paid_partnership_messages_enabled: 'is_paid_partnership_messages_enabled',
      messaging_id: 'messaging_id',
      onboarded_status: 'onboarded_status',
      past_brand_partnership_partners: 'past_brand_partnership_partners',
      portfolio_url: 'portfolio_url',
      username: 'username',
    });
  }

  static get CreatorCountries (): Object {
    return Object.freeze({
      ac: 'AC',
      ad: 'AD',
      ae: 'AE',
      af: 'AF',
      ag: 'AG',
      ai: 'AI',
      al: 'AL',
      am: 'AM',
      an: 'AN',
      ao: 'AO',
      aq: 'AQ',
      ar: 'AR',
      as: 'AS',
      at: 'AT',
      au: 'AU',
      aw: 'AW',
      ax: 'AX',
      az: 'AZ',
      ba: 'BA',
      bb: 'BB',
      bd: 'BD',
      be: 'BE',
      bf: 'BF',
      bg: 'BG',
      bh: 'BH',
      bi: 'BI',
      bj: 'BJ',
      bl: 'BL',
      bm: 'BM',
      bn: 'BN',
      bo: 'BO',
      bq: 'BQ',
      br: 'BR',
      bs: 'BS',
      bt: 'BT',
      bv: 'BV',
      bw: 'BW',
      by: 'BY',
      bz: 'BZ',
      ca: 'CA',
      cc: 'CC',
      cd: 'CD',
      cf: 'CF',
      cg: 'CG',
      ch: 'CH',
      ci: 'CI',
      ck: 'CK',
      cl: 'CL',
      cm: 'CM',
      cn: 'CN',
      co: 'CO',
      cr: 'CR',
      cu: 'CU',
      cv: 'CV',
      cw: 'CW',
      cx: 'CX',
      cy: 'CY',
      cz: 'CZ',
      de: 'DE',
      dj: 'DJ',
      dk: 'DK',
      dm: 'DM',
      do: 'DO',
      dz: 'DZ',
      ec: 'EC',
      ee: 'EE',
      eg: 'EG',
      eh: 'EH',
      er: 'ER',
      es: 'ES',
      et: 'ET',
      fi: 'FI',
      fj: 'FJ',
      fk: 'FK',
      fm: 'FM',
      fo: 'FO',
      fr: 'FR',
      ga: 'GA',
      gb: 'GB',
      gd: 'GD',
      ge: 'GE',
      gf: 'GF',
      gg: 'GG',
      gh: 'GH',
      gi: 'GI',
      gl: 'GL',
      gm: 'GM',
      gn: 'GN',
      gp: 'GP',
      gq: 'GQ',
      gr: 'GR',
      gs: 'GS',
      gt: 'GT',
      gu: 'GU',
      gw: 'GW',
      gy: 'GY',
      hk: 'HK',
      hm: 'HM',
      hn: 'HN',
      hr: 'HR',
      ht: 'HT',
      hu: 'HU',
      id: 'ID',
      ie: 'IE',
      il: 'IL',
      im: 'IM',
      in: 'IN',
      io: 'IO',
      iq: 'IQ',
      ir: 'IR',
      is: 'IS',
      it: 'IT',
      je: 'JE',
      jm: 'JM',
      jo: 'JO',
      jp: 'JP',
      ke: 'KE',
      kg: 'KG',
      kh: 'KH',
      ki: 'KI',
      km: 'KM',
      kn: 'KN',
      kp: 'KP',
      kr: 'KR',
      kw: 'KW',
      ky: 'KY',
      kz: 'KZ',
      la: 'LA',
      lb: 'LB',
      lc: 'LC',
      li: 'LI',
      lk: 'LK',
      lr: 'LR',
      ls: 'LS',
      lt: 'LT',
      lu: 'LU',
      lv: 'LV',
      ly: 'LY',
      ma: 'MA',
      mc: 'MC',
      md: 'MD',
      me: 'ME',
      mf: 'MF',
      mg: 'MG',
      mh: 'MH',
      mk: 'MK',
      ml: 'ML',
      mm: 'MM',
      mn: 'MN',
      mo: 'MO',
      mp: 'MP',
      mq: 'MQ',
      mr: 'MR',
      ms: 'MS',
      mt: 'MT',
      mu: 'MU',
      mv: 'MV',
      mw: 'MW',
      mx: 'MX',
      my: 'MY',
      mz: 'MZ',
      na: 'NA',
      nc: 'NC',
      ne: 'NE',
      nf: 'NF',
      ng: 'NG',
      ni: 'NI',
      nl: 'NL',
      no: 'NO',
      np: 'NP',
      nr: 'NR',
      nu: 'NU',
      nz: 'NZ',
      om: 'OM',
      pa: 'PA',
      pe: 'PE',
      pf: 'PF',
      pg: 'PG',
      ph: 'PH',
      pk: 'PK',
      pl: 'PL',
      pm: 'PM',
      pn: 'PN',
      pr: 'PR',
      ps: 'PS',
      pt: 'PT',
      pw: 'PW',
      py: 'PY',
      qa: 'QA',
      re: 'RE',
      ro: 'RO',
      rs: 'RS',
      ru: 'RU',
      rw: 'RW',
      sa: 'SA',
      sb: 'SB',
      sc: 'SC',
      sd: 'SD',
      se: 'SE',
      sg: 'SG',
      sh: 'SH',
      si: 'SI',
      sj: 'SJ',
      sk: 'SK',
      sl: 'SL',
      sm: 'SM',
      sn: 'SN',
      so: 'SO',
      sr: 'SR',
      ss: 'SS',
      st: 'ST',
      sv: 'SV',
      sx: 'SX',
      sy: 'SY',
      sz: 'SZ',
      tc: 'TC',
      td: 'TD',
      tf: 'TF',
      tg: 'TG',
      th: 'TH',
      tj: 'TJ',
      tk: 'TK',
      tl: 'TL',
      tm: 'TM',
      tn: 'TN',
      to: 'TO',
      tr: 'TR',
      tt: 'TT',
      tv: 'TV',
      tw: 'TW',
      tz: 'TZ',
      ua: 'UA',
      ug: 'UG',
      um: 'UM',
      us: 'US',
      uy: 'UY',
      uz: 'UZ',
      va: 'VA',
      vc: 'VC',
      ve: 'VE',
      vg: 'VG',
      vi: 'VI',
      vn: 'VN',
      vu: 'VU',
      wf: 'WF',
      ws: 'WS',
      xk: 'XK',
      ye: 'YE',
      yt: 'YT',
      za: 'ZA',
      zm: 'ZM',
      zw: 'ZW',
    });
  }
  static get CreatorGender (): Object {
    return Object.freeze({
      custom: 'custom',
      female: 'female',
      male: 'male',
      unknown: 'unknown',
    });
  }
  static get MajorAudienceCountries (): Object {
    return Object.freeze({
      ac: 'AC',
      ad: 'AD',
      ae: 'AE',
      af: 'AF',
      ag: 'AG',
      ai: 'AI',
      al: 'AL',
      am: 'AM',
      an: 'AN',
      ao: 'AO',
      aq: 'AQ',
      ar: 'AR',
      as: 'AS',
      at: 'AT',
      au: 'AU',
      aw: 'AW',
      ax: 'AX',
      az: 'AZ',
      ba: 'BA',
      bb: 'BB',
      bd: 'BD',
      be: 'BE',
      bf: 'BF',
      bg: 'BG',
      bh: 'BH',
      bi: 'BI',
      bj: 'BJ',
      bl: 'BL',
      bm: 'BM',
      bn: 'BN',
      bo: 'BO',
      bq: 'BQ',
      br: 'BR',
      bs: 'BS',
      bt: 'BT',
      bv: 'BV',
      bw: 'BW',
      by: 'BY',
      bz: 'BZ',
      ca: 'CA',
      cc: 'CC',
      cd: 'CD',
      cf: 'CF',
      cg: 'CG',
      ch: 'CH',
      ci: 'CI',
      ck: 'CK',
      cl: 'CL',
      cm: 'CM',
      cn: 'CN',
      co: 'CO',
      cr: 'CR',
      cu: 'CU',
      cv: 'CV',
      cw: 'CW',
      cx: 'CX',
      cy: 'CY',
      cz: 'CZ',
      de: 'DE',
      dj: 'DJ',
      dk: 'DK',
      dm: 'DM',
      do: 'DO',
      dz: 'DZ',
      ec: 'EC',
      ee: 'EE',
      eg: 'EG',
      eh: 'EH',
      er: 'ER',
      es: 'ES',
      et: 'ET',
      fi: 'FI',
      fj: 'FJ',
      fk: 'FK',
      fm: 'FM',
      fo: 'FO',
      fr: 'FR',
      ga: 'GA',
      gb: 'GB',
      gd: 'GD',
      ge: 'GE',
      gf: 'GF',
      gg: 'GG',
      gh: 'GH',
      gi: 'GI',
      gl: 'GL',
      gm: 'GM',
      gn: 'GN',
      gp: 'GP',
      gq: 'GQ',
      gr: 'GR',
      gs: 'GS',
      gt: 'GT',
      gu: 'GU',
      gw: 'GW',
      gy: 'GY',
      hk: 'HK',
      hm: 'HM',
      hn: 'HN',
      hr: 'HR',
      ht: 'HT',
      hu: 'HU',
      id: 'ID',
      ie: 'IE',
      il: 'IL',
      im: 'IM',
      in: 'IN',
      io: 'IO',
      iq: 'IQ',
      ir: 'IR',
      is: 'IS',
      it: 'IT',
      je: 'JE',
      jm: 'JM',
      jo: 'JO',
      jp: 'JP',
      ke: 'KE',
      kg: 'KG',
      kh: 'KH',
      ki: 'KI',
      km: 'KM',
      kn: 'KN',
      kp: 'KP',
      kr: 'KR',
      kw: 'KW',
      ky: 'KY',
      kz: 'KZ',
      la: 'LA',
      lb: 'LB',
      lc: 'LC',
      li: 'LI',
      lk: 'LK',
      lr: 'LR',
      ls: 'LS',
      lt: 'LT',
      lu: 'LU',
      lv: 'LV',
      ly: 'LY',
      ma: 'MA',
      mc: 'MC',
      md: 'MD',
      me: 'ME',
      mf: 'MF',
      mg: 'MG',
      mh: 'MH',
      mk: 'MK',
      ml: 'ML',
      mm: 'MM',
      mn: 'MN',
      mo: 'MO',
      mp: 'MP',
      mq: 'MQ',
      mr: 'MR',
      ms: 'MS',
      mt: 'MT',
      mu: 'MU',
      mv: 'MV',
      mw: 'MW',
      mx: 'MX',
      my: 'MY',
      mz: 'MZ',
      na: 'NA',
      nc: 'NC',
      ne: 'NE',
      nf: 'NF',
      ng: 'NG',
      ni: 'NI',
      nl: 'NL',
      no: 'NO',
      np: 'NP',
      nr: 'NR',
      nu: 'NU',
      nz: 'NZ',
      om: 'OM',
      pa: 'PA',
      pe: 'PE',
      pf: 'PF',
      pg: 'PG',
      ph: 'PH',
      pk: 'PK',
      pl: 'PL',
      pm: 'PM',
      pn: 'PN',
      pr: 'PR',
      ps: 'PS',
      pt: 'PT',
      pw: 'PW',
      py: 'PY',
      qa: 'QA',
      re: 'RE',
      ro: 'RO',
      rs: 'RS',
      ru: 'RU',
      rw: 'RW',
      sa: 'SA',
      sb: 'SB',
      sc: 'SC',
      sd: 'SD',
      se: 'SE',
      sg: 'SG',
      sh: 'SH',
      si: 'SI',
      sj: 'SJ',
      sk: 'SK',
      sl: 'SL',
      sm: 'SM',
      sn: 'SN',
      so: 'SO',
      sr: 'SR',
      ss: 'SS',
      st: 'ST',
      sv: 'SV',
      sx: 'SX',
      sy: 'SY',
      sz: 'SZ',
      tc: 'TC',
      td: 'TD',
      tf: 'TF',
      tg: 'TG',
      th: 'TH',
      tj: 'TJ',
      tk: 'TK',
      tl: 'TL',
      tm: 'TM',
      tn: 'TN',
      to: 'TO',
      tr: 'TR',
      tt: 'TT',
      tv: 'TV',
      tw: 'TW',
      tz: 'TZ',
      ua: 'UA',
      ug: 'UG',
      um: 'UM',
      us: 'US',
      uy: 'UY',
      uz: 'UZ',
      va: 'VA',
      vc: 'VC',
      ve: 'VE',
      vg: 'VG',
      vi: 'VI',
      vn: 'VN',
      vu: 'VU',
      wf: 'WF',
      ws: 'WS',
      xk: 'XK',
      ye: 'YE',
      yt: 'YT',
      za: 'ZA',
      zm: 'ZM',
      zw: 'ZW',
    });
  }
  static get MajorAudienceGender (): Object {
    return Object.freeze({
      custom: 'custom',
      female: 'female',
      male: 'male',
      unknown: 'unknown',
    });
  }

  getBrandedContentMedia (fields: Array<string>, params: Object = {}, fetchFirstPage: boolean = true): Cursor | Promise<*> {
    return this.getEdge(
      AbstractObject,
      fields,
      params,
      fetchFirstPage,
      '/branded_content_media'
    );
  }

  getInsights (fields: Array<string>, params: Object = {}, fetchFirstPage: boolean = true): Cursor | Promise<*> {
    return this.getEdge(
      AbstractObject,
      fields,
      params,
      fetchFirstPage,
      '/insights'
    );
  }

  getRecentMedia (fields: Array<string>, params: Object = {}, fetchFirstPage: boolean = true): Cursor | Promise<*> {
    return this.getEdge(
      AbstractObject,
      fields,
      params,
      fetchFirstPage,
      '/recent_media'
    );
  }

  
  get (fields: Array<string>, params: Object = {}): IGUserExportForCAM {
    // $FlowFixMe : Support Generic Types
    return this.read(
      fields,
      params
    );
  }
}
