 /*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @flow
 */

import {AbstractCrudObject} from './../abstract-crud-object';

/**
 * MediaFingerprint
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */
export default class MediaFingerprint extends AbstractCrudObject {
  static get Fields (): Object {
    return Object.freeze({
      duration_in_sec: 'duration_in_sec',
      fingerprint_content_type: 'fingerprint_content_type',
      fingerprint_type: 'fingerprint_type',
      id: 'id',
      metadata: 'metadata',
      title: 'title',
      universal_content_id: 'universal_content_id',
    });
  }

  static get FingerprintContentType (): Object {
    return Object.freeze({
      am_songtrack: 'AM_SONGTRACK',
      episode: 'EPISODE',
      movie: 'MOVIE',
      other: 'OTHER',
      songtrack: 'SONGTRACK',
    });
  }

  
  get (fields: Array<string>, params: Object = {}): MediaFingerprint {
    // $FlowFixMe : Support Generic Types
    return this.read(
      fields,
      params
    );
  }

  // $FlowFixMe : Support Generic Types
  update (fields: Array<string>, params: Object = {}): MediaFingerprint {
    // $FlowFixMe : Support Generic Types
    return super.update(
      params
    );
  }
}
