const axios = require('axios');

// Build a shared axios instance that routes through proxy if configured
function createAxiosInstance() {
  const proxyUrl = process.env.PROXY_URL;

  if (!proxyUrl) {
    return axios.create();
  }

  try {
    const parsed = new URL(proxyUrl);
    const proxyConfig = {
      host: parsed.hostname,
      port: parseInt(parsed.port),
      protocol: parsed.protocol.replace(':', ''),
    };
    if (parsed.username) {
      proxyConfig.auth = {
        username: decodeURIComponent(parsed.username),
        password: decodeURIComponent(parsed.password),
      };
    }

    const instance = axios.create({ proxy: proxyConfig });
    console.log(`🌐 Proxy configured: ${parsed.protocol}//${parsed.hostname}:${parsed.port}`);
    return instance;
  } catch (e) {
    console.error('⚠️ Invalid PROXY_URL, running without proxy:', e.message);
    return axios.create();
  }
}

// Re-create instance on each require so env changes are picked up after restart
module.exports = createAxiosInstance();
