'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var fs = _interopDefault(require('fs'));
var path = _interopDefault(require('path'));

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @format
 */

// HTTP Status Code
var HTTP_STATUS = {
  OK: '200',
  NOT_MODIFIED: '304'
};

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
  return typeof obj;
} : function (obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
};









var asyncToGenerator = function (fn) {
  return function () {
    var gen = fn.apply(this, arguments);
    return new Promise(function (resolve, reject) {
      function step(key, arg) {
        try {
          var info = gen[key](arg);
          var value = info.value;
        } catch (error) {
          reject(error);
          return;
        }

        if (info.done) {
          resolve(value);
        } else {
          return Promise.resolve(value).then(function (value) {
            step("next", value);
          }, function (err) {
            step("throw", err);
          });
        }
      }

      return step("next");
    });
  };
};

var classCallCheck = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

var createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);
    if (staticProps) defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();







var get$1 = function get$1(object, property, receiver) {
  if (object === null) object = Function.prototype;
  var desc = Object.getOwnPropertyDescriptor(object, property);

  if (desc === undefined) {
    var parent = Object.getPrototypeOf(object);

    if (parent === null) {
      return undefined;
    } else {
      return get$1(parent, property, receiver);
    }
  } else if ("value" in desc) {
    return desc.value;
  } else {
    var getter = desc.get;

    if (getter === undefined) {
      return undefined;
    }

    return getter.call(receiver);
  }
};

var inherits = function (subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
};











var possibleConstructorReturn = function (self, call) {
  if (!self) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return call && (typeof call === "object" || typeof call === "function") ? call : self;
};



var set$1 = function set$1(object, property, value, receiver) {
  var desc = Object.getOwnPropertyDescriptor(object, property);

  if (desc === undefined) {
    var parent = Object.getPrototypeOf(object);

    if (parent !== null) {
      set$1(parent, property, value, receiver);
    }
  } else if ("value" in desc && desc.writable) {
    desc.value = value;
  } else {
    var setter = desc.set;

    if (setter !== undefined) {
      setter.call(receiver, value);
    }
  }

  return value;
};















var toConsumableArray = function (arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  } else {
    return Array.from(arr);
  }
};

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @format
 */
var axios = require("axios");

/**
 * Isomorphic Http Promise Requests Class
 * 
 */

var Http = function () {
  function Http() {
    classCallCheck(this, Http);
  }

  createClass(Http, null, [{
    key: 'request',

    /**
     * Request
     * @param   {String}  method
     * @param   {String}  url
     * @param   {Object}  [data]
     * @return  {Promise}
     */
    value: function request(method, url, data, files, useMultipartFormData, showHeader) {
      if (typeof window !== 'undefined' && window.XMLHttpRequest) {
        return Http.xmlHttpRequest(method, url, data);
      }
      return Http.requestPromise(method, url, data, files, useMultipartFormData, showHeader);
    }

    /**
     * XmlHttpRequest request
     * @param   {String}  method
     * @param   {String}  url
     * @param   {Object}  [data]
     * @return  {Promise}
     */

  }, {
    key: 'xmlHttpRequest',
    value: function xmlHttpRequest(method, url, data) {
      return new Promise(function (resolve, reject) {
        var request = new window.XMLHttpRequest();
        request.open(method, url);
        request.onload = function () {
          try {
            var response = JSON.parse(request.response);

            if (request.status.toString() === HTTP_STATUS.OK) {
              resolve(response);
            } else {
              reject(new Error({
                body: response,
                status: request.status
              }));
            }
          } catch (e) {
            reject(new Error({
              body: request.responseText,
              status: request.status
            }));
          }
        };
        request.setRequestHeader('Content-Type', 'application/json');
        request.setRequestHeader('Accept', 'application/json');
        request.send(JSON.stringify(data));
      });
    }

    /**
     * Request Promise
     * @param   {String}  method The HTTP method name (e.g. 'GET').
     * @param   {String}  url A full URL string.
     * @param   {Object}  [data] A mapping of request parameters where a key
     *   is the parameter name and its value is a string or an object
     *   which can be JSON-encoded.
     * @param   {Object}  [files] An optional mapping of file names to ReadStream
     *   objects. These files will be attached to the request.
     * @param   {Boolean} [useMultipartFormData] An optional flag to call with
     *   multipart/form-data.
     * @return  {Promise}
     */

  }, {
    key: 'requestPromise',
    value: function requestPromise(method, url, data, files) {
      var useMultipartFormData = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
      var showHeader = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : false;

      var options = {
        method: method,
        url: url,
        baseURL: FacebookAdsApi.GRAPH,
        json: !useMultipartFormData,
        headers: { 'User-Agent': 'fbbizsdk-nodejs-v' + FacebookAdsApi.SDK_VERSION },
        data: Object,
        resolveWithFullResponse: showHeader
      };
      // Prevent null or undefined input
      // because it can be merged with the files argument later
      if (!data) {
        data = {};
      }

      options.data = data;

      // Handle file attachments if provided
      if (useMultipartFormData || files && Object.keys(files).length > 0) {
        // Use formData instead of body (required by the request-promise library)
        options.data = Object.assign(data, files);
        delete options.data;
      }

      return axios(options).catch(function (response) {
        throw response;
      });
    }
  }]);
  return Http;
}();

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @format
 */

// request-promise error types
function FacebookError(error) {
  this.name = 'FacebookError';
  this.message = error.message;
  this.stack = new Error().stack;
}
FacebookError.prototype = Object.create(Error.prototype);
FacebookError.prototype.constructor = FacebookError;

/**
 * Raised when an api request fails.
 */
var FacebookRequestError = function (_FacebookError) {
  inherits(FacebookRequestError, _FacebookError);

  /**
   * @param  {[Object}  response
   * @param  {String}   method
   * @param  {String}   url
   * @param  {Object}   data
   */
  function FacebookRequestError(response, method, url, data) {
    classCallCheck(this, FacebookRequestError);

    var errorResponse = constructErrorResponse(response);

    var _this = possibleConstructorReturn(this, (FacebookRequestError.__proto__ || Object.getPrototypeOf(FacebookRequestError)).call(this, errorResponse));

    _this.name = 'FacebookRequestError';
    _this.message = errorResponse.message;
    _this.status = errorResponse.status;
    _this.response = errorResponse.body;
    _this.headers = errorResponse.headers;
    _this.method = method;
    _this.url = url;
    if (data) {
      _this.data = data;
    }
    return _this;
  }

  return FacebookRequestError;
}(FacebookError);

/**
 * Error response has several structures depended on called APIs or errors.
 * This method contructs and formats the response into the same structure for
 * creating a FacebookRequestError object.
 */
function constructErrorResponse(response) {
  var body = void 0;
  var message = void 0;
  var status = void 0;
  var headers = void 0;

  // Batch request error contains code and body fields
  var isBatchResponse = response.code && response.body;

  if (isBatchResponse) {
    // Handle batch response
    body = typeof response.body === 'string' ? JSON.parse(response.body) : response.body;
    status = response.code;
    message = body.error.message;
    headers = response.headers;
  } else {
    // Handle single response
    if (response.response) {
      // The request was made and the server responded with a status code
      // that falls out of the range of 2xx
      body = response.response.data.error ? response.response.data.error : response.response.data;
      body = typeof body === 'string' ? JSON.parse(body) : body;
      message = body.message;
      status = response.response.status;
      headers = response.response.headers;
    } else if (response.request) {
      body = null;
      message = "The request was made but no response was received";
      status = null;
      headers = null;
    } else {
      body = null;
      message = "Something happened in setting up the request that triggered an Error";
      status = null;
      headers = null;
    }
  }

  return { body: body, message: message, status: status, headers: headers };
}

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 * 
 * @format
 */
var CrashReporter = function () {
  function CrashReporter() {
    classCallCheck(this, CrashReporter);

    this._active = true;
  }

  createClass(CrashReporter, null, [{
    key: 'enable',
    value: function enable() {
      var _this = this;

      if (this._instance == undefined || this._instance == null) {
        this._instance = new this();
        process.on('uncaughtException', function (err) {
          if (_this._instance._active && err instanceof Error) {
            var params = privateMethods.parseParam(err);
            if (params != null) {
              console.log('CrashReporter: SDK crash detected!');
              privateMethods.processUncaughtException(err, params);
              return;
            }
          }
          console.log('CrashReporter: No SDK crash detected or crash reporter is disabled!');
          throw err;
        });
      }
    }
  }, {
    key: 'disable',
    value: function disable() {
      if (this._instance == undefined || this._instance == null) {
        return;
      }
      this._instance._active = false;
    }
  }]);
  return CrashReporter;
}();

var privateMethods = {
  processUncaughtException: function processUncaughtException(err, params) {
    FacebookAdsApi.getDefaultApi().getAppID().then(function (data) {
      if (data["data"] !== undefined && data['data']['app_id'] !== undefined) {
        var appID = data['data']['app_id'];

        console.log("active uncaughtException : " + appID);
        var url = [FacebookAdsApi.GRAPH, FacebookAdsApi.VERSION, appID, 'instruments'].join('/');

        Http.request('POST', url, params).then(function (response) {
          console.log('Successfully sent crash report.');
        }).catch(function (response) {
          console.log('Failed to send crash report.');
        }).then(function () {
          throw err;
        });
      }
    }).catch(function (error) {
      console.log("Not be able to find appID, fail to send report to server.");
      throw err;
    });
  },
  parseParam: function parseParam(err) {
    var stack = err.stack.split('\n');

    var params = {};

    if (stack.length == 0) {
      return null;
    }

    var fln = stack[0].split(':');
    params['reason'] = fln[0];
    params['callstack'] = stack;
    params['platform'] = process.version;

    for (var i = 0; i < stack.length; i++) {
      if (stack[i].includes('facebook-nodejs-business-sdk')) {
        return { 'bizsdk_crash_report': params };
      }
    }
    return null;
  }
};

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 * 
 * @format
 */
/**
 * Facebook Ads API
 */

var FacebookAdsApi = function () {
  createClass(FacebookAdsApi, null, [{
    key: 'VERSION',
    get: function get() {
      return 'v24.0';
    }
  }, {
    key: 'SDK_VERSION',
    get: function get() {
      return '24.0.0';
    }
  }, {
    key: 'GRAPH',
    get: function get() {
      return 'https://graph.facebook.com';
    }
  }, {
    key: 'GRAPH_VIDEO',
    get: function get() {
      return 'https://graph-video.facebook.com';
    }

    /**
     * @param {String} accessToken
     * @param {String} [locale]
     */

  }]);

  function FacebookAdsApi(accessToken) {
    var locale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'en_US';
    var crash_log = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    classCallCheck(this, FacebookAdsApi);

    if (!accessToken) {
      throw new Error('Access token required');
    }
    this.accessToken = accessToken;
    this.locale = locale;
    this._debug = false;
    this._showHeader = false;
    if (crash_log) {
      CrashReporter.enable();
    }
  }

  /**
   * Instantiate an API and store it as the default
   * @param  {String} accessToken
   * @param  {String} [locale]
   * @return {FacebookAdsApi}
   */


  createClass(FacebookAdsApi, [{
    key: 'getAppID',
    value: function getAppID() {
      var url = [FacebookAdsApi.GRAPH, FacebookAdsApi.VERSION, 'debug_token'].join('/');

      var params = {};

      params['access_token'] = this.accessToken;
      params['input_token'] = this.accessToken;
      params['fields'] = 'app_id';
      url += '?' + FacebookAdsApi._encodeParams(params);

      return Http.request('GET', url, {}, {}, false);
    }
  }, {
    key: 'setDebug',
    value: function setDebug(flag) {
      this._debug = flag;
      return this;
    }
  }, {
    key: 'setShowHeader',
    value: function setShowHeader(flag) {
      this._showHeader = flag;
      return this;
    }

    /**
     * Http Request
     * @param  {String} method
     * @param  {String} path
     * @param  {Object} [params]
     * @param  {Object} [files]
     * @return {Promise}
     */

  }, {
    key: 'call',
    value: function call(method, path$$1) {
      var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var files = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

      var _this = this;

      var useMultipartFormData = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
      var urlOverride = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : '';

      var url = void 0;
      var data = {};
      if (method === 'POST' || method === 'PUT') {
        data = params;
        params = {};
      }
      var domain = urlOverride || FacebookAdsApi.GRAPH;
      if (typeof path$$1 !== 'string' && !(path$$1 instanceof String)) {
        url = [domain, FacebookAdsApi.VERSION].concat(toConsumableArray(path$$1)).join('/');
        params['access_token'] = this.accessToken;
        url += '?' + FacebookAdsApi._encodeParams(params);
      } else {
        url = path$$1;
      }
      var strUrl = url;
      return Http.request(method, strUrl, data, files, useMultipartFormData, this._showHeader).then(function (response) {
        if (_this._showHeader) {
          response.data['headers'] = response.headers;
        }

        response = response.data;

        if (_this._debug) {
          console.log('200 ' + method + ' ' + url + ' ' + (Object.keys(data).length > 0 ? JSON.stringify(data) : ""));
          console.log('Response: ' + (response ? JSON.stringify(response) : ""));
        }
        return Promise.resolve(response);
      }).catch(function (response) {
        if (_this._debug && response.response) {
          console.log(response.response.status + ' ' + method + ' ' + url + '\n            ' + (Object.keys(data).length > 0 ? JSON.stringify(data) : ''));
        }
        throw new FacebookRequestError(response, method, url, data);
      });
    }
  }], [{
    key: 'init',
    value: function init(accessToken) {
      var locale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'en_US';
      var crash_log = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      var api = new this(accessToken, locale, crash_log);
      this.setDefaultApi(api);
      return api;
    }
  }, {
    key: 'setDefaultApi',
    value: function setDefaultApi(api) {
      this._defaultApi = api;
    }
  }, {
    key: 'getDefaultApi',
    value: function getDefaultApi() {
      return this._defaultApi;
    }
  }, {
    key: '_encodeParams',
    value: function _encodeParams(params) {
      return Object.keys(params).map(function (key) {
        var param = params[key];
        if ((typeof param === 'undefined' ? 'undefined' : _typeof(param)) === 'object') {
          param = param ? JSON.stringify(param) : '';
        }
        return encodeURIComponent(key) + '=' + encodeURIComponent(param);
      }).join('&');
    }
  }]);
  return FacebookAdsApi;
}();

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 * 
 * @format
 */
/**
 * Represents an API request
 */

var APIRequest = function () {

  /**
   * @param {string} nodeId The node id to perform the api call.
   * @param {string} method The HTTP method of the call.
   * @param {string} endpoint The edge of the api call.
   */
  function APIRequest(nodeId, method, endpoint) {
    classCallCheck(this, APIRequest);

    this._nodeId = nodeId;
    this._method = method;
    this._endpoint = endpoint.replace('/', '');
    this._path = [nodeId, this.endpoint];
    this._fields = [];
    this._fileParams = Object.create(null);
    this._params = Object.create(null);
    this._fileCounter = 0;
  }

  /**
   * Getter function for node ID
   * @return {string} Node ID
   */


  createClass(APIRequest, [{
    key: 'addFile',


    /**
     * @param {string} filePath Path to file attached to the request
     * @return {APIReqeust} APIRequest instance
     */
    value: function addFile(filePath) {
      var fileKey = 'source' + this._fileCounter;
      var stats = fs.lstatSync(filePath);

      if (!stats.isFile()) {
        throw Error('Cannot find file ' + filePath + '!');
      }

      this._fileParams[fileKey] = filePath;
      this._fileCounter += 1;

      return this;
    }

    /**
     * @param {string[]} filePaths Array of paths to files attached to the request
     * @return {APIRequest} APIRequest instance
     */

  }, {
    key: 'addFiles',
    value: function addFiles(filePaths) {
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = filePaths[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var filePath = _step.value;

          this.addFile(filePath);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return this;
    }

    /**
     * @param {string} field Requested field
     * @return {APIReqeust} APIRequest instance
     */

  }, {
    key: 'addField',
    value: function addField(field) {
      if (!this._fields.includes(field)) {
        this._fields.push(field);
      }

      return this;
    }

    /**
     * @param {string[]} fields Array of requested fields
     * @return {APIRequest} APIRequest instance
     */

  }, {
    key: 'addFields',
    value: function addFields(fields) {
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = fields[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var field = _step2.value;

          this.addField(field);
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      return this;
    }

    /**
     * @param {string} key Param key
     * @param {*} value Param value
     * @return {APIRequest} APIRequest instance
     */

  }, {
    key: 'addParam',
    value: function addParam(key, value) {
      this._params[key] = value;

      return this;
    }

    /**
     * @param {Object} params An object containing param keys and values
     * @return {APIRequest} APIRequest instance
     */

  }, {
    key: 'addParams',
    value: function addParams(params) {
      this._params = params;

      return this;
    }
  }, {
    key: 'nodeId',
    get: function get() {
      return this._nodeId;
    }

    /**
     * Getter function for HTTP method e.g. GET, POST
     * @return {string} HTTP method
     */

  }, {
    key: 'method',
    get: function get() {
      return this._method;
    }

    /**
     * Getter function for the edge of the API call
     * @return {string} Endpoint edge
     */

  }, {
    key: 'endpoint',
    get: function get() {
      return this._endpoint;
    }

    /**
     * Getter function for path tokens
     * @return {Array<string>} Array of path tokens
     */

  }, {
    key: 'path',
    get: function get() {
      return this._path;
    }

    /**
     * Getter function for requested fields
     * @return {Array<string>} Array of request fields
     */

  }, {
    key: 'fields',
    get: function get() {
      return this._fields;
    }

    /**
     * Getter function for API params
     * @return {Object} Object containing API Params
     */

  }, {
    key: 'params',
    get: function get() {
      // Deep cloning when object value is not a function
      return JSON.parse(JSON.stringify(this._params));
    }

    /**
     * Getter function for API fileparams
     * @return {Object} Object containing API fileParams
     */

  }, {
    key: 'fileParams',
    get: function get() {
      // Deep cloning when object value is not a function
      return JSON.parse(JSON.stringify(this._fileParams));
    }
  }]);
  return APIRequest;
}();

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 * 
 * @format
 */

/**
 * Encapsulates an http response from Facebook's Graph API.
 */

var APIResponse = function () {
  function APIResponse(response, call) {
    classCallCheck(this, APIResponse);

    response.body = JSON.parse(response.body);
    this._body = response.body;
    this._httpStatus = response.code;
    this._headers = response.headers;
    this._call = call;
    this._response = response;
  }

  /**
   * @return {Object} The response body
   */


  createClass(APIResponse, [{
    key: 'body',
    get: function get() {
      return this._body;
    }
  }, {
    key: 'headers',
    get: function get() {
      return this._headers;
    }
  }, {
    key: 'etag',
    get: function get() {
      return this._headers['ETag'];
    }
  }, {
    key: 'status',
    get: function get() {
      return this._httpStatus;
    }
  }, {
    key: 'isSuccess',
    get: function get() {
      var body = this._body;

      if ('error' in body) {
        return false;
      } else if (Object.keys(body).length !== 0) {
        if ('success' in body) {
          return body['success'];
        }
        return !('Service Unavailable' in body);
      } else if (this._httpStatus === HTTP_STATUS.NOT_MODIFIED) {
        // ETag Hit
        return true;
      } else if (this._httpStatus === HTTP_STATUS.OK) {
        // HTTP OK
        return true;
      } else {
        // Something else
        return false;
      }
    }
  }, {
    key: 'error',
    get: function get() {
      if (this.isSuccess) {
        return null;
      }

      return new FacebookRequestError(this._response, this._call.method, this._call.relativeUrl, this._call.body);
    }
  }]);
  return APIResponse;
}();

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 * 
 * @format
 */
/**
 * Facebook Ads API Batch
 */

var FacebookAdsApiBatch = function () {

  /**
   * @param {FacebookAdsApi} api
   * @param {Function} successCallback
   * @param {Function} failureCallback
   */
  function FacebookAdsApiBatch(api, successCallback, failureCallback) {
    classCallCheck(this, FacebookAdsApiBatch);

    this._api = api;
    this._files = [];
    this._batch = [];
    this._requests = [];
    this._successCallbacks = [];
    this._failureCallbacks = [];

    if (successCallback != null) {
      this._successCallbacks.push(successCallback);
    }

    if (failureCallback != null) {
      this._failureCallbacks.push(failureCallback);
    }
  }

  /**
   * Adds a call to the batch.
   * @param  {string} method The HTTP method name (e.g. 'GET').
   * @param  {string[]|string} relativePath An array of path tokens or
   *   a relative URL string. An array will be translated to a url as follows:
   *     <graph url>/<tuple[0]>/<tuple[1]>...
   *   It will be assumed that if the path is not a string, it will be iterable.
   * @param  {Object} [params] A mapping of request parameters
   *   where a key is the parameter name and its value is a string or an object
   *   which can be JSON-encoded.
   * @param {Object} [files] An optional mapping of file names to binary open
   *   file objects. These files will be attached to the request.
   * @param {Function} [successCallback] A callback function which will be
   *   called with the response of this call if the call succeeded.
   * @param {Function} [failureCallback] A callback function which will be
   *   called with the response of this call if the call failed.
   * @param {APIRequest} [request] The APIRequest object
   * @return {Object} An object describing the call
   */


  createClass(FacebookAdsApiBatch, [{
    key: 'add',
    value: function add(method, relativePath, params, files, successCallback, failureCallback, request) {
      // Construct a relaitveUrl from relateivePath by assuming that
      // relativePath can only be a string or an array of strings
      var relativeUrl = typeof relativePath === 'string' ? relativePath : relativePath.join('/');

      // Contruct key-value pairs from params for GET querystring or POST body
      if (params != null) {
        var keyVals = [];

        for (var key in params) {
          var value = params[key];
          if (_typeof(params[key]) === 'object' && !(params[key] instanceof Date)) {
            value = JSON.stringify(value);
          }
          keyVals.push(key + '=' + value);
        }

        if (method === 'GET') {
          relativeUrl += '?' + keyVals.join('&');
        } else {
          var body = keyVals.join('&');
        }

        if (params && params['name']) {
          var name = params['name'];
        }
      }

      // Handle attached files
      if (files != null) {
        var attachedFiles = Object.keys(files).join(',');
      }

      // A Call object that will be used in a batch request
      var call = {
        method: method,
        relative_url: relativeUrl,
        body: body,
        name: name,
        attachedFiles: attachedFiles
      };

      this._batch.push(call);
      this._files.push(files);
      this._successCallbacks.push(successCallback);
      this._failureCallbacks.push(failureCallback);
      if (request !== undefined) {
        this._requests.push(request);
      }

      return call;
    }

    /**
     * Interface to add a APIRequest to the batch.
     * @param  {APIRequest} request The APIRequest object to add
     * @param  {Function} [successCallback] A callback function which
     *   will be called with response of this call if the call succeeded.
     * @param  {Function} [failureCallback] A callback function which
     *   will be called with the FacebookResponse of this call if the call failed.
     * @return {Object} An object describing the call
     */

  }, {
    key: 'addRequest',
    value: function addRequest(request, successCallback, failureCallback) {
      var updatedParams = request.params;
      updatedParams['fields'] = request.fields.join();

      return this.add(request.method, request.path, updatedParams, request.fileParams, successCallback, failureCallback, request);
    }

    /**
     * Makes a batch call to the api associated with this object.
     * For each individual call response, calls the success or failure callback
     * function if they were specified.
     * Note: Does not explicitly raise exceptions. Individual exceptions won't
     * be thrown for each call that fails. The success and failure callback
     * functions corresponding to a call should handle its success or failure.
     * @return {FacebookAdsApiBatch|None} If some of the calls have failed,
     *   returns a new FacebookAdsApiBatch object with those calls.
     *   Otherwise, returns None.
     */

  }, {
    key: 'execute',
    value: function execute() {
      var _this = this;

      if (this._batch.length < 1) {
        return;
      }

      var method = 'POST';
      var path$$1 = []; // request to root domain for a batch request
      var params = {
        batch: this._batch
      };

      // Call to the batch endpoint (WIP)
      return this._api.call(method, path$$1, params).then(function (responses) {
        // Keep track of batch indices that need to retry
        var retryIndices = [];

        // Check each response
        for (var index = 0; index < responses.length; index++) {
          var response = responses[index];

          if (response != null) {
            var apiResponse = new APIResponse(response, _this._batch[index]);

            // Call the success callback if provided
            if (apiResponse.isSuccess) {
              if (_this._successCallbacks[index]) {
                _this._successCallbacks[index](apiResponse);
              }
            } else {
              // Call the failure callback if provided
              if (_this._failureCallbacks[index]) {
                _this._failureCallbacks[index](apiResponse);
              }
            }
          } else {
            // Do not get response, so, we keep track of the index to retry
            retryIndices.push(index);
          }
        }

        // Create and return new batch if we need to retry
        if (retryIndices.length > 0) {
          // Create a new batch from retry indices in the current batch
          var newBatch = new FacebookAdsApiBatch(_this._api);

          var _iteratorNormalCompletion = true;
          var _didIteratorError = false;
          var _iteratorError = undefined;

          try {
            for (var _iterator = retryIndices[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
              var _index = _step.value;

              newBatch._files.push(_this._files[_index]);
              newBatch._batch.push(_this._batch[_index]);
              newBatch._successCallbacks.push(_this._successCallbacks[_index]);
              newBatch._failureCallbacks.push(_this._failureCallbacks[_index]);
            }
          } catch (err) {
            _didIteratorError = true;
            _iteratorError = err;
          } finally {
            try {
              if (!_iteratorNormalCompletion && _iterator.return) {
                _iterator.return();
              }
            } finally {
              if (_didIteratorError) {
                throw _iteratorError;
              }
            }
          }

          return newBatch;
        }

        // No retry
        return null;
      }).catch(function (error) {
        throw error;
      });
    }
  }]);
  return FacebookAdsApiBatch;
}();

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * Abstract Object
 * Manages object data fields and provides matching properties
 *
 * 
 * @format
 */
var AbstractObject = function () {
  createClass(AbstractObject, null, [{
    key: 'Fields',

    // This is a Flow workaround for setting `this[field]` in the set() function.
    get: function get() {
      return Object.freeze({});
    }
  }]);

  function AbstractObject() {
    var _this = this;

    classCallCheck(this, AbstractObject);

    this._data = {};
    if (this.constructor.Fields === undefined) {
      throw new Error('A "Fields" frozen object must be defined in the object class');
    }
    var fields = this.constructor.Fields;
    this._fields = Object.keys(fields);
    this._fields.forEach(function (field) {
      _this._defineProperty(field);
    });
  }

  /**
   * Define data getter and setter field
   * @param {String} field
   */


  createClass(AbstractObject, [{
    key: '_defineProperty',
    value: function _defineProperty(field) {
      var _this2 = this;

      Object.defineProperty(this, field, {
        get: function get() {
          return _this2._data[field];
        },
        set: function set(value) {
          _this2._data[field] = value;
        },
        enumerable: true
      });
    }

    /**
     * Set data field
     * @param {String} field
     * @param {Mixed} value
     * @return this
     */

  }, {
    key: 'set',
    value: function set(field, value) {
      if (this._fields.indexOf(field) < 0) {
        this._defineProperty(field);
      }
      this[field] = value;
      return this;
    }

    /**
     * Set multiple data fields
     * @param {Object} data
     * @return this
     */

  }, {
    key: 'setData',
    value: function setData(data) {
      var _this3 = this;

      Object.keys(data).forEach(function (key) {
        _this3.set(key, data[key]);
      });
      return this;
    }

    /**
     * Export object data
     * @return {Object}
     */

  }, {
    key: 'exportData',
    value: function exportData() {
      return this._data;
    }
  }]);
  return AbstractObject;
}();

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 * 
 * @format
 */
var Utils = function () {
  function Utils() {
    classCallCheck(this, Utils);
  }

  createClass(Utils, null, [{
    key: 'normalizeEndpoint',
    value: function normalizeEndpoint(str) {
      return str.replace(/^\/|\/$/g, '');
    }
  }, {
    key: 'removePreceedingSlash',
    value: function removePreceedingSlash(str) {
      return str.length && str[0] === '/' ? str.slice(1) : str;
    }
  }]);
  return Utils;
}();

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * Cursor
 * Iterates over edge objects and controls pagination
 * 
 * @format
 */
var Cursor = function (_Array) {
  inherits(Cursor, _Array);

  /**
   * @param  {Object} sourceObject
   * @param  {Object} targetClass
   * @param  {Object} [params]
   * @param  {String} [endpoint]
   */
  function Cursor(sourceObject, targetClass, params, endpoint) {
    classCallCheck(this, Cursor);

    var _this = possibleConstructorReturn(this, (Cursor.__proto__ || Object.getPrototypeOf(Cursor)).call(this));

    var next = [sourceObject.getId()];
    if (endpoint) {
      next.push(Utils.normalizeEndpoint(endpoint));
    } else {
      throw new Error('No endpoint specified for the target edge.');
    }
    _this._api = sourceObject.getApi();
    _this._targetClass = targetClass;
    _this.paging = { next: next, params: params };

    _this.clear = function () {
      _this.length = 0;
    };

    _this.set = function (array) {
      _this.clear();
      _this.push.apply(_this, toConsumableArray(array));
    };

    _this.next = function () {
      if (!_this.hasNext()) {
        return Promise.reject(new RangeError('end of pagination'));
      }
      return _this._loadPage(_this.paging.next);
    };

    _this.hasNext = function () {
      return Boolean(_this.paging) && Boolean(_this.paging.next);
    };

    _this.previous = function () {
      if (!_this.hasPrevious()) {
        return Promise.reject(new RangeError('start of pagination'));
      }
      return _this._loadPage(_this.paging.previous);
    };

    _this.hasPrevious = function () {
      return Boolean(_this.paging) && Boolean(_this.paging.previous);
    };

    _this._loadPage = function (path$$1) {
      var promise = new Promise(function (resolve, reject) {
        _this._api.call('GET', path$$1, _this.paging.params).then(function (response) {
          var objects = _this._buildObjectsFromResponse(response);
          _this.set(objects);
          _this.paging = response.paging;
          _this.summary = response.summary;
          _this.headers = response.headers;
          resolve(_this);
        }).catch(reject);
      });

      return promise;
    };

    _this._buildObjectsFromResponse = function (response) {
      return response.data.map(function (item) {
        var That = _this._targetClass;
        if (That.name === 'AbstractObject') {
          var result = new That();
          result.setData(item);
          return result;
        }
        return new That(item && item.id ? item.id : null, item, undefined, _this._api);
      });
    };
    return _this;
  }

  return Cursor;
}(Array);

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 * @format
 * 
 */
/**
 * Abstract Crud Object
 * Facebook Object basic persistence functions
 * @extends AbstractObject
 * 
 */
var AbstractCrudObject = function (_AbstractObject) {
  inherits(AbstractCrudObject, _AbstractObject);

  /**
   * @param  {Object} data
   * @param  {String} parentId
   * @param  {FacebookAdApi} [api]
   */
  function AbstractCrudObject() {
    var id = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var parentId = arguments[2];
    var api = arguments[3];
    classCallCheck(this, AbstractCrudObject);

    var _this = possibleConstructorReturn(this, (AbstractCrudObject.__proto__ || Object.getPrototypeOf(AbstractCrudObject)).call(this));

    _this._parentId = parentId;
    _this._api = api || FacebookAdsApi.getDefaultApi();
    if (id) {
      data.id = id;
    }
    if (data) {
      get$1(AbstractCrudObject.prototype.__proto__ || Object.getPrototypeOf(AbstractCrudObject.prototype), 'setData', _this).call(_this, data);
    }
    return _this;
  }

  /**
   * Define data getter and setter recording changes
   * @param {String} field
   */


  createClass(AbstractCrudObject, [{
    key: '_defineProperty',
    value: function _defineProperty(field) {
      var _this2 = this;

      if (this._changes === undefined) {
        this._changes = {};
      }
      Object.defineProperty(this, field, {
        get: function get() {
          return _this2._data[field];
        },
        set: function set(value) {
          _this2._changes[field] = value;
          _this2._data[field] = value;
        },
        enumerable: true
      });
    }

    /**
     * Set object data as if it were read from the server. Wipes related changes
     * @param {Object} data
     * @return this
     */

  }, {
    key: 'setData',
    value: function setData(data) {
      var _this3 = this;

      get$1(AbstractCrudObject.prototype.__proto__ || Object.getPrototypeOf(AbstractCrudObject.prototype), 'setData', this).call(this, data);
      Object.keys(data).forEach(function (key) {
        delete _this3._changes[key];
      });
      return this;
    }

    /**
     * Export changed object data
     * @return {Object}
     */

  }, {
    key: 'exportData',
    value: function exportData() {
      return this._changes;
    }

    /**
     * Export object data
     * @return {Object}
     */

  }, {
    key: 'exportAllData',
    value: function exportAllData() {
      return this._data;
    }

    /**
     * Clear change history
     * @return this
     */

  }, {
    key: 'clearHistory',
    value: function clearHistory() {
      this._changes = {};
      return this;
    }

    /**
     * @throws {Error} if object has no id
     * @return {String}
     */

  }, {
    key: 'getId',
    value: function getId() {
      if (!this.id) {
        throw new Error(this.constructor.name + ' Id not defined');
      }
      return this.id;
    }

    /**
     * @throws {Error} if object has no parent id
     * @return {String}
     */

  }, {
    key: 'getParentId',
    value: function getParentId() {
      if (!this._parentId) {
        throw new Error(this.constructor.name + ' parentId not defined');
      }
      return this._parentId;
    }

    /**
     * @return {String}
     */

  }, {
    key: 'getNodePath',
    value: function getNodePath() {
      return this.getId();
    }

    /**
     * Return object API instance
     * @throws {Error} if object doesn't hold an API
     * @return {FacebookAdsApi}
     */

  }, {
    key: 'getApi',
    value: function getApi() {
      var api = this._api;
      if (!api) {
        throw new Error(this.constructor.name + ' does not yet have an\n        associated api object.\n Did you forget to\n        instantiate an API session with:\n        "FacebookAdsApi.init"?');
      }
      return api;
    }

    /**
     * Read object data
     * @param   {Array}   [fields]
     * @param   {Object}  [params]
     * @return  {Promise}
     */

  }, {
    key: 'read',
    value: function read(fields) {
      var _this4 = this;

      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      var api = this.getApi();
      var path$$1 = [this.getNodePath()];
      if (fields) {
        params['fields'] = fields.join(',');
      }
      return new Promise(function (resolve, reject) {
        api.call('GET', path$$1, params).then(function (data) {
          return resolve(_this4.setData(data));
        }).catch(reject);
      });
    }

    /**
     * Update object
     * @param   {Object}  [params]
     * @return  {Promise}
     */

  }, {
    key: 'update',
    value: function update() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var api = this.getApi();
      var path$$1 = [this.getNodePath()];
      params = Object.assign(params, this.exportData());
      return new Promise(function (resolve, reject) {
        api.call('POST', path$$1, params).then(function (data) {
          return resolve(data);
        }).catch(reject);
      });
    }

    /**
     * Delete object
     * @param   {Object}  [params]
     * @return  {Promise}
     */

  }, {
    key: 'delete',
    value: function _delete() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var api = this.getApi();
      var path$$1 = [this.getNodePath()];
      params = Object.assign(params, this.exportData());
      return new Promise(function (resolve, reject) {
        api.call('DELETE', path$$1, params).then(function (data) {
          return resolve(data);
        }).catch(reject);
      });
    }

    /**
     * Initialize Cursor to paginate on edges
     * @param  {Object}  targetClass
     * @param  {Array}   [fields]
     * @param  {Object}  [params]
     * @param  {Boolean} [fetchFirstPage]
     * @param  {String}  [endpoint]
     * @return {Cursor}
     */

  }, {
    key: 'getEdge',
    value: function getEdge(targetClass, fields) {
      var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var fetchFirstPage = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
      var endpoint = arguments[4];

      if (fields && fields.length > 0) {
        params['fields'] = fields.join(',');
      }
      var sourceObject = this;
      var cursor = new Cursor(sourceObject, targetClass, params, endpoint);
      if (fetchFirstPage) {
        return cursor.next();
      }
      return cursor;
    }

    /**
     * Create edge object
     * @param   {String}  [endpoint]
     * @param   {Array}  [fields]
     * @param   {Object}  [params]
     * @param   {Function} [targetClassConstructor]
     * @return  {Promise}
     */

  }, {
    key: 'createEdge',
    value: function createEdge(endpoint, fields) {
      var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

      var _this5 = this;

      var targetClassConstructor = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
      var pathOverride = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;

      if (fields && fields.length > 0) {
        params['fields'] = fields.join(',');
      }
      var api = this.getApi();
      var path$$1 = pathOverride != null ? pathOverride : [this.getNodePath(), Utils.removePreceedingSlash(endpoint)];
      params = Object.assign(params, this.exportData());
      return new Promise(function (resolve, reject) {
        api.call('POST', path$$1, params).then(function (data) {
          resolve(
          /* eslint new-cap: "off" */
          targetClassConstructor === null ? _this5.setData(data) : new targetClassConstructor(data.id, data));
        }).catch(reject);
      });
    }

    /**
     * Delete edge object
     * @param   {String}  [endpoint]
     * @param   {Object}  [params]
     * @return  {Promise}
     */

  }, {
    key: 'deleteEdge',
    value: function deleteEdge(endpoint) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      var api = this.getApi();
      var path$$1 = [this.getNodePath(), Utils.removePreceedingSlash(endpoint)];
      params = Object.assign(params, this.exportData());
      return new Promise(function (resolve, reject) {
        api.call('DELETE', path$$1, params).then(function (data) {
          return resolve(data);
        }).catch(reject);
      });
    }

    /**
     * Read Objects by Ids
     * @param  {Array}          ids
     * @param  {Array}          [fields]
     * @param  {Object}         [params]
     * @param  {FacebookAdsApi} [api]
     * @return {Promise}
     */

  }], [{
    key: 'getByIds',
    value: function getByIds(ids, fields) {
      var _this6 = this;

      var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var api = arguments[3];

      api = api || FacebookAdsApi.getDefaultApi();
      if (fields && fields.length > 0) {
        params['fields'] = fields.join(',');
      }
      params['ids'] = ids.join(',');
      return new Promise(function (resolve, reject) {
        return api.call('GET', [''], params).then(function (response) {
          var result = [];
          for (var id in response) {
            var data = response[id];
            var That = _this6;
            var object = new That(data);
            result.push(object);
          }
          resolve(result);
        }).catch(reject);
      });
    }
  }]);
  return AbstractCrudObject;
}(AbstractObject);

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 * 
 */

/**
 * Type of delivery for a purchase event.
 */

var DeliveryCategory = Object.freeze({

  /**
  * Customer needs to enter the store to get the purchased product.
  */
  IN_STORE: 'in_store',

  /**
  * Customer picks up their order by driving to a store and waiting inside their vehicle.
  */
  CURBSIDE: 'curbside',

  /**
  * Purchase is delivered to the customer's home.
  */
  HOME_DELIVERY: 'home_delivery'
});

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 * 
 */

var sha256 = require('js-sha256');
var currency_codes = require('currency-codes');
var country_codes = require('iso-3166-1');
var validator = require('email-validator');

var PHONE_NUMBER_IGNORE_CHAR_SET = /[\-@#<>'",; ]|\(|\)|\+|[a-z]/g;
var PHONE_NUMBER_DROP_PREFIX_ZEROS = /^\+?0{0,2}/;
var US_PHONE_NUMBER_REGEX = /^1\(?\d{3}\)?\d{7}$/;
var INTL_PHONE_NUMBER_REGEX = /^\d{1,4}\(?\d{2,3}\)?\d{4,}$/;
var SHA256_REGEX = /^[a-f0-9]{64}$/;
var MD5_REGEX = /^[a-f0-9]{32}$/;

/**
 * ServerSideUtils contains the Utility modules used for sending Conversions API Events
 */

var ServerSideUtils = function () {
  function ServerSideUtils() {
    classCallCheck(this, ServerSideUtils);
  }

  createClass(ServerSideUtils, null, [{
    key: 'normalizeAndHash',

    /**
     * Normalizes and hashes the input given the field name.
     * @param  {String} [input] Value to be normalized. eg: `foo@bar.com` for email input.
     * @param  {String} [field] Key(Type) of Value to be normalized eg: 'em' for email field.
     * @return {String} Normalized and hashed value for the string.
     */
    value: function normalizeAndHash(input, field) {
      if (field == null || input == null) {
        return null;
      }

      var normalized_input = input.trim().toLowerCase();

      if (normalized_input.length === 0) {
        return null;
      }

      if (normalized_input.match(SHA256_REGEX) || normalized_input.match(MD5_REGEX)) {
        return normalized_input;
      }

      switch (field) {
        case 'country':
          normalized_input = ServerSideUtils.normalizeCountry(normalized_input);
          break;
        case 'ct':
          normalized_input = ServerSideUtils.normalizeCity(normalized_input);
          break;
        case 'em':
          normalized_input = ServerSideUtils.normalizeEmail(normalized_input);
          break;
        case 'ge':
          normalized_input = ServerSideUtils.normalizeGender(normalized_input);
          break;
        case 'ph':
          normalized_input = ServerSideUtils.normalizePhone(normalized_input);
          break;
        case 'st':
          normalized_input = ServerSideUtils.normalizeState(normalized_input);
          break;
        case 'zp':
          normalized_input = ServerSideUtils.normalizeZip(normalized_input);
          break;
        case 'f5first':
        case 'f5last':
          normalized_input = ServerSideUtils.normalizeF5NameField(normalized_input);
          break;
        case 'fi':
          normalized_input = normalized_input.charAt(0);
          break;
        case 'dobd':
          normalized_input = ServerSideUtils.normalizeDobd(normalized_input);
          break;
        case 'dobm':
          normalized_input = ServerSideUtils.normalizeDobm(normalized_input);
          break;
        case 'doby':
          normalized_input = ServerSideUtils.normalizeDoby(normalized_input);
          break;
      }

      // Hashing the normalized input with SHA 256
      var hashed_input = ServerSideUtils.toSHA256(normalized_input);
      return hashed_input;
    }

    /**
     * Normalizes the given country token and returns acceptable two letter ISO country code
     * @param  {String} [country] country value to be normalized.
     * @return {String} Normalized ISO country code.
     */

  }, {
    key: 'normalizeCountry',
    value: function normalizeCountry(country) {
      if (!country_codes.whereAlpha2(country)) {
        throw new Error("Invalid country code: '" + country + "'. Please follow ISO 3166-1 2-letter standard for representing country. eg: US");
      }

      return country;
    }

    /**
     * Normalizes the given city and returns acceptable city value
     * @param  {String} [city] city value to be normalized.
     * @return {String} Normalized city value.
     */

  }, {
    key: 'normalizeCity',
    value: function normalizeCity(city) {
      city = city.replace(/[0-9\s().-]/g, '');
      return city;
    }

    /**
     * Normalizes the given currency string and returns acceptable three letter ISO code
     * @param  {String} [currency] Currency value to be normalized.
     * @return {String} Normalized ISO currency code.
     */

  }, {
    key: 'normalizeCurrency',
    value: function normalizeCurrency(currency) {
      // Convert the input currency string to uppercase
      currency = currency.trim().toUpperCase();

      // Retain only uppercase alphabetic characters (A-Z) bounded for ISO code
      currency = currency.replace(/[^A-Z]/g, '');

      // Check if the normalized currency is a valid ISO 4217 code
      if (!currency_codes.codes().includes(currency)) {
        throw new Error("Invalid format for currency: '" + currency + "'. Please follow ISO 4217 3-letter standard for representing currency. Eg: USD");
      }

      // Return the normalized, uppercase currency code
      return currency;
    }

    /**
     * Normalizes the given delivery category value and returns a valid string.
     * @param  {String} [input] delivery_category input to be validated.
     * @return {String} Valid delivery_category value.
     */

  }, {
    key: 'normalizeDeliveryCategory',
    value: function normalizeDeliveryCategory(input) {

      var delivery_category = input.trim().toLowerCase();

      if (!Object.values(DeliveryCategory).includes(delivery_category)) {
        throw new Error("Invalid delivery_category passed: " + input + ". Allowed values are one of " + Object.values(DeliveryCategory).join(','));
      }

      return delivery_category;
    }

    /**
     * @param  {String} [email] email value to be normalized.
     * @return {String} Normalized email value.
     */

  }, {
    key: 'normalizeEmail',
    value: function normalizeEmail(email) {
      // Use email-validator to validate the email format
      if (!validator.validate(email)) {
        throw new Error("Invalid email format for the passed email:'" + email + "'.Please check the passed email format.");
      }

      return email;
    }

    /**
     * Normalizes the given gender and returns acceptable('f' or 'm') gender value
     * @param  {String} [gender] gender value to be normalized.
     * @return {String} Normalized gender value.
     */

  }, {
    key: 'normalizeGender',
    value: function normalizeGender(gender) {
      gender = gender.replace(/[^a-z]/g, '');

      if (gender === 'female' || gender === 'f') {
        gender = 'f';
      } else if (gender === 'male' || gender === 'm') {
        gender = 'm';
      } else {
        return null;
      }

      return gender;
    }

    /**
    * Normalizes the 5 character name field.
    * @param  {String} [name] name value to be normalized.
    * @return {String} Normalized 5 character {first,last}name field value.
    */

  }, {
    key: 'normalizeF5NameField',
    value: function normalizeF5NameField(name) {

      return name.length <= 5 ? name : name.substring(0, 5);
    }

    /**
     * Normalizes the given phone and returns acceptable phone value
     * @param  {String} [phone_number] phone number value to be normalized.
     * @return {String} Normalized phone number value.
     */

  }, {
    key: 'normalizePhone',
    value: function normalizePhone(phone_number) {
      // Remove common characters occuring as part of the phone numbers.
      phone_number = phone_number.replace(PHONE_NUMBER_IGNORE_CHAR_SET, '');

      if (ServerSideUtils.isInternationalPhoneNumber(phone_number)) {
        phone_number = phone_number.replace(PHONE_NUMBER_DROP_PREFIX_ZEROS, '');
      }

      if (phone_number.length < 7 || phone_number.length > 16) {
        throw new Error("Invalid phone number format for the passed phone number:'" + phone_number + "'.Please check the passed phone number format.");
      }

      return phone_number;
    }

    /**
     * Normalizes the given state and returns acceptable city value
     * @param  {String} [state] state value to be normalized.
     * @return {String} Normalized state value.
     */

  }, {
    key: 'normalizeState',
    value: function normalizeState(state) {
      state = state.replace(/[0-9\s().-]/g, '');
      return state;
    }

    /**
     * Normalizes the given zip/postal code and returns acceptable zip code value
     * @param  {String} [zip] zip value to be normalized.
     * @return {String} Normalized zip code value.
     */

  }, {
    key: 'normalizeZip',
    value: function normalizeZip(zip) {
      zip = zip.replace(/[\s]/g, '');

      // If the zip code '-', we retain just the first part alone.
      zip = zip.split('-', 1)[0];

      if (zip.length < 2) {
        return null;
      }

      return zip;
    }

    /**
     * Normalizes the given date of birth day
     * @param  {String} [dobd] value to be normalized.
     * @return {String} Normalized value.
     */

  }, {
    key: 'normalizeDobd',
    value: function normalizeDobd(dobd) {
      if (dobd.length === 1) {
        dobd = '0' + dobd;
      }

      var dobd_int = parseInt(dobd);
      if (dobd_int < 1 || dobd_int > 31) {
        throw new Error("Invalid format for dobd:'" + dobd + "'.Please use 'DD' format for dobd.");
      }

      return dobd;
    }

    /**
     * Normalizes the given date of birth month
     * @param  {String} [dobm] value to be normalized.
     * @return {String} Normalized value.
     */

  }, {
    key: 'normalizeDobm',
    value: function normalizeDobm(dobm) {
      if (dobm.length === 1) {
        dobm = '0' + dobm;
      }

      var dobm_int = parseInt(dobm);
      if (dobm_int < 1 || dobm_int > 12) {
        throw new Error("Invalid format for dobm:'" + dobm + "'.Please use 'MM' format for dobm.");
      }

      return dobm;
    }

    /**
     * Normalizes the given date of birth year
     * @param  {String} [doby] value to be normalized.
     * @return {String} Normalized value.
     */

  }, {
    key: 'normalizeDoby',
    value: function normalizeDoby(doby) {
      if (!doby.match(/^[0-9]{4}$/)) {
        throw new Error("Invalid format for doby:'" + doby + "'.Please use 'YYYY' format for doby.");
      }

      return doby;
    }

    /**
     * Boolean method which checks if a given number is represented in international format
     * @param  {String} phone_number that has to be tested.
     * @return {Boolean} value if a number is represented international format
     */

  }, {
    key: 'isInternationalPhoneNumber',
    value: function isInternationalPhoneNumber(phone_number) {
      // strip up to 2 leading 0s and +
      phone_number = phone_number.replace(PHONE_NUMBER_DROP_PREFIX_ZEROS, '');

      if (phone_number.startsWith('0')) {
        return false;
      }

      if (phone_number.startsWith('1')) {
        return US_PHONE_NUMBER_REGEX.test(phone_number);
      }

      return INTL_PHONE_NUMBER_REGEX.test(phone_number);
    }

    /**
     * Calculates the SHA 256 hash of a given non-null string.
     * @param  {String} [input] String to be hashed
     * @return {String} SHA 256 Hash of the string
     */

  }, {
    key: 'toSHA256',
    value: function toSHA256(input) {
      if (input === null) return input;

      return sha256(input);
    }
  }]);
  return ServerSideUtils;
}();

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 * 
 */

/**
 * Content is part of the Custom Data Parameters of a Conversions API Event Request. Content can be used to set the item/product details added in the Custom Data.
 * @see {@link https://developers.facebook.com/docs/marketing-api/conversions-api/parameters/custom-data#contents}
 */

var Content = function () {

	/**
  * @param {String} id Product Id of the Item.
  * @param {Number} quantity Quantity of the Item.
  * @param {Number} item_price Price per unit of the content/product.
  * @param {String} title Title of the listed Item.
  * @param {String} description Product description used for the item.
  * @param {String} brand Brand of the item.
  * @param {String} category Category of the Item.
  * @param {String} delivery_category The type of delivery for a purchase event
  */
	function Content(id, quantity, item_price, title, description, brand, category, delivery_category) {
		classCallCheck(this, Content);


		this._id = id;
		this._quantity = quantity;
		this._item_price = item_price;
		this._title = title;
		this._description = description;
		this._brand = brand;
		this._category = category;
		this._delivery_category = delivery_category;
	}

	/**
  * Gets the Product Id of the Item.
  * A string representing the unique Id for the product.
  * Example: XYZ.
  */


	createClass(Content, [{
		key: 'setId',


		/**
  * Sets the Product Id of the Item.
  * @param id is a string representing the unique id for the product.
  * Example: XYZ.
  */
		value: function setId(id) {
			this._id = id;
			return this;
		}

		/**
   * Gets the quantity of the Item.
   * The number/quantity of the content that is being involved in the customer interaction.
   * Example: 5
   */

	}, {
		key: 'setQuantity',


		/**
  * Sets the quantity of the Content/Item.
  * @param {Number} quantity The number/quantity of the product that is being involved in the customer interaction.
  * Example: 5
  */
		value: function setQuantity(quantity) {
			this._quantity = quantity;
			return this;
		}

		/**
   * Gets the item price for the Product.
   * The item_price or price per unit of the product.
   * Example: '123.45'
   */

	}, {
		key: 'setItemPrice',


		/**
  * Sets the item price for the Content.
  * @param {Number} item_price The item_price or price per unit of the product.
  * Example: '123.45'
  */
		value: function setItemPrice(item_price) {
			this._item_price = item_price;
			return this;
		}

		/**
   * Gets the Title of the listed Item.
   * A string representing the Title for the product.
   */

	}, {
		key: 'setTitle',


		/**
  * Sets the Title of the Item.
  * @param title is a string representing listed title for the product.
  */
		value: function setTitle(title) {
			this._title = title;
			return this;
		}

		/**
   * Gets the Description of the listed Item.
   * A string representing the Description for the product.
   */

	}, {
		key: 'setDescription',


		/**
  * Sets the Product Description of the Item.
  * @param description is a string representing the description for the product.
  */
		value: function setDescription(description) {
			this._description = description;
			return this;
		}

		/**
   * Gets the Brand of the listed Item.
   * A string representing the Brand for the product.
   */

	}, {
		key: 'setBrand',


		/**
   * Sets the Brand of the Product.
   * @param brand is a string representing the Brand for the product.
   */
		value: function setBrand(brand) {
			this._brand = brand;
			return this;
		}

		/**
   * Gets the Category of the listed Item.
   * A string representing the Category for the product.
   */

	}, {
		key: 'setCategory',


		/**
   * Sets the Category of the Product.
   * @param category is a string representing the Category for the product.
   */
		value: function setCategory(category) {
			this._category = category;
			return this;
		}

		/**
   * Gets the delivery category.
   */

	}, {
		key: 'setDeliveryCategory',


		/**
   * Sets the type of delivery for a purchase event.
   * @param {String} delivery_category The delivery category.
   */
		value: function setDeliveryCategory(delivery_category) {
			this._delivery_category = delivery_category;
			return this;
		}

		/**
   * Returns the normalized payload for the Content.
   * @returns {Object} normalized Content payload.
   */

	}, {
		key: 'normalize',
		value: function normalize() {
			var content = {};

			if (this.id) {
				content['id'] = this.id;
			}

			if (this.quantity) {
				content['quantity'] = this.quantity;
			}

			if (this.item_price) {
				content['item_price'] = this.item_price;
			}

			if (this.title) {
				content['title'] = this.title;
			}

			if (this.description) {
				content['description'] = this.description;
			}

			if (this.brand) {
				content['brand'] = this.brand;
			}

			if (this.category) {
				content['category'] = this.category;
			}

			if (this.delivery_category) {
				content['delivery_category'] = ServerSideUtils.normalizeDeliveryCategory(this.delivery_category);
			}

			return content;
		}
	}, {
		key: 'id',
		get: function get() {
			return this._id;
		}

		/**
   * Sets the Product Id of the Item.
   * @param id A string representing the unique Id for the product.
   * Example: XYZ.
   */
		,
		set: function set(id) {
			this._id = id;
		}
	}, {
		key: 'quantity',
		get: function get() {
			return this._quantity;
		}

		/**
   * Sets the quantity of the Item.
   * @param quantity The number/quantity of the product that is being involved in the customer interaction.
   * Example: 5
   */
		,
		set: function set(quantity) {
			this._quantity = quantity;
		}
	}, {
		key: 'item_price',
		get: function get() {
			return this._item_price;
		}

		/**
   * Sets the item price for the Content.
   * @param item_price The item_price or price per unit of the product.
   * Example: '123.45'
   */
		,
		set: function set(item_price) {
			this._item_price = item_price;
		}
	}, {
		key: 'title',
		get: function get() {
			return this._title;
		}

		/**
   * Sets the Title of the listed Item.
   * @param title A string representing the Title for the product.
   */
		,
		set: function set(title) {
			this._title = title;
		}
	}, {
		key: 'description',
		get: function get() {
			return this._description;
		}

		/**
   * Sets the Description of the listed Item.
   * @param description A string representing the Description for the product.
   */
		,
		set: function set(description) {
			this._description = description;
		}
	}, {
		key: 'brand',
		get: function get() {
			return this._brand;
		}

		/**
   * Sets the Brand of the listed Item.
   * @param brand A string representing the Brand for the product.
   */
		,
		set: function set(brand) {
			this._brand = brand;
		}
	}, {
		key: 'category',
		get: function get() {
			return this._category;
		}

		/**
   * Sets the Category of the listed Item.
   * @param category A string representing the Category for the product.
   */
		,
		set: function set(category) {
			this._category = category;
		}
	}, {
		key: 'delivery_category',
		get: function get() {
			return this._delivery_category;
		}

		/**
   * Sets the type of delivery for a purchase event.
   * @param delivery_category The delivery category.
   */
		,
		set: function set(delivery_category) {
			this._delivery_category = delivery_category;
		}
	}]);
	return Content;
}();

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 * 
 */

/**
 * CustomData represents the Custom Data Parameters of a Conversions API Event Request. Use these parameters to send additional data we can use for ads delivery optimization.
 * @see {@link https://developers.facebook.com/docs/marketing-api/conversions-api/parameters/custom-data}
 */

var CustomData = function () {

	/**
  * @param {Number} value value of the item Eg: 123.45
  * @param {Number} net_revenue net_revenue of the item Eg: 30.45
  * @param {String} currency currency involved in the transaction Eg: usd
  * @param {String} content_name name of the Content Eg: lettuce
  * @param {String} content_category category of the content Eg: grocery
  * @param {Array<String>} content_ids list of content unique ids involved in the event
  * @param {Array<Content>} contents Array of Content Objects. Use {Content} class to define a content.
  * @param {String} content_type Type of the Content group or Product SKU
  * @param {String} order_id Unique id representing the order
  * @param {Number} predicted_ltv Predicted LifeTime Value for the customer involved in the event
  * @param {Number} num_items Number of items involved
  * @param {String} search_string query string used for the Search event
  * @param {String} status Status of the registration in Registration event
  * @param {String} item_number The item number
  * @param {String} delivery_category The type of delivery for a purchase event
  * @param {Object} custom_properties Custom Properties to be added to the Custom Data
  */
	function CustomData(value, net_revenue, currency, content_name, content_category, content_ids, contents, content_type, order_id, predicted_ltv, num_items, search_string, status, item_number, delivery_category, custom_properties) {
		classCallCheck(this, CustomData);


		this._value = value;
		this._net_revenue = net_revenue;
		this._currency = currency;
		this._content_name = content_name;
		this._content_category = content_category;
		this._content_ids = content_ids;
		this._contents = contents;
		this._content_type = content_type;
		this._order_id = order_id;
		this._predicted_ltv = predicted_ltv;
		this._num_items = num_items;
		this._search_string = search_string;
		this._status = status;
		this._item_number = item_number;
		this._delivery_category = delivery_category;
		this._custom_properties = custom_properties;
	}

	/**
  * Gets the value of the custom data.
  * A numeric value associated with this event. This could be a monetary value or a value in some other metric.
  * Example: 142.54.
  */


	createClass(CustomData, [{
		key: 'setValue',


		/**
   * Sets the value of the custom data.
   * @param {Number} value A numeric value associated with this event. This could be a monetary value or a value in some other metric.
   * Example: 142.54.
   */
		value: function setValue(value) {
			this._value = value;
			return this;
		}

		/**
   * Gets the net_revenue of the custom data.
   * A numeric net_revenue associated with this event. This could be a monetary net_revenue or a net_revenue in some other metric.
   * Example: 30.54.
   */

	}, {
		key: 'setNetRevenue',


		/**
   * Sets the net_revenue of the custom data.
   * @param {Number} value A numeric net_revenue associated with this event. This could be a monetary net_revenue or a net_revenue in some other metric.
   * Example: 30.54.
   */
		value: function setNetRevenue(net_revenue) {
			this._net_revenue = net_revenue;
			return this;
		}

		/**
   * Gets the currency for the custom data.
   * The currency for the value specified, if applicable. Currency must be a valid ISO 4217 three digit currency code.
   * Example: 'usd'
   */

	}, {
		key: 'setCurrency',


		/**
   * Sets the currency for the custom data.
   * @param {String} currency The currency for the value specified, if applicable. Currency must be a valid ISO 4217 three digit currency code.
   * Example: 'usd'
   */
		value: function setCurrency(currency) {
			this._currency = currency;
			return this;
		}

		/**
   * Gets the content name for the custom data. The name of the page or product associated with the event.
   * The name of the page or product associated with the event.
   * Example: 'lettuce'
   */

	}, {
		key: 'setContentName',


		/**
   * Sets the content name for the custom data.
   * @param content_name The name of the page or product associated with the event.
   * Example: 'lettuce'
   */
		value: function setContentName(content_name) {
			this._content_name = content_name;
			return this;
		}

		/**
   * Gets the content category for the custom data.
   * The category of the content associated with the event.
   * Example: 'grocery'
   */

	}, {
		key: 'setContentCategory',


		/**
   * Sets the content_category for the custom data.
   * @param content_category The category of the content associated with the event.
   * Example: 'grocery'
   */
		value: function setContentCategory(content_category) {
			this._content_category = content_category;
			return this;
		}

		/**
   * Gets the content_ids for the custom data.
   * The content IDs associated with the event, such as product SKUs for items in an AddToCart, represented as Array of string.
   * If content_type is a product, then your content IDs must be an array with a single string value. Otherwise, this array can contain any number of string values.
   * Example: ['ABC123', 'XYZ789']
   */

	}, {
		key: 'setContentIds',


		/**
   * Sets the content_ids for the custom data.
   * @param {Array} content_ids The content IDs associated with the event, such as product SKUs for items in an AddToCart, represented as Array of string.
   * If content_type is a product, then your content IDs must be an array with a single string value. Otherwise, this array can contain any number of string values.
   * Example: ['ABC123', 'XYZ789']
   */
		value: function setContentIds(content_ids) {
			this._content_ids = content_ids;
			return this;
		}

		/**
   * Gets the contents for the custom data.
   * An array of Content objects that contain the product IDs associated with the event plus information about the products. id, quantity, and item_price are available fields.
   * Example: [{'id':'ABC123','quantity' :2,'item_price':5.99}, {'id':'XYZ789','quantity':2, 'item_price':9.99}]
   */

	}, {
		key: 'setContents',


		/**
   * Sets the contents for the custom data.
   * @param {Array<Content>} contents An array of Content objects that contain the product IDs associated with the event plus information about the products. id, quantity, and item_price are available fields.
   * Example: [{'id':'ABC123','quantity' :2,'item_price':5.99}, {'id':'XYZ789','quantity':2, 'item_price':9.99}]
   */
		value: function setContents(contents) {
			this._contents = contents;
			return this;
		}

		/**
   * Gets the content type for the custom data.
   * A String equal to either product or product_group. Set to product if the keys you send content_ids or contents represent products.
   * Set to product_group if the keys you send in content_ids represent product groups.
   */

	}, {
		key: 'setContentType',


		/**
   * Sets the content type for the custom data.
   * @param {String} content_type A string equal to either product or product_group. Set to product if the keys you send content_ids or contents represent products.
   * Set to product_group if the keys you send in content_ids represent product groups.
   */
		value: function setContentType(content_type) {
			this._content_type = content_type;
			return this;
		}

		/**
   * Gets the order id for the custom data.
   * order_id is the order ID for this transaction as a String.
   * Example: 'order1234'
   */

	}, {
		key: 'setOrderId',


		/**
   * Sets the order_id for the custom data.
   * @param {String} order_id The order ID for this transaction as a String.
   * Example: 'order1234'
   */
		value: function setOrderId(order_id) {
			this._order_id = order_id;
			return this;
		}

		/**
   * Gets the predicted LifeTimeValue for the (user) in custom data.
   * The predicted lifetime value of a conversion event, as a String.
   * Example: '432.12'
   */

	}, {
		key: 'setPredictedLtv',


		/**
   * Sets the predicted LifeTimeValue for the custom data.
   * @param {Number} predicted_ltv The predicted lifetime value of a conversion event, as a String.
   * Example: '432.12'
   */
		value: function setPredictedLtv(predicted_ltv) {
			this._predicted_ltv = predicted_ltv;
			return this;
		}

		/**
   * Gets the number of items for the custom data.
   * The number of items that a user tries to buy during checkout. Use only with InitiateCheckout type events.
   * Example: 5
   */

	}, {
		key: 'setNumItems',


		/**
   * Sets the number of items for the custom data.
   * @param {Number} num_items The number of items that a user tries to buy during checkout. Use only with InitiateCheckout type events.
   * Example: 5
   */
		value: function setNumItems(num_items) {
			this._num_items = num_items;
			return this;
		}

		/**
   * Gets the search string for the custom data.
   * A search query made by a user.Use only with Search events.
   * Eg: 'lettuce'
   */

	}, {
		key: 'setSearchString',


		/**
   * Sets the search string for the custom data.
   * @param search_string A search query made by a user.Use only with Search events.
   * Eg: 'lettuce'
   */
		value: function setSearchString(search_string) {
			this._search_string = search_string;
			return this;
		}

		/**
   * Gets the item number.
   */

	}, {
		key: 'setItemNumber',


		/**
   * Sets the item number.
   * @param {String} item_number The item number.
   */
		value: function setItemNumber(item_number) {
			this._item_number = item_number;
			return this;
		}

		/**
   * Gets the delivery category.
   */

	}, {
		key: 'setDeliveryCategory',


		/**
   * Sets the type of delivery for a purchase event.
   * @param {String} delivery_category The delivery category.
   */
		value: function setDeliveryCategory(delivery_category) {
			this._delivery_category = delivery_category;
			return this;
		}

		/**
   * Gets the custom properties to be included in the Custom Data.
   * If our predefined object properties don't suit your needs, you can include your own, custom properties. Custom properties can be used with both standard and custom events, and can help you further define custom audiences.
   * This behavior is the same for Conversions API and Facebook Pixel.
   * @see {@link https://developers.facebook.com/docs/marketing-api/conversions-api/parameters/custom-data#custom-properties}
   * Eg: '{ 'warehouse_location' : 'washington', 'package_size' : 'L'}'
   */

	}, {
		key: 'setCustomProperties',


		/**
   * Sets the search string for the custom data.
   * @param custom_properties A custom properties property bag to be included in the Custom Data.
   * If our predefined object properties don't suit your needs, you can include your own, custom properties. Custom properties can be used with both standard and custom events, and can help you further define custom audiences.
   * This behavior is the same for Conversions API and Facebook Pixel.
   * @see {@link https://developers.facebook.com/docs/marketing-api/conversions-api/parameters/custom-data#custom-properties}
   * Eg: '{ 'warehouse_location' : 'washington', 'package_size' : 'L'}'
   * * @returns {Object} custom_properties property bag.
   */
		value: function setCustomProperties(custom_properties) {
			this._custom_properties = custom_properties;
			return this;
		}

		/**
   * Gets the status of the registration event.
   * Status of the registration event, as a String.Use only with CompleteRegistration events.
   */

	}, {
		key: 'setStatus',


		/**
   * Sets the status of the registration event.
   * @param {String} status Status of the registration event, as a String. Use only with CompleteRegistration events.
   */
		value: function setStatus(status) {
			this._status = status;
			return this;
		}

		/**
   * Adds the custom property (key, value) to the custom property bag.
   * @param {string} key The Key for the property to be added.
   * @param {string} value The Value for the property to be added.
   */

	}, {
		key: 'add_custom_property',
		value: function add_custom_property(key, value) {

			if (this.custom_properties == null) {
				this.custom_properties = {};
			}

			this.custom_properties[key] = value;
		}

		/**
   * Returns the normalized payload for the custom_data.
   * @returns {Object} normalized custom_data payload.
   */

	}, {
		key: 'normalize',
		value: function normalize() {
			var customData = {};

			var parsedValue = Number.parseFloat(this.value);
			if (!Number.isNaN(parsedValue)) {
				customData['value'] = parsedValue;
			}

			var parsedNetRevenue = Number.parseFloat(this.net_revenue);
			if (!Number.isNaN(parsedNetRevenue)) {
				customData['net_revenue'] = parsedNetRevenue;
			}

			if (this.currency) {
				customData['currency'] = ServerSideUtils.normalizeCurrency(this.currency);
			}

			if (this.content_name) {
				customData['content_name'] = this.content_name;
			}

			if (this.content_category) {
				customData['content_category'] = this.content_category;
			}

			if (this.content_ids) {
				customData['content_ids'] = this.content_ids;
			}

			if (this.contents) {
				var normalized_contents = [];

				for (var i = 0; i < this.contents.length; i++) {
					var content = this.contents[i];
					var normalized_content = content.normalize.call(content);
					normalized_contents.push(normalized_content);
				}

				customData['contents'] = normalized_contents;
			}

			if (this.content_type) {
				customData['content_type'] = this.content_type;
			}

			if (this.order_id) {
				customData['order_id'] = this.order_id;
			}

			if (this.predicted_ltv) {
				customData['predicted_ltv'] = this.predicted_ltv;
			}

			if (this.num_items) {
				customData['num_items'] = this.num_items;
			}

			if (this.search_string) {
				customData['search_string'] = this.search_string;
			}

			if (this.status) {
				customData['status'] = this.status;
			}

			if (this.item_number) {
				customData['item_number'] = this.item_number;
			}

			if (this.delivery_category) {
				customData['delivery_category'] = ServerSideUtils.normalizeDeliveryCategory(this.delivery_category);
			}

			if (this.custom_properties) {
				for (var key in this.custom_properties) {
					if (customData.hasOwnProperty(key)) {
						throw new Error('Duplicate key in custom_properties:"' + key + '". Please make sure the keys defined in the custom_properties are not already available in standard custom_data property list.');
					}

					customData[key] = this.custom_properties[key];
				}
			}

			return customData;
		}
	}, {
		key: 'value',
		get: function get() {
			return this._value;
		}

		/**
   * Sets the value of the custom data.
   * @param value A numeric value associated with this event. This could be a monetary value or a value in some other metric.
   * Example: 142.54.
   */
		,
		set: function set(value) {
			this._value = value;
		}
	}, {
		key: 'net_revenue',
		get: function get() {
			return this._net_revenue;
		}

		/**
   * Sets the net_revenue of the custom data.
   * @param net_revenue A numeric net_revenue associated with this event. This could be a monetary net_revenue or a net_revenue in some other metric.
   * Example: 30.54.
   */
		,
		set: function set(net_revenue) {
			this._net_revenue = net_revenue;
		}
	}, {
		key: 'currency',
		get: function get() {
			return this._currency;
		}

		/**
   * Sets the currency for the custom data.
   * @param currency The currency for the value specified, if applicable. Currency must be a valid ISO 4217 three digit currency code.
   * Example: 'usd'
   */
		,
		set: function set(currency) {
			this._currency = currency;
		}
	}, {
		key: 'content_name',
		get: function get() {
			return this._content_name;
		}

		/**
   * Sets the content name for the custom data.
   * @param content_name The name of the page or product associated with the event.
   * Example: 'lettuce'
   */
		,
		set: function set(content_name) {
			this._content_name = content_name;
		}
	}, {
		key: 'content_category',
		get: function get() {
			return this._content_category;
		}

		/**
   * Sets the content_category for the custom data.
   * @param content_category The category of the content associated with the event.
   * Example: 'grocery'
   */
		,
		set: function set(content_category) {
			this._content_category = content_category;
		}
	}, {
		key: 'content_ids',
		get: function get() {
			return this._content_ids;
		}

		/**
   * Sets the content_ids for the custom data.
   * @param content_ids The content IDs associated with the event, such as product SKUs for items in an AddToCart, represented as Array of string.
   * If content_type is a product, then your content IDs must be an array with a single string value. Otherwise, this array can contain any number of string values.
   * Example: ['ABC123', 'XYZ789']
   */
		,
		set: function set(content_ids) {
			this._content_ids = content_ids;
		}
	}, {
		key: 'contents',
		get: function get() {
			return this._contents;
		}

		/**
   * Sets the contents for the custom data.
   * @param contents An array of Content objects that contain the product IDs associated with the event plus information about the products. id, quantity, and item_price are available fields.
   * Example: [{'id':'ABC123','quantity' :2,'item_price':5.99}, {'id':'XYZ789','quantity':2, 'item_price':9.99}]
   */
		,
		set: function set(contents) {
			this._contents = contents;
		}
	}, {
		key: 'content_type',
		get: function get() {
			return this._content_type;
		}

		/**
   * Sets the content type for the custom data.
   * A String equal to either product or product_group. Set to product if the keys you send content_ids or contents represent products.
   * Set to product_group if the keys you send in content_ids represent product groups.
   */
		,
		set: function set(content_type) {
			this._content_type = content_type;
		}
	}, {
		key: 'order_id',
		get: function get() {
			return this._order_id;
		}

		/**
   * Sets the order_id for the custom data.
   * @param order_id The order ID for this transaction as a String.
   * Example: 'order1234'
   */
		,
		set: function set(order_id) {
			this._order_id = order_id;
		}
	}, {
		key: 'predicted_ltv',
		get: function get() {
			return this._predicted_ltv;
		}

		/**
   * Sets the predicted LifeTimeValue for the custom data.
   * @param predicted_ltv The predicted lifetime value of a conversion event, as a String.
   * Example: '432.12'
   */
		,
		set: function set(predicted_ltv) {
			this._predicted_ltv = predicted_ltv;
		}
	}, {
		key: 'num_items',
		get: function get() {
			return this._num_items;
		}

		/**
   * Sets the number of items for the custom data.
   * @param num_items The number of items that a user tries to buy during checkout. Use only with InitiateCheckout type events.
   * Example: 5
   */
		,
		set: function set(num_items) {
			this._num_items = num_items;
		}
	}, {
		key: 'search_string',
		get: function get() {
			return this._search_string;
		}

		/**
   * Sets the search string for the custom data.
   * @param {Number} search_string A search query made by a user.Use only with Search events.
   * Eg: 'lettuce'
   */
		,
		set: function set(search_string) {
			this._search_string = search_string;
		}
	}, {
		key: 'item_number',
		get: function get() {
			return this._item_number;
		}

		/**
   * Sets the item number.
   * @param item_number The item number.
   */
		,
		set: function set(item_number) {
			this._item_number = item_number;
		}
	}, {
		key: 'delivery_category',
		get: function get() {
			return this._delivery_category;
		}

		/**
   * Sets the type of delivery for a purchase event.
   * @param delivery_category The delivery category.
   */
		,
		set: function set(delivery_category) {
			this._delivery_category = delivery_category;
		}
	}, {
		key: 'custom_properties',
		get: function get() {
			return this._custom_properties;
		}

		/**
   * Sets the custom properties to be included in the Custom Data.
   * If our predefined object properties don't suit your needs, you can include your own, custom properties. Custom properties can be used with both standard and custom events, and can help you further define custom audiences.
   * This behavior is the same for Conversions API and Facebook Pixel.
   * @see {@link https://developers.facebook.com/docs/marketing-api/conversions-api/parameters/custom-data#custom-properties}
   * @param {Object} custom_properties custom properties property bag to be included in the Custom Data. Eg: '{ 'warehouse_location' : 'washington', 'package_size' : 'L'}'
   */
		,
		set: function set(custom_properties) {
			this._custom_properties = custom_properties;
		}
	}, {
		key: 'status',
		get: function get() {
			return this._status;
		}

		/**
   * Sets the status of the registration event.
   * @param status Status of the registration event, as a String.Use only with CompleteRegistration events.
   */
		,
		set: function set(status) {
			this._status = status;
		}
	}]);
	return CustomData;
}();

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdAccountBusinessConstraints
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdAccountBusinessConstraints = function (_AbstractCrudObject) {
  inherits(AdAccountBusinessConstraints, _AbstractCrudObject);

  function AdAccountBusinessConstraints() {
    classCallCheck(this, AdAccountBusinessConstraints);
    return possibleConstructorReturn(this, (AdAccountBusinessConstraints.__proto__ || Object.getPrototypeOf(AdAccountBusinessConstraints)).apply(this, arguments));
  }

  createClass(AdAccountBusinessConstraints, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        audience_controls: 'audience_controls',
        campaigns_with_error: 'campaigns_with_error',
        placement_controls: 'placement_controls',
        status: 'status'
      });
    }
  }, {
    key: 'Status',
    get: function get() {
      return Object.freeze({
        active: 'ACTIVE',
        application_in_progress: 'APPLICATION_IN_PROGRESS',
        with_campaign_error: 'WITH_CAMPAIGN_ERROR'
      });
    }
  }]);
  return AdAccountBusinessConstraints;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdActivity
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdActivity = function (_AbstractCrudObject) {
  inherits(AdActivity, _AbstractCrudObject);

  function AdActivity() {
    classCallCheck(this, AdActivity);
    return possibleConstructorReturn(this, (AdActivity.__proto__ || Object.getPrototypeOf(AdActivity)).apply(this, arguments));
  }

  createClass(AdActivity, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        actor_id: 'actor_id',
        actor_name: 'actor_name',
        application_id: 'application_id',
        application_name: 'application_name',
        date_time_in_timezone: 'date_time_in_timezone',
        event_time: 'event_time',
        event_type: 'event_type',
        extra_data: 'extra_data',
        object_id: 'object_id',
        object_name: 'object_name',
        object_type: 'object_type',
        translated_event_type: 'translated_event_type'
      });
    }
  }, {
    key: 'EventType',
    get: function get() {
      return Object.freeze({
        accept_custom_audience_appeal: 'accept_custom_audience_appeal',
        account_spending_limit_reached: 'account_spending_limit_reached',
        ad_account_add_user_to_role: 'ad_account_add_user_to_role',
        ad_account_billing_charge: 'ad_account_billing_charge',
        ad_account_billing_charge_failed: 'ad_account_billing_charge_failed',
        ad_account_billing_chargeback: 'ad_account_billing_chargeback',
        ad_account_billing_chargeback_reversal: 'ad_account_billing_chargeback_reversal',
        ad_account_billing_decline: 'ad_account_billing_decline',
        ad_account_billing_refund: 'ad_account_billing_refund',
        ad_account_remove_spend_limit: 'ad_account_remove_spend_limit',
        ad_account_remove_user_from_role: 'ad_account_remove_user_from_role',
        ad_account_reset_spend_limit: 'ad_account_reset_spend_limit',
        ad_account_set_business_information: 'ad_account_set_business_information',
        ad_account_update_audience_type_url_parameter: 'ad_account_update_audience_type_url_parameter',
        ad_account_update_spend_limit: 'ad_account_update_spend_limit',
        ad_account_update_status: 'ad_account_update_status',
        ad_review_approved: 'ad_review_approved',
        ad_review_declined: 'ad_review_declined',
        adaccount_update_audience_segment: 'adaccount_update_audience_segment',
        add_funding_source: 'add_funding_source',
        add_images: 'add_images',
        apply_restrictions_custom_audience: 'apply_restrictions_custom_audience',
        billing_event: 'billing_event',
        campaign_ended: 'campaign_ended',
        campaign_spending_limit_reached: 'campaign_spending_limit_reached',
        conversion_event_updated: 'conversion_event_updated',
        create_ad: 'create_ad',
        create_ad_set: 'create_ad_set',
        create_adaccount_agency_fee: 'create_adaccount_agency_fee',
        create_audience: 'create_audience',
        create_campaign_group: 'create_campaign_group',
        create_campaign_group_agency_fee: 'create_campaign_group_agency_fee',
        create_campaign_legacy: 'create_campaign_legacy',
        create_custom_audience_appeal: 'create_custom_audience_appeal',
        delete_audience: 'delete_audience',
        delete_images: 'delete_images',
        di_ad_set_learning_stage_exit: 'di_ad_set_learning_stage_exit',
        edit_and_update_ad_creative: 'edit_and_update_ad_creative',
        edit_images: 'edit_images',
        first_delivery_event: 'first_delivery_event',
        funding_event_initiated: 'funding_event_initiated',
        funding_event_successful: 'funding_event_successful',
        lifetime_budget_spent: 'lifetime_budget_spent',
        merge_campaigns: 'merge_campaigns',
        receive_audience: 'receive_audience',
        reject_custom_audience_appeal: 'reject_custom_audience_appeal',
        remove_funding_source: 'remove_funding_source',
        remove_shared_audience: 'remove_shared_audience',
        share_audience: 'share_audience',
        unknown: 'unknown',
        unshare_audience: 'unshare_audience',
        update_ad_bid_info: 'update_ad_bid_info',
        update_ad_bid_type: 'update_ad_bid_type',
        update_ad_creative: 'update_ad_creative',
        update_ad_friendly_name: 'update_ad_friendly_name',
        update_ad_labels: 'update_ad_labels',
        update_ad_run_status: 'update_ad_run_status',
        update_ad_run_status_to_be_set_after_review: 'update_ad_run_status_to_be_set_after_review',
        update_ad_set_ad_keywords: 'update_ad_set_ad_keywords',
        update_ad_set_bid_adjustments: 'update_ad_set_bid_adjustments',
        update_ad_set_bid_strategy: 'update_ad_set_bid_strategy',
        update_ad_set_bidding: 'update_ad_set_bidding',
        update_ad_set_budget: 'update_ad_set_budget',
        update_ad_set_duration: 'update_ad_set_duration',
        update_ad_set_learning_stage_status: 'update_ad_set_learning_stage_status',
        update_ad_set_min_spend_target: 'update_ad_set_min_spend_target',
        update_ad_set_name: 'update_ad_set_name',
        update_ad_set_optimization_goal: 'update_ad_set_optimization_goal',
        update_ad_set_run_status: 'update_ad_set_run_status',
        update_ad_set_spend_cap: 'update_ad_set_spend_cap',
        update_ad_set_target_spec: 'update_ad_set_target_spec',
        update_ad_targets_spec: 'update_ad_targets_spec',
        update_adaccount_agency_fee: 'update_adaccount_agency_fee',
        update_adaccount_agency_fee_status: 'update_adaccount_agency_fee_status',
        update_adgroup_stop_delivery: 'update_adgroup_stop_delivery',
        update_audience: 'update_audience',
        update_budget_flex_toggle_status: 'update_budget_flex_toggle_status',
        update_campaign_ad_scheduling: 'update_campaign_ad_scheduling',
        update_campaign_budget: 'update_campaign_budget',
        update_campaign_budget_optimization_toggling_status: 'update_campaign_budget_optimization_toggling_status',
        update_campaign_budget_scheduling_state: 'update_campaign_budget_scheduling_state',
        update_campaign_conversion_goal: 'update_campaign_conversion_goal',
        update_campaign_delivery_destination: 'update_campaign_delivery_destination',
        update_campaign_delivery_type: 'update_campaign_delivery_type',
        update_campaign_group_ad_scheduling: 'update_campaign_group_ad_scheduling',
        update_campaign_group_agency_fee: 'update_campaign_group_agency_fee',
        update_campaign_group_budget_scheduling_state: 'update_campaign_group_budget_scheduling_state',
        update_campaign_group_delivery_type: 'update_campaign_group_delivery_type',
        update_campaign_group_high_demand_periods: 'update_campaign_group_high_demand_periods',
        update_campaign_group_spend_cap: 'update_campaign_group_spend_cap',
        update_campaign_high_demand_periods: 'update_campaign_high_demand_periods',
        update_campaign_name: 'update_campaign_name',
        update_campaign_run_status: 'update_campaign_run_status',
        update_campaign_schedule: 'update_campaign_schedule',
        update_campaign_value_adjustment_rule: 'update_campaign_value_adjustment_rule',
        update_delivery_type_cross_level_shift: 'update_delivery_type_cross_level_shift'
      });
    }
  }, {
    key: 'Category',
    get: function get() {
      return Object.freeze({
        account: 'ACCOUNT',
        ad: 'AD',
        ad_keywords: 'AD_KEYWORDS',
        ad_set: 'AD_SET',
        audience: 'AUDIENCE',
        bid: 'BID',
        budget: 'BUDGET',
        campaign: 'CAMPAIGN',
        date: 'DATE',
        status: 'STATUS',
        targeting: 'TARGETING'
      });
    }
  }, {
    key: 'DataSource',
    get: function get() {
      return Object.freeze({
        calypso: 'CALYPSO',
        tao: 'TAO',
        tao_ad_account: 'TAO_AD_ACCOUNT',
        tao_ad_status: 'TAO_AD_STATUS'
      });
    }
  }]);
  return AdActivity;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdPlacePageSet
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdPlacePageSet = function (_AbstractCrudObject) {
  inherits(AdPlacePageSet, _AbstractCrudObject);

  function AdPlacePageSet() {
    classCallCheck(this, AdPlacePageSet);
    return possibleConstructorReturn(this, (AdPlacePageSet.__proto__ || Object.getPrototypeOf(AdPlacePageSet)).apply(this, arguments));
  }

  createClass(AdPlacePageSet, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        account_id: 'account_id',
        id: 'id',
        location_types: 'location_types',
        name: 'name',
        pages_count: 'pages_count',
        parent_page: 'parent_page'
      });
    }
  }, {
    key: 'LocationTypes',
    get: function get() {
      return Object.freeze({
        home: 'home',
        recent: 'recent'
      });
    }
  }, {
    key: 'TargetedAreaType',
    get: function get() {
      return Object.freeze({
        custom_radius: 'CUSTOM_RADIUS',
        marketing_area: 'MARKETING_AREA',
        none: 'NONE'
      });
    }
  }]);
  return AdPlacePageSet;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdSavedKeywords
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdSavedKeywords = function (_AbstractCrudObject) {
  inherits(AdSavedKeywords, _AbstractCrudObject);

  function AdSavedKeywords() {
    classCallCheck(this, AdSavedKeywords);
    return possibleConstructorReturn(this, (AdSavedKeywords.__proto__ || Object.getPrototypeOf(AdSavedKeywords)).apply(this, arguments));
  }

  createClass(AdSavedKeywords, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        account: 'account',
        id: 'id',
        keywords: 'keywords',
        name: 'name',
        run_status: 'run_status',
        time_created: 'time_created',
        time_updated: 'time_updated'
      });
    }
  }]);
  return AdSavedKeywords;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdCreativeInsights
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdCreativeInsights = function (_AbstractCrudObject) {
  inherits(AdCreativeInsights, _AbstractCrudObject);

  function AdCreativeInsights() {
    classCallCheck(this, AdCreativeInsights);
    return possibleConstructorReturn(this, (AdCreativeInsights.__proto__ || Object.getPrototypeOf(AdCreativeInsights)).apply(this, arguments));
  }

  createClass(AdCreativeInsights, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        aesthetics: 'aesthetics'
      });
    }
  }]);
  return AdCreativeInsights;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdPreview
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdPreview = function (_AbstractCrudObject) {
  inherits(AdPreview, _AbstractCrudObject);

  function AdPreview() {
    classCallCheck(this, AdPreview);
    return possibleConstructorReturn(this, (AdPreview.__proto__ || Object.getPrototypeOf(AdPreview)).apply(this, arguments));
  }

  createClass(AdPreview, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        body: 'body',
        transformation_spec: 'transformation_spec'
      });
    }
  }, {
    key: 'AdFormat',
    get: function get() {
      return Object.freeze({
        audience_network_instream_video: 'AUDIENCE_NETWORK_INSTREAM_VIDEO',
        audience_network_instream_video_mobile: 'AUDIENCE_NETWORK_INSTREAM_VIDEO_MOBILE',
        audience_network_outstream_video: 'AUDIENCE_NETWORK_OUTSTREAM_VIDEO',
        audience_network_rewarded_video: 'AUDIENCE_NETWORK_REWARDED_VIDEO',
        biz_disco_feed_mobile: 'BIZ_DISCO_FEED_MOBILE',
        desktop_feed_standard: 'DESKTOP_FEED_STANDARD',
        facebook_ifu_reels_mobile: 'FACEBOOK_IFU_REELS_MOBILE',
        facebook_profile_feed_desktop: 'FACEBOOK_PROFILE_FEED_DESKTOP',
        facebook_profile_feed_mobile: 'FACEBOOK_PROFILE_FEED_MOBILE',
        facebook_profile_reels_mobile: 'FACEBOOK_PROFILE_REELS_MOBILE',
        facebook_reels_banner: 'FACEBOOK_REELS_BANNER',
        facebook_reels_banner_desktop: 'FACEBOOK_REELS_BANNER_DESKTOP',
        facebook_reels_banner_feed_android: 'FACEBOOK_REELS_BANNER_FEED_ANDROID',
        facebook_reels_banner_feed_android_large: 'FACEBOOK_REELS_BANNER_FEED_ANDROID_LARGE',
        facebook_reels_banner_fullscreen_ios: 'FACEBOOK_REELS_BANNER_FULLSCREEN_IOS',
        facebook_reels_banner_fullscreen_mobile: 'FACEBOOK_REELS_BANNER_FULLSCREEN_MOBILE',
        facebook_reels_mobile: 'FACEBOOK_REELS_MOBILE',
        facebook_reels_postloop: 'FACEBOOK_REELS_POSTLOOP',
        facebook_reels_postloop_feed: 'FACEBOOK_REELS_POSTLOOP_FEED',
        facebook_reels_sticker: 'FACEBOOK_REELS_STICKER',
        facebook_story_mobile: 'FACEBOOK_STORY_MOBILE',
        facebook_story_sticker_mobile: 'FACEBOOK_STORY_STICKER_MOBILE',
        instagram_explore_contextual: 'INSTAGRAM_EXPLORE_CONTEXTUAL',
        instagram_explore_grid_home: 'INSTAGRAM_EXPLORE_GRID_HOME',
        instagram_explore_immersive: 'INSTAGRAM_EXPLORE_IMMERSIVE',
        instagram_feed_web: 'INSTAGRAM_FEED_WEB',
        instagram_feed_web_m_site: 'INSTAGRAM_FEED_WEB_M_SITE',
        instagram_lead_gen_multi_submit_ads: 'INSTAGRAM_LEAD_GEN_MULTI_SUBMIT_ADS',
        instagram_profile_feed: 'INSTAGRAM_PROFILE_FEED',
        instagram_profile_reels: 'INSTAGRAM_PROFILE_REELS',
        instagram_reels: 'INSTAGRAM_REELS',
        instagram_reels_instream: 'INSTAGRAM_REELS_INSTREAM',
        instagram_reels_overlay: 'INSTAGRAM_REELS_OVERLAY',
        instagram_reels_web: 'INSTAGRAM_REELS_WEB',
        instagram_reels_web_m_site: 'INSTAGRAM_REELS_WEB_M_SITE',
        instagram_search_chain: 'INSTAGRAM_SEARCH_CHAIN',
        instagram_search_grid: 'INSTAGRAM_SEARCH_GRID',
        instagram_standard: 'INSTAGRAM_STANDARD',
        instagram_story: 'INSTAGRAM_STORY',
        instagram_story_effect_tray: 'INSTAGRAM_STORY_EFFECT_TRAY',
        instagram_story_web: 'INSTAGRAM_STORY_WEB',
        instagram_story_web_m_site: 'INSTAGRAM_STORY_WEB_M_SITE',
        instant_article_recirculation_ad: 'INSTANT_ARTICLE_RECIRCULATION_AD',
        instant_article_standard: 'INSTANT_ARTICLE_STANDARD',
        instream_banner_desktop: 'INSTREAM_BANNER_DESKTOP',
        instream_banner_feed_ios: 'INSTREAM_BANNER_FEED_IOS',
        instream_banner_fullscreen_ios: 'INSTREAM_BANNER_FULLSCREEN_IOS',
        instream_banner_fullscreen_mobile: 'INSTREAM_BANNER_FULLSCREEN_MOBILE',
        instream_banner_immersive_mobile: 'INSTREAM_BANNER_IMMERSIVE_MOBILE',
        instream_banner_mobile: 'INSTREAM_BANNER_MOBILE',
        instream_video_desktop: 'INSTREAM_VIDEO_DESKTOP',
        instream_video_fullscreen_ios: 'INSTREAM_VIDEO_FULLSCREEN_IOS',
        instream_video_fullscreen_mobile: 'INSTREAM_VIDEO_FULLSCREEN_MOBILE',
        instream_video_image: 'INSTREAM_VIDEO_IMAGE',
        instream_video_immersive_mobile: 'INSTREAM_VIDEO_IMMERSIVE_MOBILE',
        instream_video_mobile: 'INSTREAM_VIDEO_MOBILE',
        job_browser_desktop: 'JOB_BROWSER_DESKTOP',
        job_browser_mobile: 'JOB_BROWSER_MOBILE',
        marketplace_mobile: 'MARKETPLACE_MOBILE',
        messenger_mobile_inbox_media: 'MESSENGER_MOBILE_INBOX_MEDIA',
        messenger_mobile_story_media: 'MESSENGER_MOBILE_STORY_MEDIA',
        mobile_banner: 'MOBILE_BANNER',
        mobile_feed_basic: 'MOBILE_FEED_BASIC',
        mobile_feed_standard: 'MOBILE_FEED_STANDARD',
        mobile_fullwidth: 'MOBILE_FULLWIDTH',
        mobile_interstitial: 'MOBILE_INTERSTITIAL',
        mobile_medium_rectangle: 'MOBILE_MEDIUM_RECTANGLE',
        mobile_native: 'MOBILE_NATIVE',
        right_column_standard: 'RIGHT_COLUMN_STANDARD',
        suggested_video_desktop: 'SUGGESTED_VIDEO_DESKTOP',
        suggested_video_fullscreen_mobile: 'SUGGESTED_VIDEO_FULLSCREEN_MOBILE',
        suggested_video_immersive_mobile: 'SUGGESTED_VIDEO_IMMERSIVE_MOBILE',
        suggested_video_mobile: 'SUGGESTED_VIDEO_MOBILE',
        watch_feed_home: 'WATCH_FEED_HOME',
        watch_feed_mobile: 'WATCH_FEED_MOBILE'
      });
    }
  }, {
    key: 'CreativeFeature',
    get: function get() {
      return Object.freeze({
        product_metadata_automation: 'product_metadata_automation',
        profile_card: 'profile_card',
        standard_enhancements_catalog: 'standard_enhancements_catalog',
        text_overlay_translation: 'text_overlay_translation'
      });
    }
  }, {
    key: 'RenderType',
    get: function get() {
      return Object.freeze({
        fallback: 'FALLBACK'
      });
    }
  }]);
  return AdPreview;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdCreative
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdCreative = function (_AbstractCrudObject) {
  inherits(AdCreative, _AbstractCrudObject);

  function AdCreative() {
    classCallCheck(this, AdCreative);
    return possibleConstructorReturn(this, (AdCreative.__proto__ || Object.getPrototypeOf(AdCreative)).apply(this, arguments));
  }

  createClass(AdCreative, [{
    key: 'createAdLabel',
    value: function createAdLabel(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/adlabels', fields, params, AdCreative, pathOverride);
    }
  }, {
    key: 'getCreativeInsights',
    value: function getCreativeInsights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdCreativeInsights, fields, params, fetchFirstPage, '/creative_insights');
    }
  }, {
    key: 'getPreviews',
    value: function getPreviews(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdPreview, fields, params, fetchFirstPage, '/previews');
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(AdCreative.prototype.__proto__ || Object.getPrototypeOf(AdCreative.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(AdCreative.prototype.__proto__ || Object.getPrototypeOf(AdCreative.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        account_id: 'account_id',
        actor_id: 'actor_id',
        ad_disclaimer_spec: 'ad_disclaimer_spec',
        adlabels: 'adlabels',
        applink_treatment: 'applink_treatment',
        asset_feed_spec: 'asset_feed_spec',
        authorization_category: 'authorization_category',
        auto_update: 'auto_update',
        body: 'body',
        branded_content: 'branded_content',
        branded_content_sponsor_page_id: 'branded_content_sponsor_page_id',
        bundle_folder_id: 'bundle_folder_id',
        call_to_action: 'call_to_action',
        call_to_action_type: 'call_to_action_type',
        categorization_criteria: 'categorization_criteria',
        category_media_source: 'category_media_source',
        collaborative_ads_lsb_image_bank_id: 'collaborative_ads_lsb_image_bank_id',
        contextual_multi_ads: 'contextual_multi_ads',
        creative_sourcing_spec: 'creative_sourcing_spec',
        degrees_of_freedom_spec: 'degrees_of_freedom_spec',
        destination_set_id: 'destination_set_id',
        destination_spec: 'destination_spec',
        dynamic_ad_voice: 'dynamic_ad_voice',
        effective_authorization_category: 'effective_authorization_category',
        effective_instagram_media_id: 'effective_instagram_media_id',
        effective_object_story_id: 'effective_object_story_id',
        enable_direct_install: 'enable_direct_install',
        enable_launch_instant_app: 'enable_launch_instant_app',
        facebook_branded_content: 'facebook_branded_content',
        format_transformation_spec: 'format_transformation_spec',
        id: 'id',
        image_crops: 'image_crops',
        image_hash: 'image_hash',
        image_url: 'image_url',
        instagram_branded_content: 'instagram_branded_content',
        instagram_permalink_url: 'instagram_permalink_url',
        instagram_user_id: 'instagram_user_id',
        interactive_components_spec: 'interactive_components_spec',
        link_deep_link_url: 'link_deep_link_url',
        link_destination_display_url: 'link_destination_display_url',
        link_og_id: 'link_og_id',
        link_url: 'link_url',
        media_sourcing_spec: 'media_sourcing_spec',
        messenger_sponsored_message: 'messenger_sponsored_message',
        name: 'name',
        object_id: 'object_id',
        object_store_url: 'object_store_url',
        object_story_id: 'object_story_id',
        object_story_spec: 'object_story_spec',
        object_type: 'object_type',
        object_url: 'object_url',
        omnichannel_link_spec: 'omnichannel_link_spec',
        page_welcome_message: 'page_welcome_message',
        photo_album_source_object_story_id: 'photo_album_source_object_story_id',
        place_page_set_id: 'place_page_set_id',
        platform_customizations: 'platform_customizations',
        playable_asset_id: 'playable_asset_id',
        portrait_customizations: 'portrait_customizations',
        product_data: 'product_data',
        product_set_id: 'product_set_id',
        recommender_settings: 'recommender_settings',
        regional_regulation_disclaimer_spec: 'regional_regulation_disclaimer_spec',
        source_facebook_post_id: 'source_facebook_post_id',
        source_instagram_media_id: 'source_instagram_media_id',
        status: 'status',
        template_url: 'template_url',
        template_url_spec: 'template_url_spec',
        thumbnail_id: 'thumbnail_id',
        thumbnail_url: 'thumbnail_url',
        title: 'title',
        url_tags: 'url_tags',
        use_page_actor_override: 'use_page_actor_override',
        video_id: 'video_id'
      });
    }
  }, {
    key: 'CallToActionType',
    get: function get() {
      return Object.freeze({
        add_to_cart: 'ADD_TO_CART',
        apply_now: 'APPLY_NOW',
        ask_about_services: 'ASK_ABOUT_SERVICES',
        ask_for_more_info: 'ASK_FOR_MORE_INFO',
        audio_call: 'AUDIO_CALL',
        book_a_consultation: 'BOOK_A_CONSULTATION',
        book_now: 'BOOK_NOW',
        book_travel: 'BOOK_TRAVEL',
        browse_shop: 'BROWSE_SHOP',
        buy: 'BUY',
        buy_now: 'BUY_NOW',
        buy_tickets: 'BUY_TICKETS',
        buy_via_message: 'BUY_VIA_MESSAGE',
        call: 'CALL',
        call_me: 'CALL_ME',
        call_now: 'CALL_NOW',
        chat_with_us: 'CHAT_WITH_US',
        confirm: 'CONFIRM',
        contact: 'CONTACT',
        contact_us: 'CONTACT_US',
        donate: 'DONATE',
        donate_now: 'DONATE_NOW',
        download: 'DOWNLOAD',
        event_rsvp: 'EVENT_RSVP',
        find_a_group: 'FIND_A_GROUP',
        find_out_more: 'FIND_OUT_MORE',
        find_your_groups: 'FIND_YOUR_GROUPS',
        follow_news_storyline: 'FOLLOW_NEWS_STORYLINE',
        follow_page: 'FOLLOW_PAGE',
        follow_user: 'FOLLOW_USER',
        get_a_quote: 'GET_A_QUOTE',
        get_details: 'GET_DETAILS',
        get_directions: 'GET_DIRECTIONS',
        get_in_touch: 'GET_IN_TOUCH',
        get_offer: 'GET_OFFER',
        get_offer_view: 'GET_OFFER_VIEW',
        get_promotions: 'GET_PROMOTIONS',
        get_quote: 'GET_QUOTE',
        get_showtimes: 'GET_SHOWTIMES',
        get_started: 'GET_STARTED',
        inquire_now: 'INQUIRE_NOW',
        install_app: 'INSTALL_APP',
        install_mobile_app: 'INSTALL_MOBILE_APP',
        join_channel: 'JOIN_CHANNEL',
        learn_more: 'LEARN_MORE',
        like_page: 'LIKE_PAGE',
        listen_music: 'LISTEN_MUSIC',
        listen_now: 'LISTEN_NOW',
        make_an_appointment: 'MAKE_AN_APPOINTMENT',
        message_page: 'MESSAGE_PAGE',
        mobile_download: 'MOBILE_DOWNLOAD',
        no_button: 'NO_BUTTON',
        open_instant_app: 'OPEN_INSTANT_APP',
        open_link: 'OPEN_LINK',
        order_now: 'ORDER_NOW',
        pay_to_access: 'PAY_TO_ACCESS',
        play_game: 'PLAY_GAME',
        play_game_on_facebook: 'PLAY_GAME_ON_FACEBOOK',
        purchase_gift_cards: 'PURCHASE_GIFT_CARDS',
        raise_money: 'RAISE_MONEY',
        record_now: 'RECORD_NOW',
        refer_friends: 'REFER_FRIENDS',
        request_time: 'REQUEST_TIME',
        say_thanks: 'SAY_THANKS',
        see_more: 'SEE_MORE',
        see_shop: 'SEE_SHOP',
        sell_now: 'SELL_NOW',
        send_a_gift: 'SEND_A_GIFT',
        send_gift_money: 'SEND_GIFT_MONEY',
        send_updates: 'SEND_UPDATES',
        share: 'SHARE',
        shop_now: 'SHOP_NOW',
        shop_with_ai: 'SHOP_WITH_AI',
        sign_up: 'SIGN_UP',
        sotto_subscribe: 'SOTTO_SUBSCRIBE',
        start_order: 'START_ORDER',
        subscribe: 'SUBSCRIBE',
        swipe_up_product: 'SWIPE_UP_PRODUCT',
        swipe_up_shop: 'SWIPE_UP_SHOP',
        try_demo: 'TRY_DEMO',
        try_on_with_ai: 'TRY_ON_WITH_AI',
        update_app: 'UPDATE_APP',
        use_app: 'USE_APP',
        use_mobile_app: 'USE_MOBILE_APP',
        video_annotation: 'VIDEO_ANNOTATION',
        video_call: 'VIDEO_CALL',
        view_cart: 'VIEW_CART',
        view_channel: 'VIEW_CHANNEL',
        view_in_cart: 'VIEW_IN_CART',
        view_product: 'VIEW_PRODUCT',
        visit_pages_feed: 'VISIT_PAGES_FEED',
        visit_website: 'VISIT_WEBSITE',
        watch_live_video: 'WATCH_LIVE_VIDEO',
        watch_more: 'WATCH_MORE',
        watch_video: 'WATCH_VIDEO',
        whatsapp_message: 'WHATSAPP_MESSAGE',
        woodhenge_support: 'WOODHENGE_SUPPORT'
      });
    }
  }, {
    key: 'ObjectType',
    get: function get() {
      return Object.freeze({
        application: 'APPLICATION',
        domain: 'DOMAIN',
        event: 'EVENT',
        invalid: 'INVALID',
        offer: 'OFFER',
        page: 'PAGE',
        photo: 'PHOTO',
        post_deleted: 'POST_DELETED',
        privacy_check_fail: 'PRIVACY_CHECK_FAIL',
        share: 'SHARE',
        status: 'STATUS',
        store_item: 'STORE_ITEM',
        video: 'VIDEO'
      });
    }
  }, {
    key: 'Status',
    get: function get() {
      return Object.freeze({
        active: 'ACTIVE',
        deleted: 'DELETED',
        in_process: 'IN_PROCESS',
        with_issues: 'WITH_ISSUES'
      });
    }
  }, {
    key: 'ApplinkTreatment',
    get: function get() {
      return Object.freeze({
        automatic: 'automatic',
        deeplink_with_appstore_fallback: 'deeplink_with_appstore_fallback',
        deeplink_with_web_fallback: 'deeplink_with_web_fallback',
        web_only: 'web_only'
      });
    }
  }, {
    key: 'AuthorizationCategory',
    get: function get() {
      return Object.freeze({
        none: 'NONE',
        political: 'POLITICAL',
        political_with_digitally_created_media: 'POLITICAL_WITH_DIGITALLY_CREATED_MEDIA'
      });
    }
  }, {
    key: 'CategorizationCriteria',
    get: function get() {
      return Object.freeze({
        brand: 'brand',
        category: 'category',
        product_type: 'product_type'
      });
    }
  }, {
    key: 'CategoryMediaSource',
    get: function get() {
      return Object.freeze({
        category: 'CATEGORY',
        mixed: 'MIXED',
        products_collage: 'PRODUCTS_COLLAGE',
        products_slideshow: 'PRODUCTS_SLIDESHOW'
      });
    }
  }, {
    key: 'DynamicAdVoice',
    get: function get() {
      return Object.freeze({
        dynamic: 'DYNAMIC',
        story_owner: 'STORY_OWNER'
      });
    }
  }, {
    key: 'ExecutionOptions',
    get: function get() {
      return Object.freeze({
        validate_only: 'validate_only'
      });
    }
  }, {
    key: 'Operator',
    get: function get() {
      return Object.freeze({
        all: 'ALL',
        any: 'ANY'
      });
    }
  }]);
  return AdCreative;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdRuleHistory
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdRuleHistory = function (_AbstractCrudObject) {
  inherits(AdRuleHistory, _AbstractCrudObject);

  function AdRuleHistory() {
    classCallCheck(this, AdRuleHistory);
    return possibleConstructorReturn(this, (AdRuleHistory.__proto__ || Object.getPrototypeOf(AdRuleHistory)).apply(this, arguments));
  }

  createClass(AdRuleHistory, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        evaluation_spec: 'evaluation_spec',
        exception_code: 'exception_code',
        exception_message: 'exception_message',
        execution_spec: 'execution_spec',
        is_manual: 'is_manual',
        results: 'results',
        schedule_spec: 'schedule_spec',
        timestamp: 'timestamp'
      });
    }
  }, {
    key: 'Action',
    get: function get() {
      return Object.freeze({
        budget_not_redistributed: 'BUDGET_NOT_REDISTRIBUTED',
        changed_bid: 'CHANGED_BID',
        changed_budget: 'CHANGED_BUDGET',
        consolidate_asc_fragmentation: 'CONSOLIDATE_ASC_FRAGMENTATION',
        consolidate_fragmentation: 'CONSOLIDATE_FRAGMENTATION',
        convert_asc_cp_single_instance: 'CONVERT_ASC_CP_SINGLE_INSTANCE',
        email: 'EMAIL',
        enable_advantage_campaign_budget: 'ENABLE_ADVANTAGE_CAMPAIGN_BUDGET',
        enable_advantage_plus_audience: 'ENABLE_ADVANTAGE_PLUS_AUDIENCE',
        enable_advantage_plus_creative: 'ENABLE_ADVANTAGE_PLUS_CREATIVE',
        enable_advantage_plus_placements: 'ENABLE_ADVANTAGE_PLUS_PLACEMENTS',
        enable_autoflow: 'ENABLE_AUTOFLOW',
        enable_gen_uncrop: 'ENABLE_GEN_UNCROP',
        enable_landing_page_views: 'ENABLE_LANDING_PAGE_VIEWS',
        enable_music: 'ENABLE_MUSIC',
        enable_product_set_boosting: 'ENABLE_PRODUCT_SET_BOOSTING',
        enable_reels_placements: 'ENABLE_REELS_PLACEMENTS',
        enable_semantic_based_audience_expansion: 'ENABLE_SEMANTIC_BASED_AUDIENCE_EXPANSION',
        enable_shops_ads: 'ENABLE_SHOPS_ADS',
        endpoint_pinged: 'ENDPOINT_PINGED',
        error: 'ERROR',
        facebook_notification_sent: 'FACEBOOK_NOTIFICATION_SENT',
        message_sent: 'MESSAGE_SENT',
        not_changed: 'NOT_CHANGED',
        paused: 'PAUSED',
        unpaused: 'UNPAUSED'
      });
    }
  }]);
  return AdRuleHistory;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdRule
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdRule = function (_AbstractCrudObject) {
  inherits(AdRule, _AbstractCrudObject);

  function AdRule() {
    classCallCheck(this, AdRule);
    return possibleConstructorReturn(this, (AdRule.__proto__ || Object.getPrototypeOf(AdRule)).apply(this, arguments));
  }

  createClass(AdRule, [{
    key: 'createExecute',
    value: function createExecute(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/execute', fields, params, null, pathOverride);
    }
  }, {
    key: 'getHistory',
    value: function getHistory(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdRuleHistory, fields, params, fetchFirstPage, '/history');
    }
  }, {
    key: 'createPreview',
    value: function createPreview(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/preview', fields, params, AdRule, pathOverride);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(AdRule.prototype.__proto__ || Object.getPrototypeOf(AdRule.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(AdRule.prototype.__proto__ || Object.getPrototypeOf(AdRule.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        account_id: 'account_id',
        created_by: 'created_by',
        created_time: 'created_time',
        disable_error_code: 'disable_error_code',
        evaluation_spec: 'evaluation_spec',
        execution_spec: 'execution_spec',
        id: 'id',
        name: 'name',
        schedule_spec: 'schedule_spec',
        status: 'status',
        updated_time: 'updated_time'
      });
    }
  }, {
    key: 'Status',
    get: function get() {
      return Object.freeze({
        deleted: 'DELETED',
        disabled: 'DISABLED',
        enabled: 'ENABLED',
        has_issues: 'HAS_ISSUES'
      });
    }
  }, {
    key: 'UiCreationSource',
    get: function get() {
      return Object.freeze({
        am_account_overview_recommendations: 'AM_ACCOUNT_OVERVIEW_RECOMMENDATIONS',
        am_activity_history_table: 'AM_ACTIVITY_HISTORY_TABLE',
        am_ad_object_name_card: 'AM_AD_OBJECT_NAME_CARD',
        am_amfe_l3_recommendation: 'AM_AMFE_L3_RECOMMENDATION',
        am_autoflow_guidance_card: 'AM_AUTOFLOW_GUIDANCE_CARD',
        am_auto_apply_widget: 'AM_AUTO_APPLY_WIDGET',
        am_editor_card: 'AM_EDITOR_CARD',
        am_info_card: 'AM_INFO_CARD',
        am_name_cell_dropdown: 'AM_NAME_CELL_DROPDOWN',
        am_optimization_tip_guidance_card: 'AM_OPTIMIZATION_TIP_GUIDANCE_CARD',
        am_performance_summary: 'AM_PERFORMANCE_SUMMARY',
        am_rule_landing_page_banner: 'AM_RULE_LANDING_PAGE_BANNER',
        am_syd_resolution_flow: 'AM_SYD_RESOLUTION_FLOW',
        am_syd_resolution_flow_modal: 'AM_SYD_RESOLUTION_FLOW_MODAL',
        am_table_delivery_column_popover: 'AM_TABLE_DELIVERY_COLUMN_POPOVER',
        am_table_more_rules_dropdown: 'AM_TABLE_MORE_RULES_DROPDOWN',
        am_table_toggle_popover: 'AM_TABLE_TOGGLE_POPOVER',
        am_toolbar_create_rule_dropdown: 'AM_TOOLBAR_CREATE_RULE_DROPDOWN',
        pe_campaign_structure_menu: 'PE_CAMPAIGN_STRUCTURE_MENU',
        pe_editor_card: 'PE_EDITOR_CARD',
        pe_info_card: 'PE_INFO_CARD',
        pe_toolbar_create_rule_dropdown: 'PE_TOOLBAR_CREATE_RULE_DROPDOWN',
        rules_management_page_action_dropdown: 'RULES_MANAGEMENT_PAGE_ACTION_DROPDOWN',
        rules_management_page_rule_group: 'RULES_MANAGEMENT_PAGE_RULE_GROUP',
        rules_management_page_rule_name: 'RULES_MANAGEMENT_PAGE_RULE_NAME',
        rules_management_page_top_nav: 'RULES_MANAGEMENT_PAGE_TOP_NAV',
        rules_view_active_rules_dialog: 'RULES_VIEW_ACTIVE_RULES_DIALOG',
        rule_creation_success_dialog: 'RULE_CREATION_SUCCESS_DIALOG',
        rule_syd_redirect: 'RULE_SYD_REDIRECT',
        rule_templates_dialog: 'RULE_TEMPLATES_DIALOG'
      });
    }
  }]);
  return AdRule;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdsInsights
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdsInsights = function (_AbstractCrudObject) {
  inherits(AdsInsights, _AbstractCrudObject);

  function AdsInsights() {
    classCallCheck(this, AdsInsights);
    return possibleConstructorReturn(this, (AdsInsights.__proto__ || Object.getPrototypeOf(AdsInsights)).apply(this, arguments));
  }

  createClass(AdsInsights, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        account_currency: 'account_currency',
        account_id: 'account_id',
        account_name: 'account_name',
        action_values: 'action_values',
        actions: 'actions',
        ad_click_actions: 'ad_click_actions',
        ad_id: 'ad_id',
        ad_impression_actions: 'ad_impression_actions',
        ad_name: 'ad_name',
        adset_end: 'adset_end',
        adset_id: 'adset_id',
        adset_name: 'adset_name',
        adset_start: 'adset_start',
        age_targeting: 'age_targeting',
        anchor_events_performance_indicator: 'anchor_events_performance_indicator',
        attribution_setting: 'attribution_setting',
        auction_bid: 'auction_bid',
        auction_competitiveness: 'auction_competitiveness',
        auction_max_competitor_bid: 'auction_max_competitor_bid',
        average_purchases_conversion_value: 'average_purchases_conversion_value',
        buying_type: 'buying_type',
        campaign_id: 'campaign_id',
        campaign_name: 'campaign_name',
        canvas_avg_view_percent: 'canvas_avg_view_percent',
        canvas_avg_view_time: 'canvas_avg_view_time',
        catalog_segment_actions: 'catalog_segment_actions',
        catalog_segment_value: 'catalog_segment_value',
        catalog_segment_value_mobile_purchase_roas: 'catalog_segment_value_mobile_purchase_roas',
        catalog_segment_value_omni_purchase_roas: 'catalog_segment_value_omni_purchase_roas',
        catalog_segment_value_website_purchase_roas: 'catalog_segment_value_website_purchase_roas',
        clicks: 'clicks',
        conversion_lead_rate: 'conversion_lead_rate',
        conversion_leads: 'conversion_leads',
        conversion_rate_ranking: 'conversion_rate_ranking',
        conversion_values: 'conversion_values',
        conversions: 'conversions',
        converted_product_app_custom_event_fb_mobile_purchase: 'converted_product_app_custom_event_fb_mobile_purchase',
        converted_product_app_custom_event_fb_mobile_purchase_value: 'converted_product_app_custom_event_fb_mobile_purchase_value',
        converted_product_offline_purchase: 'converted_product_offline_purchase',
        converted_product_offline_purchase_value: 'converted_product_offline_purchase_value',
        converted_product_omni_purchase: 'converted_product_omni_purchase',
        converted_product_omni_purchase_values: 'converted_product_omni_purchase_values',
        converted_product_quantity: 'converted_product_quantity',
        converted_product_value: 'converted_product_value',
        converted_product_website_pixel_purchase: 'converted_product_website_pixel_purchase',
        converted_product_website_pixel_purchase_value: 'converted_product_website_pixel_purchase_value',
        converted_promoted_product_app_custom_event_fb_mobile_purchase: 'converted_promoted_product_app_custom_event_fb_mobile_purchase',
        converted_promoted_product_app_custom_event_fb_mobile_purchase_value: 'converted_promoted_product_app_custom_event_fb_mobile_purchase_value',
        converted_promoted_product_offline_purchase: 'converted_promoted_product_offline_purchase',
        converted_promoted_product_offline_purchase_value: 'converted_promoted_product_offline_purchase_value',
        converted_promoted_product_omni_purchase: 'converted_promoted_product_omni_purchase',
        converted_promoted_product_omni_purchase_values: 'converted_promoted_product_omni_purchase_values',
        converted_promoted_product_quantity: 'converted_promoted_product_quantity',
        converted_promoted_product_value: 'converted_promoted_product_value',
        converted_promoted_product_website_pixel_purchase: 'converted_promoted_product_website_pixel_purchase',
        converted_promoted_product_website_pixel_purchase_value: 'converted_promoted_product_website_pixel_purchase_value',
        cost_per_15_sec_video_view: 'cost_per_15_sec_video_view',
        cost_per_2_sec_continuous_video_view: 'cost_per_2_sec_continuous_video_view',
        cost_per_action_type: 'cost_per_action_type',
        cost_per_ad_click: 'cost_per_ad_click',
        cost_per_conversion: 'cost_per_conversion',
        cost_per_conversion_lead: 'cost_per_conversion_lead',
        cost_per_dda_countby_convs: 'cost_per_dda_countby_convs',
        cost_per_estimated_ad_recallers: 'cost_per_estimated_ad_recallers',
        cost_per_inline_link_click: 'cost_per_inline_link_click',
        cost_per_inline_post_engagement: 'cost_per_inline_post_engagement',
        cost_per_objective_result: 'cost_per_objective_result',
        cost_per_one_thousand_ad_impression: 'cost_per_one_thousand_ad_impression',
        cost_per_outbound_click: 'cost_per_outbound_click',
        cost_per_result: 'cost_per_result',
        cost_per_thruplay: 'cost_per_thruplay',
        cost_per_unique_action_type: 'cost_per_unique_action_type',
        cost_per_unique_click: 'cost_per_unique_click',
        cost_per_unique_conversion: 'cost_per_unique_conversion',
        cost_per_unique_inline_link_click: 'cost_per_unique_inline_link_click',
        cost_per_unique_outbound_click: 'cost_per_unique_outbound_click',
        cpc: 'cpc',
        cpm: 'cpm',
        cpp: 'cpp',
        created_time: 'created_time',
        creative_media_type: 'creative_media_type',
        ctr: 'ctr',
        date_start: 'date_start',
        date_stop: 'date_stop',
        dda_countby_convs: 'dda_countby_convs',
        dda_results: 'dda_results',
        engagement_rate_ranking: 'engagement_rate_ranking',
        estimated_ad_recall_rate: 'estimated_ad_recall_rate',
        estimated_ad_recall_rate_lower_bound: 'estimated_ad_recall_rate_lower_bound',
        estimated_ad_recall_rate_upper_bound: 'estimated_ad_recall_rate_upper_bound',
        estimated_ad_recallers: 'estimated_ad_recallers',
        estimated_ad_recallers_lower_bound: 'estimated_ad_recallers_lower_bound',
        estimated_ad_recallers_upper_bound: 'estimated_ad_recallers_upper_bound',
        frequency: 'frequency',
        full_view_impressions: 'full_view_impressions',
        full_view_reach: 'full_view_reach',
        gender_targeting: 'gender_targeting',
        impressions: 'impressions',
        inline_link_click_ctr: 'inline_link_click_ctr',
        inline_link_clicks: 'inline_link_clicks',
        inline_post_engagement: 'inline_post_engagement',
        instagram_upcoming_event_reminders_set: 'instagram_upcoming_event_reminders_set',
        instant_experience_clicks_to_open: 'instant_experience_clicks_to_open',
        instant_experience_clicks_to_start: 'instant_experience_clicks_to_start',
        instant_experience_outbound_clicks: 'instant_experience_outbound_clicks',
        interactive_component_tap: 'interactive_component_tap',
        labels: 'labels',
        landing_page_view_actions_per_link_click: 'landing_page_view_actions_per_link_click',
        landing_page_view_per_link_click: 'landing_page_view_per_link_click',
        landing_page_view_per_purchase_rate: 'landing_page_view_per_purchase_rate',
        link_clicks_per_results: 'link_clicks_per_results',
        location: 'location',
        marketing_messages_click_rate_benchmark: 'marketing_messages_click_rate_benchmark',
        marketing_messages_cost_per_delivered: 'marketing_messages_cost_per_delivered',
        marketing_messages_cost_per_link_btn_click: 'marketing_messages_cost_per_link_btn_click',
        marketing_messages_delivered: 'marketing_messages_delivered',
        marketing_messages_delivery_rate: 'marketing_messages_delivery_rate',
        marketing_messages_link_btn_click: 'marketing_messages_link_btn_click',
        marketing_messages_link_btn_click_rate: 'marketing_messages_link_btn_click_rate',
        marketing_messages_media_view_rate: 'marketing_messages_media_view_rate',
        marketing_messages_phone_call_btn_click_rate: 'marketing_messages_phone_call_btn_click_rate',
        marketing_messages_quick_reply_btn_click: 'marketing_messages_quick_reply_btn_click',
        marketing_messages_quick_reply_btn_click_rate: 'marketing_messages_quick_reply_btn_click_rate',
        marketing_messages_read: 'marketing_messages_read',
        marketing_messages_read_rate: 'marketing_messages_read_rate',
        marketing_messages_read_rate_benchmark: 'marketing_messages_read_rate_benchmark',
        marketing_messages_sent: 'marketing_messages_sent',
        marketing_messages_spend: 'marketing_messages_spend',
        marketing_messages_spend_currency: 'marketing_messages_spend_currency',
        marketing_messages_website_add_to_cart: 'marketing_messages_website_add_to_cart',
        marketing_messages_website_initiate_checkout: 'marketing_messages_website_initiate_checkout',
        marketing_messages_website_purchase: 'marketing_messages_website_purchase',
        marketing_messages_website_purchase_values: 'marketing_messages_website_purchase_values',
        mobile_app_purchase_roas: 'mobile_app_purchase_roas',
        objective: 'objective',
        objective_result_rate: 'objective_result_rate',
        objective_results: 'objective_results',
        onsite_conversion_messaging_detected_purchase_deduped: 'onsite_conversion_messaging_detected_purchase_deduped',
        optimization_goal: 'optimization_goal',
        outbound_clicks: 'outbound_clicks',
        outbound_clicks_ctr: 'outbound_clicks_ctr',
        place_page_name: 'place_page_name',
        product_group_retailer_id: 'product_group_retailer_id',
        product_retailer_id: 'product_retailer_id',
        product_views: 'product_views',
        purchase_per_landing_page_view: 'purchase_per_landing_page_view',
        purchase_roas: 'purchase_roas',
        purchases_per_link_click: 'purchases_per_link_click',
        qualifying_question_qualify_answer_rate: 'qualifying_question_qualify_answer_rate',
        quality_ranking: 'quality_ranking',
        reach: 'reach',
        result_rate: 'result_rate',
        result_values_performance_indicator: 'result_values_performance_indicator',
        results: 'results',
        shops_assisted_purchases: 'shops_assisted_purchases',
        social_spend: 'social_spend',
        spend: 'spend',
        total_card_view: 'total_card_view',
        total_postbacks: 'total_postbacks',
        total_postbacks_detailed: 'total_postbacks_detailed',
        total_postbacks_detailed_v4: 'total_postbacks_detailed_v4',
        unique_actions: 'unique_actions',
        unique_clicks: 'unique_clicks',
        unique_conversions: 'unique_conversions',
        unique_ctr: 'unique_ctr',
        unique_inline_link_click_ctr: 'unique_inline_link_click_ctr',
        unique_inline_link_clicks: 'unique_inline_link_clicks',
        unique_link_clicks_ctr: 'unique_link_clicks_ctr',
        unique_outbound_clicks: 'unique_outbound_clicks',
        unique_outbound_clicks_ctr: 'unique_outbound_clicks_ctr',
        unique_video_continuous_2_sec_watched_actions: 'unique_video_continuous_2_sec_watched_actions',
        unique_video_view_15_sec: 'unique_video_view_15_sec',
        updated_time: 'updated_time',
        video_15_sec_watched_actions: 'video_15_sec_watched_actions',
        video_30_sec_watched_actions: 'video_30_sec_watched_actions',
        video_avg_time_watched_actions: 'video_avg_time_watched_actions',
        video_continuous_2_sec_watched_actions: 'video_continuous_2_sec_watched_actions',
        video_p100_watched_actions: 'video_p100_watched_actions',
        video_p25_watched_actions: 'video_p25_watched_actions',
        video_p50_watched_actions: 'video_p50_watched_actions',
        video_p75_watched_actions: 'video_p75_watched_actions',
        video_p95_watched_actions: 'video_p95_watched_actions',
        video_play_actions: 'video_play_actions',
        video_play_curve_actions: 'video_play_curve_actions',
        video_play_retention_0_to_15s_actions: 'video_play_retention_0_to_15s_actions',
        video_play_retention_20_to_60s_actions: 'video_play_retention_20_to_60s_actions',
        video_play_retention_graph_actions: 'video_play_retention_graph_actions',
        video_thruplay_watched_actions: 'video_thruplay_watched_actions',
        video_time_watched_actions: 'video_time_watched_actions',
        video_view_per_impression: 'video_view_per_impression',
        website_ctr: 'website_ctr',
        website_purchase_roas: 'website_purchase_roas',
        wish_bid: 'wish_bid'
      });
    }
  }, {
    key: 'ActionAttributionWindows',
    get: function get() {
      return Object.freeze({
        value_1d_click: '1d_click',
        value_1d_ev: '1d_ev',
        value_1d_view: '1d_view',
        value_28d_click: '28d_click',
        value_28d_view: '28d_view',
        value_28d_view_all_conversions: '28d_view_all_conversions',
        value_28d_view_first_conversion: '28d_view_first_conversion',
        value_7d_click: '7d_click',
        value_7d_view: '7d_view',
        value_7d_view_all_conversions: '7d_view_all_conversions',
        value_7d_view_first_conversion: '7d_view_first_conversion',
        dda: 'dda',
        default: 'default',
        skan_click: 'skan_click',
        skan_click_second_postback: 'skan_click_second_postback',
        skan_click_third_postback: 'skan_click_third_postback',
        skan_view: 'skan_view',
        skan_view_second_postback: 'skan_view_second_postback',
        skan_view_third_postback: 'skan_view_third_postback'
      });
    }
  }, {
    key: 'ActionBreakdowns',
    get: function get() {
      return Object.freeze({
        action_canvas_component_name: 'action_canvas_component_name',
        action_carousel_card_id: 'action_carousel_card_id',
        action_carousel_card_name: 'action_carousel_card_name',
        action_destination: 'action_destination',
        action_device: 'action_device',
        action_reaction: 'action_reaction',
        action_target_id: 'action_target_id',
        action_type: 'action_type',
        action_video_sound: 'action_video_sound',
        action_video_type: 'action_video_type',
        conversion_destination: 'conversion_destination',
        matched_persona_id: 'matched_persona_id',
        matched_persona_name: 'matched_persona_name',
        signal_source_bucket: 'signal_source_bucket',
        standard_event_content_type: 'standard_event_content_type'
      });
    }
  }, {
    key: 'ActionReportTime',
    get: function get() {
      return Object.freeze({
        conversion: 'conversion',
        impression: 'impression',
        lifetime: 'lifetime',
        mixed: 'mixed'
      });
    }
  }, {
    key: 'Breakdowns',
    get: function get() {
      return Object.freeze({
        ad_extension_domain: 'ad_extension_domain',
        ad_extension_url: 'ad_extension_url',
        ad_format_asset: 'ad_format_asset',
        age: 'age',
        app_id: 'app_id',
        body_asset: 'body_asset',
        breakdown_ad_objective: 'breakdown_ad_objective',
        breakdown_reporting_ad_id: 'breakdown_reporting_ad_id',
        call_to_action_asset: 'call_to_action_asset',
        coarse_conversion_value: 'coarse_conversion_value',
        comscore_market: 'comscore_market',
        conversion_destination: 'conversion_destination',
        country: 'country',
        creative_automation_asset_id: 'creative_automation_asset_id',
        creative_relaxation_asset_type: 'creative_relaxation_asset_type',
        crm_advertiser_l12_territory_ids: 'crm_advertiser_l12_territory_ids',
        crm_advertiser_subvertical_id: 'crm_advertiser_subvertical_id',
        crm_advertiser_vertical_id: 'crm_advertiser_vertical_id',
        crm_ult_advertiser_id: 'crm_ult_advertiser_id',
        description_asset: 'description_asset',
        device_platform: 'device_platform',
        dma: 'dma',
        fidelity_type: 'fidelity_type',
        flexible_format_asset_type: 'flexible_format_asset_type',
        frequency_value: 'frequency_value',
        gen_ai_asset_type: 'gen_ai_asset_type',
        gender: 'gender',
        hourly_stats_aggregated_by_advertiser_time_zone: 'hourly_stats_aggregated_by_advertiser_time_zone',
        hourly_stats_aggregated_by_audience_time_zone: 'hourly_stats_aggregated_by_audience_time_zone',
        hsid: 'hsid',
        image_asset: 'image_asset',
        impression_device: 'impression_device',
        impression_view_time_advertiser_hour_v2: 'impression_view_time_advertiser_hour_v2',
        is_auto_advance: 'is_auto_advance',
        is_conversion_id_modeled: 'is_conversion_id_modeled',
        is_rendered_as_delayed_skip_ad: 'is_rendered_as_delayed_skip_ad',
        landing_destination: 'landing_destination',
        link_url_asset: 'link_url_asset',
        marketing_messages_btn_name: 'marketing_messages_btn_name',
        mdsa_landing_destination: 'mdsa_landing_destination',
        media_asset_url: 'media_asset_url',
        media_creator: 'media_creator',
        media_destination_url: 'media_destination_url',
        media_format: 'media_format',
        media_origin_url: 'media_origin_url',
        media_text_content: 'media_text_content',
        media_type: 'media_type',
        mmm: 'mmm',
        place_page_id: 'place_page_id',
        platform_position: 'platform_position',
        postback_sequence_index: 'postback_sequence_index',
        product_brand_breakdown: 'product_brand_breakdown',
        product_category_breakdown: 'product_category_breakdown',
        product_custom_label_0_breakdown: 'product_custom_label_0_breakdown',
        product_custom_label_1_breakdown: 'product_custom_label_1_breakdown',
        product_custom_label_2_breakdown: 'product_custom_label_2_breakdown',
        product_custom_label_3_breakdown: 'product_custom_label_3_breakdown',
        product_custom_label_4_breakdown: 'product_custom_label_4_breakdown',
        product_group_content_id_breakdown: 'product_group_content_id_breakdown',
        product_group_id: 'product_group_id',
        product_id: 'product_id',
        product_set_id_breakdown: 'product_set_id_breakdown',
        publisher_platform: 'publisher_platform',
        redownload: 'redownload',
        region: 'region',
        rta_ugc_topic: 'rta_ugc_topic',
        rule_set_id: 'rule_set_id',
        rule_set_name: 'rule_set_name',
        signal_source_bucket: 'signal_source_bucket',
        skan_campaign_id: 'skan_campaign_id',
        skan_conversion_id: 'skan_conversion_id',
        skan_version: 'skan_version',
        sot_attribution_model_type: 'sot_attribution_model_type',
        sot_attribution_window: 'sot_attribution_window',
        sot_channel: 'sot_channel',
        sot_event_type: 'sot_event_type',
        sot_source: 'sot_source',
        standard_event_content_type: 'standard_event_content_type',
        title_asset: 'title_asset',
        user_persona_id: 'user_persona_id',
        user_persona_name: 'user_persona_name',
        video_asset: 'video_asset'
      });
    }
  }, {
    key: 'DatePreset',
    get: function get() {
      return Object.freeze({
        data_maximum: 'data_maximum',
        last_14d: 'last_14d',
        last_28d: 'last_28d',
        last_30d: 'last_30d',
        last_3d: 'last_3d',
        last_7d: 'last_7d',
        last_90d: 'last_90d',
        last_month: 'last_month',
        last_quarter: 'last_quarter',
        last_week_mon_sun: 'last_week_mon_sun',
        last_week_sun_sat: 'last_week_sun_sat',
        last_year: 'last_year',
        maximum: 'maximum',
        this_month: 'this_month',
        this_quarter: 'this_quarter',
        this_week_mon_today: 'this_week_mon_today',
        this_week_sun_today: 'this_week_sun_today',
        this_year: 'this_year',
        today: 'today',
        yesterday: 'yesterday'
      });
    }
  }, {
    key: 'Level',
    get: function get() {
      return Object.freeze({
        account: 'account',
        ad: 'ad',
        adset: 'adset',
        campaign: 'campaign'
      });
    }
  }, {
    key: 'SummaryActionBreakdowns',
    get: function get() {
      return Object.freeze({
        action_canvas_component_name: 'action_canvas_component_name',
        action_carousel_card_id: 'action_carousel_card_id',
        action_carousel_card_name: 'action_carousel_card_name',
        action_destination: 'action_destination',
        action_device: 'action_device',
        action_reaction: 'action_reaction',
        action_target_id: 'action_target_id',
        action_type: 'action_type',
        action_video_sound: 'action_video_sound',
        action_video_type: 'action_video_type',
        conversion_destination: 'conversion_destination',
        matched_persona_id: 'matched_persona_id',
        matched_persona_name: 'matched_persona_name',
        signal_source_bucket: 'signal_source_bucket',
        standard_event_content_type: 'standard_event_content_type'
      });
    }
  }]);
  return AdsInsights;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdReportRun
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdReportRun = function (_AbstractCrudObject) {
  inherits(AdReportRun, _AbstractCrudObject);
  createClass(AdReportRun, [{
    key: 'getInsights',
    value: function getInsights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdsInsights, fields, params, fetchFirstPage, '/insights');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        account_id: 'account_id',
        async_percent_completion: 'async_percent_completion',
        async_report_url: 'async_report_url',
        async_status: 'async_status',
        date_start: 'date_start',
        date_stop: 'date_stop',
        emails: 'emails',
        error_code: 'error_code',
        friendly_name: 'friendly_name',
        id: 'id',
        is_async_export: 'is_async_export',
        is_bookmarked: 'is_bookmarked',
        is_running: 'is_running',
        schedule_id: 'schedule_id',
        time_completed: 'time_completed',
        time_ref: 'time_ref'
      });
    }
  }]);

  function AdReportRun() {
    var id = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var parentId = arguments[2];
    var api = arguments[3];
    classCallCheck(this, AdReportRun);

    var _this = possibleConstructorReturn(this, (AdReportRun.__proto__ || Object.getPrototypeOf(AdReportRun)).call(this));

    _this.id = data.report_run_id;
    return _this;
  }

  return AdReportRun;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Lead
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Lead = function (_AbstractCrudObject) {
  inherits(Lead, _AbstractCrudObject);

  function Lead() {
    classCallCheck(this, Lead);
    return possibleConstructorReturn(this, (Lead.__proto__ || Object.getPrototypeOf(Lead)).apply(this, arguments));
  }

  createClass(Lead, [{
    key: 'delete',


    // $FlowFixMe : Support Generic Types
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Lead.prototype.__proto__ || Object.getPrototypeOf(Lead.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        ad_id: 'ad_id',
        ad_name: 'ad_name',
        adset_id: 'adset_id',
        adset_name: 'adset_name',
        campaign_id: 'campaign_id',
        campaign_name: 'campaign_name',
        created_time: 'created_time',
        custom_disclaimer_responses: 'custom_disclaimer_responses',
        field_data: 'field_data',
        form_id: 'form_id',
        home_listing: 'home_listing',
        id: 'id',
        is_organic: 'is_organic',
        partner_name: 'partner_name',
        platform: 'platform',
        post: 'post',
        post_submission_check_result: 'post_submission_check_result',
        retailer_item_id: 'retailer_item_id',
        vehicle: 'vehicle'
      });
    }
  }]);
  return Lead;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * TargetingSentenceLine
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var TargetingSentenceLine = function (_AbstractCrudObject) {
  inherits(TargetingSentenceLine, _AbstractCrudObject);

  function TargetingSentenceLine() {
    classCallCheck(this, TargetingSentenceLine);
    return possibleConstructorReturn(this, (TargetingSentenceLine.__proto__ || Object.getPrototypeOf(TargetingSentenceLine)).apply(this, arguments));
  }

  createClass(TargetingSentenceLine, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        params: 'params',
        targetingsentencelines: 'targetingsentencelines'
      });
    }
  }]);
  return TargetingSentenceLine;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Ad
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Ad = function (_AbstractCrudObject) {
  inherits(Ad, _AbstractCrudObject);

  function Ad() {
    classCallCheck(this, Ad);
    return possibleConstructorReturn(this, (Ad.__proto__ || Object.getPrototypeOf(Ad)).apply(this, arguments));
  }

  createClass(Ad, [{
    key: 'getAdCreatives',
    value: function getAdCreatives(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdCreative, fields, params, fetchFirstPage, '/adcreatives');
    }
  }, {
    key: 'createAdLabel',
    value: function createAdLabel(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/adlabels', fields, params, Ad, pathOverride);
    }
  }, {
    key: 'getAdRulesGoverned',
    value: function getAdRulesGoverned(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdRule, fields, params, fetchFirstPage, '/adrules_governed');
    }
  }, {
    key: 'getCopies',
    value: function getCopies(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Ad, fields, params, fetchFirstPage, '/copies');
    }
  }, {
    key: 'createCopy',
    value: function createCopy(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/copies', fields, params, Ad, pathOverride);
    }
  }, {
    key: 'getInsights',
    value: function getInsights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdsInsights, fields, params, fetchFirstPage, '/insights');
    }
  }, {
    key: 'getInsightsAsync',
    value: function getInsightsAsync(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/insights', fields, params, AdReportRun, pathOverride);
    }
  }, {
    key: 'getLeads',
    value: function getLeads(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Lead, fields, params, fetchFirstPage, '/leads');
    }
  }, {
    key: 'getPreviews',
    value: function getPreviews(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdPreview, fields, params, fetchFirstPage, '/previews');
    }
  }, {
    key: 'getTargetingSentenceLines',
    value: function getTargetingSentenceLines(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(TargetingSentenceLine, fields, params, fetchFirstPage, '/targetingsentencelines');
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Ad.prototype.__proto__ || Object.getPrototypeOf(Ad.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Ad.prototype.__proto__ || Object.getPrototypeOf(Ad.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        account_id: 'account_id',
        ad_active_time: 'ad_active_time',
        ad_review_feedback: 'ad_review_feedback',
        ad_schedule_end_time: 'ad_schedule_end_time',
        ad_schedule_start_time: 'ad_schedule_start_time',
        adlabels: 'adlabels',
        adset: 'adset',
        adset_id: 'adset_id',
        bid_amount: 'bid_amount',
        bid_info: 'bid_info',
        bid_type: 'bid_type',
        campaign: 'campaign',
        campaign_id: 'campaign_id',
        configured_status: 'configured_status',
        conversion_domain: 'conversion_domain',
        conversion_specs: 'conversion_specs',
        created_time: 'created_time',
        creative: 'creative',
        creative_asset_groups_spec: 'creative_asset_groups_spec',
        demolink_hash: 'demolink_hash',
        display_sequence: 'display_sequence',
        effective_status: 'effective_status',
        engagement_audience: 'engagement_audience',
        failed_delivery_checks: 'failed_delivery_checks',
        id: 'id',
        issues_info: 'issues_info',
        last_updated_by_app_id: 'last_updated_by_app_id',
        name: 'name',
        placement: 'placement',
        preview_shareable_link: 'preview_shareable_link',
        priority: 'priority',
        recommendations: 'recommendations',
        source_ad: 'source_ad',
        source_ad_id: 'source_ad_id',
        status: 'status',
        targeting: 'targeting',
        tracking_and_conversion_with_defaults: 'tracking_and_conversion_with_defaults',
        tracking_specs: 'tracking_specs',
        updated_time: 'updated_time'
      });
    }
  }, {
    key: 'BidType',
    get: function get() {
      return Object.freeze({
        absolute_ocpm: 'ABSOLUTE_OCPM',
        cpa: 'CPA',
        cpc: 'CPC',
        cpm: 'CPM',
        multi_premium: 'MULTI_PREMIUM'
      });
    }
  }, {
    key: 'ConfiguredStatus',
    get: function get() {
      return Object.freeze({
        active: 'ACTIVE',
        archived: 'ARCHIVED',
        deleted: 'DELETED',
        paused: 'PAUSED'
      });
    }
  }, {
    key: 'EffectiveStatus',
    get: function get() {
      return Object.freeze({
        active: 'ACTIVE',
        adset_paused: 'ADSET_PAUSED',
        archived: 'ARCHIVED',
        campaign_paused: 'CAMPAIGN_PAUSED',
        deleted: 'DELETED',
        disapproved: 'DISAPPROVED',
        in_process: 'IN_PROCESS',
        paused: 'PAUSED',
        pending_billing_info: 'PENDING_BILLING_INFO',
        pending_review: 'PENDING_REVIEW',
        preapproved: 'PREAPPROVED',
        with_issues: 'WITH_ISSUES'
      });
    }
  }, {
    key: 'Status',
    get: function get() {
      return Object.freeze({
        active: 'ACTIVE',
        archived: 'ARCHIVED',
        deleted: 'DELETED',
        paused: 'PAUSED'
      });
    }
  }, {
    key: 'DatePreset',
    get: function get() {
      return Object.freeze({
        data_maximum: 'data_maximum',
        last_14d: 'last_14d',
        last_28d: 'last_28d',
        last_30d: 'last_30d',
        last_3d: 'last_3d',
        last_7d: 'last_7d',
        last_90d: 'last_90d',
        last_month: 'last_month',
        last_quarter: 'last_quarter',
        last_week_mon_sun: 'last_week_mon_sun',
        last_week_sun_sat: 'last_week_sun_sat',
        last_year: 'last_year',
        maximum: 'maximum',
        this_month: 'this_month',
        this_quarter: 'this_quarter',
        this_week_mon_today: 'this_week_mon_today',
        this_week_sun_today: 'this_week_sun_today',
        this_year: 'this_year',
        today: 'today',
        yesterday: 'yesterday'
      });
    }
  }, {
    key: 'ExecutionOptions',
    get: function get() {
      return Object.freeze({
        include_recommendations: 'include_recommendations',
        synchronous_ad_review: 'synchronous_ad_review',
        validate_only: 'validate_only'
      });
    }
  }, {
    key: 'Operator',
    get: function get() {
      return Object.freeze({
        all: 'ALL',
        any: 'ANY'
      });
    }
  }, {
    key: 'StatusOption',
    get: function get() {
      return Object.freeze({
        active: 'ACTIVE',
        inherited_from_source: 'INHERITED_FROM_SOURCE',
        paused: 'PAUSED'
      });
    }
  }]);
  return Ad;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdAsyncRequest
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdAsyncRequest = function (_AbstractCrudObject) {
  inherits(AdAsyncRequest, _AbstractCrudObject);

  function AdAsyncRequest() {
    classCallCheck(this, AdAsyncRequest);
    return possibleConstructorReturn(this, (AdAsyncRequest.__proto__ || Object.getPrototypeOf(AdAsyncRequest)).apply(this, arguments));
  }

  createClass(AdAsyncRequest, [{
    key: 'delete',


    // $FlowFixMe : Support Generic Types
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(AdAsyncRequest.prototype.__proto__ || Object.getPrototypeOf(AdAsyncRequest.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        async_request_set: 'async_request_set',
        created_time: 'created_time',
        id: 'id',
        input: 'input',
        result: 'result',
        scope_object_id: 'scope_object_id',
        status: 'status',
        type: 'type',
        updated_time: 'updated_time'
      });
    }
  }, {
    key: 'Statuses',
    get: function get() {
      return Object.freeze({
        canceled: 'CANCELED',
        canceled_dependency: 'CANCELED_DEPENDENCY',
        error: 'ERROR',
        error_conflicts: 'ERROR_CONFLICTS',
        error_dependency: 'ERROR_DEPENDENCY',
        initial: 'INITIAL',
        in_progress: 'IN_PROGRESS',
        pending_dependency: 'PENDING_DEPENDENCY',
        process_by_ad_async_engine: 'PROCESS_BY_AD_ASYNC_ENGINE',
        process_by_event_processor: 'PROCESS_BY_EVENT_PROCESSOR',
        success: 'SUCCESS',
        user_canceled: 'USER_CANCELED',
        user_canceled_dependency: 'USER_CANCELED_DEPENDENCY'
      });
    }
  }]);
  return AdAsyncRequest;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * HighDemandPeriod
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var HighDemandPeriod = function (_AbstractCrudObject) {
  inherits(HighDemandPeriod, _AbstractCrudObject);

  function HighDemandPeriod() {
    classCallCheck(this, HighDemandPeriod);
    return possibleConstructorReturn(this, (HighDemandPeriod.__proto__ || Object.getPrototypeOf(HighDemandPeriod)).apply(this, arguments));
  }

  createClass(HighDemandPeriod, [{
    key: 'delete',


    // $FlowFixMe : Support Generic Types
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(HighDemandPeriod.prototype.__proto__ || Object.getPrototypeOf(HighDemandPeriod.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(HighDemandPeriod.prototype.__proto__ || Object.getPrototypeOf(HighDemandPeriod.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        ad_object_id: 'ad_object_id',
        budget_value: 'budget_value',
        budget_value_type: 'budget_value_type',
        id: 'id',
        recurrence_type: 'recurrence_type',
        time_end: 'time_end',
        time_start: 'time_start',
        weekly_schedule: 'weekly_schedule'
      });
    }
  }, {
    key: 'BudgetValueType',
    get: function get() {
      return Object.freeze({
        absolute: 'ABSOLUTE',
        multiplier: 'MULTIPLIER'
      });
    }
  }]);
  return HighDemandPeriod;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdCampaignDeliveryEstimate
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdCampaignDeliveryEstimate = function (_AbstractCrudObject) {
  inherits(AdCampaignDeliveryEstimate, _AbstractCrudObject);

  function AdCampaignDeliveryEstimate() {
    classCallCheck(this, AdCampaignDeliveryEstimate);
    return possibleConstructorReturn(this, (AdCampaignDeliveryEstimate.__proto__ || Object.getPrototypeOf(AdCampaignDeliveryEstimate)).apply(this, arguments));
  }

  createClass(AdCampaignDeliveryEstimate, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        daily_outcomes_curve: 'daily_outcomes_curve',
        estimate_dau: 'estimate_dau',
        estimate_mau_lower_bound: 'estimate_mau_lower_bound',
        estimate_mau_upper_bound: 'estimate_mau_upper_bound',
        estimate_ready: 'estimate_ready',
        targeting_optimization_types: 'targeting_optimization_types'
      });
    }
  }, {
    key: 'OptimizationGoal',
    get: function get() {
      return Object.freeze({
        advertiser_siloed_value: 'ADVERTISER_SILOED_VALUE',
        ad_recall_lift: 'AD_RECALL_LIFT',
        app_installs: 'APP_INSTALLS',
        app_installs_and_offsite_conversions: 'APP_INSTALLS_AND_OFFSITE_CONVERSIONS',
        automatic_objective: 'AUTOMATIC_OBJECTIVE',
        conversations: 'CONVERSATIONS',
        derived_events: 'DERIVED_EVENTS',
        engaged_users: 'ENGAGED_USERS',
        event_responses: 'EVENT_RESPONSES',
        impressions: 'IMPRESSIONS',
        in_app_value: 'IN_APP_VALUE',
        landing_page_views: 'LANDING_PAGE_VIEWS',
        lead_generation: 'LEAD_GENERATION',
        link_clicks: 'LINK_CLICKS',
        meaningful_call_attempt: 'MEANINGFUL_CALL_ATTEMPT',
        messaging_appointment_conversion: 'MESSAGING_APPOINTMENT_CONVERSION',
        messaging_purchase_conversion: 'MESSAGING_PURCHASE_CONVERSION',
        none: 'NONE',
        offsite_conversions: 'OFFSITE_CONVERSIONS',
        page_likes: 'PAGE_LIKES',
        post_engagement: 'POST_ENGAGEMENT',
        profile_and_page_engagement: 'PROFILE_AND_PAGE_ENGAGEMENT',
        profile_visit: 'PROFILE_VISIT',
        quality_call: 'QUALITY_CALL',
        quality_lead: 'QUALITY_LEAD',
        reach: 'REACH',
        reminders_set: 'REMINDERS_SET',
        subscribers: 'SUBSCRIBERS',
        thruplay: 'THRUPLAY',
        value: 'VALUE',
        visit_instagram_profile: 'VISIT_INSTAGRAM_PROFILE'
      });
    }
  }]);
  return AdCampaignDeliveryEstimate;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * MessageDeliveryEstimate
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var MessageDeliveryEstimate = function (_AbstractCrudObject) {
  inherits(MessageDeliveryEstimate, _AbstractCrudObject);

  function MessageDeliveryEstimate() {
    classCallCheck(this, MessageDeliveryEstimate);
    return possibleConstructorReturn(this, (MessageDeliveryEstimate.__proto__ || Object.getPrototypeOf(MessageDeliveryEstimate)).apply(this, arguments));
  }

  createClass(MessageDeliveryEstimate, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        estimate_cost: 'estimate_cost',
        estimate_cost_lower_bound: 'estimate_cost_lower_bound',
        estimate_cost_upper_bound: 'estimate_cost_upper_bound',
        estimate_coverage_lower_bound: 'estimate_coverage_lower_bound',
        estimate_coverage_upper_bound: 'estimate_coverage_upper_bound',
        estimate_delivery: 'estimate_delivery',
        estimate_delivery_lower_bound: 'estimate_delivery_lower_bound',
        estimate_delivery_upper_bound: 'estimate_delivery_upper_bound',
        estimate_status: 'estimate_status'
      });
    }
  }, {
    key: 'OptimizationGoal',
    get: function get() {
      return Object.freeze({
        advertiser_siloed_value: 'ADVERTISER_SILOED_VALUE',
        ad_recall_lift: 'AD_RECALL_LIFT',
        app_installs: 'APP_INSTALLS',
        app_installs_and_offsite_conversions: 'APP_INSTALLS_AND_OFFSITE_CONVERSIONS',
        automatic_objective: 'AUTOMATIC_OBJECTIVE',
        conversations: 'CONVERSATIONS',
        derived_events: 'DERIVED_EVENTS',
        engaged_users: 'ENGAGED_USERS',
        event_responses: 'EVENT_RESPONSES',
        impressions: 'IMPRESSIONS',
        in_app_value: 'IN_APP_VALUE',
        landing_page_views: 'LANDING_PAGE_VIEWS',
        lead_generation: 'LEAD_GENERATION',
        link_clicks: 'LINK_CLICKS',
        meaningful_call_attempt: 'MEANINGFUL_CALL_ATTEMPT',
        messaging_appointment_conversion: 'MESSAGING_APPOINTMENT_CONVERSION',
        messaging_purchase_conversion: 'MESSAGING_PURCHASE_CONVERSION',
        none: 'NONE',
        offsite_conversions: 'OFFSITE_CONVERSIONS',
        page_likes: 'PAGE_LIKES',
        post_engagement: 'POST_ENGAGEMENT',
        profile_and_page_engagement: 'PROFILE_AND_PAGE_ENGAGEMENT',
        profile_visit: 'PROFILE_VISIT',
        quality_call: 'QUALITY_CALL',
        quality_lead: 'QUALITY_LEAD',
        reach: 'REACH',
        reminders_set: 'REMINDERS_SET',
        subscribers: 'SUBSCRIBERS',
        thruplay: 'THRUPLAY',
        value: 'VALUE',
        visit_instagram_profile: 'VISIT_INSTAGRAM_PROFILE'
      });
    }
  }, {
    key: 'PacingType',
    get: function get() {
      return Object.freeze({
        day_parting: 'DAY_PARTING',
        disabled: 'DISABLED',
        no_pacing: 'NO_PACING',
        probabilistic_pacing: 'PROBABILISTIC_PACING',
        probabilistic_pacing_v2: 'PROBABILISTIC_PACING_V2',
        standard: 'STANDARD'
      });
    }
  }]);
  return MessageDeliveryEstimate;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdSet
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdSet = function (_AbstractCrudObject) {
  inherits(AdSet, _AbstractCrudObject);

  function AdSet() {
    classCallCheck(this, AdSet);
    return possibleConstructorReturn(this, (AdSet.__proto__ || Object.getPrototypeOf(AdSet)).apply(this, arguments));
  }

  createClass(AdSet, [{
    key: 'getActivities',
    value: function getActivities(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdActivity, fields, params, fetchFirstPage, '/activities');
    }
  }, {
    key: 'getAdStudies',
    value: function getAdStudies(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdStudy, fields, params, fetchFirstPage, '/ad_studies');
    }
  }, {
    key: 'getAdCreatives',
    value: function getAdCreatives(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdCreative, fields, params, fetchFirstPage, '/adcreatives');
    }
  }, {
    key: 'deleteAdLabels',
    value: function deleteAdLabels() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(AdSet.prototype.__proto__ || Object.getPrototypeOf(AdSet.prototype), 'deleteEdge', this).call(this, '/adlabels', params);
    }
  }, {
    key: 'createAdLabel',
    value: function createAdLabel(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/adlabels', fields, params, AdSet, pathOverride);
    }
  }, {
    key: 'getAdRulesGoverned',
    value: function getAdRulesGoverned(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdRule, fields, params, fetchFirstPage, '/adrules_governed');
    }
  }, {
    key: 'getAds',
    value: function getAds(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Ad, fields, params, fetchFirstPage, '/ads');
    }
  }, {
    key: 'getAsyncAdRequests',
    value: function getAsyncAdRequests(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdAsyncRequest, fields, params, fetchFirstPage, '/asyncadrequests');
    }
  }, {
    key: 'getBudgetSchedules',
    value: function getBudgetSchedules(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(HighDemandPeriod, fields, params, fetchFirstPage, '/budget_schedules');
    }
  }, {
    key: 'createBudgetSchedule',
    value: function createBudgetSchedule(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/budget_schedules', fields, params, HighDemandPeriod, pathOverride);
    }
  }, {
    key: 'getCopies',
    value: function getCopies(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdSet, fields, params, fetchFirstPage, '/copies');
    }
  }, {
    key: 'createCopy',
    value: function createCopy(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/copies', fields, params, AdSet, pathOverride);
    }
  }, {
    key: 'getDeliveryEstimate',
    value: function getDeliveryEstimate(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdCampaignDeliveryEstimate, fields, params, fetchFirstPage, '/delivery_estimate');
    }
  }, {
    key: 'getInsights',
    value: function getInsights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdsInsights, fields, params, fetchFirstPage, '/insights');
    }
  }, {
    key: 'getInsightsAsync',
    value: function getInsightsAsync(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/insights', fields, params, AdReportRun, pathOverride);
    }
  }, {
    key: 'getMessageDeliveryEstimate',
    value: function getMessageDeliveryEstimate(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(MessageDeliveryEstimate, fields, params, fetchFirstPage, '/message_delivery_estimate');
    }
  }, {
    key: 'getTargetingSentenceLines',
    value: function getTargetingSentenceLines(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(TargetingSentenceLine, fields, params, fetchFirstPage, '/targetingsentencelines');
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(AdSet.prototype.__proto__ || Object.getPrototypeOf(AdSet.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(AdSet.prototype.__proto__ || Object.getPrototypeOf(AdSet.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        account_id: 'account_id',
        adlabels: 'adlabels',
        adset_schedule: 'adset_schedule',
        anchor_event_attribution_window_days: 'anchor_event_attribution_window_days',
        asset_feed_id: 'asset_feed_id',
        attribution_spec: 'attribution_spec',
        automatic_manual_state: 'automatic_manual_state',
        bid_adjustments: 'bid_adjustments',
        bid_amount: 'bid_amount',
        bid_constraints: 'bid_constraints',
        bid_info: 'bid_info',
        bid_strategy: 'bid_strategy',
        billing_event: 'billing_event',
        brand_safety_config: 'brand_safety_config',
        budget_remaining: 'budget_remaining',
        campaign: 'campaign',
        campaign_active_time: 'campaign_active_time',
        campaign_attribution: 'campaign_attribution',
        campaign_id: 'campaign_id',
        configured_status: 'configured_status',
        created_time: 'created_time',
        creative_sequence: 'creative_sequence',
        creative_sequence_repetition_pattern: 'creative_sequence_repetition_pattern',
        daily_budget: 'daily_budget',
        daily_min_spend_target: 'daily_min_spend_target',
        daily_spend_cap: 'daily_spend_cap',
        destination_type: 'destination_type',
        dsa_beneficiary: 'dsa_beneficiary',
        dsa_payor: 'dsa_payor',
        effective_status: 'effective_status',
        end_time: 'end_time',
        existing_customer_budget_percentage: 'existing_customer_budget_percentage',
        frequency_control_specs: 'frequency_control_specs',
        full_funnel_exploration_mode: 'full_funnel_exploration_mode',
        id: 'id',
        instagram_user_id: 'instagram_user_id',
        is_ba_skip_delayed_eligible: 'is_ba_skip_delayed_eligible',
        is_budget_schedule_enabled: 'is_budget_schedule_enabled',
        is_dynamic_creative: 'is_dynamic_creative',
        is_incremental_attribution_enabled: 'is_incremental_attribution_enabled',
        issues_info: 'issues_info',
        learning_stage_info: 'learning_stage_info',
        lifetime_budget: 'lifetime_budget',
        lifetime_imps: 'lifetime_imps',
        lifetime_min_spend_target: 'lifetime_min_spend_target',
        lifetime_spend_cap: 'lifetime_spend_cap',
        max_budget_spend_percentage: 'max_budget_spend_percentage',
        min_budget_spend_percentage: 'min_budget_spend_percentage',
        multi_optimization_goal_weight: 'multi_optimization_goal_weight',
        name: 'name',
        optimization_goal: 'optimization_goal',
        optimization_sub_event: 'optimization_sub_event',
        pacing_type: 'pacing_type',
        placement_soft_opt_out: 'placement_soft_opt_out',
        promoted_object: 'promoted_object',
        recommendations: 'recommendations',
        recurring_budget_semantics: 'recurring_budget_semantics',
        regional_regulated_categories: 'regional_regulated_categories',
        regional_regulation_identities: 'regional_regulation_identities',
        review_feedback: 'review_feedback',
        rf_prediction_id: 'rf_prediction_id',
        source_adset: 'source_adset',
        source_adset_id: 'source_adset_id',
        start_time: 'start_time',
        status: 'status',
        targeting: 'targeting',
        targeting_optimization_types: 'targeting_optimization_types',
        time_based_ad_rotation_id_blocks: 'time_based_ad_rotation_id_blocks',
        time_based_ad_rotation_intervals: 'time_based_ad_rotation_intervals',
        trending_topics_spec: 'trending_topics_spec',
        updated_time: 'updated_time',
        use_new_app_click: 'use_new_app_click',
        value_rule_set_id: 'value_rule_set_id',
        value_rules_applied: 'value_rules_applied'
      });
    }
  }, {
    key: 'BidStrategy',
    get: function get() {
      return Object.freeze({
        cost_cap: 'COST_CAP',
        lowest_cost_without_cap: 'LOWEST_COST_WITHOUT_CAP',
        lowest_cost_with_bid_cap: 'LOWEST_COST_WITH_BID_CAP',
        lowest_cost_with_min_roas: 'LOWEST_COST_WITH_MIN_ROAS'
      });
    }
  }, {
    key: 'BillingEvent',
    get: function get() {
      return Object.freeze({
        app_installs: 'APP_INSTALLS',
        clicks: 'CLICKS',
        impressions: 'IMPRESSIONS',
        link_clicks: 'LINK_CLICKS',
        listing_interaction: 'LISTING_INTERACTION',
        none: 'NONE',
        offer_claims: 'OFFER_CLAIMS',
        page_likes: 'PAGE_LIKES',
        post_engagement: 'POST_ENGAGEMENT',
        purchase: 'PURCHASE',
        thruplay: 'THRUPLAY'
      });
    }
  }, {
    key: 'ConfiguredStatus',
    get: function get() {
      return Object.freeze({
        active: 'ACTIVE',
        archived: 'ARCHIVED',
        deleted: 'DELETED',
        paused: 'PAUSED'
      });
    }
  }, {
    key: 'EffectiveStatus',
    get: function get() {
      return Object.freeze({
        active: 'ACTIVE',
        archived: 'ARCHIVED',
        campaign_paused: 'CAMPAIGN_PAUSED',
        deleted: 'DELETED',
        in_process: 'IN_PROCESS',
        paused: 'PAUSED',
        with_issues: 'WITH_ISSUES'
      });
    }
  }, {
    key: 'OptimizationGoal',
    get: function get() {
      return Object.freeze({
        advertiser_siloed_value: 'ADVERTISER_SILOED_VALUE',
        ad_recall_lift: 'AD_RECALL_LIFT',
        app_installs: 'APP_INSTALLS',
        app_installs_and_offsite_conversions: 'APP_INSTALLS_AND_OFFSITE_CONVERSIONS',
        automatic_objective: 'AUTOMATIC_OBJECTIVE',
        conversations: 'CONVERSATIONS',
        derived_events: 'DERIVED_EVENTS',
        engaged_users: 'ENGAGED_USERS',
        event_responses: 'EVENT_RESPONSES',
        impressions: 'IMPRESSIONS',
        in_app_value: 'IN_APP_VALUE',
        landing_page_views: 'LANDING_PAGE_VIEWS',
        lead_generation: 'LEAD_GENERATION',
        link_clicks: 'LINK_CLICKS',
        meaningful_call_attempt: 'MEANINGFUL_CALL_ATTEMPT',
        messaging_appointment_conversion: 'MESSAGING_APPOINTMENT_CONVERSION',
        messaging_purchase_conversion: 'MESSAGING_PURCHASE_CONVERSION',
        none: 'NONE',
        offsite_conversions: 'OFFSITE_CONVERSIONS',
        page_likes: 'PAGE_LIKES',
        post_engagement: 'POST_ENGAGEMENT',
        profile_and_page_engagement: 'PROFILE_AND_PAGE_ENGAGEMENT',
        profile_visit: 'PROFILE_VISIT',
        quality_call: 'QUALITY_CALL',
        quality_lead: 'QUALITY_LEAD',
        reach: 'REACH',
        reminders_set: 'REMINDERS_SET',
        subscribers: 'SUBSCRIBERS',
        thruplay: 'THRUPLAY',
        value: 'VALUE',
        visit_instagram_profile: 'VISIT_INSTAGRAM_PROFILE'
      });
    }
  }, {
    key: 'Status',
    get: function get() {
      return Object.freeze({
        active: 'ACTIVE',
        archived: 'ARCHIVED',
        deleted: 'DELETED',
        paused: 'PAUSED'
      });
    }
  }, {
    key: 'AutomaticManualState',
    get: function get() {
      return Object.freeze({
        automatic: 'AUTOMATIC',
        manual: 'MANUAL',
        unset: 'UNSET'
      });
    }
  }, {
    key: 'BudgetSource',
    get: function get() {
      return Object.freeze({
        none: 'NONE',
        rmn: 'RMN'
      });
    }
  }, {
    key: 'CreativeSequenceRepetitionPattern',
    get: function get() {
      return Object.freeze({
        full_sequence: 'FULL_SEQUENCE',
        last_ad: 'LAST_AD'
      });
    }
  }, {
    key: 'DatePreset',
    get: function get() {
      return Object.freeze({
        data_maximum: 'DATA_MAXIMUM',
        last_14d: 'LAST_14D',
        last_28d: 'LAST_28D',
        last_30d: 'LAST_30D',
        last_3d: 'LAST_3D',
        last_7d: 'LAST_7D',
        last_90d: 'LAST_90D',
        last_month: 'LAST_MONTH',
        last_quarter: 'LAST_QUARTER',
        last_week_mon_sun: 'LAST_WEEK_MON_SUN',
        last_week_sun_sat: 'LAST_WEEK_SUN_SAT',
        last_year: 'LAST_YEAR',
        maximum: 'MAXIMUM',
        this_month: 'THIS_MONTH',
        this_quarter: 'THIS_QUARTER',
        this_week_mon_today: 'THIS_WEEK_MON_TODAY',
        this_week_sun_today: 'THIS_WEEK_SUN_TODAY',
        this_year: 'THIS_YEAR',
        today: 'TODAY',
        yesterday: 'YESTERDAY'
      });
    }
  }, {
    key: 'DestinationType',
    get: function get() {
      return Object.freeze({
        app: 'APP',
        applinks_automatic: 'APPLINKS_AUTOMATIC',
        facebook: 'FACEBOOK',
        facebook_live: 'FACEBOOK_LIVE',
        facebook_page: 'FACEBOOK_PAGE',
        imagine: 'IMAGINE',
        instagram_direct: 'INSTAGRAM_DIRECT',
        instagram_live: 'INSTAGRAM_LIVE',
        instagram_profile: 'INSTAGRAM_PROFILE',
        instagram_profile_and_facebook_page: 'INSTAGRAM_PROFILE_AND_FACEBOOK_PAGE',
        messaging_instagram_direct_messenger: 'MESSAGING_INSTAGRAM_DIRECT_MESSENGER',
        messaging_instagram_direct_messenger_whatsapp: 'MESSAGING_INSTAGRAM_DIRECT_MESSENGER_WHATSAPP',
        messaging_instagram_direct_whatsapp: 'MESSAGING_INSTAGRAM_DIRECT_WHATSAPP',
        messaging_messenger_whatsapp: 'MESSAGING_MESSENGER_WHATSAPP',
        messenger: 'MESSENGER',
        on_ad: 'ON_AD',
        on_event: 'ON_EVENT',
        on_page: 'ON_PAGE',
        on_post: 'ON_POST',
        on_video: 'ON_VIDEO',
        shop_automatic: 'SHOP_AUTOMATIC',
        website: 'WEBSITE',
        whatsapp: 'WHATSAPP'
      });
    }
  }, {
    key: 'ExecutionOptions',
    get: function get() {
      return Object.freeze({
        include_recommendations: 'include_recommendations',
        validate_only: 'validate_only'
      });
    }
  }, {
    key: 'FullFunnelExplorationMode',
    get: function get() {
      return Object.freeze({
        extended_exploration: 'EXTENDED_EXPLORATION',
        limited_exploration: 'LIMITED_EXPLORATION',
        none_exploration: 'NONE_EXPLORATION'
      });
    }
  }, {
    key: 'MultiOptimizationGoalWeight',
    get: function get() {
      return Object.freeze({
        balanced: 'BALANCED',
        prefer_event: 'PREFER_EVENT',
        prefer_install: 'PREFER_INSTALL',
        undefined: 'UNDEFINED'
      });
    }
  }, {
    key: 'OptimizationSubEvent',
    get: function get() {
      return Object.freeze({
        none: 'NONE',
        post_interaction: 'POST_INTERACTION',
        travel_intent: 'TRAVEL_INTENT',
        travel_intent_bucket_01: 'TRAVEL_INTENT_BUCKET_01',
        travel_intent_bucket_02: 'TRAVEL_INTENT_BUCKET_02',
        travel_intent_bucket_03: 'TRAVEL_INTENT_BUCKET_03',
        travel_intent_bucket_04: 'TRAVEL_INTENT_BUCKET_04',
        travel_intent_bucket_05: 'TRAVEL_INTENT_BUCKET_05',
        travel_intent_no_destination_intent: 'TRAVEL_INTENT_NO_DESTINATION_INTENT',
        trip_consideration: 'TRIP_CONSIDERATION',
        video_sound_on: 'VIDEO_SOUND_ON'
      });
    }
  }, {
    key: 'RegionalRegulatedCategories',
    get: function get() {
      return Object.freeze({
        value_0: '0',
        value_1: '1',
        value_2: '2',
        value_3: '3',
        value_4: '4',
        value_5: '5',
        value_6: '6',
        value_7: '7',
        value_8: '8',
        value_9: '9',
        value_10: '10',
        value_11: '11',
        value_12: '12'
      });
    }
  }, {
    key: 'TuneForCategory',
    get: function get() {
      return Object.freeze({
        credit: 'CREDIT',
        employment: 'EMPLOYMENT',
        financial_products_services: 'FINANCIAL_PRODUCTS_SERVICES',
        housing: 'HOUSING',
        issues_elections_politics: 'ISSUES_ELECTIONS_POLITICS',
        none: 'NONE',
        online_gambling_and_gaming: 'ONLINE_GAMBLING_AND_GAMING'
      });
    }
  }, {
    key: 'Operator',
    get: function get() {
      return Object.freeze({
        all: 'ALL',
        any: 'ANY'
      });
    }
  }, {
    key: 'StatusOption',
    get: function get() {
      return Object.freeze({
        active: 'ACTIVE',
        inherited_from_source: 'INHERITED_FROM_SOURCE',
        paused: 'PAUSED'
      });
    }
  }]);
  return AdSet;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Campaign
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Campaign = function (_AbstractCrudObject) {
  inherits(Campaign, _AbstractCrudObject);

  function Campaign() {
    classCallCheck(this, Campaign);
    return possibleConstructorReturn(this, (Campaign.__proto__ || Object.getPrototypeOf(Campaign)).apply(this, arguments));
  }

  createClass(Campaign, [{
    key: 'getAdStudies',
    value: function getAdStudies(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdStudy, fields, params, fetchFirstPage, '/ad_studies');
    }
  }, {
    key: 'createAdLabel',
    value: function createAdLabel(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/adlabels', fields, params, Campaign, pathOverride);
    }
  }, {
    key: 'getAdRulesGoverned',
    value: function getAdRulesGoverned(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdRule, fields, params, fetchFirstPage, '/adrules_governed');
    }
  }, {
    key: 'getAds',
    value: function getAds(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Ad, fields, params, fetchFirstPage, '/ads');
    }
  }, {
    key: 'getAdSets',
    value: function getAdSets(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdSet, fields, params, fetchFirstPage, '/adsets');
    }
  }, {
    key: 'getBudgetSchedules',
    value: function getBudgetSchedules(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(HighDemandPeriod, fields, params, fetchFirstPage, '/budget_schedules');
    }
  }, {
    key: 'createBudgetSchedule',
    value: function createBudgetSchedule(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/budget_schedules', fields, params, HighDemandPeriod, pathOverride);
    }
  }, {
    key: 'getCopies',
    value: function getCopies(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Campaign, fields, params, fetchFirstPage, '/copies');
    }
  }, {
    key: 'createCopy',
    value: function createCopy(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/copies', fields, params, Campaign, pathOverride);
    }
  }, {
    key: 'getInsights',
    value: function getInsights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdsInsights, fields, params, fetchFirstPage, '/insights');
    }
  }, {
    key: 'getInsightsAsync',
    value: function getInsightsAsync(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/insights', fields, params, AdReportRun, pathOverride);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Campaign.prototype.__proto__ || Object.getPrototypeOf(Campaign.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Campaign.prototype.__proto__ || Object.getPrototypeOf(Campaign.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        account_id: 'account_id',
        adlabels: 'adlabels',
        advantage_state_info: 'advantage_state_info',
        bid_strategy: 'bid_strategy',
        boosted_object_id: 'boosted_object_id',
        brand_lift_studies: 'brand_lift_studies',
        budget_rebalance_flag: 'budget_rebalance_flag',
        budget_remaining: 'budget_remaining',
        buying_type: 'buying_type',
        campaign_group_active_time: 'campaign_group_active_time',
        can_create_brand_lift_study: 'can_create_brand_lift_study',
        can_use_spend_cap: 'can_use_spend_cap',
        configured_status: 'configured_status',
        created_time: 'created_time',
        daily_budget: 'daily_budget',
        effective_status: 'effective_status',
        has_secondary_skadnetwork_reporting: 'has_secondary_skadnetwork_reporting',
        id: 'id',
        is_adset_budget_sharing_enabled: 'is_adset_budget_sharing_enabled',
        is_budget_schedule_enabled: 'is_budget_schedule_enabled',
        is_direct_send_campaign: 'is_direct_send_campaign',
        is_message_campaign: 'is_message_campaign',
        is_skadnetwork_attribution: 'is_skadnetwork_attribution',
        issues_info: 'issues_info',
        last_budget_toggling_time: 'last_budget_toggling_time',
        lifetime_budget: 'lifetime_budget',
        name: 'name',
        objective: 'objective',
        pacing_type: 'pacing_type',
        primary_attribution: 'primary_attribution',
        promoted_object: 'promoted_object',
        recommendations: 'recommendations',
        smart_promotion_type: 'smart_promotion_type',
        source_campaign: 'source_campaign',
        source_campaign_id: 'source_campaign_id',
        source_recommendation_type: 'source_recommendation_type',
        special_ad_categories: 'special_ad_categories',
        special_ad_category: 'special_ad_category',
        special_ad_category_country: 'special_ad_category_country',
        spend_cap: 'spend_cap',
        start_time: 'start_time',
        status: 'status',
        stop_time: 'stop_time',
        topline_id: 'topline_id',
        updated_time: 'updated_time'
      });
    }
  }, {
    key: 'BidStrategy',
    get: function get() {
      return Object.freeze({
        cost_cap: 'COST_CAP',
        lowest_cost_without_cap: 'LOWEST_COST_WITHOUT_CAP',
        lowest_cost_with_bid_cap: 'LOWEST_COST_WITH_BID_CAP',
        lowest_cost_with_min_roas: 'LOWEST_COST_WITH_MIN_ROAS'
      });
    }
  }, {
    key: 'ConfiguredStatus',
    get: function get() {
      return Object.freeze({
        active: 'ACTIVE',
        archived: 'ARCHIVED',
        deleted: 'DELETED',
        paused: 'PAUSED'
      });
    }
  }, {
    key: 'EffectiveStatus',
    get: function get() {
      return Object.freeze({
        active: 'ACTIVE',
        archived: 'ARCHIVED',
        deleted: 'DELETED',
        in_process: 'IN_PROCESS',
        paused: 'PAUSED',
        with_issues: 'WITH_ISSUES'
      });
    }
  }, {
    key: 'Status',
    get: function get() {
      return Object.freeze({
        active: 'ACTIVE',
        archived: 'ARCHIVED',
        deleted: 'DELETED',
        paused: 'PAUSED'
      });
    }
  }, {
    key: 'DatePreset',
    get: function get() {
      return Object.freeze({
        data_maximum: 'data_maximum',
        last_14d: 'last_14d',
        last_28d: 'last_28d',
        last_30d: 'last_30d',
        last_3d: 'last_3d',
        last_7d: 'last_7d',
        last_90d: 'last_90d',
        last_month: 'last_month',
        last_quarter: 'last_quarter',
        last_week_mon_sun: 'last_week_mon_sun',
        last_week_sun_sat: 'last_week_sun_sat',
        last_year: 'last_year',
        maximum: 'maximum',
        this_month: 'this_month',
        this_quarter: 'this_quarter',
        this_week_mon_today: 'this_week_mon_today',
        this_week_sun_today: 'this_week_sun_today',
        this_year: 'this_year',
        today: 'today',
        yesterday: 'yesterday'
      });
    }
  }, {
    key: 'ExecutionOptions',
    get: function get() {
      return Object.freeze({
        include_recommendations: 'include_recommendations',
        validate_only: 'validate_only'
      });
    }
  }, {
    key: 'Objective',
    get: function get() {
      return Object.freeze({
        app_installs: 'APP_INSTALLS',
        brand_awareness: 'BRAND_AWARENESS',
        conversions: 'CONVERSIONS',
        event_responses: 'EVENT_RESPONSES',
        lead_generation: 'LEAD_GENERATION',
        link_clicks: 'LINK_CLICKS',
        local_awareness: 'LOCAL_AWARENESS',
        messages: 'MESSAGES',
        offer_claims: 'OFFER_CLAIMS',
        outcome_app_promotion: 'OUTCOME_APP_PROMOTION',
        outcome_awareness: 'OUTCOME_AWARENESS',
        outcome_engagement: 'OUTCOME_ENGAGEMENT',
        outcome_leads: 'OUTCOME_LEADS',
        outcome_sales: 'OUTCOME_SALES',
        outcome_traffic: 'OUTCOME_TRAFFIC',
        page_likes: 'PAGE_LIKES',
        post_engagement: 'POST_ENGAGEMENT',
        product_catalog_sales: 'PRODUCT_CATALOG_SALES',
        reach: 'REACH',
        store_visits: 'STORE_VISITS',
        video_views: 'VIDEO_VIEWS'
      });
    }
  }, {
    key: 'SmartPromotionType',
    get: function get() {
      return Object.freeze({
        guided_creation: 'GUIDED_CREATION',
        smart_app_promotion: 'SMART_APP_PROMOTION'
      });
    }
  }, {
    key: 'SpecialAdCategories',
    get: function get() {
      return Object.freeze({
        credit: 'CREDIT',
        employment: 'EMPLOYMENT',
        financial_products_services: 'FINANCIAL_PRODUCTS_SERVICES',
        housing: 'HOUSING',
        issues_elections_politics: 'ISSUES_ELECTIONS_POLITICS',
        none: 'NONE',
        online_gambling_and_gaming: 'ONLINE_GAMBLING_AND_GAMING'
      });
    }
  }, {
    key: 'SpecialAdCategoryCountry',
    get: function get() {
      return Object.freeze({
        ac: 'AC',
        ad: 'AD',
        ae: 'AE',
        af: 'AF',
        ag: 'AG',
        ai: 'AI',
        al: 'AL',
        am: 'AM',
        an: 'AN',
        ao: 'AO',
        aq: 'AQ',
        ar: 'AR',
        as: 'AS',
        at: 'AT',
        au: 'AU',
        aw: 'AW',
        ax: 'AX',
        az: 'AZ',
        ba: 'BA',
        bb: 'BB',
        bd: 'BD',
        be: 'BE',
        bf: 'BF',
        bg: 'BG',
        bh: 'BH',
        bi: 'BI',
        bj: 'BJ',
        bl: 'BL',
        bm: 'BM',
        bn: 'BN',
        bo: 'BO',
        bq: 'BQ',
        br: 'BR',
        bs: 'BS',
        bt: 'BT',
        bv: 'BV',
        bw: 'BW',
        by: 'BY',
        bz: 'BZ',
        ca: 'CA',
        cc: 'CC',
        cd: 'CD',
        cf: 'CF',
        cg: 'CG',
        ch: 'CH',
        ci: 'CI',
        ck: 'CK',
        cl: 'CL',
        cm: 'CM',
        cn: 'CN',
        co: 'CO',
        cr: 'CR',
        cu: 'CU',
        cv: 'CV',
        cw: 'CW',
        cx: 'CX',
        cy: 'CY',
        cz: 'CZ',
        de: 'DE',
        dj: 'DJ',
        dk: 'DK',
        dm: 'DM',
        do: 'DO',
        dz: 'DZ',
        ec: 'EC',
        ee: 'EE',
        eg: 'EG',
        eh: 'EH',
        er: 'ER',
        es: 'ES',
        et: 'ET',
        fi: 'FI',
        fj: 'FJ',
        fk: 'FK',
        fm: 'FM',
        fo: 'FO',
        fr: 'FR',
        ga: 'GA',
        gb: 'GB',
        gd: 'GD',
        ge: 'GE',
        gf: 'GF',
        gg: 'GG',
        gh: 'GH',
        gi: 'GI',
        gl: 'GL',
        gm: 'GM',
        gn: 'GN',
        gp: 'GP',
        gq: 'GQ',
        gr: 'GR',
        gs: 'GS',
        gt: 'GT',
        gu: 'GU',
        gw: 'GW',
        gy: 'GY',
        hk: 'HK',
        hm: 'HM',
        hn: 'HN',
        hr: 'HR',
        ht: 'HT',
        hu: 'HU',
        id: 'ID',
        ie: 'IE',
        il: 'IL',
        im: 'IM',
        in: 'IN',
        io: 'IO',
        iq: 'IQ',
        ir: 'IR',
        is: 'IS',
        it: 'IT',
        je: 'JE',
        jm: 'JM',
        jo: 'JO',
        jp: 'JP',
        ke: 'KE',
        kg: 'KG',
        kh: 'KH',
        ki: 'KI',
        km: 'KM',
        kn: 'KN',
        kp: 'KP',
        kr: 'KR',
        kw: 'KW',
        ky: 'KY',
        kz: 'KZ',
        la: 'LA',
        lb: 'LB',
        lc: 'LC',
        li: 'LI',
        lk: 'LK',
        lr: 'LR',
        ls: 'LS',
        lt: 'LT',
        lu: 'LU',
        lv: 'LV',
        ly: 'LY',
        ma: 'MA',
        mc: 'MC',
        md: 'MD',
        me: 'ME',
        mf: 'MF',
        mg: 'MG',
        mh: 'MH',
        mk: 'MK',
        ml: 'ML',
        mm: 'MM',
        mn: 'MN',
        mo: 'MO',
        mp: 'MP',
        mq: 'MQ',
        mr: 'MR',
        ms: 'MS',
        mt: 'MT',
        mu: 'MU',
        mv: 'MV',
        mw: 'MW',
        mx: 'MX',
        my: 'MY',
        mz: 'MZ',
        na: 'NA',
        nc: 'NC',
        ne: 'NE',
        nf: 'NF',
        ng: 'NG',
        ni: 'NI',
        nl: 'NL',
        no: 'NO',
        np: 'NP',
        nr: 'NR',
        nu: 'NU',
        nz: 'NZ',
        om: 'OM',
        pa: 'PA',
        pe: 'PE',
        pf: 'PF',
        pg: 'PG',
        ph: 'PH',
        pk: 'PK',
        pl: 'PL',
        pm: 'PM',
        pn: 'PN',
        pr: 'PR',
        ps: 'PS',
        pt: 'PT',
        pw: 'PW',
        py: 'PY',
        qa: 'QA',
        re: 'RE',
        ro: 'RO',
        rs: 'RS',
        ru: 'RU',
        rw: 'RW',
        sa: 'SA',
        sb: 'SB',
        sc: 'SC',
        sd: 'SD',
        se: 'SE',
        sg: 'SG',
        sh: 'SH',
        si: 'SI',
        sj: 'SJ',
        sk: 'SK',
        sl: 'SL',
        sm: 'SM',
        sn: 'SN',
        so: 'SO',
        sr: 'SR',
        ss: 'SS',
        st: 'ST',
        sv: 'SV',
        sx: 'SX',
        sy: 'SY',
        sz: 'SZ',
        tc: 'TC',
        td: 'TD',
        tf: 'TF',
        tg: 'TG',
        th: 'TH',
        tj: 'TJ',
        tk: 'TK',
        tl: 'TL',
        tm: 'TM',
        tn: 'TN',
        to: 'TO',
        tr: 'TR',
        tt: 'TT',
        tv: 'TV',
        tw: 'TW',
        tz: 'TZ',
        ua: 'UA',
        ug: 'UG',
        um: 'UM',
        us: 'US',
        uy: 'UY',
        uz: 'UZ',
        va: 'VA',
        vc: 'VC',
        ve: 'VE',
        vg: 'VG',
        vi: 'VI',
        vn: 'VN',
        vu: 'VU',
        wf: 'WF',
        ws: 'WS',
        xk: 'XK',
        ye: 'YE',
        yt: 'YT',
        za: 'ZA',
        zm: 'ZM',
        zw: 'ZW'
      });
    }
  }, {
    key: 'Operator',
    get: function get() {
      return Object.freeze({
        all: 'ALL',
        any: 'ANY'
      });
    }
  }, {
    key: 'SpecialAdCategory',
    get: function get() {
      return Object.freeze({
        credit: 'CREDIT',
        employment: 'EMPLOYMENT',
        financial_products_services: 'FINANCIAL_PRODUCTS_SERVICES',
        housing: 'HOUSING',
        issues_elections_politics: 'ISSUES_ELECTIONS_POLITICS',
        none: 'NONE',
        online_gambling_and_gaming: 'ONLINE_GAMBLING_AND_GAMING'
      });
    }
  }, {
    key: 'StatusOption',
    get: function get() {
      return Object.freeze({
        active: 'ACTIVE',
        inherited_from_source: 'INHERITED_FROM_SOURCE',
        paused: 'PAUSED'
      });
    }
  }]);
  return Campaign;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdStudyCell
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdStudyCell = function (_AbstractCrudObject) {
  inherits(AdStudyCell, _AbstractCrudObject);

  function AdStudyCell() {
    classCallCheck(this, AdStudyCell);
    return possibleConstructorReturn(this, (AdStudyCell.__proto__ || Object.getPrototypeOf(AdStudyCell)).apply(this, arguments));
  }

  createClass(AdStudyCell, [{
    key: 'getAdAccounts',
    value: function getAdAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdAccount, fields, params, fetchFirstPage, '/adaccounts');
    }
  }, {
    key: 'getAdSets',
    value: function getAdSets(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdSet, fields, params, fetchFirstPage, '/adsets');
    }
  }, {
    key: 'getCampaigns',
    value: function getCampaigns(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Campaign, fields, params, fetchFirstPage, '/campaigns');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(AdStudyCell.prototype.__proto__ || Object.getPrototypeOf(AdStudyCell.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        ad_entities_count: 'ad_entities_count',
        control_percentage: 'control_percentage',
        id: 'id',
        name: 'name',
        treatment_percentage: 'treatment_percentage'
      });
    }
  }, {
    key: 'CreationTemplate',
    get: function get() {
      return Object.freeze({
        automatic_placements: 'AUTOMATIC_PLACEMENTS',
        brand_awareness: 'BRAND_AWARENESS',
        facebook: 'FACEBOOK',
        facebook_audience_network: 'FACEBOOK_AUDIENCE_NETWORK',
        facebook_instagram: 'FACEBOOK_INSTAGRAM',
        facebook_news_feed: 'FACEBOOK_NEWS_FEED',
        facebook_news_feed_in_stream_video: 'FACEBOOK_NEWS_FEED_IN_STREAM_VIDEO',
        high_frequency: 'HIGH_FREQUENCY',
        instagram: 'INSTAGRAM',
        in_stream_video: 'IN_STREAM_VIDEO',
        low_frequency: 'LOW_FREQUENCY',
        medium_frequency: 'MEDIUM_FREQUENCY',
        mobile_optimized_video: 'MOBILE_OPTIMIZED_VIDEO',
        page_post_engagement: 'PAGE_POST_ENGAGEMENT',
        reach: 'REACH',
        tv_commercial: 'TV_COMMERCIAL',
        tv_facebook: 'TV_FACEBOOK',
        video_view_optimization: 'VIDEO_VIEW_OPTIMIZATION'
      });
    }
  }]);
  return AdStudyCell;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * PrivateLiftStudyInstance
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var PrivateLiftStudyInstance = function (_AbstractCrudObject) {
  inherits(PrivateLiftStudyInstance, _AbstractCrudObject);

  function PrivateLiftStudyInstance() {
    classCallCheck(this, PrivateLiftStudyInstance);
    return possibleConstructorReturn(this, (PrivateLiftStudyInstance.__proto__ || Object.getPrototypeOf(PrivateLiftStudyInstance)).apply(this, arguments));
  }

  createClass(PrivateLiftStudyInstance, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(PrivateLiftStudyInstance.prototype.__proto__ || Object.getPrototypeOf(PrivateLiftStudyInstance.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        breakdown_key: 'breakdown_key',
        created_time: 'created_time',
        feature_list: 'feature_list',
        id: 'id',
        issuer_certificate: 'issuer_certificate',
        latest_status_update_time: 'latest_status_update_time',
        run_id: 'run_id',
        server_hostnames: 'server_hostnames',
        server_ips: 'server_ips',
        status: 'status',
        tier: 'tier'
      });
    }
  }, {
    key: 'Operation',
    get: function get() {
      return Object.freeze({
        aggregate: 'AGGREGATE',
        cancel: 'CANCEL',
        compute: 'COMPUTE',
        id_match: 'ID_MATCH',
        next: 'NEXT',
        none: 'NONE'
      });
    }
  }]);
  return PrivateLiftStudyInstance;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdPlacement
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdPlacement = function (_AbstractCrudObject) {
  inherits(AdPlacement, _AbstractCrudObject);

  function AdPlacement() {
    classCallCheck(this, AdPlacement);
    return possibleConstructorReturn(this, (AdPlacement.__proto__ || Object.getPrototypeOf(AdPlacement)).apply(this, arguments));
  }

  createClass(AdPlacement, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        bundle_id: 'bundle_id',
        display_format: 'display_format',
        external_placement_id: 'external_placement_id',
        google_display_format: 'google_display_format',
        id: 'id',
        name: 'name',
        placement_group: 'placement_group',
        platform: 'platform',
        status: 'status'
      });
    }
  }]);
  return AdPlacement;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdNetworkAnalyticsSyncQueryResult
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdNetworkAnalyticsSyncQueryResult = function (_AbstractCrudObject) {
  inherits(AdNetworkAnalyticsSyncQueryResult, _AbstractCrudObject);

  function AdNetworkAnalyticsSyncQueryResult() {
    classCallCheck(this, AdNetworkAnalyticsSyncQueryResult);
    return possibleConstructorReturn(this, (AdNetworkAnalyticsSyncQueryResult.__proto__ || Object.getPrototypeOf(AdNetworkAnalyticsSyncQueryResult)).apply(this, arguments));
  }

  createClass(AdNetworkAnalyticsSyncQueryResult, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        omitted_results: 'omitted_results',
        query_id: 'query_id',
        results: 'results'
      });
    }
  }, {
    key: 'AggregationPeriod',
    get: function get() {
      return Object.freeze({
        day: 'DAY',
        total: 'TOTAL'
      });
    }
  }, {
    key: 'Breakdowns',
    get: function get() {
      return Object.freeze({
        ad_server_campaign_id: 'AD_SERVER_CAMPAIGN_ID',
        ad_space: 'AD_SPACE',
        age: 'AGE',
        app: 'APP',
        clicked_view_tag: 'CLICKED_VIEW_TAG',
        country: 'COUNTRY',
        deal: 'DEAL',
        deal_ad: 'DEAL_AD',
        deal_page: 'DEAL_PAGE',
        delivery_method: 'DELIVERY_METHOD',
        display_format: 'DISPLAY_FORMAT',
        fail_reason: 'FAIL_REASON',
        gender: 'GENDER',
        instant_article_id: 'INSTANT_ARTICLE_ID',
        instant_article_page_id: 'INSTANT_ARTICLE_PAGE_ID',
        is_deal_backfill: 'IS_DEAL_BACKFILL',
        placement: 'PLACEMENT',
        placement_name: 'PLACEMENT_NAME',
        platform: 'PLATFORM',
        property: 'PROPERTY',
        sdk_version: 'SDK_VERSION'
      });
    }
  }, {
    key: 'Metrics',
    get: function get() {
      return Object.freeze({
        fb_ad_network_bidding_bid_rate: 'FB_AD_NETWORK_BIDDING_BID_RATE',
        fb_ad_network_bidding_request: 'FB_AD_NETWORK_BIDDING_REQUEST',
        fb_ad_network_bidding_response: 'FB_AD_NETWORK_BIDDING_RESPONSE',
        fb_ad_network_bidding_revenue: 'FB_AD_NETWORK_BIDDING_REVENUE',
        fb_ad_network_bidding_win_rate: 'FB_AD_NETWORK_BIDDING_WIN_RATE',
        fb_ad_network_click: 'FB_AD_NETWORK_CLICK',
        fb_ad_network_cpm: 'FB_AD_NETWORK_CPM',
        fb_ad_network_ctr: 'FB_AD_NETWORK_CTR',
        fb_ad_network_filled_request: 'FB_AD_NETWORK_FILLED_REQUEST',
        fb_ad_network_fill_rate: 'FB_AD_NETWORK_FILL_RATE',
        fb_ad_network_imp: 'FB_AD_NETWORK_IMP',
        fb_ad_network_impression_rate: 'FB_AD_NETWORK_IMPRESSION_RATE',
        fb_ad_network_request: 'FB_AD_NETWORK_REQUEST',
        fb_ad_network_revenue: 'FB_AD_NETWORK_REVENUE',
        fb_ad_network_show_rate: 'FB_AD_NETWORK_SHOW_RATE',
        fb_ad_network_video_guarantee_revenue: 'FB_AD_NETWORK_VIDEO_GUARANTEE_REVENUE',
        fb_ad_network_video_mrc: 'FB_AD_NETWORK_VIDEO_MRC',
        fb_ad_network_video_mrc_rate: 'FB_AD_NETWORK_VIDEO_MRC_RATE',
        fb_ad_network_video_view: 'FB_AD_NETWORK_VIDEO_VIEW',
        fb_ad_network_video_view_rate: 'FB_AD_NETWORK_VIDEO_VIEW_RATE'
      });
    }
  }, {
    key: 'OrderingColumn',
    get: function get() {
      return Object.freeze({
        metric: 'METRIC',
        time: 'TIME',
        value: 'VALUE'
      });
    }
  }, {
    key: 'OrderingType',
    get: function get() {
      return Object.freeze({
        ascending: 'ASCENDING',
        descending: 'DESCENDING'
      });
    }
  }]);
  return AdNetworkAnalyticsSyncQueryResult;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdNetworkAnalyticsAsyncQueryResult
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdNetworkAnalyticsAsyncQueryResult = function (_AbstractCrudObject) {
  inherits(AdNetworkAnalyticsAsyncQueryResult, _AbstractCrudObject);

  function AdNetworkAnalyticsAsyncQueryResult() {
    classCallCheck(this, AdNetworkAnalyticsAsyncQueryResult);
    return possibleConstructorReturn(this, (AdNetworkAnalyticsAsyncQueryResult.__proto__ || Object.getPrototypeOf(AdNetworkAnalyticsAsyncQueryResult)).apply(this, arguments));
  }

  createClass(AdNetworkAnalyticsAsyncQueryResult, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        data: 'data',
        omitted_results: 'omitted_results',
        query_id: 'query_id',
        results: 'results',
        status: 'status'
      });
    }
  }]);
  return AdNetworkAnalyticsAsyncQueryResult;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ALMAdAccountInfo
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ALMAdAccountInfo = function (_AbstractCrudObject) {
  inherits(ALMAdAccountInfo, _AbstractCrudObject);

  function ALMAdAccountInfo() {
    classCallCheck(this, ALMAdAccountInfo);
    return possibleConstructorReturn(this, (ALMAdAccountInfo.__proto__ || Object.getPrototypeOf(ALMAdAccountInfo)).apply(this, arguments));
  }

  createClass(ALMAdAccountInfo, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        ad_account_id: 'ad_account_id',
        id: 'id',
        managed_by: 'managed_by',
        owned_by: 'owned_by',
        parent_advertiser_id: 'parent_advertiser_id',
        sub_vertical: 'sub_vertical',
        tag: 'tag',
        user_ids: 'user_ids',
        vertical: 'vertical'
      });
    }
  }]);
  return ALMAdAccountInfo;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdCustomDerivedMetrics
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdCustomDerivedMetrics = function (_AbstractCrudObject) {
  inherits(AdCustomDerivedMetrics, _AbstractCrudObject);

  function AdCustomDerivedMetrics() {
    classCallCheck(this, AdCustomDerivedMetrics);
    return possibleConstructorReturn(this, (AdCustomDerivedMetrics.__proto__ || Object.getPrototypeOf(AdCustomDerivedMetrics)).apply(this, arguments));
  }

  createClass(AdCustomDerivedMetrics, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        ad_account_id: 'ad_account_id',
        business: 'business',
        creation_time: 'creation_time',
        creator: 'creator',
        custom_derived_metric_type: 'custom_derived_metric_type',
        deletion_time: 'deletion_time',
        deletor: 'deletor',
        description: 'description',
        format_type: 'format_type',
        formula: 'formula',
        has_attribution_windows: 'has_attribution_windows',
        has_inline_attribution_window: 'has_inline_attribution_window',
        id: 'id',
        name: 'name',
        permission: 'permission',
        saved_report_id: 'saved_report_id',
        scope: 'scope'
      });
    }
  }, {
    key: 'Scope',
    get: function get() {
      return Object.freeze({
        account: 'ACCOUNT',
        business: 'BUSINESS',
        business_asset_group: 'BUSINESS_ASSET_GROUP'
      });
    }
  }]);
  return AdCustomDerivedMetrics;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdsDataset
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdsDataset = function (_AbstractCrudObject) {
  inherits(AdsDataset, _AbstractCrudObject);

  function AdsDataset() {
    classCallCheck(this, AdsDataset);
    return possibleConstructorReturn(this, (AdsDataset.__proto__ || Object.getPrototypeOf(AdsDataset)).apply(this, arguments));
  }

  createClass(AdsDataset, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        can_proxy: 'can_proxy',
        collection_rate: 'collection_rate',
        config: 'config',
        creation_time: 'creation_time',
        creator: 'creator',
        dataset_id: 'dataset_id',
        description: 'description',
        duplicate_entries: 'duplicate_entries',
        enable_auto_assign_to_accounts: 'enable_auto_assign_to_accounts',
        enable_automatic_events: 'enable_automatic_events',
        enable_automatic_matching: 'enable_automatic_matching',
        enable_real_time_event_log: 'enable_real_time_event_log',
        event_stats: 'event_stats',
        event_time_max: 'event_time_max',
        event_time_min: 'event_time_min',
        first_party_cookie_status: 'first_party_cookie_status',
        has_bapi_domains: 'has_bapi_domains',
        has_catalog_microdata_activity: 'has_catalog_microdata_activity',
        has_ofa_redacted_keys: 'has_ofa_redacted_keys',
        has_sent_pii: 'has_sent_pii',
        id: 'id',
        is_consolidated_container: 'is_consolidated_container',
        is_created_by_business: 'is_created_by_business',
        is_crm: 'is_crm',
        is_eligible_for_sharing_to_ad_account: 'is_eligible_for_sharing_to_ad_account',
        is_eligible_for_sharing_to_business: 'is_eligible_for_sharing_to_business',
        is_eligible_for_value_optimization: 'is_eligible_for_value_optimization',
        is_mta_use: 'is_mta_use',
        is_restricted_use: 'is_restricted_use',
        is_unavailable: 'is_unavailable',
        last_fired_time: 'last_fired_time',
        last_upload_app: 'last_upload_app',
        last_upload_app_changed_time: 'last_upload_app_changed_time',
        last_upload_time: 'last_upload_time',
        late_upload_reminder_eligibility: 'late_upload_reminder_eligibility',
        match_rate_approx: 'match_rate_approx',
        matched_entries: 'matched_entries',
        name: 'name',
        no_ads_tracked_for_weekly_uploaded_events_reminder_eligibility: 'no_ads_tracked_for_weekly_uploaded_events_reminder_eligibility',
        num_active_ad_set_tracked: 'num_active_ad_set_tracked',
        num_recent_offline_conversions_uploaded: 'num_recent_offline_conversions_uploaded',
        num_uploads: 'num_uploads',
        owner_ad_account: 'owner_ad_account',
        owner_business: 'owner_business',
        percentage_of_late_uploads_in_external_suboptimal_window: 'percentage_of_late_uploads_in_external_suboptimal_window',
        permissions: 'permissions',
        server_last_fired_time: 'server_last_fired_time',
        show_automatic_events: 'show_automatic_events',
        upload_rate: 'upload_rate',
        upload_reminder_eligibility: 'upload_reminder_eligibility',
        usage: 'usage',
        valid_entries: 'valid_entries'
      });
    }
  }, {
    key: 'SortBy',
    get: function get() {
      return Object.freeze({
        last_fired_time: 'LAST_FIRED_TIME',
        name: 'NAME'
      });
    }
  }]);
  return AdsDataset;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdsReportBuilderMMMReport
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdsReportBuilderMMMReport = function (_AbstractCrudObject) {
  inherits(AdsReportBuilderMMMReport, _AbstractCrudObject);

  function AdsReportBuilderMMMReport() {
    classCallCheck(this, AdsReportBuilderMMMReport);
    return possibleConstructorReturn(this, (AdsReportBuilderMMMReport.__proto__ || Object.getPrototypeOf(AdsReportBuilderMMMReport)).apply(this, arguments));
  }

  createClass(AdsReportBuilderMMMReport, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        async_status: 'async_status',
        export_format: 'export_format',
        export_name: 'export_name',
        export_type: 'export_type',
        has_seen: 'has_seen',
        id: 'id',
        mmm_status: 'mmm_status',
        time_start: 'time_start'
      });
    }
  }]);
  return AdsReportBuilderMMMReport;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdsReportBuilderMMMReportScheduler
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdsReportBuilderMMMReportScheduler = function (_AbstractCrudObject) {
  inherits(AdsReportBuilderMMMReportScheduler, _AbstractCrudObject);

  function AdsReportBuilderMMMReportScheduler() {
    classCallCheck(this, AdsReportBuilderMMMReportScheduler);
    return possibleConstructorReturn(this, (AdsReportBuilderMMMReportScheduler.__proto__ || Object.getPrototypeOf(AdsReportBuilderMMMReportScheduler)).apply(this, arguments));
  }

  createClass(AdsReportBuilderMMMReportScheduler, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        ad_account_ids: 'ad_account_ids',
        filtering: 'filtering',
        id: 'id',
        report_name: 'report_name',
        schedule_frequency: 'schedule_frequency'
      });
    }
  }]);
  return AdsReportBuilderMMMReportScheduler;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AssignedUser
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AssignedUser = function (_AbstractCrudObject) {
  inherits(AssignedUser, _AbstractCrudObject);

  function AssignedUser() {
    classCallCheck(this, AssignedUser);
    return possibleConstructorReturn(this, (AssignedUser.__proto__ || Object.getPrototypeOf(AssignedUser)).apply(this, arguments));
  }

  createClass(AssignedUser, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        business: 'business',
        id: 'id',
        name: 'name',
        user_type: 'user_type'
      });
    }
  }]);
  return AssignedUser;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CustomConversionStatsResult
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CustomConversionStatsResult = function (_AbstractCrudObject) {
  inherits(CustomConversionStatsResult, _AbstractCrudObject);

  function CustomConversionStatsResult() {
    classCallCheck(this, CustomConversionStatsResult);
    return possibleConstructorReturn(this, (CustomConversionStatsResult.__proto__ || Object.getPrototypeOf(CustomConversionStatsResult)).apply(this, arguments));
  }

  createClass(CustomConversionStatsResult, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        aggregation: 'aggregation',
        data: 'data',
        timestamp: 'timestamp'
      });
    }
  }, {
    key: 'Aggregation',
    get: function get() {
      return Object.freeze({
        count: 'count',
        device_type: 'device_type',
        host: 'host',
        pixel_fire: 'pixel_fire',
        unmatched_count: 'unmatched_count',
        unmatched_usd_amount: 'unmatched_usd_amount',
        url: 'url',
        usd_amount: 'usd_amount'
      });
    }
  }]);
  return CustomConversionStatsResult;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CustomConversion
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CustomConversion = function (_AbstractCrudObject) {
  inherits(CustomConversion, _AbstractCrudObject);

  function CustomConversion() {
    classCallCheck(this, CustomConversion);
    return possibleConstructorReturn(this, (CustomConversion.__proto__ || Object.getPrototypeOf(CustomConversion)).apply(this, arguments));
  }

  createClass(CustomConversion, [{
    key: 'getStats',
    value: function getStats(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CustomConversionStatsResult, fields, params, fetchFirstPage, '/stats');
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(CustomConversion.prototype.__proto__ || Object.getPrototypeOf(CustomConversion.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(CustomConversion.prototype.__proto__ || Object.getPrototypeOf(CustomConversion.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        account_id: 'account_id',
        aggregation_rule: 'aggregation_rule',
        business: 'business',
        creation_time: 'creation_time',
        custom_event_type: 'custom_event_type',
        data_sources: 'data_sources',
        default_conversion_value: 'default_conversion_value',
        description: 'description',
        event_source_type: 'event_source_type',
        first_fired_time: 'first_fired_time',
        id: 'id',
        is_archived: 'is_archived',
        is_unavailable: 'is_unavailable',
        last_fired_time: 'last_fired_time',
        name: 'name',
        offline_conversion_data_set: 'offline_conversion_data_set',
        pixel: 'pixel',
        retention_days: 'retention_days',
        rule: 'rule'
      });
    }
  }, {
    key: 'CustomEventType',
    get: function get() {
      return Object.freeze({
        add_payment_info: 'ADD_PAYMENT_INFO',
        add_to_cart: 'ADD_TO_CART',
        add_to_wishlist: 'ADD_TO_WISHLIST',
        complete_registration: 'COMPLETE_REGISTRATION',
        contact: 'CONTACT',
        content_view: 'CONTENT_VIEW',
        customize_product: 'CUSTOMIZE_PRODUCT',
        donate: 'DONATE',
        facebook_selected: 'FACEBOOK_SELECTED',
        find_location: 'FIND_LOCATION',
        initiated_checkout: 'INITIATED_CHECKOUT',
        lead: 'LEAD',
        listing_interaction: 'LISTING_INTERACTION',
        other: 'OTHER',
        purchase: 'PURCHASE',
        schedule: 'SCHEDULE',
        search: 'SEARCH',
        start_trial: 'START_TRIAL',
        submit_application: 'SUBMIT_APPLICATION',
        subscribe: 'SUBSCRIBE'
      });
    }
  }, {
    key: 'ActionSourceType',
    get: function get() {
      return Object.freeze({
        app: 'app',
        business_messaging: 'business_messaging',
        chat: 'chat',
        email: 'email',
        other: 'other',
        phone_call: 'phone_call',
        physical_store: 'physical_store',
        system_generated: 'system_generated',
        website: 'website'
      });
    }
  }]);
  return CustomConversion;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AREffect
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AREffect = function (_AbstractCrudObject) {
  inherits(AREffect, _AbstractCrudObject);

  function AREffect() {
    classCallCheck(this, AREffect);
    return possibleConstructorReturn(this, (AREffect.__proto__ || Object.getPrototypeOf(AREffect)).apply(this, arguments));
  }

  createClass(AREffect, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        creation_time: 'creation_time',
        id: 'id',
        last_modified_time: 'last_modified_time',
        name: 'name',
        status: 'status',
        surfaces: 'surfaces'
      });
    }
  }]);
  return AREffect;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * IGUpcomingEvent
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var IGUpcomingEvent = function (_AbstractCrudObject) {
  inherits(IGUpcomingEvent, _AbstractCrudObject);

  function IGUpcomingEvent() {
    classCallCheck(this, IGUpcomingEvent);
    return possibleConstructorReturn(this, (IGUpcomingEvent.__proto__ || Object.getPrototypeOf(IGUpcomingEvent)).apply(this, arguments));
  }

  createClass(IGUpcomingEvent, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(IGUpcomingEvent.prototype.__proto__ || Object.getPrototypeOf(IGUpcomingEvent.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        end_time: 'end_time',
        id: 'id',
        notification_subtypes: 'notification_subtypes',
        notification_target_time: 'notification_target_time',
        start_time: 'start_time',
        title: 'title'
      });
    }
  }, {
    key: 'NotificationSubtypes',
    get: function get() {
      return Object.freeze({
        after_event_1day: 'AFTER_EVENT_1DAY',
        after_event_2day: 'AFTER_EVENT_2DAY',
        after_event_3day: 'AFTER_EVENT_3DAY',
        after_event_4day: 'AFTER_EVENT_4DAY',
        after_event_5day: 'AFTER_EVENT_5DAY',
        after_event_6day: 'AFTER_EVENT_6DAY',
        after_event_7day: 'AFTER_EVENT_7DAY',
        before_event_15min: 'BEFORE_EVENT_15MIN',
        before_event_1day: 'BEFORE_EVENT_1DAY',
        before_event_1hour: 'BEFORE_EVENT_1HOUR',
        before_event_2day: 'BEFORE_EVENT_2DAY',
        event_start: 'EVENT_START',
        rescheduled: 'RESCHEDULED'
      });
    }
  }, {
    key: 'NotificationTargetTime',
    get: function get() {
      return Object.freeze({
        event_end: 'EVENT_END',
        event_start: 'EVENT_START'
      });
    }
  }]);
  return IGUpcomingEvent;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * InstagramUser
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var InstagramUser = function (_AbstractCrudObject) {
  inherits(InstagramUser, _AbstractCrudObject);

  function InstagramUser() {
    classCallCheck(this, InstagramUser);
    return possibleConstructorReturn(this, (InstagramUser.__proto__ || Object.getPrototypeOf(InstagramUser)).apply(this, arguments));
  }

  createClass(InstagramUser, [{
    key: 'getAgencies',
    value: function getAgencies(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Business, fields, params, fetchFirstPage, '/agencies');
    }
  }, {
    key: 'getArEffects',
    value: function getArEffects(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AREffect, fields, params, fetchFirstPage, '/ar_effects');
    }
  }, {
    key: 'getAuthorizedAdAccounts',
    value: function getAuthorizedAdAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdAccount, fields, params, fetchFirstPage, '/authorized_adaccounts');
    }
  }, {
    key: 'getUpcomingEvents',
    value: function getUpcomingEvents(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGUpcomingEvent, fields, params, fetchFirstPage, '/upcoming_events');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        follow_count: 'follow_count',
        followed_by_count: 'followed_by_count',
        has_profile_picture: 'has_profile_picture',
        id: 'id',
        ig_user_id: 'ig_user_id',
        is_private: 'is_private',
        is_published: 'is_published',
        media_count: 'media_count',
        mini_shop_storefront: 'mini_shop_storefront',
        owner_business: 'owner_business',
        profile_pic: 'profile_pic',
        username: 'username'
      });
    }
  }]);
  return InstagramUser;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * PagePostExperiment
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var PagePostExperiment = function (_AbstractCrudObject) {
  inherits(PagePostExperiment, _AbstractCrudObject);

  function PagePostExperiment() {
    classCallCheck(this, PagePostExperiment);
    return possibleConstructorReturn(this, (PagePostExperiment.__proto__ || Object.getPrototypeOf(PagePostExperiment)).apply(this, arguments));
  }

  createClass(PagePostExperiment, [{
    key: 'getVideoInsights',
    value: function getVideoInsights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/video_insights');
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(PagePostExperiment.prototype.__proto__ || Object.getPrototypeOf(PagePostExperiment.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        auto_resolve_settings: 'auto_resolve_settings',
        control_video_id: 'control_video_id',
        creation_time: 'creation_time',
        creator: 'creator',
        declared_winning_time: 'declared_winning_time',
        declared_winning_video_id: 'declared_winning_video_id',
        description: 'description',
        experiment_video_ids: 'experiment_video_ids',
        id: 'id',
        insight_snapshots: 'insight_snapshots',
        name: 'name',
        optimization_goal: 'optimization_goal',
        publish_status: 'publish_status',
        publish_time: 'publish_time',
        scheduled_experiment_timestamp: 'scheduled_experiment_timestamp',
        updated_time: 'updated_time'
      });
    }
  }, {
    key: 'OptimizationGoal',
    get: function get() {
      return Object.freeze({
        auto_resolve_to_control: 'AUTO_RESOLVE_TO_CONTROL',
        avg_time_watched: 'AVG_TIME_WATCHED',
        comments: 'COMMENTS',
        impressions: 'IMPRESSIONS',
        impressions_unique: 'IMPRESSIONS_UNIQUE',
        link_clicks: 'LINK_CLICKS',
        other: 'OTHER',
        reactions: 'REACTIONS',
        reels_plays: 'REELS_PLAYS',
        shares: 'SHARES',
        video_views_60s: 'VIDEO_VIEWS_60S'
      });
    }
  }]);
  return PagePostExperiment;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AdsEligibility
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AdsEligibility = function (_AbstractCrudObject) {
  inherits(AdsEligibility, _AbstractCrudObject);

  function AdsEligibility() {
    classCallCheck(this, AdsEligibility);
    return possibleConstructorReturn(this, (AdsEligibility.__proto__ || Object.getPrototypeOf(AdsEligibility)).apply(this, arguments));
  }

  createClass(AdsEligibility, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        live_shopping: 'live_shopping'
      });
    }
  }]);
  return AdsEligibility;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProfilePictureSource
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProfilePictureSource = function (_AbstractCrudObject) {
  inherits(ProfilePictureSource, _AbstractCrudObject);

  function ProfilePictureSource() {
    classCallCheck(this, ProfilePictureSource);
    return possibleConstructorReturn(this, (ProfilePictureSource.__proto__ || Object.getPrototypeOf(ProfilePictureSource)).apply(this, arguments));
  }

  createClass(ProfilePictureSource, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        bottom: 'bottom',
        cache_key: 'cache_key',
        height: 'height',
        is_silhouette: 'is_silhouette',
        left: 'left',
        right: 'right',
        top: 'top',
        url: 'url',
        width: 'width'
      });
    }
  }, {
    key: 'Type',
    get: function get() {
      return Object.freeze({
        album: 'album',
        small: 'small',
        thumbnail: 'thumbnail'
      });
    }
  }]);
  return ProfilePictureSource;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Profile
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Profile = function (_AbstractCrudObject) {
  inherits(Profile, _AbstractCrudObject);

  function Profile() {
    classCallCheck(this, Profile);
    return possibleConstructorReturn(this, (Profile.__proto__ || Object.getPrototypeOf(Profile)).apply(this, arguments));
  }

  createClass(Profile, [{
    key: 'getPicture',
    value: function getPicture(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProfilePictureSource, fields, params, fetchFirstPage, '/picture');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        can_post: 'can_post',
        id: 'id',
        link: 'link',
        name: 'name',
        pic: 'pic',
        pic_crop: 'pic_crop',
        pic_large: 'pic_large',
        pic_small: 'pic_small',
        pic_square: 'pic_square',
        profile_type: 'profile_type',
        username: 'username'
      });
    }
  }, {
    key: 'ProfileType',
    get: function get() {
      return Object.freeze({
        application: 'application',
        event: 'event',
        group: 'group',
        page: 'page',
        user: 'user'
      });
    }
  }, {
    key: 'Type',
    get: function get() {
      return Object.freeze({
        angry: 'ANGRY',
        care: 'CARE',
        fire: 'FIRE',
        haha: 'HAHA',
        hundred: 'HUNDRED',
        like: 'LIKE',
        love: 'LOVE',
        none: 'NONE',
        pride: 'PRIDE',
        sad: 'SAD',
        thankful: 'THANKFUL',
        wow: 'WOW'
      });
    }
  }]);
  return Profile;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Comment
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Comment = function (_AbstractCrudObject) {
  inherits(Comment, _AbstractCrudObject);

  function Comment() {
    classCallCheck(this, Comment);
    return possibleConstructorReturn(this, (Comment.__proto__ || Object.getPrototypeOf(Comment)).apply(this, arguments));
  }

  createClass(Comment, [{
    key: 'getComments',
    value: function getComments(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Comment, fields, params, fetchFirstPage, '/comments');
    }
  }, {
    key: 'createComment',
    value: function createComment(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/comments', fields, params, Comment, pathOverride);
    }
  }, {
    key: 'deleteLikes',
    value: function deleteLikes() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Comment.prototype.__proto__ || Object.getPrototypeOf(Comment.prototype), 'deleteEdge', this).call(this, '/likes', params);
    }
  }, {
    key: 'getLikes',
    value: function getLikes(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Profile, fields, params, fetchFirstPage, '/likes');
    }
  }, {
    key: 'createLike',
    value: function createLike(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/likes', fields, params, Comment, pathOverride);
    }
  }, {
    key: 'getReactions',
    value: function getReactions(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Profile, fields, params, fetchFirstPage, '/reactions');
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Comment.prototype.__proto__ || Object.getPrototypeOf(Comment.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Comment.prototype.__proto__ || Object.getPrototypeOf(Comment.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        admin_creator: 'admin_creator',
        application: 'application',
        attachment: 'attachment',
        can_comment: 'can_comment',
        can_hide: 'can_hide',
        can_like: 'can_like',
        can_remove: 'can_remove',
        can_reply_privately: 'can_reply_privately',
        comment_count: 'comment_count',
        created_time: 'created_time',
        from: 'from',
        id: 'id',
        is_hidden: 'is_hidden',
        is_private: 'is_private',
        like_count: 'like_count',
        live_broadcast_timestamp: 'live_broadcast_timestamp',
        message: 'message',
        message_tags: 'message_tags',
        object: 'object',
        parent: 'parent',
        permalink_url: 'permalink_url',
        private_reply_conversation: 'private_reply_conversation',
        user_likes: 'user_likes'
      });
    }
  }, {
    key: 'Order',
    get: function get() {
      return Object.freeze({
        chronological: 'chronological',
        reverse_chronological: 'reverse_chronological'
      });
    }
  }, {
    key: 'CommentPrivacyValue',
    get: function get() {
      return Object.freeze({
        declined_by_admin_assistant: 'DECLINED_BY_ADMIN_ASSISTANT',
        default_privacy: 'DEFAULT_PRIVACY',
        friends_and_post_owner: 'FRIENDS_AND_POST_OWNER',
        friends_only: 'FRIENDS_ONLY',
        graphql_multiple_value_hack_do_not_use: 'GRAPHQL_MULTIPLE_VALUE_HACK_DO_NOT_USE',
        owner_or_commenter: 'OWNER_OR_COMMENTER',
        pending_approval: 'PENDING_APPROVAL',
        removed_by_admin_assistant: 'REMOVED_BY_ADMIN_ASSISTANT',
        side_conversation: 'SIDE_CONVERSATION',
        side_conversation_and_post_owner: 'SIDE_CONVERSATION_AND_POST_OWNER',
        spotlight_tab: 'SPOTLIGHT_TAB'
      });
    }
  }, {
    key: 'Filter',
    get: function get() {
      return Object.freeze({
        stream: 'stream',
        toplevel: 'toplevel'
      });
    }
  }, {
    key: 'LiveFilter',
    get: function get() {
      return Object.freeze({
        filter_low_quality: 'filter_low_quality',
        no_filter: 'no_filter'
      });
    }
  }]);
  return Comment;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * RTBDynamicPost
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var RTBDynamicPost = function (_AbstractCrudObject) {
  inherits(RTBDynamicPost, _AbstractCrudObject);

  function RTBDynamicPost() {
    classCallCheck(this, RTBDynamicPost);
    return possibleConstructorReturn(this, (RTBDynamicPost.__proto__ || Object.getPrototypeOf(RTBDynamicPost)).apply(this, arguments));
  }

  createClass(RTBDynamicPost, [{
    key: 'getComments',
    value: function getComments(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Comment, fields, params, fetchFirstPage, '/comments');
    }
  }, {
    key: 'getLikes',
    value: function getLikes(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Profile, fields, params, fetchFirstPage, '/likes');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        child_attachments: 'child_attachments',
        created: 'created',
        description: 'description',
        id: 'id',
        image_url: 'image_url',
        link: 'link',
        message: 'message',
        owner_id: 'owner_id',
        place_id: 'place_id',
        product_id: 'product_id',
        title: 'title'
      });
    }
  }]);
  return RTBDynamicPost;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * InsightsResult
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var InsightsResult = function (_AbstractCrudObject) {
  inherits(InsightsResult, _AbstractCrudObject);

  function InsightsResult() {
    classCallCheck(this, InsightsResult);
    return possibleConstructorReturn(this, (InsightsResult.__proto__ || Object.getPrototypeOf(InsightsResult)).apply(this, arguments));
  }

  createClass(InsightsResult, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        description: 'description',
        description_from_api_doc: 'description_from_api_doc',
        id: 'id',
        name: 'name',
        period: 'period',
        title: 'title',
        values: 'values'
      });
    }
  }, {
    key: 'Breakdown',
    get: function get() {
      return Object.freeze({
        action_type: 'action_type',
        follow_type: 'follow_type',
        story_navigation_action_type: 'story_navigation_action_type',
        surface_type: 'surface_type'
      });
    }
  }, {
    key: 'Metric',
    get: function get() {
      return Object.freeze({
        clips_replays_count: 'clips_replays_count',
        comments: 'comments',
        content_views: 'content_views',
        follows: 'follows',
        ig_reels_aggregated_all_plays_count: 'ig_reels_aggregated_all_plays_count',
        ig_reels_avg_watch_time: 'ig_reels_avg_watch_time',
        ig_reels_video_view_total_time: 'ig_reels_video_view_total_time',
        impressions: 'impressions',
        likes: 'likes',
        navigation: 'navigation',
        plays: 'plays',
        profile_activity: 'profile_activity',
        profile_visits: 'profile_visits',
        quotes: 'quotes',
        reach: 'reach',
        replies: 'replies',
        reposts: 'reposts',
        saved: 'saved',
        shares: 'shares',
        thread_replies: 'thread_replies',
        thread_shares: 'thread_shares',
        threads_media_clicks: 'threads_media_clicks',
        threads_views: 'threads_views',
        total_interactions: 'total_interactions',
        views: 'views'
      });
    }
  }, {
    key: 'Period',
    get: function get() {
      return Object.freeze({
        day: 'day',
        days_28: 'days_28',
        lifetime: 'lifetime',
        month: 'month',
        total_over_range: 'total_over_range',
        week: 'week'
      });
    }
  }, {
    key: 'DatePreset',
    get: function get() {
      return Object.freeze({
        data_maximum: 'data_maximum',
        last_14d: 'last_14d',
        last_28d: 'last_28d',
        last_30d: 'last_30d',
        last_3d: 'last_3d',
        last_7d: 'last_7d',
        last_90d: 'last_90d',
        last_month: 'last_month',
        last_quarter: 'last_quarter',
        last_week_mon_sun: 'last_week_mon_sun',
        last_week_sun_sat: 'last_week_sun_sat',
        last_year: 'last_year',
        maximum: 'maximum',
        this_month: 'this_month',
        this_quarter: 'this_quarter',
        this_week_mon_today: 'this_week_mon_today',
        this_week_sun_today: 'this_week_sun_today',
        this_year: 'this_year',
        today: 'today',
        yesterday: 'yesterday'
      });
    }
  }, {
    key: 'MetricType',
    get: function get() {
      return Object.freeze({
        default: 'default',
        time_series: 'time_series',
        total_value: 'total_value'
      });
    }
  }, {
    key: 'Timeframe',
    get: function get() {
      return Object.freeze({
        last_14_days: 'last_14_days',
        last_30_days: 'last_30_days',
        last_90_days: 'last_90_days',
        prev_month: 'prev_month',
        this_month: 'this_month',
        this_week: 'this_week'
      });
    }
  }]);
  return InsightsResult;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Post
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Post = function (_AbstractCrudObject) {
  inherits(Post, _AbstractCrudObject);

  function Post() {
    classCallCheck(this, Post);
    return possibleConstructorReturn(this, (Post.__proto__ || Object.getPrototypeOf(Post)).apply(this, arguments));
  }

  createClass(Post, [{
    key: 'getAttachments',
    value: function getAttachments(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/attachments');
    }
  }, {
    key: 'getComments',
    value: function getComments(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Comment, fields, params, fetchFirstPage, '/comments');
    }
  }, {
    key: 'createComment',
    value: function createComment(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/comments', fields, params, Comment, pathOverride);
    }
  }, {
    key: 'getDynamicPosts',
    value: function getDynamicPosts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(RTBDynamicPost, fields, params, fetchFirstPage, '/dynamic_posts');
    }
  }, {
    key: 'getInsights',
    value: function getInsights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(InsightsResult, fields, params, fetchFirstPage, '/insights');
    }
  }, {
    key: 'deleteLikes',
    value: function deleteLikes() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Post.prototype.__proto__ || Object.getPrototypeOf(Post.prototype), 'deleteEdge', this).call(this, '/likes', params);
    }
  }, {
    key: 'createLike',
    value: function createLike(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/likes', fields, params, Post, pathOverride);
    }
  }, {
    key: 'getReactions',
    value: function getReactions(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Profile, fields, params, fetchFirstPage, '/reactions');
    }
  }, {
    key: 'getSharedPosts',
    value: function getSharedPosts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Post, fields, params, fetchFirstPage, '/sharedposts');
    }
  }, {
    key: 'getSponsorTags',
    value: function getSponsorTags(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/sponsor_tags');
    }
  }, {
    key: 'getTo',
    value: function getTo(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Profile, fields, params, fetchFirstPage, '/to');
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Post.prototype.__proto__ || Object.getPrototypeOf(Post.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Post.prototype.__proto__ || Object.getPrototypeOf(Post.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        actions: 'actions',
        admin_creator: 'admin_creator',
        allowed_advertising_objectives: 'allowed_advertising_objectives',
        application: 'application',
        backdated_time: 'backdated_time',
        call_to_action: 'call_to_action',
        can_reply_privately: 'can_reply_privately',
        caption: 'caption',
        child_attachments: 'child_attachments',
        comments_mirroring_domain: 'comments_mirroring_domain',
        coordinates: 'coordinates',
        created_time: 'created_time',
        description: 'description',
        event: 'event',
        expanded_height: 'expanded_height',
        expanded_width: 'expanded_width',
        feed_targeting: 'feed_targeting',
        from: 'from',
        full_picture: 'full_picture',
        height: 'height',
        icon: 'icon',
        id: 'id',
        instagram_eligibility: 'instagram_eligibility',
        is_app_share: 'is_app_share',
        is_eligible_for_promotion: 'is_eligible_for_promotion',
        is_expired: 'is_expired',
        is_hidden: 'is_hidden',
        is_inline_created: 'is_inline_created',
        is_instagram_eligible: 'is_instagram_eligible',
        is_popular: 'is_popular',
        is_published: 'is_published',
        is_spherical: 'is_spherical',
        link: 'link',
        message: 'message',
        message_tags: 'message_tags',
        multi_share_end_card: 'multi_share_end_card',
        multi_share_optimized: 'multi_share_optimized',
        name: 'name',
        object_id: 'object_id',
        parent_id: 'parent_id',
        permalink_url: 'permalink_url',
        picture: 'picture',
        place: 'place',
        privacy: 'privacy',
        promotable_id: 'promotable_id',
        promotion_status: 'promotion_status',
        properties: 'properties',
        scheduled_publish_time: 'scheduled_publish_time',
        shares: 'shares',
        source: 'source',
        status_type: 'status_type',
        story: 'story',
        story_tags: 'story_tags',
        subscribed: 'subscribed',
        target: 'target',
        targeting: 'targeting',
        timeline_visibility: 'timeline_visibility',
        type: 'type',
        updated_time: 'updated_time',
        via: 'via',
        video_buying_eligibility: 'video_buying_eligibility',
        width: 'width'
      });
    }
  }, {
    key: 'BackdatedTimeGranularity',
    get: function get() {
      return Object.freeze({
        day: 'day',
        hour: 'hour',
        min: 'min',
        month: 'month',
        none: 'none',
        year: 'year'
      });
    }
  }, {
    key: 'Formatting',
    get: function get() {
      return Object.freeze({
        markdown: 'MARKDOWN',
        plaintext: 'PLAINTEXT'
      });
    }
  }, {
    key: 'PlaceAttachmentSetting',
    get: function get() {
      return Object.freeze({
        value_1: '1',
        value_2: '2'
      });
    }
  }, {
    key: 'PostSurfacesBlacklist',
    get: function get() {
      return Object.freeze({
        value_1: '1',
        value_2: '2',
        value_3: '3',
        value_4: '4',
        value_5: '5'
      });
    }
  }, {
    key: 'PostingToRedspace',
    get: function get() {
      return Object.freeze({
        disabled: 'disabled',
        enabled: 'enabled'
      });
    }
  }, {
    key: 'TargetSurface',
    get: function get() {
      return Object.freeze({
        story: 'STORY',
        timeline: 'TIMELINE'
      });
    }
  }, {
    key: 'UnpublishedContentType',
    get: function get() {
      return Object.freeze({
        ads_post: 'ADS_POST',
        draft: 'DRAFT',
        inline_created: 'INLINE_CREATED',
        published: 'PUBLISHED',
        reviewable_branded_content: 'REVIEWABLE_BRANDED_CONTENT',
        scheduled: 'SCHEDULED',
        scheduled_recurring: 'SCHEDULED_RECURRING'
      });
    }
  }, {
    key: 'FeedStoryVisibility',
    get: function get() {
      return Object.freeze({
        hidden: 'hidden',
        visible: 'visible'
      });
    }
  }, {
    key: 'TimelineVisibility',
    get: function get() {
      return Object.freeze({
        forced_allow: 'forced_allow',
        hidden: 'hidden',
        normal: 'normal'
      });
    }
  }]);
  return Post;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * PagePost
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var PagePost = function (_AbstractCrudObject) {
  inherits(PagePost, _AbstractCrudObject);

  function PagePost() {
    classCallCheck(this, PagePost);
    return possibleConstructorReturn(this, (PagePost.__proto__ || Object.getPrototypeOf(PagePost)).apply(this, arguments));
  }

  createClass(PagePost, [{
    key: 'getAttachments',
    value: function getAttachments(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/attachments');
    }
  }, {
    key: 'getComments',
    value: function getComments(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Comment, fields, params, fetchFirstPage, '/comments');
    }
  }, {
    key: 'createComment',
    value: function createComment(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/comments', fields, params, Comment, pathOverride);
    }
  }, {
    key: 'getDynamicPosts',
    value: function getDynamicPosts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(RTBDynamicPost, fields, params, fetchFirstPage, '/dynamic_posts');
    }
  }, {
    key: 'getInsights',
    value: function getInsights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(InsightsResult, fields, params, fetchFirstPage, '/insights');
    }
  }, {
    key: 'deleteLikes',
    value: function deleteLikes() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(PagePost.prototype.__proto__ || Object.getPrototypeOf(PagePost.prototype), 'deleteEdge', this).call(this, '/likes', params);
    }
  }, {
    key: 'getLikes',
    value: function getLikes(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Profile, fields, params, fetchFirstPage, '/likes');
    }
  }, {
    key: 'createLike',
    value: function createLike(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/likes', fields, params, PagePost, pathOverride);
    }
  }, {
    key: 'getReactions',
    value: function getReactions(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Profile, fields, params, fetchFirstPage, '/reactions');
    }
  }, {
    key: 'getSharedPosts',
    value: function getSharedPosts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Post, fields, params, fetchFirstPage, '/sharedposts');
    }
  }, {
    key: 'getSponsorTags',
    value: function getSponsorTags(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/sponsor_tags');
    }
  }, {
    key: 'getTo',
    value: function getTo(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Profile, fields, params, fetchFirstPage, '/to');
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(PagePost.prototype.__proto__ || Object.getPrototypeOf(PagePost.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(PagePost.prototype.__proto__ || Object.getPrototypeOf(PagePost.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        actions: 'actions',
        admin_creator: 'admin_creator',
        allowed_advertising_objectives: 'allowed_advertising_objectives',
        application: 'application',
        backdated_time: 'backdated_time',
        call_to_action: 'call_to_action',
        can_reply_privately: 'can_reply_privately',
        child_attachments: 'child_attachments',
        comments_mirroring_domain: 'comments_mirroring_domain',
        coordinates: 'coordinates',
        created_time: 'created_time',
        event: 'event',
        expanded_height: 'expanded_height',
        expanded_width: 'expanded_width',
        feed_targeting: 'feed_targeting',
        from: 'from',
        full_picture: 'full_picture',
        height: 'height',
        icon: 'icon',
        id: 'id',
        instagram_eligibility: 'instagram_eligibility',
        is_app_share: 'is_app_share',
        is_eligible_for_promotion: 'is_eligible_for_promotion',
        is_expired: 'is_expired',
        is_hidden: 'is_hidden',
        is_inline_created: 'is_inline_created',
        is_instagram_eligible: 'is_instagram_eligible',
        is_popular: 'is_popular',
        is_published: 'is_published',
        is_spherical: 'is_spherical',
        message: 'message',
        message_tags: 'message_tags',
        multi_share_end_card: 'multi_share_end_card',
        multi_share_optimized: 'multi_share_optimized',
        parent_id: 'parent_id',
        permalink_url: 'permalink_url',
        picture: 'picture',
        place: 'place',
        privacy: 'privacy',
        promotable_id: 'promotable_id',
        promotion_status: 'promotion_status',
        properties: 'properties',
        scheduled_publish_time: 'scheduled_publish_time',
        shares: 'shares',
        status_type: 'status_type',
        story: 'story',
        story_tags: 'story_tags',
        subscribed: 'subscribed',
        target: 'target',
        targeting: 'targeting',
        timeline_visibility: 'timeline_visibility',
        updated_time: 'updated_time',
        via: 'via',
        video_buying_eligibility: 'video_buying_eligibility',
        width: 'width'
      });
    }
  }, {
    key: 'With',
    get: function get() {
      return Object.freeze({
        location: 'LOCATION'
      });
    }
  }, {
    key: 'BackdatedTimeGranularity',
    get: function get() {
      return Object.freeze({
        day: 'day',
        hour: 'hour',
        min: 'min',
        month: 'month',
        none: 'none',
        year: 'year'
      });
    }
  }, {
    key: 'FeedStoryVisibility',
    get: function get() {
      return Object.freeze({
        hidden: 'hidden',
        visible: 'visible'
      });
    }
  }, {
    key: 'TimelineVisibility',
    get: function get() {
      return Object.freeze({
        forced_allow: 'forced_allow',
        hidden: 'hidden',
        normal: 'normal'
      });
    }
  }]);
  return PagePost;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Photo
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Photo = function (_AbstractCrudObject) {
  inherits(Photo, _AbstractCrudObject);

  function Photo() {
    classCallCheck(this, Photo);
    return possibleConstructorReturn(this, (Photo.__proto__ || Object.getPrototypeOf(Photo)).apply(this, arguments));
  }

  createClass(Photo, [{
    key: 'getComments',
    value: function getComments(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Comment, fields, params, fetchFirstPage, '/comments');
    }
  }, {
    key: 'createComment',
    value: function createComment(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/comments', fields, params, Comment, pathOverride);
    }
  }, {
    key: 'getInsights',
    value: function getInsights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(InsightsResult, fields, params, fetchFirstPage, '/insights');
    }
  }, {
    key: 'getLikes',
    value: function getLikes(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Profile, fields, params, fetchFirstPage, '/likes');
    }
  }, {
    key: 'createLike',
    value: function createLike(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/likes', fields, params, Photo, pathOverride);
    }
  }, {
    key: 'getSponsorTags',
    value: function getSponsorTags(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/sponsor_tags');
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Photo.prototype.__proto__ || Object.getPrototypeOf(Photo.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        album: 'album',
        alt_text: 'alt_text',
        alt_text_custom: 'alt_text_custom',
        backdated_time: 'backdated_time',
        backdated_time_granularity: 'backdated_time_granularity',
        can_backdate: 'can_backdate',
        can_delete: 'can_delete',
        can_tag: 'can_tag',
        created_time: 'created_time',
        event: 'event',
        from: 'from',
        height: 'height',
        icon: 'icon',
        id: 'id',
        images: 'images',
        link: 'link',
        name: 'name',
        name_tags: 'name_tags',
        page_story_id: 'page_story_id',
        picture: 'picture',
        place: 'place',
        position: 'position',
        source: 'source',
        target: 'target',
        updated_time: 'updated_time',
        webp_images: 'webp_images',
        width: 'width'
      });
    }
  }, {
    key: 'BackdatedTimeGranularity',
    get: function get() {
      return Object.freeze({
        day: 'day',
        hour: 'hour',
        min: 'min',
        month: 'month',
        none: 'none',
        year: 'year'
      });
    }
  }, {
    key: 'UnpublishedContentType',
    get: function get() {
      return Object.freeze({
        ads_post: 'ADS_POST',
        draft: 'DRAFT',
        inline_created: 'INLINE_CREATED',
        published: 'PUBLISHED',
        reviewable_branded_content: 'REVIEWABLE_BRANDED_CONTENT',
        scheduled: 'SCHEDULED',
        scheduled_recurring: 'SCHEDULED_RECURRING'
      });
    }
  }, {
    key: 'Type',
    get: function get() {
      return Object.freeze({
        profile: 'profile',
        tagged: 'tagged',
        uploaded: 'uploaded'
      });
    }
  }]);
  return Photo;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Album
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Album = function (_AbstractCrudObject) {
  inherits(Album, _AbstractCrudObject);

  function Album() {
    classCallCheck(this, Album);
    return possibleConstructorReturn(this, (Album.__proto__ || Object.getPrototypeOf(Album)).apply(this, arguments));
  }

  createClass(Album, [{
    key: 'getComments',
    value: function getComments(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Comment, fields, params, fetchFirstPage, '/comments');
    }
  }, {
    key: 'createComment',
    value: function createComment(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/comments', fields, params, Comment, pathOverride);
    }
  }, {
    key: 'getLikes',
    value: function getLikes(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Profile, fields, params, fetchFirstPage, '/likes');
    }
  }, {
    key: 'createLike',
    value: function createLike(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/likes', fields, params, Album, pathOverride);
    }
  }, {
    key: 'getPhotos',
    value: function getPhotos(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Photo, fields, params, fetchFirstPage, '/photos');
    }
  }, {
    key: 'createPhoto',
    value: function createPhoto(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/photos', fields, params, Photo, pathOverride);
    }
  }, {
    key: 'getPicture',
    value: function getPicture(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProfilePictureSource, fields, params, fetchFirstPage, '/picture');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        backdated_time: 'backdated_time',
        backdated_time_granularity: 'backdated_time_granularity',
        can_backdate: 'can_backdate',
        can_upload: 'can_upload',
        count: 'count',
        cover_photo: 'cover_photo',
        created_time: 'created_time',
        description: 'description',
        edit_link: 'edit_link',
        event: 'event',
        from: 'from',
        id: 'id',
        is_user_facing: 'is_user_facing',
        link: 'link',
        location: 'location',
        modified_major: 'modified_major',
        name: 'name',
        photo_count: 'photo_count',
        place: 'place',
        privacy: 'privacy',
        type: 'type',
        updated_time: 'updated_time',
        video_count: 'video_count'
      });
    }
  }]);
  return Album;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ArAdsDataContainer
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ArAdsDataContainer = function (_AbstractCrudObject) {
  inherits(ArAdsDataContainer, _AbstractCrudObject);

  function ArAdsDataContainer() {
    classCallCheck(this, ArAdsDataContainer);
    return possibleConstructorReturn(this, (ArAdsDataContainer.__proto__ || Object.getPrototypeOf(ArAdsDataContainer)).apply(this, arguments));
  }

  createClass(ArAdsDataContainer, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        camera_facing_override: 'camera_facing_override',
        creation_time: 'creation_time',
        effect: 'effect',
        id: 'id',
        is_published: 'is_published',
        last_modified_time: 'last_modified_time',
        name: 'name'
      });
    }
  }]);
  return ArAdsDataContainer;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * BusinessProject
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var BusinessProject = function (_AbstractCrudObject) {
  inherits(BusinessProject, _AbstractCrudObject);

  function BusinessProject() {
    classCallCheck(this, BusinessProject);
    return possibleConstructorReturn(this, (BusinessProject.__proto__ || Object.getPrototypeOf(BusinessProject)).apply(this, arguments));
  }

  createClass(BusinessProject, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        business: 'business',
        created_time: 'created_time',
        creator: 'creator',
        id: 'id',
        name: 'name'
      });
    }
  }]);
  return BusinessProject;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * PageCallToAction
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var PageCallToAction = function (_AbstractCrudObject) {
  inherits(PageCallToAction, _AbstractCrudObject);

  function PageCallToAction() {
    classCallCheck(this, PageCallToAction);
    return possibleConstructorReturn(this, (PageCallToAction.__proto__ || Object.getPrototypeOf(PageCallToAction)).apply(this, arguments));
  }

  createClass(PageCallToAction, [{
    key: 'delete',


    // $FlowFixMe : Support Generic Types
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(PageCallToAction.prototype.__proto__ || Object.getPrototypeOf(PageCallToAction.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(PageCallToAction.prototype.__proto__ || Object.getPrototypeOf(PageCallToAction.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        android_app: 'android_app',
        android_deeplink: 'android_deeplink',
        android_destination_type: 'android_destination_type',
        android_package_name: 'android_package_name',
        android_url: 'android_url',
        created_time: 'created_time',
        email_address: 'email_address',
        from: 'from',
        id: 'id',
        intl_number_with_plus: 'intl_number_with_plus',
        iphone_app: 'iphone_app',
        iphone_deeplink: 'iphone_deeplink',
        iphone_destination_type: 'iphone_destination_type',
        iphone_url: 'iphone_url',
        status: 'status',
        type: 'type',
        updated_time: 'updated_time',
        web_destination_type: 'web_destination_type',
        web_url: 'web_url'
      });
    }
  }, {
    key: 'AndroidDestinationType',
    get: function get() {
      return Object.freeze({
        app_deeplink: 'APP_DEEPLINK',
        become_a_volunteer: 'BECOME_A_VOLUNTEER',
        email: 'EMAIL',
        facebook_app: 'FACEBOOK_APP',
        follow: 'FOLLOW',
        marketplace_inventory_page: 'MARKETPLACE_INVENTORY_PAGE',
        menu_on_facebook: 'MENU_ON_FACEBOOK',
        messenger: 'MESSENGER',
        mini_shop: 'MINI_SHOP',
        mobile_center: 'MOBILE_CENTER',
        none: 'NONE',
        phone_call: 'PHONE_CALL',
        shop_on_facebook: 'SHOP_ON_FACEBOOK',
        website: 'WEBSITE'
      });
    }
  }, {
    key: 'IphoneDestinationType',
    get: function get() {
      return Object.freeze({
        app_deeplink: 'APP_DEEPLINK',
        become_a_volunteer: 'BECOME_A_VOLUNTEER',
        email: 'EMAIL',
        facebook_app: 'FACEBOOK_APP',
        follow: 'FOLLOW',
        marketplace_inventory_page: 'MARKETPLACE_INVENTORY_PAGE',
        menu_on_facebook: 'MENU_ON_FACEBOOK',
        messenger: 'MESSENGER',
        mini_shop: 'MINI_SHOP',
        none: 'NONE',
        phone_call: 'PHONE_CALL',
        shop_on_facebook: 'SHOP_ON_FACEBOOK',
        website: 'WEBSITE'
      });
    }
  }, {
    key: 'Type',
    get: function get() {
      return Object.freeze({
        become_a_volunteer: 'BECOME_A_VOLUNTEER',
        book_appointment: 'BOOK_APPOINTMENT',
        book_now: 'BOOK_NOW',
        buy_tickets: 'BUY_TICKETS',
        call_now: 'CALL_NOW',
        charity_donate: 'CHARITY_DONATE',
        check_in: 'CHECK_IN',
        contact_us: 'CONTACT_US',
        creator_storefront: 'CREATOR_STOREFRONT',
        donate_now: 'DONATE_NOW',
        email: 'EMAIL',
        follow_page: 'FOLLOW_PAGE',
        get_directions: 'GET_DIRECTIONS',
        get_offer: 'GET_OFFER',
        get_offer_view: 'GET_OFFER_VIEW',
        interested: 'INTERESTED',
        learn_more: 'LEARN_MORE',
        listen: 'LISTEN',
        local_dev_platform: 'LOCAL_DEV_PLATFORM',
        message: 'MESSAGE',
        mobile_center: 'MOBILE_CENTER',
        open_app: 'OPEN_APP',
        order_food: 'ORDER_FOOD',
        play_music: 'PLAY_MUSIC',
        play_now: 'PLAY_NOW',
        purchase_gift_cards: 'PURCHASE_GIFT_CARDS',
        request_appointment: 'REQUEST_APPOINTMENT',
        request_quote: 'REQUEST_QUOTE',
        shop_now: 'SHOP_NOW',
        shop_on_facebook: 'SHOP_ON_FACEBOOK',
        sign_up: 'SIGN_UP',
        view_inventory: 'VIEW_INVENTORY',
        view_menu: 'VIEW_MENU',
        view_shop: 'VIEW_SHOP',
        visit_group: 'VISIT_GROUP',
        watch_now: 'WATCH_NOW',
        woodhenge_support: 'WOODHENGE_SUPPORT'
      });
    }
  }, {
    key: 'WebDestinationType',
    get: function get() {
      return Object.freeze({
        become_a_volunteer: 'BECOME_A_VOLUNTEER',
        become_supporter: 'BECOME_SUPPORTER',
        email: 'EMAIL',
        follow: 'FOLLOW',
        messenger: 'MESSENGER',
        mobile_center: 'MOBILE_CENTER',
        none: 'NONE',
        shop_on_facebook: 'SHOP_ON_FACEBOOK',
        website: 'WEBSITE'
      });
    }
  }]);
  return PageCallToAction;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CanvasBodyElement
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CanvasBodyElement = function (_AbstractCrudObject) {
  inherits(CanvasBodyElement, _AbstractCrudObject);

  function CanvasBodyElement() {
    classCallCheck(this, CanvasBodyElement);
    return possibleConstructorReturn(this, (CanvasBodyElement.__proto__ || Object.getPrototypeOf(CanvasBodyElement)).apply(this, arguments));
  }

  createClass(CanvasBodyElement, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        element: 'element'
      });
    }
  }]);
  return CanvasBodyElement;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CanvasPreview
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CanvasPreview = function (_AbstractCrudObject) {
  inherits(CanvasPreview, _AbstractCrudObject);

  function CanvasPreview() {
    classCallCheck(this, CanvasPreview);
    return possibleConstructorReturn(this, (CanvasPreview.__proto__ || Object.getPrototypeOf(CanvasPreview)).apply(this, arguments));
  }

  createClass(CanvasPreview, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        body: 'body'
      });
    }
  }]);
  return CanvasPreview;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * TextWithEntities
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var TextWithEntities = function (_AbstractCrudObject) {
  inherits(TextWithEntities, _AbstractCrudObject);

  function TextWithEntities() {
    classCallCheck(this, TextWithEntities);
    return possibleConstructorReturn(this, (TextWithEntities.__proto__ || Object.getPrototypeOf(TextWithEntities)).apply(this, arguments));
  }

  createClass(TextWithEntities, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        text: 'text'
      });
    }
  }]);
  return TextWithEntities;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Canvas
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Canvas = function (_AbstractCrudObject) {
  inherits(Canvas, _AbstractCrudObject);

  function Canvas() {
    classCallCheck(this, Canvas);
    return possibleConstructorReturn(this, (Canvas.__proto__ || Object.getPrototypeOf(Canvas)).apply(this, arguments));
  }

  createClass(Canvas, [{
    key: 'getPreview',
    value: function getPreview(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CanvasPreview, fields, params, fetchFirstPage, '/preview');
    }
  }, {
    key: 'getPreviews',
    value: function getPreviews(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(TextWithEntities, fields, params, fetchFirstPage, '/previews');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Canvas.prototype.__proto__ || Object.getPrototypeOf(Canvas.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        background_color: 'background_color',
        body_elements: 'body_elements',
        business_id: 'business_id',
        canvas_link: 'canvas_link',
        collection_hero_image: 'collection_hero_image',
        collection_hero_video: 'collection_hero_video',
        collection_thumbnails: 'collection_thumbnails',
        dynamic_setting: 'dynamic_setting',
        element_payload: 'element_payload',
        elements: 'elements',
        fb_body_elements: 'fb_body_elements',
        hero_asset_facebook_post_id: 'hero_asset_facebook_post_id',
        hero_asset_instagram_media_id: 'hero_asset_instagram_media_id',
        id: 'id',
        is_hidden: 'is_hidden',
        is_published: 'is_published',
        last_editor: 'last_editor',
        linked_documents: 'linked_documents',
        name: 'name',
        owner: 'owner',
        property_list: 'property_list',
        source_template: 'source_template',
        store_url: 'store_url',
        style_list: 'style_list',
        tags: 'tags',
        ui_property_list: 'ui_property_list',
        unused_body_elements: 'unused_body_elements',
        update_time: 'update_time',
        use_retailer_item_ids: 'use_retailer_item_ids'
      });
    }
  }]);
  return Canvas;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ChatPlugin
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ChatPlugin = function (_AbstractCrudObject) {
  inherits(ChatPlugin, _AbstractCrudObject);

  function ChatPlugin() {
    classCallCheck(this, ChatPlugin);
    return possibleConstructorReturn(this, (ChatPlugin.__proto__ || Object.getPrototypeOf(ChatPlugin)).apply(this, arguments));
  }

  createClass(ChatPlugin, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        alignment: 'alignment',
        desktop_bottom_spacing: 'desktop_bottom_spacing',
        desktop_side_spacing: 'desktop_side_spacing',
        entry_point_icon: 'entry_point_icon',
        entry_point_label: 'entry_point_label',
        greeting_dialog_display: 'greeting_dialog_display',
        guest_chat_mode: 'guest_chat_mode',
        mobile_bottom_spacing: 'mobile_bottom_spacing',
        mobile_chat_display: 'mobile_chat_display',
        mobile_side_spacing: 'mobile_side_spacing',
        theme_color: 'theme_color',
        welcome_screen_greeting: 'welcome_screen_greeting'
      });
    }
  }]);
  return ChatPlugin;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CommerceOrder
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CommerceOrder = function (_AbstractCrudObject) {
  inherits(CommerceOrder, _AbstractCrudObject);

  function CommerceOrder() {
    classCallCheck(this, CommerceOrder);
    return possibleConstructorReturn(this, (CommerceOrder.__proto__ || Object.getPrototypeOf(CommerceOrder)).apply(this, arguments));
  }

  createClass(CommerceOrder, [{
    key: 'createAcknowledgeOrder',
    value: function createAcknowledgeOrder(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/acknowledge_order', fields, params, CommerceOrder, pathOverride);
    }
  }, {
    key: 'getCancellations',
    value: function getCancellations(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/cancellations');
    }
  }, {
    key: 'createCancellation',
    value: function createCancellation(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/cancellations', fields, params, CommerceOrder, pathOverride);
    }
  }, {
    key: 'createItemUpdate',
    value: function createItemUpdate(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/item_updates', fields, params, CommerceOrder, pathOverride);
    }
  }, {
    key: 'getItems',
    value: function getItems(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/items');
    }
  }, {
    key: 'getPayments',
    value: function getPayments(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/payments');
    }
  }, {
    key: 'getPromotionDetails',
    value: function getPromotionDetails(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/promotion_details');
    }
  }, {
    key: 'getPromoTIOns',
    value: function getPromoTIOns(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/promotions');
    }
  }, {
    key: 'getRefunds',
    value: function getRefunds(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/refunds');
    }
  }, {
    key: 'createRefund',
    value: function createRefund(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/refunds', fields, params, CommerceOrder, pathOverride);
    }
  }, {
    key: 'getReturns',
    value: function getReturns(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/returns');
    }
  }, {
    key: 'createReturn',
    value: function createReturn(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/returns', fields, params, CommerceOrder, pathOverride);
    }
  }, {
    key: 'getShipments',
    value: function getShipments(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/shipments');
    }
  }, {
    key: 'createShipment',
    value: function createShipment(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/shipments', fields, params, CommerceOrder, pathOverride);
    }
  }, {
    key: 'createUpdateShipment',
    value: function createUpdateShipment(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/update_shipment', fields, params, CommerceOrder, pathOverride);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        buyer_details: 'buyer_details',
        channel: 'channel',
        contains_bopis_items: 'contains_bopis_items',
        created: 'created',
        estimated_payment_details: 'estimated_payment_details',
        id: 'id',
        is_group_buy: 'is_group_buy',
        is_test_order: 'is_test_order',
        last_updated: 'last_updated',
        merchant_order_id: 'merchant_order_id',
        order_status: 'order_status',
        pre_order_details: 'pre_order_details',
        selected_shipping_option: 'selected_shipping_option',
        ship_by_date: 'ship_by_date',
        shipping_address: 'shipping_address'
      });
    }
  }, {
    key: 'Filters',
    get: function get() {
      return Object.freeze({
        has_cancellations: 'HAS_CANCELLATIONS',
        has_fulfillments: 'HAS_FULFILLMENTS',
        has_refunds: 'HAS_REFUNDS',
        no_cancellations: 'NO_CANCELLATIONS',
        no_refunds: 'NO_REFUNDS',
        no_shipments: 'NO_SHIPMENTS'
      });
    }
  }, {
    key: 'State',
    get: function get() {
      return Object.freeze({
        completed: 'COMPLETED',
        created: 'CREATED',
        fb_processing: 'FB_PROCESSING',
        in_progress: 'IN_PROGRESS'
      });
    }
  }, {
    key: 'ReasonCode',
    get: function get() {
      return Object.freeze({
        buyers_remorse: 'BUYERS_REMORSE',
        damaged_goods: 'DAMAGED_GOODS',
        facebook_initiated: 'FACEBOOK_INITIATED',
        not_as_described: 'NOT_AS_DESCRIBED',
        quality_issue: 'QUALITY_ISSUE',
        refund_compromised: 'REFUND_COMPROMISED',
        refund_for_return: 'REFUND_FOR_RETURN',
        refund_reason_other: 'REFUND_REASON_OTHER',
        refund_sfi_fake: 'REFUND_SFI_FAKE',
        refund_sfi_real: 'REFUND_SFI_REAL',
        wrong_item: 'WRONG_ITEM'
      });
    }
  }]);
  return CommerceOrder;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CommercePayout
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CommercePayout = function (_AbstractCrudObject) {
  inherits(CommercePayout, _AbstractCrudObject);

  function CommercePayout() {
    classCallCheck(this, CommercePayout);
    return possibleConstructorReturn(this, (CommercePayout.__proto__ || Object.getPrototypeOf(CommercePayout)).apply(this, arguments));
  }

  createClass(CommercePayout, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        amount: 'amount',
        payout_date: 'payout_date',
        payout_reference_id: 'payout_reference_id',
        status: 'status',
        transfer_id: 'transfer_id'
      });
    }
  }]);
  return CommercePayout;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CommerceOrderTransactionDetail
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CommerceOrderTransactionDetail = function (_AbstractCrudObject) {
  inherits(CommerceOrderTransactionDetail, _AbstractCrudObject);

  function CommerceOrderTransactionDetail() {
    classCallCheck(this, CommerceOrderTransactionDetail);
    return possibleConstructorReturn(this, (CommerceOrderTransactionDetail.__proto__ || Object.getPrototypeOf(CommerceOrderTransactionDetail)).apply(this, arguments));
  }

  createClass(CommerceOrderTransactionDetail, [{
    key: 'getItems',
    value: function getItems(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/items');
    }
  }, {
    key: 'getTaxDetails',
    value: function getTaxDetails(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/tax_details');
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        merchant_order_id: 'merchant_order_id',
        net_payment_amount: 'net_payment_amount',
        order_created: 'order_created',
        order_details: 'order_details',
        order_id: 'order_id',
        payout_reference_id: 'payout_reference_id',
        postal_code: 'postal_code',
        processing_fee: 'processing_fee',
        state: 'state',
        tax_rate: 'tax_rate',
        transaction_date: 'transaction_date',
        transaction_type: 'transaction_type',
        transfer_id: 'transfer_id',
        id: 'id'
      });
    }
  }]);
  return CommerceOrderTransactionDetail;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CatalogItemChannelsToIntegrityStatus
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CatalogItemChannelsToIntegrityStatus = function (_AbstractCrudObject) {
  inherits(CatalogItemChannelsToIntegrityStatus, _AbstractCrudObject);

  function CatalogItemChannelsToIntegrityStatus() {
    classCallCheck(this, CatalogItemChannelsToIntegrityStatus);
    return possibleConstructorReturn(this, (CatalogItemChannelsToIntegrityStatus.__proto__ || Object.getPrototypeOf(CatalogItemChannelsToIntegrityStatus)).apply(this, arguments));
  }

  createClass(CatalogItemChannelsToIntegrityStatus, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        channels: 'channels',
        rejection_information: 'rejection_information'
      });
    }
  }]);
  return CatalogItemChannelsToIntegrityStatus;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * OverrideDetails
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var OverrideDetails = function (_AbstractCrudObject) {
  inherits(OverrideDetails, _AbstractCrudObject);

  function OverrideDetails() {
    classCallCheck(this, OverrideDetails);
    return possibleConstructorReturn(this, (OverrideDetails.__proto__ || Object.getPrototypeOf(OverrideDetails)).apply(this, arguments));
  }

  createClass(OverrideDetails, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        key: 'key',
        type: 'type',
        values: 'values'
      });
    }
  }, {
    key: 'Type',
    get: function get() {
      return Object.freeze({
        country: 'COUNTRY',
        language: 'LANGUAGE',
        language_and_country: 'LANGUAGE_AND_COUNTRY'
      });
    }
  }]);
  return OverrideDetails;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * DynamicVideoMetadata
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var DynamicVideoMetadata = function (_AbstractCrudObject) {
  inherits(DynamicVideoMetadata, _AbstractCrudObject);

  function DynamicVideoMetadata() {
    classCallCheck(this, DynamicVideoMetadata);
    return possibleConstructorReturn(this, (DynamicVideoMetadata.__proto__ || Object.getPrototypeOf(DynamicVideoMetadata)).apply(this, arguments));
  }

  createClass(DynamicVideoMetadata, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        tags: 'tags',
        url: 'url',
        video: 'video'
      });
    }
  }]);
  return DynamicVideoMetadata;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AutomotiveModel
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AutomotiveModel = function (_AbstractCrudObject) {
  inherits(AutomotiveModel, _AbstractCrudObject);

  function AutomotiveModel() {
    classCallCheck(this, AutomotiveModel);
    return possibleConstructorReturn(this, (AutomotiveModel.__proto__ || Object.getPrototypeOf(AutomotiveModel)).apply(this, arguments));
  }

  createClass(AutomotiveModel, [{
    key: 'getChannelsToIntegrityStatus',
    value: function getChannelsToIntegrityStatus(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CatalogItemChannelsToIntegrityStatus, fields, params, fetchFirstPage, '/channels_to_integrity_status');
    }
  }, {
    key: 'getOverrideDetails',
    value: function getOverrideDetails(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(OverrideDetails, fields, params, fetchFirstPage, '/override_details');
    }
  }, {
    key: 'getVideosMetadata',
    value: function getVideosMetadata(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(DynamicVideoMetadata, fields, params, fetchFirstPage, '/videos_metadata');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        applinks: 'applinks',
        automotive_model_id: 'automotive_model_id',
        availability: 'availability',
        body_style: 'body_style',
        category_specific_fields: 'category_specific_fields',
        currency: 'currency',
        custom_label_0: 'custom_label_0',
        custom_label_1: 'custom_label_1',
        custom_label_2: 'custom_label_2',
        custom_label_3: 'custom_label_3',
        custom_label_4: 'custom_label_4',
        custom_number_0: 'custom_number_0',
        custom_number_1: 'custom_number_1',
        custom_number_2: 'custom_number_2',
        custom_number_3: 'custom_number_3',
        custom_number_4: 'custom_number_4',
        description: 'description',
        drivetrain: 'drivetrain',
        exterior_color: 'exterior_color',
        finance_description: 'finance_description',
        finance_type: 'finance_type',
        fuel_type: 'fuel_type',
        generation: 'generation',
        id: 'id',
        image_fetch_status: 'image_fetch_status',
        images: 'images',
        interior_color: 'interior_color',
        interior_upholstery: 'interior_upholstery',
        make: 'make',
        model: 'model',
        price: 'price',
        sanitized_images: 'sanitized_images',
        title: 'title',
        transmission: 'transmission',
        trim: 'trim',
        unit_price: 'unit_price',
        url: 'url',
        visibility: 'visibility',
        year: 'year'
      });
    }
  }, {
    key: 'ImageFetchStatus',
    get: function get() {
      return Object.freeze({
        direct_upload: 'DIRECT_UPLOAD',
        fetched: 'FETCHED',
        fetch_failed: 'FETCH_FAILED',
        no_status: 'NO_STATUS',
        outdated: 'OUTDATED',
        partial_fetch: 'PARTIAL_FETCH'
      });
    }
  }, {
    key: 'Visibility',
    get: function get() {
      return Object.freeze({
        published: 'PUBLISHED',
        staging: 'STAGING'
      });
    }
  }]);
  return AutomotiveModel;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * StoreCatalogSettings
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var StoreCatalogSettings = function (_AbstractCrudObject) {
  inherits(StoreCatalogSettings, _AbstractCrudObject);

  function StoreCatalogSettings() {
    classCallCheck(this, StoreCatalogSettings);
    return possibleConstructorReturn(this, (StoreCatalogSettings.__proto__ || Object.getPrototypeOf(StoreCatalogSettings)).apply(this, arguments));
  }

  createClass(StoreCatalogSettings, [{
    key: 'delete',


    // $FlowFixMe : Support Generic Types
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(StoreCatalogSettings.prototype.__proto__ || Object.getPrototypeOf(StoreCatalogSettings.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        page: 'page'
      });
    }
  }]);
  return StoreCatalogSettings;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductCatalogCategory
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductCatalogCategory = function (_AbstractCrudObject) {
  inherits(ProductCatalogCategory, _AbstractCrudObject);

  function ProductCatalogCategory() {
    classCallCheck(this, ProductCatalogCategory);
    return possibleConstructorReturn(this, (ProductCatalogCategory.__proto__ || Object.getPrototypeOf(ProductCatalogCategory)).apply(this, arguments));
  }

  createClass(ProductCatalogCategory, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        criteria_value: 'criteria_value',
        description: 'description',
        destination_uri: 'destination_uri',
        image_url: 'image_url',
        name: 'name',
        num_items: 'num_items',
        tokens: 'tokens'
      });
    }
  }, {
    key: 'CategorizationCriteria',
    get: function get() {
      return Object.freeze({
        brand: 'BRAND',
        category: 'CATEGORY',
        product_type: 'PRODUCT_TYPE'
      });
    }
  }]);
  return ProductCatalogCategory;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CheckBatchRequestStatus
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CheckBatchRequestStatus = function (_AbstractCrudObject) {
  inherits(CheckBatchRequestStatus, _AbstractCrudObject);

  function CheckBatchRequestStatus() {
    classCallCheck(this, CheckBatchRequestStatus);
    return possibleConstructorReturn(this, (CheckBatchRequestStatus.__proto__ || Object.getPrototypeOf(CheckBatchRequestStatus)).apply(this, arguments));
  }

  createClass(CheckBatchRequestStatus, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        errors: 'errors',
        errors_total_count: 'errors_total_count',
        handle: 'handle',
        ids_of_invalid_requests: 'ids_of_invalid_requests',
        status: 'status',
        warnings: 'warnings',
        warnings_total_count: 'warnings_total_count'
      });
    }
  }, {
    key: 'ErrorPriority',
    get: function get() {
      return Object.freeze({
        high: 'HIGH',
        low: 'LOW',
        medium: 'MEDIUM'
      });
    }
  }]);
  return CheckBatchRequestStatus;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductCatalogCheckMarketplacePartnerDealsStatus
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductCatalogCheckMarketplacePartnerDealsStatus = function (_AbstractCrudObject) {
  inherits(ProductCatalogCheckMarketplacePartnerDealsStatus, _AbstractCrudObject);

  function ProductCatalogCheckMarketplacePartnerDealsStatus() {
    classCallCheck(this, ProductCatalogCheckMarketplacePartnerDealsStatus);
    return possibleConstructorReturn(this, (ProductCatalogCheckMarketplacePartnerDealsStatus.__proto__ || Object.getPrototypeOf(ProductCatalogCheckMarketplacePartnerDealsStatus)).apply(this, arguments));
  }

  createClass(ProductCatalogCheckMarketplacePartnerDealsStatus, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        errors: 'errors',
        session_id: 'session_id',
        status: 'status'
      });
    }
  }]);
  return ProductCatalogCheckMarketplacePartnerDealsStatus;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductCatalogCheckMarketplacePartnerSellersStatus
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductCatalogCheckMarketplacePartnerSellersStatus = function (_AbstractCrudObject) {
  inherits(ProductCatalogCheckMarketplacePartnerSellersStatus, _AbstractCrudObject);

  function ProductCatalogCheckMarketplacePartnerSellersStatus() {
    classCallCheck(this, ProductCatalogCheckMarketplacePartnerSellersStatus);
    return possibleConstructorReturn(this, (ProductCatalogCheckMarketplacePartnerSellersStatus.__proto__ || Object.getPrototypeOf(ProductCatalogCheckMarketplacePartnerSellersStatus)).apply(this, arguments));
  }

  createClass(ProductCatalogCheckMarketplacePartnerSellersStatus, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        sample_errors: 'sample_errors',
        session_id: 'session_id',
        status: 'status'
      });
    }
  }]);
  return ProductCatalogCheckMarketplacePartnerSellersStatus;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductImage
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductImage = function (_AbstractCrudObject) {
  inherits(ProductImage, _AbstractCrudObject);

  function ProductImage() {
    classCallCheck(this, ProductImage);
    return possibleConstructorReturn(this, (ProductImage.__proto__ || Object.getPrototypeOf(ProductImage)).apply(this, arguments));
  }

  createClass(ProductImage, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        height: 'height',
        id: 'id',
        image_url: 'image_url',
        width: 'width'
      });
    }
  }]);
  return ProductImage;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CPASLsbImageBank
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CPASLsbImageBank = function (_AbstractCrudObject) {
  inherits(CPASLsbImageBank, _AbstractCrudObject);

  function CPASLsbImageBank() {
    classCallCheck(this, CPASLsbImageBank);
    return possibleConstructorReturn(this, (CPASLsbImageBank.__proto__ || Object.getPrototypeOf(CPASLsbImageBank)).apply(this, arguments));
  }

  createClass(CPASLsbImageBank, [{
    key: 'getBackupImages',
    value: function getBackupImages(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductImage, fields, params, fetchFirstPage, '/backup_images');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(CPASLsbImageBank.prototype.__proto__ || Object.getPrototypeOf(CPASLsbImageBank.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        ad_group_id: 'ad_group_id',
        catalog_segment_proxy_id: 'catalog_segment_proxy_id',
        id: 'id'
      });
    }
  }]);
  return CPASLsbImageBank;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CollaborativeAdsShareSettings
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CollaborativeAdsShareSettings = function (_AbstractCrudObject) {
  inherits(CollaborativeAdsShareSettings, _AbstractCrudObject);

  function CollaborativeAdsShareSettings() {
    classCallCheck(this, CollaborativeAdsShareSettings);
    return possibleConstructorReturn(this, (CollaborativeAdsShareSettings.__proto__ || Object.getPrototypeOf(CollaborativeAdsShareSettings)).apply(this, arguments));
  }

  createClass(CollaborativeAdsShareSettings, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        agency_business: 'agency_business',
        id: 'id',
        product_catalog_proxy_id: 'product_catalog_proxy_id',
        utm_campaign: 'utm_campaign',
        utm_medium: 'utm_medium',
        utm_source: 'utm_source'
      });
    }
  }]);
  return CollaborativeAdsShareSettings;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CreatorAssetCreative
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CreatorAssetCreative = function (_AbstractCrudObject) {
  inherits(CreatorAssetCreative, _AbstractCrudObject);

  function CreatorAssetCreative() {
    classCallCheck(this, CreatorAssetCreative);
    return possibleConstructorReturn(this, (CreatorAssetCreative.__proto__ || Object.getPrototypeOf(CreatorAssetCreative)).apply(this, arguments));
  }

  createClass(CreatorAssetCreative, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        image_url: 'image_url',
        moderation_status: 'moderation_status',
        product_item_retailer_id: 'product_item_retailer_id',
        product_url: 'product_url',
        retailer_id: 'retailer_id',
        video_url: 'video_url'
      });
    }
  }, {
    key: 'ModerationStatus',
    get: function get() {
      return Object.freeze({
        archived: 'ARCHIVED',
        eligible: 'ELIGIBLE',
        expired: 'EXPIRED',
        ineligible: 'INELIGIBLE',
        in_review: 'IN_REVIEW',
        paused: 'PAUSED',
        unknown: 'UNKNOWN'
      });
    }
  }]);
  return CreatorAssetCreative;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductCatalogDataSource
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductCatalogDataSource = function (_AbstractCrudObject) {
  inherits(ProductCatalogDataSource, _AbstractCrudObject);

  function ProductCatalogDataSource() {
    classCallCheck(this, ProductCatalogDataSource);
    return possibleConstructorReturn(this, (ProductCatalogDataSource.__proto__ || Object.getPrototypeOf(ProductCatalogDataSource)).apply(this, arguments));
  }

  createClass(ProductCatalogDataSource, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        app_id: 'app_id',
        id: 'id',
        ingestion_source_type: 'ingestion_source_type',
        name: 'name',
        upload_type: 'upload_type'
      });
    }
  }, {
    key: 'IngestionSourceType',
    get: function get() {
      return Object.freeze({
        all: 'ALL',
        primary: 'PRIMARY',
        supplementary: 'SUPPLEMENTARY'
      });
    }
  }]);
  return ProductCatalogDataSource;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Destination
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Destination = function (_AbstractCrudObject) {
  inherits(Destination, _AbstractCrudObject);

  function Destination() {
    classCallCheck(this, Destination);
    return possibleConstructorReturn(this, (Destination.__proto__ || Object.getPrototypeOf(Destination)).apply(this, arguments));
  }

  createClass(Destination, [{
    key: 'getChannelsToIntegrityStatus',
    value: function getChannelsToIntegrityStatus(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CatalogItemChannelsToIntegrityStatus, fields, params, fetchFirstPage, '/channels_to_integrity_status');
    }
  }, {
    key: 'getOverrideDetails',
    value: function getOverrideDetails(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(OverrideDetails, fields, params, fetchFirstPage, '/override_details');
    }
  }, {
    key: 'getVideosMetadata',
    value: function getVideosMetadata(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(DynamicVideoMetadata, fields, params, fetchFirstPage, '/videos_metadata');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        address: 'address',
        applinks: 'applinks',
        category_specific_fields: 'category_specific_fields',
        currency: 'currency',
        custom_label_0: 'custom_label_0',
        custom_label_1: 'custom_label_1',
        custom_label_2: 'custom_label_2',
        custom_label_3: 'custom_label_3',
        custom_label_4: 'custom_label_4',
        custom_number_0: 'custom_number_0',
        custom_number_1: 'custom_number_1',
        custom_number_2: 'custom_number_2',
        custom_number_3: 'custom_number_3',
        custom_number_4: 'custom_number_4',
        description: 'description',
        destination_id: 'destination_id',
        id: 'id',
        image_fetch_status: 'image_fetch_status',
        images: 'images',
        name: 'name',
        price: 'price',
        price_change: 'price_change',
        sanitized_images: 'sanitized_images',
        tags: 'tags',
        types: 'types',
        unit_price: 'unit_price',
        url: 'url',
        visibility: 'visibility'
      });
    }
  }, {
    key: 'ImageFetchStatus',
    get: function get() {
      return Object.freeze({
        direct_upload: 'DIRECT_UPLOAD',
        fetched: 'FETCHED',
        fetch_failed: 'FETCH_FAILED',
        no_status: 'NO_STATUS',
        outdated: 'OUTDATED',
        partial_fetch: 'PARTIAL_FETCH'
      });
    }
  }, {
    key: 'Visibility',
    get: function get() {
      return Object.freeze({
        published: 'PUBLISHED',
        staging: 'STAGING'
      });
    }
  }]);
  return Destination;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductCatalogDiagnosticGroup
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductCatalogDiagnosticGroup = function (_AbstractCrudObject) {
  inherits(ProductCatalogDiagnosticGroup, _AbstractCrudObject);

  function ProductCatalogDiagnosticGroup() {
    classCallCheck(this, ProductCatalogDiagnosticGroup);
    return possibleConstructorReturn(this, (ProductCatalogDiagnosticGroup.__proto__ || Object.getPrototypeOf(ProductCatalogDiagnosticGroup)).apply(this, arguments));
  }

  createClass(ProductCatalogDiagnosticGroup, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        affected_channels: 'affected_channels',
        affected_entity: 'affected_entity',
        affected_features: 'affected_features',
        diagnostics: 'diagnostics',
        error_code: 'error_code',
        number_of_affected_entities: 'number_of_affected_entities',
        number_of_affected_items: 'number_of_affected_items',
        severity: 'severity',
        subtitle: 'subtitle',
        title: 'title',
        type: 'type'
      });
    }
  }, {
    key: 'AffectedEntity',
    get: function get() {
      return Object.freeze({
        product_catalog: 'product_catalog',
        product_event: 'product_event',
        product_item: 'product_item',
        product_set: 'product_set'
      });
    }
  }, {
    key: 'AffectedFeatures',
    get: function get() {
      return Object.freeze({
        augmented_reality: 'augmented_reality',
        checkout: 'checkout'
      });
    }
  }, {
    key: 'Severity',
    get: function get() {
      return Object.freeze({
        must_fix: 'MUST_FIX',
        opportunity: 'OPPORTUNITY'
      });
    }
  }, {
    key: 'Type',
    get: function get() {
      return Object.freeze({
        ar_visibility_issues: 'AR_VISIBILITY_ISSUES',
        attributes_invalid: 'ATTRIBUTES_INVALID',
        attributes_missing: 'ATTRIBUTES_MISSING',
        category: 'CATEGORY',
        checkout: 'CHECKOUT',
        da_visibility_issues: 'DA_VISIBILITY_ISSUES',
        event_source_issues: 'EVENT_SOURCE_ISSUES',
        image_quality: 'IMAGE_QUALITY',
        low_quality_title_and_description: 'LOW_QUALITY_TITLE_AND_DESCRIPTION',
        policy_violation: 'POLICY_VIOLATION',
        shops_visibility_issues: 'SHOPS_VISIBILITY_ISSUES'
      });
    }
  }, {
    key: 'AffectedChannels',
    get: function get() {
      return Object.freeze({
        b2c_marketplace: 'b2c_marketplace',
        c2c_marketplace: 'c2c_marketplace',
        da: 'da',
        daily_deals: 'daily_deals',
        daily_deals_legacy: 'daily_deals_legacy',
        ig_product_tagging: 'ig_product_tagging',
        marketplace: 'marketplace',
        marketplace_ads_deprecated: 'marketplace_ads_deprecated',
        marketplace_shops: 'marketplace_shops',
        mini_shops: 'mini_shops',
        offline_conversions: 'offline_conversions',
        shops: 'shops',
        universal_checkout: 'universal_checkout',
        whatsapp: 'whatsapp'
      });
    }
  }, {
    key: 'AffectedEntities',
    get: function get() {
      return Object.freeze({
        product_catalog: 'product_catalog',
        product_event: 'product_event',
        product_item: 'product_item',
        product_set: 'product_set'
      });
    }
  }, {
    key: 'Severities',
    get: function get() {
      return Object.freeze({
        must_fix: 'MUST_FIX',
        opportunity: 'OPPORTUNITY'
      });
    }
  }, {
    key: 'Types',
    get: function get() {
      return Object.freeze({
        ar_visibility_issues: 'AR_VISIBILITY_ISSUES',
        attributes_invalid: 'ATTRIBUTES_INVALID',
        attributes_missing: 'ATTRIBUTES_MISSING',
        category: 'CATEGORY',
        checkout: 'CHECKOUT',
        da_visibility_issues: 'DA_VISIBILITY_ISSUES',
        event_source_issues: 'EVENT_SOURCE_ISSUES',
        image_quality: 'IMAGE_QUALITY',
        low_quality_title_and_description: 'LOW_QUALITY_TITLE_AND_DESCRIPTION',
        policy_violation: 'POLICY_VIOLATION',
        shops_visibility_issues: 'SHOPS_VISIBILITY_ISSUES'
      });
    }
  }]);
  return ProductCatalogDiagnosticGroup;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductEventStat
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductEventStat = function (_AbstractCrudObject) {
  inherits(ProductEventStat, _AbstractCrudObject);

  function ProductEventStat() {
    classCallCheck(this, ProductEventStat);
    return possibleConstructorReturn(this, (ProductEventStat.__proto__ || Object.getPrototypeOf(ProductEventStat)).apply(this, arguments));
  }

  createClass(ProductEventStat, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        date_start: 'date_start',
        date_stop: 'date_stop',
        device_type: 'device_type',
        event: 'event',
        event_source: 'event_source',
        total_content_ids_matched_other_catalogs: 'total_content_ids_matched_other_catalogs',
        total_matched_content_ids: 'total_matched_content_ids',
        total_unmatched_content_ids: 'total_unmatched_content_ids',
        unique_content_ids_matched_other_catalogs: 'unique_content_ids_matched_other_catalogs',
        unique_matched_content_ids: 'unique_matched_content_ids',
        unique_unmatched_content_ids: 'unique_unmatched_content_ids'
      });
    }
  }, {
    key: 'DeviceType',
    get: function get() {
      return Object.freeze({
        desktop: 'desktop',
        mobile_android_phone: 'mobile_android_phone',
        mobile_android_tablet: 'mobile_android_tablet',
        mobile_ipad: 'mobile_ipad',
        mobile_iphone: 'mobile_iphone',
        mobile_ipod: 'mobile_ipod',
        mobile_phone: 'mobile_phone',
        mobile_tablet: 'mobile_tablet',
        mobile_windows_phone: 'mobile_windows_phone',
        unknown: 'unknown'
      });
    }
  }, {
    key: 'Event',
    get: function get() {
      return Object.freeze({
        addtocart: 'AddToCart',
        addtowishlist: 'AddToWishlist',
        initiatecheckout: 'InitiateCheckout',
        lead: 'Lead',
        purchase: 'Purchase',
        search: 'Search',
        subscribe: 'Subscribe',
        viewcontent: 'ViewContent'
      });
    }
  }, {
    key: 'Breakdowns',
    get: function get() {
      return Object.freeze({
        device_type: 'DEVICE_TYPE'
      });
    }
  }]);
  return ProductEventStat;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ExternalEventSource
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ExternalEventSource = function (_AbstractCrudObject) {
  inherits(ExternalEventSource, _AbstractCrudObject);

  function ExternalEventSource() {
    classCallCheck(this, ExternalEventSource);
    return possibleConstructorReturn(this, (ExternalEventSource.__proto__ || Object.getPrototypeOf(ExternalEventSource)).apply(this, arguments));
  }

  createClass(ExternalEventSource, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        name: 'name',
        source_type: 'source_type'
      });
    }
  }]);
  return ExternalEventSource;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Flight
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Flight = function (_AbstractCrudObject) {
  inherits(Flight, _AbstractCrudObject);

  function Flight() {
    classCallCheck(this, Flight);
    return possibleConstructorReturn(this, (Flight.__proto__ || Object.getPrototypeOf(Flight)).apply(this, arguments));
  }

  createClass(Flight, [{
    key: 'getChannelsToIntegrityStatus',
    value: function getChannelsToIntegrityStatus(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CatalogItemChannelsToIntegrityStatus, fields, params, fetchFirstPage, '/channels_to_integrity_status');
    }
  }, {
    key: 'getOverrideDetails',
    value: function getOverrideDetails(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(OverrideDetails, fields, params, fetchFirstPage, '/override_details');
    }
  }, {
    key: 'getVideosMetadata',
    value: function getVideosMetadata(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(DynamicVideoMetadata, fields, params, fetchFirstPage, '/videos_metadata');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Flight.prototype.__proto__ || Object.getPrototypeOf(Flight.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        applinks: 'applinks',
        category_specific_fields: 'category_specific_fields',
        currency: 'currency',
        custom_label_0: 'custom_label_0',
        custom_label_1: 'custom_label_1',
        custom_label_2: 'custom_label_2',
        custom_label_3: 'custom_label_3',
        custom_label_4: 'custom_label_4',
        custom_number_0: 'custom_number_0',
        custom_number_1: 'custom_number_1',
        custom_number_2: 'custom_number_2',
        custom_number_3: 'custom_number_3',
        custom_number_4: 'custom_number_4',
        description: 'description',
        destination_airport: 'destination_airport',
        destination_city: 'destination_city',
        flight_id: 'flight_id',
        id: 'id',
        image_fetch_status: 'image_fetch_status',
        images: 'images',
        oneway_currency: 'oneway_currency',
        oneway_price: 'oneway_price',
        origin_airport: 'origin_airport',
        origin_city: 'origin_city',
        price: 'price',
        product_priority_0: 'product_priority_0',
        product_priority_1: 'product_priority_1',
        product_priority_2: 'product_priority_2',
        product_priority_3: 'product_priority_3',
        product_priority_4: 'product_priority_4',
        sanitized_images: 'sanitized_images',
        tags: 'tags',
        unit_price: 'unit_price',
        url: 'url',
        visibility: 'visibility'
      });
    }
  }, {
    key: 'ImageFetchStatus',
    get: function get() {
      return Object.freeze({
        direct_upload: 'DIRECT_UPLOAD',
        fetched: 'FETCHED',
        fetch_failed: 'FETCH_FAILED',
        no_status: 'NO_STATUS',
        outdated: 'OUTDATED',
        partial_fetch: 'PARTIAL_FETCH'
      });
    }
  }, {
    key: 'Visibility',
    get: function get() {
      return Object.freeze({
        published: 'PUBLISHED',
        staging: 'STAGING'
      });
    }
  }]);
  return Flight;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * HomeListing
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var HomeListing = function (_AbstractCrudObject) {
  inherits(HomeListing, _AbstractCrudObject);

  function HomeListing() {
    classCallCheck(this, HomeListing);
    return possibleConstructorReturn(this, (HomeListing.__proto__ || Object.getPrototypeOf(HomeListing)).apply(this, arguments));
  }

  createClass(HomeListing, [{
    key: 'getChannelsToIntegrityStatus',
    value: function getChannelsToIntegrityStatus(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CatalogItemChannelsToIntegrityStatus, fields, params, fetchFirstPage, '/channels_to_integrity_status');
    }
  }, {
    key: 'getOverrideDetails',
    value: function getOverrideDetails(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(OverrideDetails, fields, params, fetchFirstPage, '/override_details');
    }
  }, {
    key: 'getVideosMetadata',
    value: function getVideosMetadata(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(DynamicVideoMetadata, fields, params, fetchFirstPage, '/videos_metadata');
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(HomeListing.prototype.__proto__ || Object.getPrototypeOf(HomeListing.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(HomeListing.prototype.__proto__ || Object.getPrototypeOf(HomeListing.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        ac_type: 'ac_type',
        additional_fees_description: 'additional_fees_description',
        address: 'address',
        agent_company: 'agent_company',
        agent_email: 'agent_email',
        agent_fb_page_id: 'agent_fb_page_id',
        agent_name: 'agent_name',
        agent_phone: 'agent_phone',
        applinks: 'applinks',
        area_size: 'area_size',
        area_unit: 'area_unit',
        availability: 'availability',
        category_specific_fields: 'category_specific_fields',
        co_2_emission_rating_eu: 'co_2_emission_rating_eu',
        currency: 'currency',
        custom_label_0: 'custom_label_0',
        custom_label_1: 'custom_label_1',
        custom_label_2: 'custom_label_2',
        custom_label_3: 'custom_label_3',
        custom_label_4: 'custom_label_4',
        custom_number_0: 'custom_number_0',
        custom_number_1: 'custom_number_1',
        custom_number_2: 'custom_number_2',
        custom_number_3: 'custom_number_3',
        custom_number_4: 'custom_number_4',
        days_on_market: 'days_on_market',
        description: 'description',
        energy_rating_eu: 'energy_rating_eu',
        furnish_type: 'furnish_type',
        group_id: 'group_id',
        heating_type: 'heating_type',
        home_listing_id: 'home_listing_id',
        id: 'id',
        image_fetch_status: 'image_fetch_status',
        images: 'images',
        laundry_type: 'laundry_type',
        listing_type: 'listing_type',
        max_currency: 'max_currency',
        max_price: 'max_price',
        min_currency: 'min_currency',
        min_price: 'min_price',
        name: 'name',
        num_baths: 'num_baths',
        num_beds: 'num_beds',
        num_rooms: 'num_rooms',
        num_units: 'num_units',
        parking_type: 'parking_type',
        partner_verification: 'partner_verification',
        pet_policy: 'pet_policy',
        price: 'price',
        property_type: 'property_type',
        sanitized_images: 'sanitized_images',
        securitydeposit_currency: 'securitydeposit_currency',
        securitydeposit_price: 'securitydeposit_price',
        tags: 'tags',
        unit_price: 'unit_price',
        url: 'url',
        visibility: 'visibility',
        year_built: 'year_built'
      });
    }
  }, {
    key: 'ImageFetchStatus',
    get: function get() {
      return Object.freeze({
        direct_upload: 'DIRECT_UPLOAD',
        fetched: 'FETCHED',
        fetch_failed: 'FETCH_FAILED',
        no_status: 'NO_STATUS',
        outdated: 'OUTDATED',
        partial_fetch: 'PARTIAL_FETCH'
      });
    }
  }, {
    key: 'Visibility',
    get: function get() {
      return Object.freeze({
        published: 'PUBLISHED',
        staging: 'STAGING'
      });
    }
  }]);
  return HomeListing;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductCatalogHotelRoomsBatch
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductCatalogHotelRoomsBatch = function (_AbstractCrudObject) {
  inherits(ProductCatalogHotelRoomsBatch, _AbstractCrudObject);

  function ProductCatalogHotelRoomsBatch() {
    classCallCheck(this, ProductCatalogHotelRoomsBatch);
    return possibleConstructorReturn(this, (ProductCatalogHotelRoomsBatch.__proto__ || Object.getPrototypeOf(ProductCatalogHotelRoomsBatch)).apply(this, arguments));
  }

  createClass(ProductCatalogHotelRoomsBatch, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        errors: 'errors',
        errors_total_count: 'errors_total_count',
        handle: 'handle',
        status: 'status'
      });
    }
  }]);
  return ProductCatalogHotelRoomsBatch;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * DynamicPriceConfigByDate
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var DynamicPriceConfigByDate = function (_AbstractCrudObject) {
  inherits(DynamicPriceConfigByDate, _AbstractCrudObject);

  function DynamicPriceConfigByDate() {
    classCallCheck(this, DynamicPriceConfigByDate);
    return possibleConstructorReturn(this, (DynamicPriceConfigByDate.__proto__ || Object.getPrototypeOf(DynamicPriceConfigByDate)).apply(this, arguments));
  }

  createClass(DynamicPriceConfigByDate, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        checkin_date: 'checkin_date',
        prices: 'prices',
        prices_pretty: 'prices_pretty',
        id: 'id'
      });
    }
  }]);
  return DynamicPriceConfigByDate;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * HotelRoom
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var HotelRoom = function (_AbstractCrudObject) {
  inherits(HotelRoom, _AbstractCrudObject);

  function HotelRoom() {
    classCallCheck(this, HotelRoom);
    return possibleConstructorReturn(this, (HotelRoom.__proto__ || Object.getPrototypeOf(HotelRoom)).apply(this, arguments));
  }

  createClass(HotelRoom, [{
    key: 'getPricingVariables',
    value: function getPricingVariables(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(DynamicPriceConfigByDate, fields, params, fetchFirstPage, '/pricing_variables');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        applinks: 'applinks',
        base_price: 'base_price',
        currency: 'currency',
        description: 'description',
        id: 'id',
        images: 'images',
        margin_level: 'margin_level',
        name: 'name',
        room_id: 'room_id',
        sale_price: 'sale_price',
        url: 'url'
      });
    }
  }]);
  return HotelRoom;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Hotel
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Hotel = function (_AbstractCrudObject) {
  inherits(Hotel, _AbstractCrudObject);

  function Hotel() {
    classCallCheck(this, Hotel);
    return possibleConstructorReturn(this, (Hotel.__proto__ || Object.getPrototypeOf(Hotel)).apply(this, arguments));
  }

  createClass(Hotel, [{
    key: 'getChannelsToIntegrityStatus',
    value: function getChannelsToIntegrityStatus(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CatalogItemChannelsToIntegrityStatus, fields, params, fetchFirstPage, '/channels_to_integrity_status');
    }
  }, {
    key: 'getHotelRooms',
    value: function getHotelRooms(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(HotelRoom, fields, params, fetchFirstPage, '/hotel_rooms');
    }
  }, {
    key: 'getOverrideDetails',
    value: function getOverrideDetails(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(OverrideDetails, fields, params, fetchFirstPage, '/override_details');
    }
  }, {
    key: 'getVideosMetadata',
    value: function getVideosMetadata(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(DynamicVideoMetadata, fields, params, fetchFirstPage, '/videos_metadata');
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Hotel.prototype.__proto__ || Object.getPrototypeOf(Hotel.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Hotel.prototype.__proto__ || Object.getPrototypeOf(Hotel.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        address: 'address',
        applinks: 'applinks',
        brand: 'brand',
        category: 'category',
        category_specific_fields: 'category_specific_fields',
        currency: 'currency',
        custom_label_0: 'custom_label_0',
        custom_label_1: 'custom_label_1',
        custom_label_2: 'custom_label_2',
        custom_label_3: 'custom_label_3',
        custom_label_4: 'custom_label_4',
        custom_number_0: 'custom_number_0',
        custom_number_1: 'custom_number_1',
        custom_number_2: 'custom_number_2',
        custom_number_3: 'custom_number_3',
        custom_number_4: 'custom_number_4',
        description: 'description',
        guest_ratings: 'guest_ratings',
        hotel_id: 'hotel_id',
        id: 'id',
        image_fetch_status: 'image_fetch_status',
        images: 'images',
        lowest_base_price: 'lowest_base_price',
        loyalty_program: 'loyalty_program',
        margin_level: 'margin_level',
        name: 'name',
        phone: 'phone',
        product_priority_0: 'product_priority_0',
        product_priority_1: 'product_priority_1',
        product_priority_2: 'product_priority_2',
        product_priority_3: 'product_priority_3',
        product_priority_4: 'product_priority_4',
        sale_price: 'sale_price',
        sanitized_images: 'sanitized_images',
        star_rating: 'star_rating',
        tags: 'tags',
        unit_price: 'unit_price',
        url: 'url',
        visibility: 'visibility'
      });
    }
  }, {
    key: 'ImageFetchStatus',
    get: function get() {
      return Object.freeze({
        direct_upload: 'DIRECT_UPLOAD',
        fetched: 'FETCHED',
        fetch_failed: 'FETCH_FAILED',
        no_status: 'NO_STATUS',
        outdated: 'OUTDATED',
        partial_fetch: 'PARTIAL_FETCH'
      });
    }
  }, {
    key: 'Visibility',
    get: function get() {
      return Object.freeze({
        published: 'PUBLISHED',
        staging: 'STAGING'
      });
    }
  }]);
  return Hotel;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductCatalogPricingVariablesBatch
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductCatalogPricingVariablesBatch = function (_AbstractCrudObject) {
  inherits(ProductCatalogPricingVariablesBatch, _AbstractCrudObject);

  function ProductCatalogPricingVariablesBatch() {
    classCallCheck(this, ProductCatalogPricingVariablesBatch);
    return possibleConstructorReturn(this, (ProductCatalogPricingVariablesBatch.__proto__ || Object.getPrototypeOf(ProductCatalogPricingVariablesBatch)).apply(this, arguments));
  }

  createClass(ProductCatalogPricingVariablesBatch, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        errors: 'errors',
        errors_total_count: 'errors_total_count',
        handle: 'handle',
        status: 'status'
      });
    }
  }]);
  return ProductCatalogPricingVariablesBatch;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * MediaTitle
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var MediaTitle = function (_AbstractCrudObject) {
  inherits(MediaTitle, _AbstractCrudObject);

  function MediaTitle() {
    classCallCheck(this, MediaTitle);
    return possibleConstructorReturn(this, (MediaTitle.__proto__ || Object.getPrototypeOf(MediaTitle)).apply(this, arguments));
  }

  createClass(MediaTitle, [{
    key: 'getChannelsToIntegrityStatus',
    value: function getChannelsToIntegrityStatus(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CatalogItemChannelsToIntegrityStatus, fields, params, fetchFirstPage, '/channels_to_integrity_status');
    }
  }, {
    key: 'getOverrideDetails',
    value: function getOverrideDetails(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(OverrideDetails, fields, params, fetchFirstPage, '/override_details');
    }
  }, {
    key: 'getVideosMetadata',
    value: function getVideosMetadata(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(DynamicVideoMetadata, fields, params, fetchFirstPage, '/videos_metadata');
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(MediaTitle.prototype.__proto__ || Object.getPrototypeOf(MediaTitle.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(MediaTitle.prototype.__proto__ || Object.getPrototypeOf(MediaTitle.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        applinks: 'applinks',
        category_specific_fields: 'category_specific_fields',
        content_category: 'content_category',
        currency: 'currency',
        description: 'description',
        fb_page_alias: 'fb_page_alias',
        fb_page_id: 'fb_page_id',
        genres: 'genres',
        id: 'id',
        image_fetch_status: 'image_fetch_status',
        images: 'images',
        kg_fb_id: 'kg_fb_id',
        media_title_id: 'media_title_id',
        price: 'price',
        sanitized_images: 'sanitized_images',
        title: 'title',
        title_display_name: 'title_display_name',
        unit_price: 'unit_price',
        url: 'url',
        visibility: 'visibility',
        wiki_data_item: 'wiki_data_item'
      });
    }
  }, {
    key: 'ImageFetchStatus',
    get: function get() {
      return Object.freeze({
        direct_upload: 'DIRECT_UPLOAD',
        fetched: 'FETCHED',
        fetch_failed: 'FETCH_FAILED',
        no_status: 'NO_STATUS',
        outdated: 'OUTDATED',
        partial_fetch: 'PARTIAL_FETCH'
      });
    }
  }, {
    key: 'Visibility',
    get: function get() {
      return Object.freeze({
        published: 'PUBLISHED',
        staging: 'STAGING'
      });
    }
  }, {
    key: 'ContentCategory',
    get: function get() {
      return Object.freeze({
        movie: 'MOVIE',
        music: 'MUSIC',
        tv_show: 'TV_SHOW'
      });
    }
  }]);
  return MediaTitle;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * VehicleOffer
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var VehicleOffer = function (_AbstractCrudObject) {
  inherits(VehicleOffer, _AbstractCrudObject);

  function VehicleOffer() {
    classCallCheck(this, VehicleOffer);
    return possibleConstructorReturn(this, (VehicleOffer.__proto__ || Object.getPrototypeOf(VehicleOffer)).apply(this, arguments));
  }

  createClass(VehicleOffer, [{
    key: 'getChannelsToIntegrityStatus',
    value: function getChannelsToIntegrityStatus(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CatalogItemChannelsToIntegrityStatus, fields, params, fetchFirstPage, '/channels_to_integrity_status');
    }
  }, {
    key: 'getOverrideDetails',
    value: function getOverrideDetails(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(OverrideDetails, fields, params, fetchFirstPage, '/override_details');
    }
  }, {
    key: 'getVideosMetadata',
    value: function getVideosMetadata(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(DynamicVideoMetadata, fields, params, fetchFirstPage, '/videos_metadata');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        amount_currency: 'amount_currency',
        amount_percentage: 'amount_percentage',
        amount_price: 'amount_price',
        amount_qualifier: 'amount_qualifier',
        applinks: 'applinks',
        availability: 'availability',
        body_style: 'body_style',
        cashback_currency: 'cashback_currency',
        cashback_price: 'cashback_price',
        category_specific_fields: 'category_specific_fields',
        currency: 'currency',
        custom_label_0: 'custom_label_0',
        custom_label_1: 'custom_label_1',
        custom_label_2: 'custom_label_2',
        custom_label_3: 'custom_label_3',
        custom_label_4: 'custom_label_4',
        custom_number_0: 'custom_number_0',
        custom_number_1: 'custom_number_1',
        custom_number_2: 'custom_number_2',
        custom_number_3: 'custom_number_3',
        custom_number_4: 'custom_number_4',
        dma_codes: 'dma_codes',
        downpayment_currency: 'downpayment_currency',
        downpayment_price: 'downpayment_price',
        downpayment_qualifier: 'downpayment_qualifier',
        drivetrain: 'drivetrain',
        end_date: 'end_date',
        end_time: 'end_time',
        exterior_color: 'exterior_color',
        fuel_type: 'fuel_type',
        generation: 'generation',
        id: 'id',
        image_fetch_status: 'image_fetch_status',
        images: 'images',
        interior_color: 'interior_color',
        interior_upholstery: 'interior_upholstery',
        make: 'make',
        model: 'model',
        offer_description: 'offer_description',
        offer_disclaimer: 'offer_disclaimer',
        offer_type: 'offer_type',
        price: 'price',
        product_priority_0: 'product_priority_0',
        product_priority_1: 'product_priority_1',
        product_priority_2: 'product_priority_2',
        product_priority_3: 'product_priority_3',
        product_priority_4: 'product_priority_4',
        sanitized_images: 'sanitized_images',
        start_date: 'start_date',
        start_time: 'start_time',
        tags: 'tags',
        term_length: 'term_length',
        term_qualifier: 'term_qualifier',
        title: 'title',
        transmission: 'transmission',
        trim: 'trim',
        unit_price: 'unit_price',
        url: 'url',
        vehicle_offer_id: 'vehicle_offer_id',
        visibility: 'visibility',
        year: 'year'
      });
    }
  }, {
    key: 'ImageFetchStatus',
    get: function get() {
      return Object.freeze({
        direct_upload: 'DIRECT_UPLOAD',
        fetched: 'FETCHED',
        fetch_failed: 'FETCH_FAILED',
        no_status: 'NO_STATUS',
        outdated: 'OUTDATED',
        partial_fetch: 'PARTIAL_FETCH'
      });
    }
  }, {
    key: 'Visibility',
    get: function get() {
      return Object.freeze({
        published: 'PUBLISHED',
        staging: 'STAGING'
      });
    }
  }]);
  return VehicleOffer;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Vehicle
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Vehicle = function (_AbstractCrudObject) {
  inherits(Vehicle, _AbstractCrudObject);

  function Vehicle() {
    classCallCheck(this, Vehicle);
    return possibleConstructorReturn(this, (Vehicle.__proto__ || Object.getPrototypeOf(Vehicle)).apply(this, arguments));
  }

  createClass(Vehicle, [{
    key: 'getChannelsToIntegrityStatus',
    value: function getChannelsToIntegrityStatus(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CatalogItemChannelsToIntegrityStatus, fields, params, fetchFirstPage, '/channels_to_integrity_status');
    }
  }, {
    key: 'getOverrideDetails',
    value: function getOverrideDetails(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(OverrideDetails, fields, params, fetchFirstPage, '/override_details');
    }
  }, {
    key: 'getVideosMetadata',
    value: function getVideosMetadata(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(DynamicVideoMetadata, fields, params, fetchFirstPage, '/videos_metadata');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Vehicle.prototype.__proto__ || Object.getPrototypeOf(Vehicle.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        address: 'address',
        applinks: 'applinks',
        availability: 'availability',
        availability_circle_radius: 'availability_circle_radius',
        availability_circle_radius_unit: 'availability_circle_radius_unit',
        body_style: 'body_style',
        category_specific_fields: 'category_specific_fields',
        condition: 'condition',
        currency: 'currency',
        custom_label_0: 'custom_label_0',
        custom_label_1: 'custom_label_1',
        custom_label_2: 'custom_label_2',
        custom_label_3: 'custom_label_3',
        custom_label_4: 'custom_label_4',
        custom_number_0: 'custom_number_0',
        custom_number_1: 'custom_number_1',
        custom_number_2: 'custom_number_2',
        custom_number_3: 'custom_number_3',
        custom_number_4: 'custom_number_4',
        date_first_on_lot: 'date_first_on_lot',
        dealer_communication_channel: 'dealer_communication_channel',
        dealer_email: 'dealer_email',
        dealer_id: 'dealer_id',
        dealer_name: 'dealer_name',
        dealer_phone: 'dealer_phone',
        dealer_privacy_policy_url: 'dealer_privacy_policy_url',
        description: 'description',
        drivetrain: 'drivetrain',
        exterior_color: 'exterior_color',
        fb_page_id: 'fb_page_id',
        features: 'features',
        fuel_type: 'fuel_type',
        id: 'id',
        image_fetch_status: 'image_fetch_status',
        images: 'images',
        interior_color: 'interior_color',
        legal_disclosure_impressum_url: 'legal_disclosure_impressum_url',
        make: 'make',
        mileage: 'mileage',
        model: 'model',
        previous_currency: 'previous_currency',
        previous_price: 'previous_price',
        price: 'price',
        product_priority_0: 'product_priority_0',
        product_priority_1: 'product_priority_1',
        product_priority_2: 'product_priority_2',
        product_priority_3: 'product_priority_3',
        product_priority_4: 'product_priority_4',
        sale_currency: 'sale_currency',
        sale_price: 'sale_price',
        sanitized_images: 'sanitized_images',
        state_of_vehicle: 'state_of_vehicle',
        tags: 'tags',
        title: 'title',
        transmission: 'transmission',
        trim: 'trim',
        unit_price: 'unit_price',
        url: 'url',
        vehicle_id: 'vehicle_id',
        vehicle_registration_plate: 'vehicle_registration_plate',
        vehicle_specifications: 'vehicle_specifications',
        vehicle_type: 'vehicle_type',
        vin: 'vin',
        visibility: 'visibility',
        year: 'year'
      });
    }
  }, {
    key: 'ImageFetchStatus',
    get: function get() {
      return Object.freeze({
        direct_upload: 'DIRECT_UPLOAD',
        fetched: 'FETCHED',
        fetch_failed: 'FETCH_FAILED',
        no_status: 'NO_STATUS',
        outdated: 'OUTDATED',
        partial_fetch: 'PARTIAL_FETCH'
      });
    }
  }, {
    key: 'Visibility',
    get: function get() {
      return Object.freeze({
        published: 'PUBLISHED',
        staging: 'STAGING'
      });
    }
  }, {
    key: 'Availability',
    get: function get() {
      return Object.freeze({
        available: 'AVAILABLE',
        not_available: 'NOT_AVAILABLE',
        pending: 'PENDING',
        unknown: 'UNKNOWN'
      });
    }
  }, {
    key: 'BodyStyle',
    get: function get() {
      return Object.freeze({
        convertible: 'CONVERTIBLE',
        coupe: 'COUPE',
        crossover: 'CROSSOVER',
        estate: 'ESTATE',
        grandtourer: 'GRANDTOURER',
        hatchback: 'HATCHBACK',
        minibus: 'MINIBUS',
        minivan: 'MINIVAN',
        mpv: 'MPV',
        none: 'NONE',
        other: 'OTHER',
        pickup: 'PICKUP',
        roadster: 'ROADSTER',
        saloon: 'SALOON',
        sedan: 'SEDAN',
        small_car: 'SMALL_CAR',
        sportscar: 'SPORTSCAR',
        supercar: 'SUPERCAR',
        supermini: 'SUPERMINI',
        suv: 'SUV',
        truck: 'TRUCK',
        van: 'VAN',
        wagon: 'WAGON'
      });
    }
  }, {
    key: 'Condition',
    get: function get() {
      return Object.freeze({
        excellent: 'EXCELLENT',
        fair: 'FAIR',
        good: 'GOOD',
        none: 'NONE',
        other: 'OTHER',
        poor: 'POOR',
        very_good: 'VERY_GOOD'
      });
    }
  }, {
    key: 'Drivetrain',
    get: function get() {
      return Object.freeze({
        awd: 'AWD',
        four_wd: 'FOUR_WD',
        fwd: 'FWD',
        none: 'NONE',
        other: 'OTHER',
        rwd: 'RWD',
        two_wd: 'TWO_WD'
      });
    }
  }, {
    key: 'FuelType',
    get: function get() {
      return Object.freeze({
        diesel: 'DIESEL',
        electric: 'ELECTRIC',
        flex: 'FLEX',
        gasoline: 'GASOLINE',
        hybrid: 'HYBRID',
        none: 'NONE',
        other: 'OTHER',
        petrol: 'PETROL',
        plugin_hybrid: 'PLUGIN_HYBRID'
      });
    }
  }, {
    key: 'StateOfVehicle',
    get: function get() {
      return Object.freeze({
        cpo: 'CPO',
        new: 'NEW',
        used: 'USED'
      });
    }
  }, {
    key: 'Transmission',
    get: function get() {
      return Object.freeze({
        automatic: 'AUTOMATIC',
        manual: 'MANUAL',
        none: 'NONE',
        other: 'OTHER'
      });
    }
  }, {
    key: 'VehicleType',
    get: function get() {
      return Object.freeze({
        boat: 'BOAT',
        car_truck: 'CAR_TRUCK',
        commercial: 'COMMERCIAL',
        motorcycle: 'MOTORCYCLE',
        other: 'OTHER',
        powersport: 'POWERSPORT',
        rv_camper: 'RV_CAMPER',
        trailer: 'TRAILER'
      });
    }
  }]);
  return Vehicle;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductSet
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductSet = function (_AbstractCrudObject) {
  inherits(ProductSet, _AbstractCrudObject);

  function ProductSet() {
    classCallCheck(this, ProductSet);
    return possibleConstructorReturn(this, (ProductSet.__proto__ || Object.getPrototypeOf(ProductSet)).apply(this, arguments));
  }

  createClass(ProductSet, [{
    key: 'getAutomotiveModels',
    value: function getAutomotiveModels(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AutomotiveModel, fields, params, fetchFirstPage, '/automotive_models');
    }
  }, {
    key: 'getDestinations',
    value: function getDestinations(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Destination, fields, params, fetchFirstPage, '/destinations');
    }
  }, {
    key: 'getFlights',
    value: function getFlights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Flight, fields, params, fetchFirstPage, '/flights');
    }
  }, {
    key: 'getHomeListings',
    value: function getHomeListings(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(HomeListing, fields, params, fetchFirstPage, '/home_listings');
    }
  }, {
    key: 'getHotels',
    value: function getHotels(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Hotel, fields, params, fetchFirstPage, '/hotels');
    }
  }, {
    key: 'getMediaTitles',
    value: function getMediaTitles(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(MediaTitle, fields, params, fetchFirstPage, '/media_titles');
    }
  }, {
    key: 'getProducts',
    value: function getProducts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductItem, fields, params, fetchFirstPage, '/products');
    }
  }, {
    key: 'getVehicleOffers',
    value: function getVehicleOffers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(VehicleOffer, fields, params, fetchFirstPage, '/vehicle_offers');
    }
  }, {
    key: 'getVehicles',
    value: function getVehicles(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Vehicle, fields, params, fetchFirstPage, '/vehicles');
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(ProductSet.prototype.__proto__ || Object.getPrototypeOf(ProductSet.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(ProductSet.prototype.__proto__ || Object.getPrototypeOf(ProductSet.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        auto_creation_url: 'auto_creation_url',
        filter: 'filter',
        id: 'id',
        latest_metadata: 'latest_metadata',
        live_metadata: 'live_metadata',
        name: 'name',
        ordering_info: 'ordering_info',
        product_catalog: 'product_catalog',
        product_count: 'product_count',
        retailer_id: 'retailer_id'
      });
    }
  }]);
  return ProductSet;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductItem
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductItem = function (_AbstractCrudObject) {
  inherits(ProductItem, _AbstractCrudObject);

  function ProductItem() {
    classCallCheck(this, ProductItem);
    return possibleConstructorReturn(this, (ProductItem.__proto__ || Object.getPrototypeOf(ProductItem)).apply(this, arguments));
  }

  createClass(ProductItem, [{
    key: 'getChannelsToIntegrityStatus',
    value: function getChannelsToIntegrityStatus(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CatalogItemChannelsToIntegrityStatus, fields, params, fetchFirstPage, '/channels_to_integrity_status');
    }
  }, {
    key: 'getOverrideDetails',
    value: function getOverrideDetails(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(OverrideDetails, fields, params, fetchFirstPage, '/override_details');
    }
  }, {
    key: 'getProductSets',
    value: function getProductSets(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductSet, fields, params, fetchFirstPage, '/product_sets');
    }
  }, {
    key: 'getVideosMetadata',
    value: function getVideosMetadata(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(DynamicVideoMetadata, fields, params, fetchFirstPage, '/videos_metadata');
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(ProductItem.prototype.__proto__ || Object.getPrototypeOf(ProductItem.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(ProductItem.prototype.__proto__ || Object.getPrototypeOf(ProductItem.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        additional_image_cdn_urls: 'additional_image_cdn_urls',
        additional_image_urls: 'additional_image_urls',
        additional_variant_attributes: 'additional_variant_attributes',
        age_group: 'age_group',
        applinks: 'applinks',
        availability: 'availability',
        brand: 'brand',
        bundle_items: 'bundle_items',
        bundle_retailer_ids: 'bundle_retailer_ids',
        capabilities_disabled_by_user: 'capabilities_disabled_by_user',
        capability_to_review_status: 'capability_to_review_status',
        category: 'category',
        category_specific_fields: 'category_specific_fields',
        color: 'color',
        commerce_insights: 'commerce_insights',
        condition: 'condition',
        currency: 'currency',
        custom_data: 'custom_data',
        custom_label_0: 'custom_label_0',
        custom_label_1: 'custom_label_1',
        custom_label_2: 'custom_label_2',
        custom_label_3: 'custom_label_3',
        custom_label_4: 'custom_label_4',
        custom_number_0: 'custom_number_0',
        custom_number_1: 'custom_number_1',
        custom_number_2: 'custom_number_2',
        custom_number_3: 'custom_number_3',
        custom_number_4: 'custom_number_4',
        description: 'description',
        errors: 'errors',
        expiration_date: 'expiration_date',
        fb_product_category: 'fb_product_category',
        gender: 'gender',
        generated_background_images: 'generated_background_images',
        generated_background_images_ad_usage: 'generated_background_images_ad_usage',
        gtin: 'gtin',
        id: 'id',
        image_cdn_urls: 'image_cdn_urls',
        image_fetch_status: 'image_fetch_status',
        image_url: 'image_url',
        images: 'images',
        importer_address: 'importer_address',
        importer_name: 'importer_name',
        invalidation_errors: 'invalidation_errors',
        inventory: 'inventory',
        is_bundle_hero: 'is_bundle_hero',
        live_special_price: 'live_special_price',
        manufacturer_info: 'manufacturer_info',
        manufacturer_part_number: 'manufacturer_part_number',
        marked_for_product_launch: 'marked_for_product_launch',
        material: 'material',
        mobile_link: 'mobile_link',
        name: 'name',
        ordering_index: 'ordering_index',
        origin_country: 'origin_country',
        parent_product_id: 'parent_product_id',
        pattern: 'pattern',
        post_conversion_signal_based_enforcement_appeal_eligibility: 'post_conversion_signal_based_enforcement_appeal_eligibility',
        price: 'price',
        product_catalog: 'product_catalog',
        product_feed: 'product_feed',
        product_group: 'product_group',
        product_local_info: 'product_local_info',
        product_relationship: 'product_relationship',
        product_type: 'product_type',
        quantity_to_sell_on_facebook: 'quantity_to_sell_on_facebook',
        retailer_id: 'retailer_id',
        retailer_product_group_id: 'retailer_product_group_id',
        review_rejection_reasons: 'review_rejection_reasons',
        review_status: 'review_status',
        rich_text_description: 'rich_text_description',
        sale_price: 'sale_price',
        sale_price_end_date: 'sale_price_end_date',
        sale_price_start_date: 'sale_price_start_date',
        shipping_weight_unit: 'shipping_weight_unit',
        shipping_weight_value: 'shipping_weight_value',
        short_description: 'short_description',
        size: 'size',
        start_date: 'start_date',
        status: 'status',
        tags: 'tags',
        url: 'url',
        vendor_id: 'vendor_id',
        video_fetch_status: 'video_fetch_status',
        videos: 'videos',
        visibility: 'visibility',
        wa_compliance_category: 'wa_compliance_category'
      });
    }
  }, {
    key: 'AgeGroup',
    get: function get() {
      return Object.freeze({
        adult: 'adult',
        all_ages: 'all ages',
        infant: 'infant',
        kids: 'kids',
        newborn: 'newborn',
        teen: 'teen',
        toddler: 'toddler'
      });
    }
  }, {
    key: 'Availability',
    get: function get() {
      return Object.freeze({
        available_for_order: 'available for order',
        discontinued: 'discontinued',
        in_stock: 'in stock',
        mark_as_sold: 'mark_as_sold',
        out_of_stock: 'out of stock',
        pending: 'pending',
        preorder: 'preorder'
      });
    }
  }, {
    key: 'CapabilityToReviewStatus',
    get: function get() {
      return Object.freeze({
        approved: 'APPROVED',
        no_review: 'NO_REVIEW',
        outdated: 'OUTDATED',
        pending: 'PENDING',
        rejected: 'REJECTED'
      });
    }
  }, {
    key: 'Condition',
    get: function get() {
      return Object.freeze({
        cpo: 'cpo',
        new: 'new',
        open_box_new: 'open_box_new',
        refurbished: 'refurbished',
        used: 'used',
        used_fair: 'used_fair',
        used_good: 'used_good',
        used_like_new: 'used_like_new'
      });
    }
  }, {
    key: 'Gender',
    get: function get() {
      return Object.freeze({
        female: 'female',
        male: 'male',
        unisex: 'unisex'
      });
    }
  }, {
    key: 'ImageFetchStatus',
    get: function get() {
      return Object.freeze({
        direct_upload: 'DIRECT_UPLOAD',
        fetched: 'FETCHED',
        fetch_failed: 'FETCH_FAILED',
        no_status: 'NO_STATUS',
        outdated: 'OUTDATED',
        partial_fetch: 'PARTIAL_FETCH'
      });
    }
  }, {
    key: 'ReviewStatus',
    get: function get() {
      return Object.freeze({
        approved: 'approved',
        outdated: 'outdated',
        pending: 'pending',
        rejected: 'rejected'
      });
    }
  }, {
    key: 'ShippingWeightUnit',
    get: function get() {
      return Object.freeze({
        g: 'g',
        kg: 'kg',
        lb: 'lb',
        oz: 'oz'
      });
    }
  }, {
    key: 'Status',
    get: function get() {
      return Object.freeze({
        published: 'PUBLISHED',
        staging: 'STAGING'
      });
    }
  }, {
    key: 'VideoFetchStatus',
    get: function get() {
      return Object.freeze({
        direct_upload: 'DIRECT_UPLOAD',
        fetched: 'FETCHED',
        fetch_failed: 'FETCH_FAILED',
        no_status: 'NO_STATUS',
        outdated: 'OUTDATED',
        partial_fetch: 'PARTIAL_FETCH'
      });
    }
  }, {
    key: 'Visibility',
    get: function get() {
      return Object.freeze({
        published: 'published',
        staging: 'staging'
      });
    }
  }, {
    key: 'CommerceTaxCategory',
    get: function get() {
      return Object.freeze({
        fb_animal: 'FB_ANIMAL',
        fb_animal_supp: 'FB_ANIMAL_SUPP',
        fb_aprl: 'FB_APRL',
        fb_aprl_accessories: 'FB_APRL_ACCESSORIES',
        fb_aprl_athl_unif: 'FB_APRL_ATHL_UNIF',
        fb_aprl_cases: 'FB_APRL_CASES',
        fb_aprl_clothing: 'FB_APRL_CLOTHING',
        fb_aprl_costume: 'FB_APRL_COSTUME',
        fb_aprl_cstm: 'FB_APRL_CSTM',
        fb_aprl_formal: 'FB_APRL_FORMAL',
        fb_aprl_handbag: 'FB_APRL_HANDBAG',
        fb_aprl_jewelry: 'FB_APRL_JEWELRY',
        fb_aprl_shoe: 'FB_APRL_SHOE',
        fb_aprl_shoe_acc: 'FB_APRL_SHOE_ACC',
        fb_aprl_swim: 'FB_APRL_SWIM',
        fb_aprl_swim_chil: 'FB_APRL_SWIM_CHIL',
        fb_aprl_swim_cvr: 'FB_APRL_SWIM_CVR',
        fb_arts: 'FB_ARTS',
        fb_arts_hobby: 'FB_ARTS_HOBBY',
        fb_arts_party: 'FB_ARTS_PARTY',
        fb_arts_party_gift_card: 'FB_ARTS_PARTY_GIFT_CARD',
        fb_arts_ticket: 'FB_ARTS_TICKET',
        fb_baby: 'FB_BABY',
        fb_baby_bath: 'FB_BABY_BATH',
        fb_baby_blanket: 'FB_BABY_BLANKET',
        fb_baby_diaper: 'FB_BABY_DIAPER',
        fb_baby_gift_set: 'FB_BABY_GIFT_SET',
        fb_baby_health: 'FB_BABY_HEALTH',
        fb_baby_nursing: 'FB_BABY_NURSING',
        fb_baby_potty_trn: 'FB_BABY_POTTY_TRN',
        fb_baby_safe: 'FB_BABY_SAFE',
        fb_baby_toys: 'FB_BABY_TOYS',
        fb_baby_transport: 'FB_BABY_TRANSPORT',
        fb_baby_transport_acc: 'FB_BABY_TRANSPORT_ACC',
        fb_bags: 'FB_BAGS',
        fb_bags_bkpk: 'FB_BAGS_BKPK',
        fb_bags_boxes: 'FB_BAGS_BOXES',
        fb_bags_brfcs: 'FB_BAGS_BRFCS',
        fb_bags_csmt_bag: 'FB_BAGS_CSMT_BAG',
        fb_bags_dffl: 'FB_BAGS_DFFL',
        fb_bags_dipr: 'FB_BAGS_DIPR',
        fb_bags_fnny: 'FB_BAGS_FNNY',
        fb_bags_grmt: 'FB_BAGS_GRMT',
        fb_bags_lugg: 'FB_BAGS_LUGG',
        fb_bags_lug_acc: 'FB_BAGS_LUG_ACC',
        fb_bags_msgr: 'FB_BAGS_MSGR',
        fb_bags_tote: 'FB_BAGS_TOTE',
        fb_bags_trn_cas: 'FB_BAGS_TRN_CAS',
        fb_bldg: 'FB_BLDG',
        fb_bldg_acc: 'FB_BLDG_ACC',
        fb_bldg_cnsmb: 'FB_BLDG_CNSMB',
        fb_bldg_fence: 'FB_BLDG_FENCE',
        fb_bldg_fuel_tnk: 'FB_BLDG_FUEL_TNK',
        fb_bldg_ht_vnt: 'FB_BLDG_HT_VNT',
        fb_bldg_lock: 'FB_BLDG_LOCK',
        fb_bldg_matrl: 'FB_BLDG_MATRL',
        fb_bldg_plmb: 'FB_BLDG_PLMB',
        fb_bldg_pump: 'FB_BLDG_PUMP',
        fb_bldg_pwrs: 'FB_BLDG_PWRS',
        fb_bldg_str_tank: 'FB_BLDG_STR_TANK',
        fb_bldg_s_eng: 'FB_BLDG_S_ENG',
        fb_bldg_tl_acc: 'FB_BLDG_TL_ACC',
        fb_bldg_tool: 'FB_BLDG_TOOL',
        fb_busind: 'FB_BUSIND',
        fb_busind_advertising: 'FB_BUSIND_ADVERTISING',
        fb_busind_agriculture: 'FB_BUSIND_AGRICULTURE',
        fb_busind_automation: 'FB_BUSIND_AUTOMATION',
        fb_busind_heavy_mach: 'FB_BUSIND_HEAVY_MACH',
        fb_busind_lab: 'FB_BUSIND_LAB',
        fb_busind_medical: 'FB_BUSIND_MEDICAL',
        fb_busind_retail: 'FB_BUSIND_RETAIL',
        fb_busind_sanitary_ct: 'FB_BUSIND_SANITARY_CT',
        fb_busind_sign: 'FB_BUSIND_SIGN',
        fb_busind_storage: 'FB_BUSIND_STORAGE',
        fb_busind_storage_acc: 'FB_BUSIND_STORAGE_ACC',
        fb_busind_work_gear: 'FB_BUSIND_WORK_GEAR',
        fb_camera_acc: 'FB_CAMERA_ACC',
        fb_camera_camera: 'FB_CAMERA_CAMERA',
        fb_camera_optic: 'FB_CAMERA_OPTIC',
        fb_camera_optics: 'FB_CAMERA_OPTICS',
        fb_camera_photo: 'FB_CAMERA_PHOTO',
        fb_elec: 'FB_ELEC',
        fb_elec_acc: 'FB_ELEC_ACC',
        fb_elec_arcdade: 'FB_ELEC_ARCDADE',
        fb_elec_audio: 'FB_ELEC_AUDIO',
        fb_elec_circuit: 'FB_ELEC_CIRCUIT',
        fb_elec_comm: 'FB_ELEC_COMM',
        fb_elec_computer: 'FB_ELEC_COMPUTER',
        fb_elec_gps_acc: 'FB_ELEC_GPS_ACC',
        fb_elec_gps_nav: 'FB_ELEC_GPS_NAV',
        fb_elec_gps_trk: 'FB_ELEC_GPS_TRK',
        fb_elec_marine: 'FB_ELEC_MARINE',
        fb_elec_network: 'FB_ELEC_NETWORK',
        fb_elec_part: 'FB_ELEC_PART',
        fb_elec_print: 'FB_ELEC_PRINT',
        fb_elec_radar: 'FB_ELEC_RADAR',
        fb_elec_sftwr: 'FB_ELEC_SFTWR',
        fb_elec_speed_rdr: 'FB_ELEC_SPEED_RDR',
        fb_elec_television: 'FB_ELEC_TELEVISION',
        fb_elec_toll: 'FB_ELEC_TOLL',
        fb_elec_video: 'FB_ELEC_VIDEO',
        fb_elec_vid_gm_acc: 'FB_ELEC_VID_GM_ACC',
        fb_elec_vid_gm_cnsl: 'FB_ELEC_VID_GM_CNSL',
        fb_food: 'FB_FOOD',
        fb_furn: 'FB_FURN',
        fb_furn_baby: 'FB_FURN_BABY',
        fb_furn_bench: 'FB_FURN_BENCH',
        fb_furn_cart: 'FB_FURN_CART',
        fb_furn_chair: 'FB_FURN_CHAIR',
        fb_furn_chair_acc: 'FB_FURN_CHAIR_ACC',
        fb_furn_divide: 'FB_FURN_DIVIDE',
        fb_furn_divide_acc: 'FB_FURN_DIVIDE_ACC',
        fb_furn_ent_ctr: 'FB_FURN_ENT_CTR',
        fb_furn_futn: 'FB_FURN_FUTN',
        fb_furn_futn_pad: 'FB_FURN_FUTN_PAD',
        fb_furn_office: 'FB_FURN_OFFICE',
        fb_furn_office_acc: 'FB_FURN_OFFICE_ACC',
        fb_furn_otto: 'FB_FURN_OTTO',
        fb_furn_outdoor: 'FB_FURN_OUTDOOR',
        fb_furn_outdoor_acc: 'FB_FURN_OUTDOOR_ACC',
        fb_furn_sets: 'FB_FURN_SETS',
        fb_furn_shelve_acc: 'FB_FURN_SHELVE_ACC',
        fb_furn_shlf: 'FB_FURN_SHLF',
        fb_furn_sofa: 'FB_FURN_SOFA',
        fb_furn_sofa_acc: 'FB_FURN_SOFA_ACC',
        fb_furn_storage: 'FB_FURN_STORAGE',
        fb_furn_tabl: 'FB_FURN_TABL',
        fb_furn_tabl_acc: 'FB_FURN_TABL_ACC',
        fb_generic_taxable: 'FB_GENERIC_TAXABLE',
        fb_hlth: 'FB_HLTH',
        fb_hlth_hlth: 'FB_HLTH_HLTH',
        fb_hlth_jwl_cr: 'FB_HLTH_JWL_CR',
        fb_hlth_lilp_blm: 'FB_HLTH_LILP_BLM',
        fb_hlth_ltn_spf: 'FB_HLTH_LTN_SPF',
        fb_hlth_prsl_cr: 'FB_HLTH_PRSL_CR',
        fb_hlth_skn_cr: 'FB_HLTH_SKN_CR',
        fb_hmgn: 'FB_HMGN',
        fb_hmgn_bath: 'FB_HMGN_BATH',
        fb_hmgn_dcor: 'FB_HMGN_DCOR',
        fb_hmgn_emgy: 'FB_HMGN_EMGY',
        fb_hmgn_fplc: 'FB_HMGN_FPLC',
        fb_hmgn_fplc_acc: 'FB_HMGN_FPLC_ACC',
        fb_hmgn_gs_sft: 'FB_HMGN_GS_SFT',
        fb_hmgn_hs_acc: 'FB_HMGN_HS_ACC',
        fb_hmgn_hs_app: 'FB_HMGN_HS_APP',
        fb_hmgn_hs_spl: 'FB_HMGN_HS_SPL',
        fb_hmgn_ktcn: 'FB_HMGN_KTCN',
        fb_hmgn_lawn: 'FB_HMGN_LAWN',
        fb_hmgn_lght: 'FB_HMGN_LGHT',
        fb_hmgn_linn: 'FB_HMGN_LINN',
        fb_hmgn_lt_acc: 'FB_HMGN_LT_ACC',
        fb_hmgn_otdr: 'FB_HMGN_OTDR',
        fb_hmgn_pool: 'FB_HMGN_POOL',
        fb_hmgn_scty: 'FB_HMGN_SCTY',
        fb_hmgn_smk_acc: 'FB_HMGN_SMK_ACC',
        fb_hmgn_umbr: 'FB_HMGN_UMBR',
        fb_hmgn_umbr_acc: 'FB_HMGN_UMBR_ACC',
        fb_mdia: 'FB_MDIA',
        fb_mdia_book: 'FB_MDIA_BOOK',
        fb_mdia_dvds: 'FB_MDIA_DVDS',
        fb_mdia_mag: 'FB_MDIA_MAG',
        fb_mdia_manl: 'FB_MDIA_MANL',
        fb_mdia_musc: 'FB_MDIA_MUSC',
        fb_mdia_prj_pln: 'FB_MDIA_PRJ_PLN',
        fb_mdia_sht_mus: 'FB_MDIA_SHT_MUS',
        fb_offc: 'FB_OFFC',
        fb_offc_bkac: 'FB_OFFC_BKAC',
        fb_offc_crts: 'FB_OFFC_CRTS',
        fb_offc_dskp: 'FB_OFFC_DSKP',
        fb_offc_eqip: 'FB_OFFC_EQIP',
        fb_offc_flng: 'FB_OFFC_FLNG',
        fb_offc_gnrl: 'FB_OFFC_GNRL',
        fb_offc_instm: 'FB_OFFC_INSTM',
        fb_offc_lp_dsk: 'FB_OFFC_LP_DSK',
        fb_offc_mats: 'FB_OFFC_MATS',
        fb_offc_nm_plt: 'FB_OFFC_NM_PLT',
        fb_offc_ppr_hndl: 'FB_OFFC_PPR_HNDL',
        fb_offc_prsnt_spl: 'FB_OFFC_PRSNT_SPL',
        fb_offc_sealr: 'FB_OFFC_SEALR',
        fb_offc_ship_spl: 'FB_OFFC_SHIP_SPL',
        fb_rlgn: 'FB_RLGN',
        fb_rlgn_cmny: 'FB_RLGN_CMNY',
        fb_rlgn_item: 'FB_RLGN_ITEM',
        fb_rlgn_wedd: 'FB_RLGN_WEDD',
        fb_sftwr: 'FB_SFTWR',
        fb_sfwr_cmptr: 'FB_SFWR_CMPTR',
        fb_sfwr_dgtl_gd: 'FB_SFWR_DGTL_GD',
        fb_sfwr_game: 'FB_SFWR_GAME',
        fb_shipping: 'FB_SHIPPING',
        fb_spor: 'FB_SPOR',
        fb_sport_athl: 'FB_SPORT_ATHL',
        fb_sport_athl_clth: 'FB_SPORT_ATHL_CLTH',
        fb_sport_athl_shoe: 'FB_SPORT_ATHL_SHOE',
        fb_sport_athl_sprt: 'FB_SPORT_ATHL_SPRT',
        fb_sport_exrcs: 'FB_SPORT_EXRCS',
        fb_sport_indr_gm: 'FB_SPORT_INDR_GM',
        fb_sport_otdr_gm: 'FB_SPORT_OTDR_GM',
        fb_toys: 'FB_TOYS',
        fb_toys_eqip: 'FB_TOYS_EQIP',
        fb_toys_game: 'FB_TOYS_GAME',
        fb_toys_pzzl: 'FB_TOYS_PZZL',
        fb_toys_tmrs: 'FB_TOYS_TMRS',
        fb_toys_toys: 'FB_TOYS_TOYS',
        fb_vehi: 'FB_VEHI',
        fb_vehi_part: 'FB_VEHI_PART'
      });
    }
  }, {
    key: 'ErrorPriority',
    get: function get() {
      return Object.freeze({
        high: 'HIGH',
        low: 'LOW',
        medium: 'MEDIUM'
      });
    }
  }, {
    key: 'ErrorType',
    get: function get() {
      return Object.freeze({
        address_blocklisted_in_market: 'ADDRESS_BLOCKLISTED_IN_MARKET',
        aggregated_localization_issues: 'AGGREGATED_LOCALIZATION_ISSUES',
        app_has_no_aem_setup: 'APP_HAS_NO_AEM_SETUP',
        ar_deleted_due_to_update: 'AR_DELETED_DUE_TO_UPDATE',
        ar_policy_violated: 'AR_POLICY_VIOLATED',
        available: 'AVAILABLE',
        bad_quality_image: 'BAD_QUALITY_IMAGE',
        big_catalog_with_all_items_in_stock: 'BIG_CATALOG_WITH_ALL_ITEMS_IN_STOCK',
        biz_msg_ai_agent_disabled_by_user: 'BIZ_MSG_AI_AGENT_DISABLED_BY_USER',
        biz_msg_gen_ai_policy_violated: 'BIZ_MSG_GEN_AI_POLICY_VIOLATED',
        cannot_edit_subscription_products: 'CANNOT_EDIT_SUBSCRIPTION_PRODUCTS',
        catalog_not_connected_to_event_source: 'CATALOG_NOT_CONNECTED_TO_EVENT_SOURCE',
        checkout_disabled_by_user: 'CHECKOUT_DISABLED_BY_USER',
        commerce_account_legal_address_invalid: 'COMMERCE_ACCOUNT_LEGAL_ADDRESS_INVALID',
        commerce_account_not_legally_compliant: 'COMMERCE_ACCOUNT_NOT_LEGALLY_COMPLIANT',
        crawled_availability_mismatch: 'CRAWLED_AVAILABILITY_MISMATCH',
        da_disabled_by_user: 'DA_DISABLED_BY_USER',
        da_policy_violation: 'DA_POLICY_VIOLATION',
        deleted_item: 'DELETED_ITEM',
        digital_goods_not_available_for_checkout: 'DIGITAL_GOODS_NOT_AVAILABLE_FOR_CHECKOUT',
        duplicate_images: 'DUPLICATE_IMAGES',
        duplicate_title_and_description: 'DUPLICATE_TITLE_AND_DESCRIPTION',
        empty_availability: 'EMPTY_AVAILABILITY',
        empty_condition: 'EMPTY_CONDITION',
        empty_description: 'EMPTY_DESCRIPTION',
        empty_image_url: 'EMPTY_IMAGE_URL',
        empty_price: 'EMPTY_PRICE',
        empty_product_url: 'EMPTY_PRODUCT_URL',
        empty_seller_description: 'EMPTY_SELLER_DESCRIPTION',
        empty_title: 'EMPTY_TITLE',
        external_merchant_id_mismatch: 'EXTERNAL_MERCHANT_ID_MISMATCH',
        generic_invalid_field: 'GENERIC_INVALID_FIELD',
        groups_disabled_by_user: 'GROUPS_DISABLED_BY_USER',
        hidden_until_product_launch: 'HIDDEN_UNTIL_PRODUCT_LAUNCH',
        illegal_product_category: 'ILLEGAL_PRODUCT_CATEGORY',
        image_fetch_failed: 'IMAGE_FETCH_FAILED',
        image_fetch_failed_bad_gateway: 'IMAGE_FETCH_FAILED_BAD_GATEWAY',
        image_fetch_failed_file_size_exceeded: 'IMAGE_FETCH_FAILED_FILE_SIZE_EXCEEDED',
        image_fetch_failed_forbidden: 'IMAGE_FETCH_FAILED_FORBIDDEN',
        image_fetch_failed_link_broken: 'IMAGE_FETCH_FAILED_LINK_BROKEN',
        image_fetch_failed_timed_out: 'IMAGE_FETCH_FAILED_TIMED_OUT',
        image_resolution_low: 'IMAGE_RESOLUTION_LOW',
        inactive_shopify_product: 'INACTIVE_SHOPIFY_PRODUCT',
        invalid_commerce_tax_category: 'INVALID_COMMERCE_TAX_CATEGORY',
        invalid_consolidated_locality_information: 'INVALID_CONSOLIDATED_LOCALITY_INFORMATION',
        invalid_content_id: 'INVALID_CONTENT_ID',
        invalid_dealer_communication_parameters: 'INVALID_DEALER_COMMUNICATION_PARAMETERS',
        invalid_dma_codes: 'INVALID_DMA_CODES',
        invalid_fb_page_id: 'INVALID_FB_PAGE_ID',
        invalid_images: 'INVALID_IMAGES',
        invalid_monetizer_return_policy: 'INVALID_MONETIZER_RETURN_POLICY',
        invalid_offer_disclaimer_url: 'INVALID_OFFER_DISCLAIMER_URL',
        invalid_offer_end_date: 'INVALID_OFFER_END_DATE',
        invalid_pre_order_params: 'INVALID_PRE_ORDER_PARAMS',
        invalid_range_for_area_size: 'INVALID_RANGE_FOR_AREA_SIZE',
        invalid_range_for_built_up_area_size: 'INVALID_RANGE_FOR_BUILT_UP_AREA_SIZE',
        invalid_range_for_num_of_baths: 'INVALID_RANGE_FOR_NUM_OF_BATHS',
        invalid_range_for_num_of_beds: 'INVALID_RANGE_FOR_NUM_OF_BEDS',
        invalid_range_for_num_of_rooms: 'INVALID_RANGE_FOR_NUM_OF_ROOMS',
        invalid_range_for_parking_spaces: 'INVALID_RANGE_FOR_PARKING_SPACES',
        invalid_shelter_page_id: 'INVALID_SHELTER_PAGE_ID',
        invalid_shipping_profile_params: 'INVALID_SHIPPING_PROFILE_PARAMS',
        invalid_subscription_disable_params: 'INVALID_SUBSCRIPTION_DISABLE_PARAMS',
        invalid_subscription_enable_params: 'INVALID_SUBSCRIPTION_ENABLE_PARAMS',
        invalid_subscription_params: 'INVALID_SUBSCRIPTION_PARAMS',
        invalid_tax_extension_state: 'INVALID_TAX_EXTENSION_STATE',
        invalid_vehicle_state: 'INVALID_VEHICLE_STATE',
        invalid_virtual_tour_url_domain: 'INVALID_VIRTUAL_TOUR_URL_DOMAIN',
        inventory_zero_availability_in_stock: 'INVENTORY_ZERO_AVAILABILITY_IN_STOCK',
        in_another_product_launch: 'IN_ANOTHER_PRODUCT_LAUNCH',
        item_group_not_specified: 'ITEM_GROUP_NOT_SPECIFIED',
        item_not_shippable_for_sca_shop: 'ITEM_NOT_SHIPPABLE_FOR_SCA_SHOP',
        item_override_empty_availability: 'ITEM_OVERRIDE_EMPTY_AVAILABILITY',
        item_override_empty_price: 'ITEM_OVERRIDE_EMPTY_PRICE',
        item_override_not_visible: 'ITEM_OVERRIDE_NOT_VISIBLE',
        item_price_not_positive: 'ITEM_PRICE_NOT_POSITIVE',
        item_stale_out_of_stock: 'ITEM_STALE_OUT_OF_STOCK',
        marketplace_disabled_by_user: 'MARKETPLACE_DISABLED_BY_USER',
        marketplace_partner_auction_no_bid_close_time: 'MARKETPLACE_PARTNER_AUCTION_NO_BID_CLOSE_TIME',
        marketplace_partner_currency_not_valid: 'MARKETPLACE_PARTNER_CURRENCY_NOT_VALID',
        marketplace_partner_distribution_disabled: 'MARKETPLACE_PARTNER_DISTRIBUTION_DISABLED',
        marketplace_partner_listing_country_not_match_catalog: 'MARKETPLACE_PARTNER_LISTING_COUNTRY_NOT_MATCH_CATALOG',
        marketplace_partner_listing_limit_exceeded: 'MARKETPLACE_PARTNER_LISTING_LIMIT_EXCEEDED',
        marketplace_partner_missing_latlong: 'MARKETPLACE_PARTNER_MISSING_LATLONG',
        marketplace_partner_missing_shipping_cost: 'MARKETPLACE_PARTNER_MISSING_SHIPPING_COST',
        marketplace_partner_not_local_item: 'MARKETPLACE_PARTNER_NOT_LOCAL_ITEM',
        marketplace_partner_not_shipped_item: 'MARKETPLACE_PARTNER_NOT_SHIPPED_ITEM',
        marketplace_partner_policy_violation: 'MARKETPLACE_PARTNER_POLICY_VIOLATION',
        marketplace_partner_rule_listing_limit_exceeded: 'MARKETPLACE_PARTNER_RULE_LISTING_LIMIT_EXCEEDED',
        marketplace_partner_seller_banned: 'MARKETPLACE_PARTNER_SELLER_BANNED',
        marketplace_partner_seller_not_valid: 'MARKETPLACE_PARTNER_SELLER_NOT_VALID',
        mini_shops_disabled_by_user: 'MINI_SHOPS_DISABLED_BY_USER',
        missing_checkout: 'MISSING_CHECKOUT',
        missing_checkout_currency: 'MISSING_CHECKOUT_CURRENCY',
        missing_color: 'MISSING_COLOR',
        missing_country_override_in_shipping_profile: 'MISSING_COUNTRY_OVERRIDE_IN_SHIPPING_PROFILE',
        missing_event: 'MISSING_EVENT',
        missing_india_compliance_fields: 'MISSING_INDIA_COMPLIANCE_FIELDS',
        missing_shipping_profile: 'MISSING_SHIPPING_PROFILE',
        missing_size: 'MISSING_SIZE',
        missing_tax_category: 'MISSING_TAX_CATEGORY',
        negative_community_feedback: 'NEGATIVE_COMMUNITY_FEEDBACK',
        negative_price: 'NEGATIVE_PRICE',
        not_enough_images: 'NOT_ENOUGH_IMAGES',
        not_enough_unique_products: 'NOT_ENOUGH_UNIQUE_PRODUCTS',
        no_content_id: 'NO_CONTENT_ID',
        overlay_disclaimer_exceeded_max_length: 'OVERLAY_DISCLAIMER_EXCEEDED_MAX_LENGTH',
        part_of_product_launch: 'PART_OF_PRODUCT_LAUNCH',
        passing_multiple_content_ids: 'PASSING_MULTIPLE_CONTENT_IDS',
        product_dominant_currency_mismatch: 'PRODUCT_DOMINANT_CURRENCY_MISMATCH',
        product_expired: 'PRODUCT_EXPIRED',
        product_item_hidden_from_all_shops: 'PRODUCT_ITEM_HIDDEN_FROM_ALL_SHOPS',
        product_item_invalid_partner_tokens: 'PRODUCT_ITEM_INVALID_PARTNER_TOKENS',
        product_item_not_included_in_any_shop: 'PRODUCT_ITEM_NOT_INCLUDED_IN_ANY_SHOP',
        product_item_not_visible: 'PRODUCT_ITEM_NOT_VISIBLE',
        product_not_approved: 'PRODUCT_NOT_APPROVED',
        product_not_dominant_currency: 'PRODUCT_NOT_DOMINANT_CURRENCY',
        product_out_of_stock: 'PRODUCT_OUT_OF_STOCK',
        product_url_equals_domain: 'PRODUCT_URL_EQUALS_DOMAIN',
        property_price_currency_not_supported: 'PROPERTY_PRICE_CURRENCY_NOT_SUPPORTED',
        property_price_too_high: 'PROPERTY_PRICE_TOO_HIGH',
        property_price_too_low: 'PROPERTY_PRICE_TOO_LOW',
        property_unit_price_currency_mismatch_item_price_currency: 'PROPERTY_UNIT_PRICE_CURRENCY_MISMATCH_ITEM_PRICE_CURRENCY',
        property_value_contains_html_tags: 'PROPERTY_VALUE_CONTAINS_HTML_TAGS',
        property_value_description_contains_off_platform_link: 'PROPERTY_VALUE_DESCRIPTION_CONTAINS_OFF_PLATFORM_LINK',
        property_value_format: 'PROPERTY_VALUE_FORMAT',
        property_value_missing: 'PROPERTY_VALUE_MISSING',
        property_value_missing_warning: 'PROPERTY_VALUE_MISSING_WARNING',
        property_value_non_positive: 'PROPERTY_VALUE_NON_POSITIVE',
        property_value_string_exceeds_length: 'PROPERTY_VALUE_STRING_EXCEEDS_LENGTH',
        property_value_string_too_short: 'PROPERTY_VALUE_STRING_TOO_SHORT',
        property_value_uppercase: 'PROPERTY_VALUE_UPPERCASE',
        property_value_uppercase_warning: 'PROPERTY_VALUE_UPPERCASE_WARNING',
        purchase_rate_below_addtocart: 'PURCHASE_RATE_BELOW_ADDTOCART',
        purchase_rate_below_viewcontent: 'PURCHASE_RATE_BELOW_VIEWCONTENT',
        quality_duplicated_description: 'QUALITY_DUPLICATED_DESCRIPTION',
        quality_item_link_broken: 'QUALITY_ITEM_LINK_BROKEN',
        quality_item_link_redirecting: 'QUALITY_ITEM_LINK_REDIRECTING',
        retailer_id_not_provided: 'RETAILER_ID_NOT_PROVIDED',
        retailer_id_used_by_group: 'RETAILER_ID_USED_BY_GROUP',
        shopify_invalid_retailer_id: 'SHOPIFY_INVALID_RETAILER_ID',
        shopify_item_missing_shipping_profile: 'SHOPIFY_ITEM_MISSING_SHIPPING_PROFILE',
        shops_policy_violation: 'SHOPS_POLICY_VIOLATION',
        subscription_info_not_enabled_for_feed: 'SUBSCRIPTION_INFO_NOT_ENABLED_FOR_FEED',
        tax_category_not_supported_in_uk: 'TAX_CATEGORY_NOT_SUPPORTED_IN_UK',
        unique_product_identifier_missing: 'UNIQUE_PRODUCT_IDENTIFIER_MISSING',
        unmatched_events: 'UNMATCHED_EVENTS',
        unsupported_product_category: 'UNSUPPORTED_PRODUCT_CATEGORY',
        variant_attribute_issue: 'VARIANT_ATTRIBUTE_ISSUE',
        video_fetch_failed: 'VIDEO_FETCH_FAILED',
        video_fetch_failed_bad_gateway: 'VIDEO_FETCH_FAILED_BAD_GATEWAY',
        video_fetch_failed_file_size_exceeded: 'VIDEO_FETCH_FAILED_FILE_SIZE_EXCEEDED',
        video_fetch_failed_forbidden: 'VIDEO_FETCH_FAILED_FORBIDDEN',
        video_fetch_failed_link_broken: 'VIDEO_FETCH_FAILED_LINK_BROKEN',
        video_fetch_failed_timed_out: 'VIDEO_FETCH_FAILED_TIMED_OUT',
        video_issue_generic: 'VIDEO_ISSUE_GENERIC',
        video_not_downloadable: 'VIDEO_NOT_DOWNLOADABLE',
        whatsapp_disabled_by_user: 'WHATSAPP_DISABLED_BY_USER',
        whatsapp_marketing_message_disabled_by_user: 'WHATSAPP_MARKETING_MESSAGE_DISABLED_BY_USER',
        whatsapp_marketing_message_policy_violation: 'WHATSAPP_MARKETING_MESSAGE_POLICY_VIOLATION',
        whatsapp_policy_violation: 'WHATSAPP_POLICY_VIOLATION'
      });
    }
  }, {
    key: 'MarkedForProductLaunch',
    get: function get() {
      return Object.freeze({
        default: 'default',
        marked: 'marked',
        not_marked: 'not_marked'
      });
    }
  }, {
    key: 'OriginCountry',
    get: function get() {
      return Object.freeze({
        ac: 'AC',
        ad: 'AD',
        ae: 'AE',
        af: 'AF',
        ag: 'AG',
        ai: 'AI',
        al: 'AL',
        am: 'AM',
        an: 'AN',
        ao: 'AO',
        aq: 'AQ',
        ar: 'AR',
        as: 'AS',
        at: 'AT',
        au: 'AU',
        aw: 'AW',
        ax: 'AX',
        az: 'AZ',
        ba: 'BA',
        bb: 'BB',
        bd: 'BD',
        be: 'BE',
        bf: 'BF',
        bg: 'BG',
        bh: 'BH',
        bi: 'BI',
        bj: 'BJ',
        bl: 'BL',
        bm: 'BM',
        bn: 'BN',
        bo: 'BO',
        bq: 'BQ',
        br: 'BR',
        bs: 'BS',
        bt: 'BT',
        bv: 'BV',
        bw: 'BW',
        by: 'BY',
        bz: 'BZ',
        ca: 'CA',
        cc: 'CC',
        cd: 'CD',
        cf: 'CF',
        cg: 'CG',
        ch: 'CH',
        ci: 'CI',
        ck: 'CK',
        cl: 'CL',
        cm: 'CM',
        cn: 'CN',
        co: 'CO',
        cr: 'CR',
        cu: 'CU',
        cv: 'CV',
        cw: 'CW',
        cx: 'CX',
        cy: 'CY',
        cz: 'CZ',
        de: 'DE',
        dj: 'DJ',
        dk: 'DK',
        dm: 'DM',
        do: 'DO',
        dz: 'DZ',
        ec: 'EC',
        ee: 'EE',
        eg: 'EG',
        eh: 'EH',
        er: 'ER',
        es: 'ES',
        et: 'ET',
        fi: 'FI',
        fj: 'FJ',
        fk: 'FK',
        fm: 'FM',
        fo: 'FO',
        fr: 'FR',
        ga: 'GA',
        gb: 'GB',
        gd: 'GD',
        ge: 'GE',
        gf: 'GF',
        gg: 'GG',
        gh: 'GH',
        gi: 'GI',
        gl: 'GL',
        gm: 'GM',
        gn: 'GN',
        gp: 'GP',
        gq: 'GQ',
        gr: 'GR',
        gs: 'GS',
        gt: 'GT',
        gu: 'GU',
        gw: 'GW',
        gy: 'GY',
        hk: 'HK',
        hm: 'HM',
        hn: 'HN',
        hr: 'HR',
        ht: 'HT',
        hu: 'HU',
        id: 'ID',
        ie: 'IE',
        il: 'IL',
        im: 'IM',
        in: 'IN',
        io: 'IO',
        iq: 'IQ',
        ir: 'IR',
        is: 'IS',
        it: 'IT',
        je: 'JE',
        jm: 'JM',
        jo: 'JO',
        jp: 'JP',
        ke: 'KE',
        kg: 'KG',
        kh: 'KH',
        ki: 'KI',
        km: 'KM',
        kn: 'KN',
        kp: 'KP',
        kr: 'KR',
        kw: 'KW',
        ky: 'KY',
        kz: 'KZ',
        la: 'LA',
        lb: 'LB',
        lc: 'LC',
        li: 'LI',
        lk: 'LK',
        lr: 'LR',
        ls: 'LS',
        lt: 'LT',
        lu: 'LU',
        lv: 'LV',
        ly: 'LY',
        ma: 'MA',
        mc: 'MC',
        md: 'MD',
        me: 'ME',
        mf: 'MF',
        mg: 'MG',
        mh: 'MH',
        mk: 'MK',
        ml: 'ML',
        mm: 'MM',
        mn: 'MN',
        mo: 'MO',
        mp: 'MP',
        mq: 'MQ',
        mr: 'MR',
        ms: 'MS',
        mt: 'MT',
        mu: 'MU',
        mv: 'MV',
        mw: 'MW',
        mx: 'MX',
        my: 'MY',
        mz: 'MZ',
        na: 'NA',
        nc: 'NC',
        ne: 'NE',
        nf: 'NF',
        ng: 'NG',
        ni: 'NI',
        nl: 'NL',
        no: 'NO',
        np: 'NP',
        nr: 'NR',
        nu: 'NU',
        nz: 'NZ',
        om: 'OM',
        pa: 'PA',
        pe: 'PE',
        pf: 'PF',
        pg: 'PG',
        ph: 'PH',
        pk: 'PK',
        pl: 'PL',
        pm: 'PM',
        pn: 'PN',
        pr: 'PR',
        ps: 'PS',
        pt: 'PT',
        pw: 'PW',
        py: 'PY',
        qa: 'QA',
        re: 'RE',
        ro: 'RO',
        rs: 'RS',
        ru: 'RU',
        rw: 'RW',
        sa: 'SA',
        sb: 'SB',
        sc: 'SC',
        sd: 'SD',
        se: 'SE',
        sg: 'SG',
        sh: 'SH',
        si: 'SI',
        sj: 'SJ',
        sk: 'SK',
        sl: 'SL',
        sm: 'SM',
        sn: 'SN',
        so: 'SO',
        sr: 'SR',
        ss: 'SS',
        st: 'ST',
        sv: 'SV',
        sx: 'SX',
        sy: 'SY',
        sz: 'SZ',
        tc: 'TC',
        td: 'TD',
        tf: 'TF',
        tg: 'TG',
        th: 'TH',
        tj: 'TJ',
        tk: 'TK',
        tl: 'TL',
        tm: 'TM',
        tn: 'TN',
        to: 'TO',
        tr: 'TR',
        tt: 'TT',
        tv: 'TV',
        tw: 'TW',
        tz: 'TZ',
        ua: 'UA',
        ug: 'UG',
        um: 'UM',
        us: 'US',
        uy: 'UY',
        uz: 'UZ',
        va: 'VA',
        vc: 'VC',
        ve: 'VE',
        vg: 'VG',
        vi: 'VI',
        vn: 'VN',
        vu: 'VU',
        wf: 'WF',
        ws: 'WS',
        xk: 'XK',
        ye: 'YE',
        yt: 'YT',
        za: 'ZA',
        zm: 'ZM',
        zw: 'ZW'
      });
    }
  }, {
    key: 'WaComplianceCategory',
    get: function get() {
      return Object.freeze({
        country_origin_exempt: 'COUNTRY_ORIGIN_EXEMPT',
        default: 'DEFAULT'
      });
    }
  }]);
  return ProductItem;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductFeedRule
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductFeedRule = function (_AbstractCrudObject) {
  inherits(ProductFeedRule, _AbstractCrudObject);

  function ProductFeedRule() {
    classCallCheck(this, ProductFeedRule);
    return possibleConstructorReturn(this, (ProductFeedRule.__proto__ || Object.getPrototypeOf(ProductFeedRule)).apply(this, arguments));
  }

  createClass(ProductFeedRule, [{
    key: 'delete',


    // $FlowFixMe : Support Generic Types
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(ProductFeedRule.prototype.__proto__ || Object.getPrototypeOf(ProductFeedRule.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(ProductFeedRule.prototype.__proto__ || Object.getPrototypeOf(ProductFeedRule.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        attribute: 'attribute',
        id: 'id',
        params: 'params',
        rule_type: 'rule_type'
      });
    }
  }, {
    key: 'RuleType',
    get: function get() {
      return Object.freeze({
        fallback_rule: 'fallback_rule',
        letter_case_rule: 'letter_case_rule',
        mapping_rule: 'mapping_rule',
        regex_replace_rule: 'regex_replace_rule',
        value_mapping_rule: 'value_mapping_rule'
      });
    }
  }]);
  return ProductFeedRule;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductFeedSchedule
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductFeedSchedule = function (_AbstractCrudObject) {
  inherits(ProductFeedSchedule, _AbstractCrudObject);

  function ProductFeedSchedule() {
    classCallCheck(this, ProductFeedSchedule);
    return possibleConstructorReturn(this, (ProductFeedSchedule.__proto__ || Object.getPrototypeOf(ProductFeedSchedule)).apply(this, arguments));
  }

  createClass(ProductFeedSchedule, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        day_of_month: 'day_of_month',
        day_of_week: 'day_of_week',
        hour: 'hour',
        id: 'id',
        interval: 'interval',
        interval_count: 'interval_count',
        minute: 'minute',
        timezone: 'timezone',
        url: 'url',
        username: 'username'
      });
    }
  }, {
    key: 'Interval',
    get: function get() {
      return Object.freeze({
        daily: 'DAILY',
        hourly: 'HOURLY',
        monthly: 'MONTHLY',
        weekly: 'WEEKLY'
      });
    }
  }]);
  return ProductFeedSchedule;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductFeedUploadErrorSample
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductFeedUploadErrorSample = function (_AbstractCrudObject) {
  inherits(ProductFeedUploadErrorSample, _AbstractCrudObject);

  function ProductFeedUploadErrorSample() {
    classCallCheck(this, ProductFeedUploadErrorSample);
    return possibleConstructorReturn(this, (ProductFeedUploadErrorSample.__proto__ || Object.getPrototypeOf(ProductFeedUploadErrorSample)).apply(this, arguments));
  }

  createClass(ProductFeedUploadErrorSample, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        retailer_id: 'retailer_id',
        row_number: 'row_number'
      });
    }
  }]);
  return ProductFeedUploadErrorSample;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductFeedRuleSuggestion
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductFeedRuleSuggestion = function (_AbstractCrudObject) {
  inherits(ProductFeedRuleSuggestion, _AbstractCrudObject);

  function ProductFeedRuleSuggestion() {
    classCallCheck(this, ProductFeedRuleSuggestion);
    return possibleConstructorReturn(this, (ProductFeedRuleSuggestion.__proto__ || Object.getPrototypeOf(ProductFeedRuleSuggestion)).apply(this, arguments));
  }

  createClass(ProductFeedRuleSuggestion, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        attribute: 'attribute',
        params: 'params',
        type: 'type'
      });
    }
  }]);
  return ProductFeedRuleSuggestion;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductFeedUploadError
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductFeedUploadError = function (_AbstractCrudObject) {
  inherits(ProductFeedUploadError, _AbstractCrudObject);

  function ProductFeedUploadError() {
    classCallCheck(this, ProductFeedUploadError);
    return possibleConstructorReturn(this, (ProductFeedUploadError.__proto__ || Object.getPrototypeOf(ProductFeedUploadError)).apply(this, arguments));
  }

  createClass(ProductFeedUploadError, [{
    key: 'getSamples',
    value: function getSamples(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductFeedUploadErrorSample, fields, params, fetchFirstPage, '/samples');
    }
  }, {
    key: 'getSuggestedRules',
    value: function getSuggestedRules(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductFeedRuleSuggestion, fields, params, fetchFirstPage, '/suggested_rules');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        affected_surfaces: 'affected_surfaces',
        description: 'description',
        error_type: 'error_type',
        id: 'id',
        severity: 'severity',
        summary: 'summary',
        total_count: 'total_count'
      });
    }
  }, {
    key: 'AffectedSurfaces',
    get: function get() {
      return Object.freeze({
        dynamic_ads: 'Dynamic Ads',
        marketplace: 'Marketplace',
        us_marketplace: 'US Marketplace'
      });
    }
  }, {
    key: 'Severity',
    get: function get() {
      return Object.freeze({
        fatal: 'fatal',
        warning: 'warning'
      });
    }
  }, {
    key: 'ErrorPriority',
    get: function get() {
      return Object.freeze({
        high: 'HIGH',
        low: 'LOW',
        medium: 'MEDIUM'
      });
    }
  }]);
  return ProductFeedUploadError;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductFeedUpload
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductFeedUpload = function (_AbstractCrudObject) {
  inherits(ProductFeedUpload, _AbstractCrudObject);

  function ProductFeedUpload() {
    classCallCheck(this, ProductFeedUpload);
    return possibleConstructorReturn(this, (ProductFeedUpload.__proto__ || Object.getPrototypeOf(ProductFeedUpload)).apply(this, arguments));
  }

  createClass(ProductFeedUpload, [{
    key: 'createErrorReport',
    value: function createErrorReport(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/error_report', fields, params, ProductFeedUpload, pathOverride);
    }
  }, {
    key: 'getErrors',
    value: function getErrors(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductFeedUploadError, fields, params, fetchFirstPage, '/errors');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        end_time: 'end_time',
        error_count: 'error_count',
        error_report: 'error_report',
        filename: 'filename',
        id: 'id',
        input_method: 'input_method',
        num_deleted_items: 'num_deleted_items',
        num_detected_items: 'num_detected_items',
        num_invalid_items: 'num_invalid_items',
        num_persisted_items: 'num_persisted_items',
        start_time: 'start_time',
        url: 'url',
        warning_count: 'warning_count'
      });
    }
  }, {
    key: 'InputMethod',
    get: function get() {
      return Object.freeze({
        google_sheets_fetch: 'Google Sheets Fetch',
        manual_upload: 'Manual Upload',
        reupload_last_file: 'Reupload Last File',
        server_fetch: 'Server Fetch',
        user_initiated_server_fetch: 'User initiated server fetch'
      });
    }
  }]);
  return ProductFeedUpload;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductFeed
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductFeed = function (_AbstractCrudObject) {
  inherits(ProductFeed, _AbstractCrudObject);

  function ProductFeed() {
    classCallCheck(this, ProductFeed);
    return possibleConstructorReturn(this, (ProductFeed.__proto__ || Object.getPrototypeOf(ProductFeed)).apply(this, arguments));
  }

  createClass(ProductFeed, [{
    key: 'getAutomotiveModels',
    value: function getAutomotiveModels(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AutomotiveModel, fields, params, fetchFirstPage, '/automotive_models');
    }
  }, {
    key: 'getDestinations',
    value: function getDestinations(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Destination, fields, params, fetchFirstPage, '/destinations');
    }
  }, {
    key: 'getFlights',
    value: function getFlights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Flight, fields, params, fetchFirstPage, '/flights');
    }
  }, {
    key: 'getHomeListings',
    value: function getHomeListings(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(HomeListing, fields, params, fetchFirstPage, '/home_listings');
    }
  }, {
    key: 'getHotels',
    value: function getHotels(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Hotel, fields, params, fetchFirstPage, '/hotels');
    }
  }, {
    key: 'getMediaTitles',
    value: function getMediaTitles(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(MediaTitle, fields, params, fetchFirstPage, '/media_titles');
    }
  }, {
    key: 'getProducts',
    value: function getProducts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductItem, fields, params, fetchFirstPage, '/products');
    }
  }, {
    key: 'getRules',
    value: function getRules(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductFeedRule, fields, params, fetchFirstPage, '/rules');
    }
  }, {
    key: 'createRule',
    value: function createRule(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/rules', fields, params, ProductFeedRule, pathOverride);
    }
  }, {
    key: 'createSupplementaryFeedAssoc',
    value: function createSupplementaryFeedAssoc(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/supplementary_feed_assocs', fields, params, null, pathOverride);
    }
  }, {
    key: 'getUploadSchedules',
    value: function getUploadSchedules(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductFeedSchedule, fields, params, fetchFirstPage, '/upload_schedules');
    }
  }, {
    key: 'createUploadSchedule',
    value: function createUploadSchedule(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/upload_schedules', fields, params, ProductFeed, pathOverride);
    }
  }, {
    key: 'getUploads',
    value: function getUploads(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductFeedUpload, fields, params, fetchFirstPage, '/uploads');
    }
  }, {
    key: 'createUpload',
    value: function createUpload(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/uploads', fields, params, ProductFeedUpload, pathOverride);
    }
  }, {
    key: 'getVehicleOffers',
    value: function getVehicleOffers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(VehicleOffer, fields, params, fetchFirstPage, '/vehicle_offers');
    }
  }, {
    key: 'getVehicles',
    value: function getVehicles(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Vehicle, fields, params, fetchFirstPage, '/vehicles');
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(ProductFeed.prototype.__proto__ || Object.getPrototypeOf(ProductFeed.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(ProductFeed.prototype.__proto__ || Object.getPrototypeOf(ProductFeed.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        country: 'country',
        created_time: 'created_time',
        default_currency: 'default_currency',
        deletion_enabled: 'deletion_enabled',
        delimiter: 'delimiter',
        encoding: 'encoding',
        file_name: 'file_name',
        id: 'id',
        ingestion_source_type: 'ingestion_source_type',
        item_sub_type: 'item_sub_type',
        latest_upload: 'latest_upload',
        migrated_from_feed_id: 'migrated_from_feed_id',
        name: 'name',
        override_type: 'override_type',
        primary_feeds: 'primary_feeds',
        product_count: 'product_count',
        quoted_fields_mode: 'quoted_fields_mode',
        schedule: 'schedule',
        supplementary_feeds: 'supplementary_feeds',
        update_schedule: 'update_schedule'
      });
    }
  }, {
    key: 'Delimiter',
    get: function get() {
      return Object.freeze({
        autodetect: 'AUTODETECT',
        bar: 'BAR',
        comma: 'COMMA',
        semicolon: 'SEMICOLON',
        tab: 'TAB',
        tilde: 'TILDE'
      });
    }
  }, {
    key: 'IngestionSourceType',
    get: function get() {
      return Object.freeze({
        primary_feed: 'primary_feed',
        supplementary_feed: 'supplementary_feed'
      });
    }
  }, {
    key: 'QuotedFieldsMode',
    get: function get() {
      return Object.freeze({
        autodetect: 'AUTODETECT',
        off: 'OFF',
        on: 'ON'
      });
    }
  }, {
    key: 'Encoding',
    get: function get() {
      return Object.freeze({
        autodetect: 'AUTODETECT',
        latin1: 'LATIN1',
        utf16be: 'UTF16BE',
        utf16le: 'UTF16LE',
        utf32be: 'UTF32BE',
        utf32le: 'UTF32LE',
        utf8: 'UTF8'
      });
    }
  }, {
    key: 'FeedType',
    get: function get() {
      return Object.freeze({
        automotive_model: 'AUTOMOTIVE_MODEL',
        collection: 'COLLECTION',
        destination: 'DESTINATION',
        flight: 'FLIGHT',
        home_listing: 'HOME_LISTING',
        hotel: 'HOTEL',
        hotel_room: 'HOTEL_ROOM',
        local_inventory: 'LOCAL_INVENTORY',
        media_title: 'MEDIA_TITLE',
        offer: 'OFFER',
        products: 'PRODUCTS',
        product_ratings_and_reviews: 'PRODUCT_RATINGS_AND_REVIEWS',
        transactable_items: 'TRANSACTABLE_ITEMS',
        vehicles: 'VEHICLES',
        vehicle_offer: 'VEHICLE_OFFER'
      });
    }
  }, {
    key: 'ItemSubType',
    get: function get() {
      return Object.freeze({
        appliances: 'APPLIANCES',
        baby_feeding: 'BABY_FEEDING',
        baby_transport: 'BABY_TRANSPORT',
        beauty: 'BEAUTY',
        bedding: 'BEDDING',
        cameras: 'CAMERAS',
        cell_phones_and_smart_watches: 'CELL_PHONES_AND_SMART_WATCHES',
        cleaning_supplies: 'CLEANING_SUPPLIES',
        clothing: 'CLOTHING',
        clothing_accessories: 'CLOTHING_ACCESSORIES',
        computers_and_tablets: 'COMPUTERS_AND_TABLETS',
        diapering_and_potty_training: 'DIAPERING_AND_POTTY_TRAINING',
        electronics_accessories: 'ELECTRONICS_ACCESSORIES',
        furniture: 'FURNITURE',
        health: 'HEALTH',
        home_goods: 'HOME_GOODS',
        jewelry: 'JEWELRY',
        nursery: 'NURSERY',
        printers_and_scanners: 'PRINTERS_AND_SCANNERS',
        projectors: 'PROJECTORS',
        shoes_and_footwear: 'SHOES_AND_FOOTWEAR',
        software: 'SOFTWARE',
        toys: 'TOYS',
        tvs_and_monitors: 'TVS_AND_MONITORS',
        video_game_consoles_and_video_games: 'VIDEO_GAME_CONSOLES_AND_VIDEO_GAMES',
        watches: 'WATCHES'
      });
    }
  }, {
    key: 'OverrideType',
    get: function get() {
      return Object.freeze({
        batch_api_language_or_country: 'BATCH_API_LANGUAGE_OR_COUNTRY',
        catalog_segment_customize_default: 'CATALOG_SEGMENT_CUSTOMIZE_DEFAULT',
        country: 'COUNTRY',
        language: 'LANGUAGE',
        language_and_country: 'LANGUAGE_AND_COUNTRY',
        local: 'LOCAL',
        smart_pixel_language_or_country: 'SMART_PIXEL_LANGUAGE_OR_COUNTRY',
        version: 'VERSION'
      });
    }
  }, {
    key: 'UseCase',
    get: function get() {
      return Object.freeze({
        creator_asset: 'CREATOR_ASSET'
      });
    }
  }]);
  return ProductFeed;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductGroup
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductGroup = function (_AbstractCrudObject) {
  inherits(ProductGroup, _AbstractCrudObject);

  function ProductGroup() {
    classCallCheck(this, ProductGroup);
    return possibleConstructorReturn(this, (ProductGroup.__proto__ || Object.getPrototypeOf(ProductGroup)).apply(this, arguments));
  }

  createClass(ProductGroup, [{
    key: 'getProducts',
    value: function getProducts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductItem, fields, params, fetchFirstPage, '/products');
    }
  }, {
    key: 'createProduct',
    value: function createProduct(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/products', fields, params, ProductItem, pathOverride);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(ProductGroup.prototype.__proto__ || Object.getPrototypeOf(ProductGroup.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(ProductGroup.prototype.__proto__ || Object.getPrototypeOf(ProductGroup.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        product_catalog: 'product_catalog',
        retailer_id: 'retailer_id',
        variants: 'variants'
      });
    }
  }]);
  return ProductGroup;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductCatalogProductSetsBatch
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductCatalogProductSetsBatch = function (_AbstractCrudObject) {
  inherits(ProductCatalogProductSetsBatch, _AbstractCrudObject);

  function ProductCatalogProductSetsBatch() {
    classCallCheck(this, ProductCatalogProductSetsBatch);
    return possibleConstructorReturn(this, (ProductCatalogProductSetsBatch.__proto__ || Object.getPrototypeOf(ProductCatalogProductSetsBatch)).apply(this, arguments));
  }

  createClass(ProductCatalogProductSetsBatch, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        errors: 'errors',
        errors_total_count: 'errors_total_count',
        handle: 'handle',
        status: 'status'
      });
    }
  }]);
  return ProductCatalogProductSetsBatch;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CatalogContentVersionConfig
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CatalogContentVersionConfig = function (_AbstractCrudObject) {
  inherits(CatalogContentVersionConfig, _AbstractCrudObject);

  function CatalogContentVersionConfig() {
    classCallCheck(this, CatalogContentVersionConfig);
    return possibleConstructorReturn(this, (CatalogContentVersionConfig.__proto__ || Object.getPrototypeOf(CatalogContentVersionConfig)).apply(this, arguments));
  }

  createClass(CatalogContentVersionConfig, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        name: 'name',
        version: 'version'
      });
    }
  }]);
  return CatalogContentVersionConfig;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ProductCatalog
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ProductCatalog = function (_AbstractCrudObject) {
  inherits(ProductCatalog, _AbstractCrudObject);

  function ProductCatalog() {
    classCallCheck(this, ProductCatalog);
    return possibleConstructorReturn(this, (ProductCatalog.__proto__ || Object.getPrototypeOf(ProductCatalog)).apply(this, arguments));
  }

  createClass(ProductCatalog, [{
    key: 'deleteAgencies',
    value: function deleteAgencies() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(ProductCatalog.prototype.__proto__ || Object.getPrototypeOf(ProductCatalog.prototype), 'deleteEdge', this).call(this, '/agencies', params);
    }
  }, {
    key: 'getAgencies',
    value: function getAgencies(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Business, fields, params, fetchFirstPage, '/agencies');
    }
  }, {
    key: 'createAgency',
    value: function createAgency(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/agencies', fields, params, ProductCatalog, pathOverride);
    }
  }, {
    key: 'deleteAssignedUsers',
    value: function deleteAssignedUsers() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(ProductCatalog.prototype.__proto__ || Object.getPrototypeOf(ProductCatalog.prototype), 'deleteEdge', this).call(this, '/assigned_users', params);
    }
  }, {
    key: 'getAssignedUsers',
    value: function getAssignedUsers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AssignedUser, fields, params, fetchFirstPage, '/assigned_users');
    }
  }, {
    key: 'createAssignedUser',
    value: function createAssignedUser(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/assigned_users', fields, params, ProductCatalog, pathOverride);
    }
  }, {
    key: 'getAutomotiveModels',
    value: function getAutomotiveModels(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AutomotiveModel, fields, params, fetchFirstPage, '/automotive_models');
    }
  }, {
    key: 'createBatch',
    value: function createBatch(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/batch', fields, params, ProductCatalog, pathOverride);
    }
  }, {
    key: 'createCatalogStore',
    value: function createCatalogStore(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/catalog_store', fields, params, StoreCatalogSettings, pathOverride);
    }
  }, {
    key: 'getCategories',
    value: function getCategories(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductCatalogCategory, fields, params, fetchFirstPage, '/categories');
    }
  }, {
    key: 'createCategory',
    value: function createCategory(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/categories', fields, params, ProductCatalogCategory, pathOverride);
    }
  }, {
    key: 'getCheckBatchRequestStatus',
    value: function getCheckBatchRequestStatus(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CheckBatchRequestStatus, fields, params, fetchFirstPage, '/check_batch_request_status');
    }
  }, {
    key: 'getCheckMarketplacePartnerDealsStatus',
    value: function getCheckMarketplacePartnerDealsStatus(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductCatalogCheckMarketplacePartnerDealsStatus, fields, params, fetchFirstPage, '/check_marketplace_partner_deals_status');
    }
  }, {
    key: 'getCheckMarketplacePartnerSellersStatus',
    value: function getCheckMarketplacePartnerSellersStatus(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductCatalogCheckMarketplacePartnerSellersStatus, fields, params, fetchFirstPage, '/check_marketplace_partner_sellers_status');
    }
  }, {
    key: 'getCollaborativeAdsLsbImageBank',
    value: function getCollaborativeAdsLsbImageBank(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CPASLsbImageBank, fields, params, fetchFirstPage, '/collaborative_ads_lsb_image_bank');
    }
  }, {
    key: 'getCollaborativeAdsShareSettings',
    value: function getCollaborativeAdsShareSettings(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CollaborativeAdsShareSettings, fields, params, fetchFirstPage, '/collaborative_ads_share_settings');
    }
  }, {
    key: 'createCpasLsbImageBank',
    value: function createCpasLsbImageBank(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/cpas_lsb_image_bank', fields, params, CPASLsbImageBank, pathOverride);
    }
  }, {
    key: 'getCreatorAssetCreatives',
    value: function getCreatorAssetCreatives(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CreatorAssetCreative, fields, params, fetchFirstPage, '/creator_asset_creatives');
    }
  }, {
    key: 'getDataSources',
    value: function getDataSources(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductCatalogDataSource, fields, params, fetchFirstPage, '/data_sources');
    }
  }, {
    key: 'getDestinations',
    value: function getDestinations(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Destination, fields, params, fetchFirstPage, '/destinations');
    }
  }, {
    key: 'getDiagnostics',
    value: function getDiagnostics(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductCatalogDiagnosticGroup, fields, params, fetchFirstPage, '/diagnostics');
    }
  }, {
    key: 'getEventStats',
    value: function getEventStats(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductEventStat, fields, params, fetchFirstPage, '/event_stats');
    }
  }, {
    key: 'deleteExternalEventSources',
    value: function deleteExternalEventSources() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(ProductCatalog.prototype.__proto__ || Object.getPrototypeOf(ProductCatalog.prototype), 'deleteEdge', this).call(this, '/external_event_sources', params);
    }
  }, {
    key: 'getExternalEventSources',
    value: function getExternalEventSources(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ExternalEventSource, fields, params, fetchFirstPage, '/external_event_sources');
    }
  }, {
    key: 'createExternalEventSource',
    value: function createExternalEventSource(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/external_event_sources', fields, params, ProductCatalog, pathOverride);
    }
  }, {
    key: 'getFlights',
    value: function getFlights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Flight, fields, params, fetchFirstPage, '/flights');
    }
  }, {
    key: 'createGeolocatedItemsBatch',
    value: function createGeolocatedItemsBatch(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/geolocated_items_batch', fields, params, ProductCatalog, pathOverride);
    }
  }, {
    key: 'getHomeListings',
    value: function getHomeListings(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(HomeListing, fields, params, fetchFirstPage, '/home_listings');
    }
  }, {
    key: 'createHomeListing',
    value: function createHomeListing(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/home_listings', fields, params, HomeListing, pathOverride);
    }
  }, {
    key: 'getHotelRoomsBatch',
    value: function getHotelRoomsBatch(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductCatalogHotelRoomsBatch, fields, params, fetchFirstPage, '/hotel_rooms_batch');
    }
  }, {
    key: 'createHotelRoomsBatch',
    value: function createHotelRoomsBatch(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/hotel_rooms_batch', fields, params, ProductCatalog, pathOverride);
    }
  }, {
    key: 'getHotels',
    value: function getHotels(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Hotel, fields, params, fetchFirstPage, '/hotels');
    }
  }, {
    key: 'createHotel',
    value: function createHotel(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/hotels', fields, params, Hotel, pathOverride);
    }
  }, {
    key: 'createItemsBatch',
    value: function createItemsBatch(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/items_batch', fields, params, ProductCatalog, pathOverride);
    }
  }, {
    key: 'createLocalizedItemsBatch',
    value: function createLocalizedItemsBatch(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/localized_items_batch', fields, params, ProductCatalog, pathOverride);
    }
  }, {
    key: 'createMarketPlacePartnerDealsDetail',
    value: function createMarketPlacePartnerDealsDetail(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/marketplace_partner_deals_details', fields, params, ProductCatalog, pathOverride);
    }
  }, {
    key: 'createMarketPlacePartnerSellersDetail',
    value: function createMarketPlacePartnerSellersDetail(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/marketplace_partner_sellers_details', fields, params, ProductCatalog, pathOverride);
    }
  }, {
    key: 'createMarketPlacePartnerSignal',
    value: function createMarketPlacePartnerSignal(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/marketplace_partner_signals', fields, params, ProductCatalog, pathOverride);
    }
  }, {
    key: 'getPricingVariablesBatch',
    value: function getPricingVariablesBatch(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductCatalogPricingVariablesBatch, fields, params, fetchFirstPage, '/pricing_variables_batch');
    }
  }, {
    key: 'createPricingVariablesBatch',
    value: function createPricingVariablesBatch(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/pricing_variables_batch', fields, params, ProductCatalog, pathOverride);
    }
  }, {
    key: 'getProductFeeds',
    value: function getProductFeeds(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductFeed, fields, params, fetchFirstPage, '/product_feeds');
    }
  }, {
    key: 'createProductFeed',
    value: function createProductFeed(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/product_feeds', fields, params, ProductFeed, pathOverride);
    }
  }, {
    key: 'getProductGroups',
    value: function getProductGroups(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductGroup, fields, params, fetchFirstPage, '/product_groups');
    }
  }, {
    key: 'createProductGroup',
    value: function createProductGroup(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/product_groups', fields, params, ProductGroup, pathOverride);
    }
  }, {
    key: 'getProductSets',
    value: function getProductSets(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductSet, fields, params, fetchFirstPage, '/product_sets');
    }
  }, {
    key: 'createProductSet',
    value: function createProductSet(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/product_sets', fields, params, ProductSet, pathOverride);
    }
  }, {
    key: 'getProductSetsBatch',
    value: function getProductSetsBatch(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductCatalogProductSetsBatch, fields, params, fetchFirstPage, '/product_sets_batch');
    }
  }, {
    key: 'getProducts',
    value: function getProducts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductItem, fields, params, fetchFirstPage, '/products');
    }
  }, {
    key: 'createProduct',
    value: function createProduct(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/products', fields, params, ProductItem, pathOverride);
    }
  }, {
    key: 'createUpdateGeneratedImageConfig',
    value: function createUpdateGeneratedImageConfig(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/update_generated_image_config', fields, params, ProductCatalog, pathOverride);
    }
  }, {
    key: 'getVehicleOffers',
    value: function getVehicleOffers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(VehicleOffer, fields, params, fetchFirstPage, '/vehicle_offers');
    }
  }, {
    key: 'getVehicles',
    value: function getVehicles(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Vehicle, fields, params, fetchFirstPage, '/vehicles');
    }
  }, {
    key: 'createVehicle',
    value: function createVehicle(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/vehicles', fields, params, Vehicle, pathOverride);
    }
  }, {
    key: 'getVersionConfigs',
    value: function getVersionConfigs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CatalogContentVersionConfig, fields, params, fetchFirstPage, '/version_configs');
    }
  }, {
    key: 'createVersionItemsBatch',
    value: function createVersionItemsBatch(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/version_items_batch', fields, params, ProductCatalog, pathOverride);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(ProductCatalog.prototype.__proto__ || Object.getPrototypeOf(ProductCatalog.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(ProductCatalog.prototype.__proto__ || Object.getPrototypeOf(ProductCatalog.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        ad_account_to_collaborative_ads_share_settings: 'ad_account_to_collaborative_ads_share_settings',
        agency_collaborative_ads_share_settings: 'agency_collaborative_ads_share_settings',
        business: 'business',
        catalog_store: 'catalog_store',
        commerce_merchant_settings: 'commerce_merchant_settings',
        creator_user: 'creator_user',
        da_display_settings: 'da_display_settings',
        default_image_url: 'default_image_url',
        fallback_image_url: 'fallback_image_url',
        feed_count: 'feed_count',
        id: 'id',
        is_catalog_segment: 'is_catalog_segment',
        is_local_catalog: 'is_local_catalog',
        name: 'name',
        owner_business: 'owner_business',
        product_count: 'product_count',
        store_catalog_settings: 'store_catalog_settings',
        user_access_expire_time: 'user_access_expire_time',
        vertical: 'vertical'
      });
    }
  }, {
    key: 'AdditionalVerticalOption',
    get: function get() {
      return Object.freeze({
        local_da_catalog: 'LOCAL_DA_CATALOG',
        local_products: 'LOCAL_PRODUCTS'
      });
    }
  }, {
    key: 'Vertical',
    get: function get() {
      return Object.freeze({
        adoptable_pets: 'adoptable_pets',
        commerce: 'commerce',
        destinations: 'destinations',
        flights: 'flights',
        generic: 'generic',
        home_listings: 'home_listings',
        hotels: 'hotels',
        local_service_businesses: 'local_service_businesses',
        offer_items: 'offer_items',
        offline_commerce: 'offline_commerce',
        transactable_items: 'transactable_items',
        vehicles: 'vehicles'
      });
    }
  }, {
    key: 'EnabledCollabTerms',
    get: function get() {
      return Object.freeze({
        enforce_create_new_ad_account: 'ENFORCE_CREATE_NEW_AD_ACCOUNT',
        enforce_share_ad_performance_access: 'ENFORCE_SHARE_AD_PERFORMANCE_ACCESS'
      });
    }
  }, {
    key: 'PermittedRoles',
    get: function get() {
      return Object.freeze({
        admin: 'ADMIN',
        advertiser: 'ADVERTISER'
      });
    }
  }, {
    key: 'PermittedTasks',
    get: function get() {
      return Object.freeze({
        aa_analyze: 'AA_ANALYZE',
        advertise: 'ADVERTISE',
        manage: 'MANAGE',
        manage_ar: 'MANAGE_AR'
      });
    }
  }, {
    key: 'Tasks',
    get: function get() {
      return Object.freeze({
        aa_analyze: 'AA_ANALYZE',
        advertise: 'ADVERTISE',
        manage: 'MANAGE',
        manage_ar: 'MANAGE_AR'
      });
    }
  }, {
    key: 'Standard',
    get: function get() {
      return Object.freeze({
        google: 'google'
      });
    }
  }, {
    key: 'ItemSubType',
    get: function get() {
      return Object.freeze({
        appliances: 'APPLIANCES',
        baby_feeding: 'BABY_FEEDING',
        baby_transport: 'BABY_TRANSPORT',
        beauty: 'BEAUTY',
        bedding: 'BEDDING',
        cameras: 'CAMERAS',
        cell_phones_and_smart_watches: 'CELL_PHONES_AND_SMART_WATCHES',
        cleaning_supplies: 'CLEANING_SUPPLIES',
        clothing: 'CLOTHING',
        clothing_accessories: 'CLOTHING_ACCESSORIES',
        computers_and_tablets: 'COMPUTERS_AND_TABLETS',
        diapering_and_potty_training: 'DIAPERING_AND_POTTY_TRAINING',
        electronics_accessories: 'ELECTRONICS_ACCESSORIES',
        furniture: 'FURNITURE',
        health: 'HEALTH',
        home_goods: 'HOME_GOODS',
        jewelry: 'JEWELRY',
        nursery: 'NURSERY',
        printers_and_scanners: 'PRINTERS_AND_SCANNERS',
        projectors: 'PROJECTORS',
        shoes_and_footwear: 'SHOES_AND_FOOTWEAR',
        software: 'SOFTWARE',
        toys: 'TOYS',
        tvs_and_monitors: 'TVS_AND_MONITORS',
        video_game_consoles_and_video_games: 'VIDEO_GAME_CONSOLES_AND_VIDEO_GAMES',
        watches: 'WATCHES'
      });
    }
  }, {
    key: 'EventName',
    get: function get() {
      return Object.freeze({
        add_to_cart: 'ADD_TO_CART',
        purchase: 'PURCHASE',
        test: 'TEST',
        view_item: 'VIEW_ITEM'
      });
    }
  }]);
  return ProductCatalog;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CommerceMerchantSettingsSetupStatus
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CommerceMerchantSettingsSetupStatus = function (_AbstractCrudObject) {
  inherits(CommerceMerchantSettingsSetupStatus, _AbstractCrudObject);

  function CommerceMerchantSettingsSetupStatus() {
    classCallCheck(this, CommerceMerchantSettingsSetupStatus);
    return possibleConstructorReturn(this, (CommerceMerchantSettingsSetupStatus.__proto__ || Object.getPrototypeOf(CommerceMerchantSettingsSetupStatus)).apply(this, arguments));
  }

  createClass(CommerceMerchantSettingsSetupStatus, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        deals_setup: 'deals_setup',
        marketplace_approval_status: 'marketplace_approval_status',
        marketplace_approval_status_details: 'marketplace_approval_status_details',
        payment_setup: 'payment_setup',
        review_status: 'review_status',
        shop_setup: 'shop_setup'
      });
    }
  }]);
  return CommerceMerchantSettingsSetupStatus;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Shop
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Shop = function (_AbstractCrudObject) {
  inherits(Shop, _AbstractCrudObject);

  function Shop() {
    classCallCheck(this, Shop);
    return possibleConstructorReturn(this, (Shop.__proto__ || Object.getPrototypeOf(Shop)).apply(this, arguments));
  }

  createClass(Shop, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        commerce_merchant_settings: 'commerce_merchant_settings',
        fb_sales_channel: 'fb_sales_channel',
        id: 'id',
        ig_sales_channel: 'ig_sales_channel',
        shop_status: 'shop_status',
        workspace: 'workspace'
      });
    }
  }]);
  return Shop;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CommerceMerchantSettings
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CommerceMerchantSettings = function (_AbstractCrudObject) {
  inherits(CommerceMerchantSettings, _AbstractCrudObject);

  function CommerceMerchantSettings() {
    classCallCheck(this, CommerceMerchantSettings);
    return possibleConstructorReturn(this, (CommerceMerchantSettings.__proto__ || Object.getPrototypeOf(CommerceMerchantSettings)).apply(this, arguments));
  }

  createClass(CommerceMerchantSettings, [{
    key: 'createAcknowledgeOrder',
    value: function createAcknowledgeOrder(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/acknowledge_orders', fields, params, CommerceMerchantSettings, pathOverride);
    }
  }, {
    key: 'getCommerceOrders',
    value: function getCommerceOrders(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CommerceOrder, fields, params, fetchFirstPage, '/commerce_orders');
    }
  }, {
    key: 'getCommercePayouts',
    value: function getCommercePayouts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CommercePayout, fields, params, fetchFirstPage, '/commerce_payouts');
    }
  }, {
    key: 'getCommerceTransactions',
    value: function getCommerceTransactions(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CommerceOrderTransactionDetail, fields, params, fetchFirstPage, '/commerce_transactions');
    }
  }, {
    key: 'getOrderManagementApps',
    value: function getOrderManagementApps(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Application, fields, params, fetchFirstPage, '/order_management_apps');
    }
  }, {
    key: 'getProductCatalogs',
    value: function getProductCatalogs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductCatalog, fields, params, fetchFirstPage, '/product_catalogs');
    }
  }, {
    key: 'getReturns',
    value: function getReturns(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/returns');
    }
  }, {
    key: 'getSetupStatus',
    value: function getSetupStatus(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CommerceMerchantSettingsSetupStatus, fields, params, fetchFirstPage, '/setup_status');
    }
  }, {
    key: 'createShippingProfile',
    value: function createShippingProfile(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/shipping_profiles', fields, params, null, pathOverride);
    }
  }, {
    key: 'getShops',
    value: function getShops(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Shop, fields, params, fetchFirstPage, '/shops');
    }
  }, {
    key: 'getTaxSettings',
    value: function getTaxSettings(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/tax_settings');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        checkout_config: 'checkout_config',
        checkout_message: 'checkout_message',
        contact_email: 'contact_email',
        cta: 'cta',
        display_name: 'display_name',
        facebook_channel: 'facebook_channel',
        id: 'id',
        instagram_channel: 'instagram_channel',
        korea_ftc_listing: 'korea_ftc_listing',
        merchant_page: 'merchant_page',
        merchant_status: 'merchant_status',
        offsite_iab_checkout_enabled_countries: 'offsite_iab_checkout_enabled_countries',
        payment_provider: 'payment_provider',
        privacy_policy_localized: 'privacy_policy_localized',
        return_policy_localized: 'return_policy_localized',
        shops_ads_setup: 'shops_ads_setup',
        terms: 'terms'
      });
    }
  }]);
  return CommerceMerchantSettings;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * UnifiedThread
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var UnifiedThread = function (_AbstractCrudObject) {
  inherits(UnifiedThread, _AbstractCrudObject);

  function UnifiedThread() {
    classCallCheck(this, UnifiedThread);
    return possibleConstructorReturn(this, (UnifiedThread.__proto__ || Object.getPrototypeOf(UnifiedThread)).apply(this, arguments));
  }

  createClass(UnifiedThread, [{
    key: 'getMessages',
    value: function getMessages(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/messages');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        can_reply: 'can_reply',
        folder: 'folder',
        former_participants: 'former_participants',
        id: 'id',
        is_owner: 'is_owner',
        is_subscribed: 'is_subscribed',
        link: 'link',
        linked_group: 'linked_group',
        message_count: 'message_count',
        name: 'name',
        participants: 'participants',
        scoped_thread_key: 'scoped_thread_key',
        senders: 'senders',
        snippet: 'snippet',
        unread_count: 'unread_count',
        updated_time: 'updated_time',
        wallpaper: 'wallpaper'
      });
    }
  }, {
    key: 'Platform',
    get: function get() {
      return Object.freeze({
        instagram: 'INSTAGRAM',
        messenger: 'MESSENGER'
      });
    }
  }]);
  return UnifiedThread;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * VideoCopyrightMatch
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var VideoCopyrightMatch = function (_AbstractCrudObject) {
  inherits(VideoCopyrightMatch, _AbstractCrudObject);

  function VideoCopyrightMatch() {
    classCallCheck(this, VideoCopyrightMatch);
    return possibleConstructorReturn(this, (VideoCopyrightMatch.__proto__ || Object.getPrototypeOf(VideoCopyrightMatch)).apply(this, arguments));
  }

  createClass(VideoCopyrightMatch, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        created_date: 'created_date',
        id: 'id',
        last_modified_user: 'last_modified_user',
        match_data: 'match_data',
        match_status: 'match_status',
        notes: 'notes',
        permalink: 'permalink',
        policy_eval_modify_reasons: 'policy_eval_modify_reasons',
        ugc_content_format: 'ugc_content_format'
      });
    }
  }, {
    key: 'Action',
    get: function get() {
      return Object.freeze({
        block: 'BLOCK',
        claim_ad_earnings: 'CLAIM_AD_EARNINGS',
        manual_review: 'MANUAL_REVIEW',
        monitor: 'MONITOR',
        request_takedown: 'REQUEST_TAKEDOWN'
      });
    }
  }, {
    key: 'ActionReason',
    get: function get() {
      return Object.freeze({
        article_17_preflagging: 'ARTICLE_17_PREFLAGGING',
        artist_objection: 'ARTIST_OBJECTION',
        objectionable_content: 'OBJECTIONABLE_CONTENT',
        premium_music_video: 'PREMIUM_MUSIC_VIDEO',
        prerelease_content: 'PRERELEASE_CONTENT',
        product_parameters: 'PRODUCT_PARAMETERS',
        restricted_content: 'RESTRICTED_CONTENT',
        unauthorized_commercial_use: 'UNAUTHORIZED_COMMERCIAL_USE'
      });
    }
  }, {
    key: 'MatchContentType',
    get: function get() {
      return Object.freeze({
        audio_only: 'AUDIO_ONLY',
        video_and_audio: 'VIDEO_AND_AUDIO',
        video_only: 'VIDEO_ONLY'
      });
    }
  }]);
  return VideoCopyrightMatch;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CTXOptimizationEligibility
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CTXOptimizationEligibility = function (_AbstractCrudObject) {
  inherits(CTXOptimizationEligibility, _AbstractCrudObject);

  function CTXOptimizationEligibility() {
    classCallCheck(this, CTXOptimizationEligibility);
    return possibleConstructorReturn(this, (CTXOptimizationEligibility.__proto__ || Object.getPrototypeOf(CTXOptimizationEligibility)).apply(this, arguments));
  }

  createClass(CTXOptimizationEligibility, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        ctm: 'ctm'
      });
    }
  }]);
  return CTXOptimizationEligibility;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * PageUserMessageThreadLabel
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var PageUserMessageThreadLabel = function (_AbstractCrudObject) {
  inherits(PageUserMessageThreadLabel, _AbstractCrudObject);

  function PageUserMessageThreadLabel() {
    classCallCheck(this, PageUserMessageThreadLabel);
    return possibleConstructorReturn(this, (PageUserMessageThreadLabel.__proto__ || Object.getPrototypeOf(PageUserMessageThreadLabel)).apply(this, arguments));
  }

  createClass(PageUserMessageThreadLabel, [{
    key: 'deleteLabel',
    value: function deleteLabel() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(PageUserMessageThreadLabel.prototype.__proto__ || Object.getPrototypeOf(PageUserMessageThreadLabel.prototype), 'deleteEdge', this).call(this, '/label', params);
    }
  }, {
    key: 'createLabel',
    value: function createLabel(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/label', fields, params, PageUserMessageThreadLabel, pathOverride);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(PageUserMessageThreadLabel.prototype.__proto__ || Object.getPrototypeOf(PageUserMessageThreadLabel.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        page_label_name: 'page_label_name'
      });
    }
  }]);
  return PageUserMessageThreadLabel;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CustomUserSettings
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CustomUserSettings = function (_AbstractCrudObject) {
  inherits(CustomUserSettings, _AbstractCrudObject);

  function CustomUserSettings() {
    classCallCheck(this, CustomUserSettings);
    return possibleConstructorReturn(this, (CustomUserSettings.__proto__ || Object.getPrototypeOf(CustomUserSettings)).apply(this, arguments));
  }

  createClass(CustomUserSettings, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        page_level_persistent_menu: 'page_level_persistent_menu',
        user_level_persistent_menu: 'user_level_persistent_menu'
      });
    }
  }]);
  return CustomUserSettings;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Dataset
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Dataset = function (_AbstractCrudObject) {
  inherits(Dataset, _AbstractCrudObject);

  function Dataset() {
    classCallCheck(this, Dataset);
    return possibleConstructorReturn(this, (Dataset.__proto__ || Object.getPrototypeOf(Dataset)).apply(this, arguments));
  }

  createClass(Dataset, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        name: 'name'
      });
    }
  }]);
  return Dataset;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * NullNode
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var NullNode = function (_AbstractCrudObject) {
  inherits(NullNode, _AbstractCrudObject);

  function NullNode() {
    classCallCheck(this, NullNode);
    return possibleConstructorReturn(this, (NullNode.__proto__ || Object.getPrototypeOf(NullNode)).apply(this, arguments));
  }

  createClass(NullNode, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({});
    }
  }]);
  return NullNode;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AppRequestFormerRecipient
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AppRequestFormerRecipient = function (_AbstractCrudObject) {
  inherits(AppRequestFormerRecipient, _AbstractCrudObject);

  function AppRequestFormerRecipient() {
    classCallCheck(this, AppRequestFormerRecipient);
    return possibleConstructorReturn(this, (AppRequestFormerRecipient.__proto__ || Object.getPrototypeOf(AppRequestFormerRecipient)).apply(this, arguments));
  }

  createClass(AppRequestFormerRecipient, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        recipient_id: 'recipient_id'
      });
    }
  }]);
  return AppRequestFormerRecipient;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * AppRequest
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var AppRequest = function (_AbstractCrudObject) {
  inherits(AppRequest, _AbstractCrudObject);

  function AppRequest() {
    classCallCheck(this, AppRequest);
    return possibleConstructorReturn(this, (AppRequest.__proto__ || Object.getPrototypeOf(AppRequest)).apply(this, arguments));
  }

  createClass(AppRequest, [{
    key: 'delete',


    // $FlowFixMe : Support Generic Types
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(AppRequest.prototype.__proto__ || Object.getPrototypeOf(AppRequest.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        action_type: 'action_type',
        application: 'application',
        created_time: 'created_time',
        data: 'data',
        from: 'from',
        id: 'id',
        message: 'message',
        object: 'object',
        to: 'to'
      });
    }
  }]);
  return AppRequest;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CTXPartnerAppWelcomeMessageFlow
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CTXPartnerAppWelcomeMessageFlow = function (_AbstractCrudObject) {
  inherits(CTXPartnerAppWelcomeMessageFlow, _AbstractCrudObject);

  function CTXPartnerAppWelcomeMessageFlow() {
    classCallCheck(this, CTXPartnerAppWelcomeMessageFlow);
    return possibleConstructorReturn(this, (CTXPartnerAppWelcomeMessageFlow.__proto__ || Object.getPrototypeOf(CTXPartnerAppWelcomeMessageFlow)).apply(this, arguments));
  }

  createClass(CTXPartnerAppWelcomeMessageFlow, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        compatible_platforms: 'compatible_platforms',
        eligible_platforms: 'eligible_platforms',
        id: 'id',
        is_ig_only_flow: 'is_ig_only_flow',
        is_used_in_ad: 'is_used_in_ad',
        last_update_time: 'last_update_time',
        name: 'name',
        welcome_message_flow: 'welcome_message_flow',
        welcome_message_sequence: 'welcome_message_sequence'
      });
    }
  }]);
  return CTXPartnerAppWelcomeMessageFlow;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * WhatsAppBusinessAccount
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var WhatsAppBusinessAccount = function (_AbstractCrudObject) {
  inherits(WhatsAppBusinessAccount, _AbstractCrudObject);

  function WhatsAppBusinessAccount() {
    classCallCheck(this, WhatsAppBusinessAccount);
    return possibleConstructorReturn(this, (WhatsAppBusinessAccount.__proto__ || Object.getPrototypeOf(WhatsAppBusinessAccount)).apply(this, arguments));
  }

  createClass(WhatsAppBusinessAccount, [{
    key: 'getActivities',
    value: function getActivities(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/activities');
    }
  }, {
    key: 'deleteAssignedUsers',
    value: function deleteAssignedUsers() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(WhatsAppBusinessAccount.prototype.__proto__ || Object.getPrototypeOf(WhatsAppBusinessAccount.prototype), 'deleteEdge', this).call(this, '/assigned_users', params);
    }
  }, {
    key: 'getAssignedUsers',
    value: function getAssignedUsers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AssignedUser, fields, params, fetchFirstPage, '/assigned_users');
    }
  }, {
    key: 'createAssignedUser',
    value: function createAssignedUser(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/assigned_users', fields, params, WhatsAppBusinessAccount, pathOverride);
    }
  }, {
    key: 'getAudiences',
    value: function getAudiences(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/audiences');
    }
  }, {
    key: 'getCallAnalytics',
    value: function getCallAnalytics(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/call_analytics');
    }
  }, {
    key: 'getConversationAnalytics',
    value: function getConversationAnalytics(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/conversation_analytics');
    }
  }, {
    key: 'getDataset',
    value: function getDataset(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Dataset, fields, params, fetchFirstPage, '/dataset');
    }
  }, {
    key: 'createDataset',
    value: function createDataset(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/dataset', fields, params, Dataset, pathOverride);
    }
  }, {
    key: 'getDegreesOfFreedomSpec',
    value: function getDegreesOfFreedomSpec(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/degrees_of_freedom_spec');
    }
  }, {
    key: 'getFlows',
    value: function getFlows(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/flows');
    }
  }, {
    key: 'createFlow',
    value: function createFlow(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/flows', fields, params, null, pathOverride);
    }
  }, {
    key: 'createGeneratePaymentConfigurationOauthLink',
    value: function createGeneratePaymentConfigurationOauthLink(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/generate_payment_configuration_oauth_link', fields, params, WhatsAppBusinessAccount, pathOverride);
    }
  }, {
    key: 'getGroupAnalytics',
    value: function getGroupAnalytics(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/group_analytics');
    }
  }, {
    key: 'getMarketingCampaigns',
    value: function getMarketingCampaigns(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/marketing_campaigns');
    }
  }, {
    key: 'getMessageCampaigns',
    value: function getMessageCampaigns(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/message_campaigns');
    }
  }, {
    key: 'createMessageSample',
    value: function createMessageSample(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/message_samples', fields, params, WhatsAppBusinessAccount, pathOverride);
    }
  }, {
    key: 'getMessageTemplatePreviews',
    value: function getMessageTemplatePreviews(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/message_template_previews');
    }
  }, {
    key: 'deleteMessageTemplates',
    value: function deleteMessageTemplates() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(WhatsAppBusinessAccount.prototype.__proto__ || Object.getPrototypeOf(WhatsAppBusinessAccount.prototype), 'deleteEdge', this).call(this, '/message_templates', params);
    }
  }, {
    key: 'getMessageTemplates',
    value: function getMessageTemplates(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/message_templates');
    }
  }, {
    key: 'createMessageTemplate',
    value: function createMessageTemplate(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/message_templates', fields, params, WhatsAppBusinessAccount, pathOverride);
    }
  }, {
    key: 'createMigrateFlow',
    value: function createMigrateFlow(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/migrate_flows', fields, params, WhatsAppBusinessAccount, pathOverride);
    }
  }, {
    key: 'createMigrateMessageTemplate',
    value: function createMigrateMessageTemplate(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/migrate_message_templates', fields, params, WhatsAppBusinessAccount, pathOverride);
    }
  }, {
    key: 'deletePaymentConfiguration',
    value: function deletePaymentConfiguration() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(WhatsAppBusinessAccount.prototype.__proto__ || Object.getPrototypeOf(WhatsAppBusinessAccount.prototype), 'deleteEdge', this).call(this, '/payment_configuration', params);
    }
  }, {
    key: 'getPaymentConfiguration',
    value: function getPaymentConfiguration(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/payment_configuration');
    }
  }, {
    key: 'createPaymentConfiguration',
    value: function createPaymentConfiguration(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/payment_configuration', fields, params, WhatsAppBusinessAccount, pathOverride);
    }
  }, {
    key: 'getPaymentConfigurations',
    value: function getPaymentConfigurations(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/payment_configurations');
    }
  }, {
    key: 'getPhoneNumbers',
    value: function getPhoneNumbers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/phone_numbers');
    }
  }, {
    key: 'createPhoneNumber',
    value: function createPhoneNumber(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/phone_numbers', fields, params, null, pathOverride);
    }
  }, {
    key: 'getPricingAnalytics',
    value: function getPricingAnalytics(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/pricing_analytics');
    }
  }, {
    key: 'deleteProductCatalogs',
    value: function deleteProductCatalogs() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(WhatsAppBusinessAccount.prototype.__proto__ || Object.getPrototypeOf(WhatsAppBusinessAccount.prototype), 'deleteEdge', this).call(this, '/product_catalogs', params);
    }
  }, {
    key: 'getProductCatalogs',
    value: function getProductCatalogs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductCatalog, fields, params, fetchFirstPage, '/product_catalogs');
    }
  }, {
    key: 'createProductCatalog',
    value: function createProductCatalog(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/product_catalogs', fields, params, ProductCatalog, pathOverride);
    }
  }, {
    key: 'getSchedules',
    value: function getSchedules(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/schedules');
    }
  }, {
    key: 'createSetOboMobilityIntent',
    value: function createSetOboMobilityIntent(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/set_obo_mobility_intent', fields, params, null, pathOverride);
    }
  }, {
    key: 'createSetSolutionMigrationIntent',
    value: function createSetSolutionMigrationIntent(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/set_solution_migration_intent', fields, params, null, pathOverride);
    }
  }, {
    key: 'getSolutions',
    value: function getSolutions(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/solutions');
    }
  }, {
    key: 'deleteSubscribedApps',
    value: function deleteSubscribedApps() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(WhatsAppBusinessAccount.prototype.__proto__ || Object.getPrototypeOf(WhatsAppBusinessAccount.prototype), 'deleteEdge', this).call(this, '/subscribed_apps', params);
    }
  }, {
    key: 'getSubscribedApps',
    value: function getSubscribedApps(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/subscribed_apps');
    }
  }, {
    key: 'createSubscribedApp',
    value: function createSubscribedApp(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/subscribed_apps', fields, params, WhatsAppBusinessAccount, pathOverride);
    }
  }, {
    key: 'getTemplateAnalytics',
    value: function getTemplateAnalytics(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/template_analytics');
    }
  }, {
    key: 'getTemplateGroupAnalytics',
    value: function getTemplateGroupAnalytics(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/template_group_analytics');
    }
  }, {
    key: 'getTemplateGroups',
    value: function getTemplateGroups(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/template_groups');
    }
  }, {
    key: 'createTemplateGroup',
    value: function createTemplateGroup(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/template_groups', fields, params, null, pathOverride);
    }
  }, {
    key: 'getTemplatePerformanceMetrics',
    value: function getTemplatePerformanceMetrics(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/template_performance_metrics');
    }
  }, {
    key: 'createUpsertMessageTemplate',
    value: function createUpsertMessageTemplate(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/upsert_message_templates', fields, params, WhatsAppBusinessAccount, pathOverride);
    }
  }, {
    key: 'deleteWelcomeMessageSequences',
    value: function deleteWelcomeMessageSequences() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(WhatsAppBusinessAccount.prototype.__proto__ || Object.getPrototypeOf(WhatsAppBusinessAccount.prototype), 'deleteEdge', this).call(this, '/welcome_message_sequences', params);
    }
  }, {
    key: 'getWelcomeMessageSequences',
    value: function getWelcomeMessageSequences(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CTXPartnerAppWelcomeMessageFlow, fields, params, fetchFirstPage, '/welcome_message_sequences');
    }
  }, {
    key: 'createWelcomeMessageSequence',
    value: function createWelcomeMessageSequence(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/welcome_message_sequences', fields, params, null, pathOverride);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(WhatsAppBusinessAccount.prototype.__proto__ || Object.getPrototypeOf(WhatsAppBusinessAccount.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        account_review_status: 'account_review_status',
        analytics: 'analytics',
        auth_international_rate_eligibility: 'auth_international_rate_eligibility',
        business_verification_status: 'business_verification_status',
        country: 'country',
        creation_time: 'creation_time',
        currency: 'currency',
        health_status: 'health_status',
        id: 'id',
        is_enabled_for_insights: 'is_enabled_for_insights',
        is_shared_with_partners: 'is_shared_with_partners',
        linked_commerce_account: 'linked_commerce_account',
        marketing_messages_lite_api_status: 'marketing_messages_lite_api_status',
        marketing_messages_onboarding_status: 'marketing_messages_onboarding_status',
        message_template_namespace: 'message_template_namespace',
        name: 'name',
        on_behalf_of_business_info: 'on_behalf_of_business_info',
        owner_business: 'owner_business',
        owner_business_info: 'owner_business_info',
        ownership_type: 'ownership_type',
        primary_business_location: 'primary_business_location',
        primary_funding_id: 'primary_funding_id',
        purchase_order_number: 'purchase_order_number',
        status: 'status',
        timezone_id: 'timezone_id',
        whatsapp_business_manager_messaging_limit: 'whatsapp_business_manager_messaging_limit'
      });
    }
  }, {
    key: 'BusinessVerificationStatus',
    get: function get() {
      return Object.freeze({
        expired: 'expired',
        failed: 'failed',
        ineligible: 'ineligible',
        not_verified: 'not_verified',
        pending: 'pending',
        pending_need_more_info: 'pending_need_more_info',
        pending_submission: 'pending_submission',
        rejected: 'rejected',
        revoked: 'revoked',
        verified: 'verified'
      });
    }
  }, {
    key: 'WhatsappBusinessManagerMessagingLimit',
    get: function get() {
      return Object.freeze({
        tier_100k: 'TIER_100K',
        tier_10k: 'TIER_10K',
        tier_250: 'TIER_250',
        tier_2k: 'TIER_2K',
        tier_unlimited: 'TIER_UNLIMITED',
        untiered: 'UNTIERED'
      });
    }
  }, {
    key: 'Tasks',
    get: function get() {
      return Object.freeze({
        develop: 'DEVELOP',
        manage: 'MANAGE',
        manage_extensions: 'MANAGE_EXTENSIONS',
        manage_phone: 'MANAGE_PHONE',
        manage_phone_assets: 'MANAGE_PHONE_ASSETS',
        manage_templates: 'MANAGE_TEMPLATES',
        messaging: 'MESSAGING',
        view_cost: 'VIEW_COST',
        view_phone_assets: 'VIEW_PHONE_ASSETS',
        view_templates: 'VIEW_TEMPLATES'
      });
    }
  }, {
    key: 'Type',
    get: function get() {
      return Object.freeze({
        interactive: 'INTERACTIVE',
        text: 'TEXT'
      });
    }
  }, {
    key: 'Category',
    get: function get() {
      return Object.freeze({
        authentication: 'AUTHENTICATION',
        marketing: 'MARKETING',
        utility: 'UTILITY'
      });
    }
  }, {
    key: 'DisplayFormat',
    get: function get() {
      return Object.freeze({
        order_details: 'ORDER_DETAILS'
      });
    }
  }, {
    key: 'ParameterFormat',
    get: function get() {
      return Object.freeze({
        named: 'NAMED',
        positional: 'POSITIONAL'
      });
    }
  }, {
    key: 'SendType',
    get: function get() {
      return Object.freeze({
        campaign: 'CAMPAIGN',
        direct: 'DIRECT'
      });
    }
  }, {
    key: 'SubCategory',
    get: function get() {
      return Object.freeze({
        order_details: 'ORDER_DETAILS',
        order_status: 'ORDER_STATUS',
        rich_order_status: 'RICH_ORDER_STATUS'
      });
    }
  }, {
    key: 'ProviderName',
    get: function get() {
      return Object.freeze({
        billdesk: 'BILLDESK',
        payu: 'PAYU',
        razorpay: 'RAZORPAY',
        upi_vpa: 'UPI_VPA',
        zaakpay: 'ZAAKPAY'
      });
    }
  }]);
  return WhatsAppBusinessAccount;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * BusinessUser
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var BusinessUser = function (_AbstractCrudObject) {
  inherits(BusinessUser, _AbstractCrudObject);

  function BusinessUser() {
    classCallCheck(this, BusinessUser);
    return possibleConstructorReturn(this, (BusinessUser.__proto__ || Object.getPrototypeOf(BusinessUser)).apply(this, arguments));
  }

  createClass(BusinessUser, [{
    key: 'getAssignedAdAccounts',
    value: function getAssignedAdAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdAccount, fields, params, fetchFirstPage, '/assigned_ad_accounts');
    }
  }, {
    key: 'getAssignedBusinessAssetGroups',
    value: function getAssignedBusinessAssetGroups(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BusinessAssetGroup, fields, params, fetchFirstPage, '/assigned_business_asset_groups');
    }
  }, {
    key: 'getAssignedPages',
    value: function getAssignedPages(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/assigned_pages');
    }
  }, {
    key: 'getAssignedProductCatalogs',
    value: function getAssignedProductCatalogs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductCatalog, fields, params, fetchFirstPage, '/assigned_product_catalogs');
    }
  }, {
    key: 'getAssignedWhatsAppBusinessAccounts',
    value: function getAssignedWhatsAppBusinessAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(WhatsAppBusinessAccount, fields, params, fetchFirstPage, '/assigned_whatsapp_business_accounts');
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(BusinessUser.prototype.__proto__ || Object.getPrototypeOf(BusinessUser.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(BusinessUser.prototype.__proto__ || Object.getPrototypeOf(BusinessUser.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        business: 'business',
        business_role_request: 'business_role_request',
        email: 'email',
        finance_permission: 'finance_permission',
        first_name: 'first_name',
        id: 'id',
        ip_permission: 'ip_permission',
        last_name: 'last_name',
        marked_for_removal: 'marked_for_removal',
        name: 'name',
        pending_email: 'pending_email',
        role: 'role',
        tasks: 'tasks',
        title: 'title',
        two_fac_status: 'two_fac_status'
      });
    }
  }, {
    key: 'InvitedUserType',
    get: function get() {
      return Object.freeze({
        fb: 'FB',
        mwa: 'MWA'
      });
    }
  }, {
    key: 'Role',
    get: function get() {
      return Object.freeze({
        admin: 'ADMIN',
        ads_rights_reviewer: 'ADS_RIGHTS_REVIEWER',
        default: 'DEFAULT',
        developer: 'DEVELOPER',
        employee: 'EMPLOYEE',
        finance_analyst: 'FINANCE_ANALYST',
        finance_edit: 'FINANCE_EDIT',
        finance_editor: 'FINANCE_EDITOR',
        finance_view: 'FINANCE_VIEW',
        manage: 'MANAGE',
        partner_center_admin: 'PARTNER_CENTER_ADMIN',
        partner_center_analyst: 'PARTNER_CENTER_ANALYST',
        partner_center_education: 'PARTNER_CENTER_EDUCATION',
        partner_center_marketing: 'PARTNER_CENTER_MARKETING',
        partner_center_operations: 'PARTNER_CENTER_OPERATIONS'
      });
    }
  }, {
    key: 'Tasks',
    get: function get() {
      return Object.freeze({
        admin: 'ADMIN',
        ads_rights_reviewer: 'ADS_RIGHTS_REVIEWER',
        default: 'DEFAULT',
        developer: 'DEVELOPER',
        employee: 'EMPLOYEE',
        finance_analyst: 'FINANCE_ANALYST',
        finance_edit: 'FINANCE_EDIT',
        finance_editor: 'FINANCE_EDITOR',
        finance_view: 'FINANCE_VIEW',
        manage: 'MANAGE',
        partner_center_admin: 'PARTNER_CENTER_ADMIN',
        partner_center_analyst: 'PARTNER_CENTER_ANALYST',
        partner_center_education: 'PARTNER_CENTER_EDUCATION',
        partner_center_marketing: 'PARTNER_CENTER_MARKETING',
        partner_center_operations: 'PARTNER_CENTER_OPERATIONS'
      });
    }
  }]);
  return BusinessUser;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * FundraiserPersonToCharity
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var FundraiserPersonToCharity = function (_AbstractCrudObject) {
  inherits(FundraiserPersonToCharity, _AbstractCrudObject);

  function FundraiserPersonToCharity() {
    classCallCheck(this, FundraiserPersonToCharity);
    return possibleConstructorReturn(this, (FundraiserPersonToCharity.__proto__ || Object.getPrototypeOf(FundraiserPersonToCharity)).apply(this, arguments));
  }

  createClass(FundraiserPersonToCharity, [{
    key: 'getDonations',
    value: function getDonations(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/donations');
    }
  }, {
    key: 'createEndFundraiser',
    value: function createEndFundraiser(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/end_fundraiser', fields, params, null, pathOverride);
    }
  }, {
    key: 'getExternalDonations',
    value: function getExternalDonations(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/external_donations');
    }
  }, {
    key: 'createExternalDonation',
    value: function createExternalDonation(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/external_donations', fields, params, null, pathOverride);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(FundraiserPersonToCharity.prototype.__proto__ || Object.getPrototypeOf(FundraiserPersonToCharity.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        amount_raised: 'amount_raised',
        charity_id: 'charity_id',
        currency: 'currency',
        description: 'description',
        donations_count: 'donations_count',
        donors_count: 'donors_count',
        end_time: 'end_time',
        external_amount_raised: 'external_amount_raised',
        external_donations_count: 'external_donations_count',
        external_donors_count: 'external_donors_count',
        external_event_name: 'external_event_name',
        external_event_start_time: 'external_event_start_time',
        external_event_uri: 'external_event_uri',
        external_fundraiser_uri: 'external_fundraiser_uri',
        external_id: 'external_id',
        goal_amount: 'goal_amount',
        id: 'id',
        internal_amount_raised: 'internal_amount_raised',
        internal_donations_count: 'internal_donations_count',
        internal_donors_count: 'internal_donors_count',
        name: 'name',
        uri: 'uri'
      });
    }
  }, {
    key: 'FundraiserType',
    get: function get() {
      return Object.freeze({
        person_for_charity: 'person_for_charity'
      });
    }
  }]);
  return FundraiserPersonToCharity;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * VideoThumbnail
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var VideoThumbnail = function (_AbstractCrudObject) {
  inherits(VideoThumbnail, _AbstractCrudObject);

  function VideoThumbnail() {
    classCallCheck(this, VideoThumbnail);
    return possibleConstructorReturn(this, (VideoThumbnail.__proto__ || Object.getPrototypeOf(VideoThumbnail)).apply(this, arguments));
  }

  createClass(VideoThumbnail, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        height: 'height',
        id: 'id',
        is_preferred: 'is_preferred',
        name: 'name',
        scale: 'scale',
        uri: 'uri',
        width: 'width'
      });
    }
  }]);
  return VideoThumbnail;
}(AbstractCrudObject);

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 * @format
 * 
 */
/**
 * Video uploader that can upload videos to adaccount
 **/

var VideoUploader = function () {
  function VideoUploader() {
    classCallCheck(this, VideoUploader);

    this._session = null;
  }

  /**
   * Upload the given video file.
   * @param {AdVideo} video The AdVideo object that will be uploaded
   * @param {Boolean} [waitForEncoding] Whether to wait until encoding
   *   is finished
   **/


  createClass(VideoUploader, [{
    key: 'upload',
    value: function upload(video, waitForEncoding) {
      // Check there is no existing session
      if (this._session) {
        throw Error('There is already an upload session for this video uploader');
      }

      // Initate an upload session
      this._session = new VideoUploadSession(video, waitForEncoding);
      var result = this._session.start();
      this._session = null;
      return result;
    }
  }]);
  return VideoUploader;
}();

var VideoUploadSession = function () {
  function VideoUploadSession(video) {
    var waitForEncoding = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    classCallCheck(this, VideoUploadSession);

    this._video = video;
    this._api = video.getApi();

    if (video.filepath) {
      this._filePath = video.filepath;
      this._slideshowSpec = null;
    } else if (video.slideshow_spec) {
      this._slideshowSpec = video.slideshow_spec;
      this._filePath = null;
    }

    this._accountId = video.getParentId();
    this._waitForEncoding = waitForEncoding;
    // Setup start request manager
    this._startRequestManager = new VideoUploadStartRequestManager(this._api);
    // Setup transfer request manager
    this._transferRequestManager = new VideoUploadTransferRequestManager(this._api);
    // Setup finish request manager
    this._finishRequestManager = new VideoUploadFinishRequestManager(this._api);
  }

  createClass(VideoUploadSession, [{
    key: 'start',
    value: function () {
      var _ref = asyncToGenerator(function* () {
        var videoId = void 0;

        // Run start request manager
        var startResponse = yield this._startRequestManager.sendRequest(this.getStartRequestContext());
        this._startOffset = parseInt(startResponse['start_offset']);
        this._endOffset = parseInt(startResponse['end_offset']);
        this._sessionId = startResponse['upload_session_id'];
        videoId = startResponse['video_id'];
        // Run transfer request manager
        yield this._transferRequestManager.sendRequest(this.getTransferRequestContext());
        // Run finish request manager
        var finishResponse = yield this._finishRequestManager.sendRequest(this.getFinishRequestContext());
        // Populate the video info
        var body = finishResponse;
        body.id = videoId;
        delete body.success;

        return body;
      });

      function start() {
        return _ref.apply(this, arguments);
      }

      return start;
    }()
  }, {
    key: 'getStartRequestContext',
    value: function getStartRequestContext() {
      var context = new VideoUploadRequestContext();

      if (this._filePath) {
        // Read file size
        context.fileSize = fs.statSync(this._filePath).size;
      }
      context.accountId = this._accountId;

      return context;
    }
  }, {
    key: 'getTransferRequestContext',
    value: function getTransferRequestContext() {
      var context = new VideoUploadRequestContext();

      context.sessionId = this._sessionId;
      context.startOffset = this._startOffset;
      context.endOffset = this._endOffset;

      if (this._filePath) {
        context.filePath = this._filePath;
      }
      if (this._slideshowSpec) {
        context.slideshowSpec = this._slideshowSpec;
      }
      context.accountId = this._accountId;

      return context;
    }
  }, {
    key: 'getFinishRequestContext',
    value: function getFinishRequestContext() {
      var context = new VideoUploadRequestContext();

      context.sessionId = this._sessionId;
      context.accountId = this._accountId;

      if (this._filePath) {
        context.fileName = path.basename(this._filePath);
      }

      return context;
    }
  }]);
  return VideoUploadSession;
}();

/**
 * Abstract class for request managers
 **/


var VideoUploadRequestManager = function () {
  function VideoUploadRequestManager(api) {
    classCallCheck(this, VideoUploadRequestManager);

    this._api = api;
  }

  createClass(VideoUploadRequestManager, [{
    key: 'sendRequest',
    value: function sendRequest(context) {
      throw new TypeError('Class extending VideoUploadRequestManager must implement ' + 'sendRequest method');
    }
  }, {
    key: 'getParamsFromContext',
    value: function getParamsFromContext(context) {
      throw new TypeError('Class extending VideoUploadRequestManager must implement ' + 'getParamsFromContext method');
    }
  }]);
  return VideoUploadRequestManager;
}();

var VideoUploadStartRequestManager = function (_VideoUploadRequestMa) {
  inherits(VideoUploadStartRequestManager, _VideoUploadRequestMa);

  function VideoUploadStartRequestManager() {
    classCallCheck(this, VideoUploadStartRequestManager);
    return possibleConstructorReturn(this, (VideoUploadStartRequestManager.__proto__ || Object.getPrototypeOf(VideoUploadStartRequestManager)).apply(this, arguments));
  }

  createClass(VideoUploadStartRequestManager, [{
    key: 'sendRequest',

    /**
     * Send start request with the given context
     **/
    value: function () {
      var _ref2 = asyncToGenerator(function* (context) {
        // Init a VideoUploadRequest and send the request
        var request = new VideoUploadRequest(this._api);
        request.setParams(this.getParamsFromContext(context));

        var response = yield request.send([context.accountId, 'advideos']);

        return response;
      });

      function sendRequest(_x2) {
        return _ref2.apply(this, arguments);
      }

      return sendRequest;
    }()
  }, {
    key: 'getParamsFromContext',
    value: function getParamsFromContext(context) {
      return {
        file_size: context.fileSize,
        upload_phase: 'start'
      };
    }
  }]);
  return VideoUploadStartRequestManager;
}(VideoUploadRequestManager);

var VideoUploadTransferRequestManager = function (_VideoUploadRequestMa2) {
  inherits(VideoUploadTransferRequestManager, _VideoUploadRequestMa2);

  function VideoUploadTransferRequestManager() {
    classCallCheck(this, VideoUploadTransferRequestManager);
    return possibleConstructorReturn(this, (VideoUploadTransferRequestManager.__proto__ || Object.getPrototypeOf(VideoUploadTransferRequestManager)).apply(this, arguments));
  }

  createClass(VideoUploadTransferRequestManager, [{
    key: 'sendRequest',


    /**
     * Send transfer request with the given context
     **/
    value: function () {
      var _ref3 = asyncToGenerator(function* (context) {
        // Init a VideoUploadRequest
        var request = new VideoUploadRequest(this._api);
        var start_offset = context.startOffset;
        var end_offset = context.endOffset;
        var filePath = context.filePath;
        var fileSize = fs.statSync(filePath).size;

        // Give a chance to retry every 10M, or at least twice
        var numRetry = Math.max(fileSize / (1024 * 1024 * 10), 2);
        var response = null;
        // While there are still more chunks to send
        var videoFileDescriptor = fs.openSync(filePath, 'r');
        while (start_offset !== end_offset) {
          context.startOffset = start_offset;
          context.endOffset = end_offset;
          var params = {
            upload_phase: 'transfer',
            start_offset: context.startOffset,
            upload_session_id: context.sessionId,
            video_file_chunk: context.videoFileChunk
          };
          request.setParams(params, {
            video_file_chunk: fs.createReadStream(context.filePath, {
              start: context.startOffset,
              end: context.endOffset - 1
            })
          });
          // Send the request
          try {
            response = yield request.send([context.accountId, 'advideos']);
            start_offset = parseInt(response['start_offset']);
            end_offset = parseInt(response['end_offset']);
          } catch (error) {
            if (numRetry > 0) {
              numRetry = Math.max(numRetry - 1, 0);
              continue;
            }
            fs.close(videoFileDescriptor, function (err) {});
            throw error;
          }
        }

        this._startOffset = start_offset;
        this._endOffset = end_offset;
        fs.close(videoFileDescriptor, function (err) {});

        return response;
      });

      function sendRequest(_x3) {
        return _ref3.apply(this, arguments);
      }

      return sendRequest;
    }()
  }]);
  return VideoUploadTransferRequestManager;
}(VideoUploadRequestManager);

var VideoUploadFinishRequestManager = function (_VideoUploadRequestMa3) {
  inherits(VideoUploadFinishRequestManager, _VideoUploadRequestMa3);

  function VideoUploadFinishRequestManager() {
    classCallCheck(this, VideoUploadFinishRequestManager);
    return possibleConstructorReturn(this, (VideoUploadFinishRequestManager.__proto__ || Object.getPrototypeOf(VideoUploadFinishRequestManager)).apply(this, arguments));
  }

  createClass(VideoUploadFinishRequestManager, [{
    key: 'sendRequest',

    /**
     * Send transfer request with the given context
     **/
    value: function () {
      var _ref4 = asyncToGenerator(function* (context) {
        // Init a VideoUploadRequest
        var request = new VideoUploadRequest(this._api);

        // Parse the context
        request.setParams(this.getParamsFromContext(context));

        // Sent the request
        var response = yield request.send([context.accountId, 'advideos']);

        return response;
      });

      function sendRequest(_x4) {
        return _ref4.apply(this, arguments);
      }

      return sendRequest;
    }()
  }, {
    key: 'getParamsFromContext',
    value: function getParamsFromContext(context) {
      return {
        upload_phase: 'finish',
        upload_session_id: context.sessionId,
        title: context.fileName
      };
    }
  }]);
  return VideoUploadFinishRequestManager;
}(VideoUploadRequestManager);

/**
 * Upload request context that contains the param data
 **/


var VideoUploadRequestContext = function () {
  function VideoUploadRequestContext() {
    classCallCheck(this, VideoUploadRequestContext);
  }

  createClass(VideoUploadRequestContext, [{
    key: 'accountId',
    get: function get() {
      return this._accountId;
    },
    set: function set(accountId) {
      this._accountId = accountId;
    }
  }, {
    key: 'fileName',
    get: function get() {
      return this._fileName;
    },
    set: function set(fileName) {
      this._fileName = fileName;
    }
  }, {
    key: 'filePath',
    get: function get() {
      return this._filePath;
    },
    set: function set(filePath) {
      this._filePath = filePath;
    }
  }, {
    key: 'fileSize',
    get: function get() {
      return this._fileSize;
    },
    set: function set(fileSize) {
      this._fileSize = fileSize;
    }
  }, {
    key: 'name',
    get: function get() {
      return this._name;
    },
    set: function set(name) {
      this._name = name;
    }
  }, {
    key: 'sessionId',
    get: function get() {
      return this._sessionId;
    },
    set: function set(sessionId) {
      this._sessionId = sessionId;
    }
  }, {
    key: 'startOffset',
    get: function get() {
      return this._startOffset;
    },
    set: function set(startOffset) {
      this._startOffset = startOffset;
    }
  }, {
    key: 'endOffset',
    get: function get() {
      return this._endOffset;
    },
    set: function set(endOffset) {
      this._endOffset = endOffset;
    }
  }, {
    key: 'slideshowSpec',
    get: function get() {
      return this._slideshowSpec;
    },
    set: function set(slideshowSpec) {
      this._slideshowSpec = slideshowSpec;
    }
  }, {
    key: 'videoFileChunk',
    get: function get() {
      return this._videoFileChunk;
    },
    set: function set(videoFileChunk) {
      this._videoFileChunk = videoFileChunk;
    }
  }]);
  return VideoUploadRequestContext;
}();

var VideoUploadRequest = function () {
  function VideoUploadRequest(api) {
    classCallCheck(this, VideoUploadRequest);

    this._params = null;
    this._files = null;
    this._api = api;
  }

  /**
   * Send the current request
   **/


  createClass(VideoUploadRequest, [{
    key: 'send',
    value: function send(path$$1) {
      var _this4 = this;

      return new Promise(function (resolve, reject) {
        _this4._api.call('POST', path$$1, _this4._params, _this4._files, true, // use multipart/form-data
        FacebookAdsApi.GRAPH_VIDEO // override graph.facebook.com
        ).then(function (response) {
          return resolve(JSON.parse(response));
        }).catch(function (error) {
          return reject(error);
        });
      });
    }
  }, {
    key: 'setParams',
    value: function setParams(params) {
      var files = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

      this._params = params;
      this._files = files;
    }
  }]);
  return VideoUploadRequest;
}();

function sleep(ms) {
  return new Promise(function (resolve) {
    return setTimeout(resolve, ms);
  });
}

var VideoEncodingStatusChecker = function () {
  function VideoEncodingStatusChecker() {
    classCallCheck(this, VideoEncodingStatusChecker);
  }

  createClass(VideoEncodingStatusChecker, null, [{
    key: 'waitUntilReady',
    value: function () {
      var _ref5 = asyncToGenerator(function* (api, videoId, interval, timeout) {
        var startTime = new Date().getTime();
        var status = null;

        while (true) {
          status = VideoEncodingStatusChecker.getStatus(api, videoId);
          status = status['video_status'];

          if (status !== 'processing') {
            break;
          }

          if (startTime + timeout <= new Date().getTime()) {
            throw Error('Video encoding timeout: ' + timeout);
          }

          yield sleep(interval);
        }

        if (status !== 'ready') {
          status = status == null ? '' : status;
          throw Error('Video encoding status ' + status);
        }
      });

      function waitUntilReady(_x6, _x7, _x8, _x9) {
        return _ref5.apply(this, arguments);
      }

      return waitUntilReady;
    }()
  }, {
    key: 'getStatus',
    value: function getStatus(api, videoId) {
      var result = api.call('GET', [videoId.toString()], { fields: 'status' });
      // $FlowFixMe
      return result['status'];
    }
  }]);
  return VideoEncodingStatusChecker;
}();

/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @format
 * 
 */

/**
 * AdVideo
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */
var AdVideo = function (_AbstractCrudObject) {
  inherits(AdVideo, _AbstractCrudObject);

  function AdVideo() {
    classCallCheck(this, AdVideo);
    return possibleConstructorReturn(this, (AdVideo.__proto__ || Object.getPrototypeOf(AdVideo)).apply(this, arguments));
  }

  createClass(AdVideo, [{
    key: 'create',


    /**
     * Uploads filepath and creates the AdVideo object from it.
     * It requires 'filepath' property to be defined.
     **/
    value: function create(batch, failureHandler, successHandler) {
      var response = null;
      var spec = this.slideshow_spec;
      if (spec) {
        var request = new VideoUploadRequest(this.getApi());

        request.setParams({
          'slideshow_spec[images_urls]': JSON.stringify(spec['images_urls']),
          'slideshow_spec[duration_ms]': spec['duration_ms'],
          'slideshow_spec[transition_ms]': spec['transition_ms']
        });
        response = request.send([this.getParentId(), 'advideos']);
      } else if (this.filepath) {
        var videoUploader = new VideoUploader();

        response = videoUploader.upload(this, true);
      } else {
        throw Error('AdVideo requires a filepath or slideshow_spec to be defined.');
      }

      this.setData(response);

      return response;
    }
  }, {
    key: 'waitUntilEncodingReady',
    value: function waitUntilEncodingReady() {
      var interval = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 30;
      var timeout = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 600;

      if (!this.id) {
        throw Error('Invalid Video ID');
      }

      VideoEncodingStatusChecker.waitUntilReady(this.getApi(), parseInt(this.id), interval, timeout);
    }

    /**
     *  Returns all the thumbnails associated with the ad video
     */

  }, {
    key: 'getThumbnails',
    value: function getThumbnails(fields, params) {
      return this.getEdge(VideoThumbnail, fields, params, true, 'thumbnails');
    }
  }, {
    key: 'filepath',
    get: function get() {
      return this.filepath;
    }
  }, {
    key: 'slideshow_spec',
    get: function get() {
      return this.slideshow_spec;
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        filepath: 'filepath',
        id: 'id',
        slideshow_spec: 'slideshow_spec'
      });
    }
  }]);
  return AdVideo;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Group
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Group = function (_AbstractCrudObject) {
  inherits(Group, _AbstractCrudObject);

  function Group() {
    classCallCheck(this, Group);
    return possibleConstructorReturn(this, (Group.__proto__ || Object.getPrototypeOf(Group)).apply(this, arguments));
  }

  createClass(Group, [{
    key: 'deleteAdmins',
    value: function deleteAdmins() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Group.prototype.__proto__ || Object.getPrototypeOf(Group.prototype), 'deleteEdge', this).call(this, '/admins', params);
    }
  }, {
    key: 'createAdmin',
    value: function createAdmin(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/admins', fields, params, Group, pathOverride);
    }
  }, {
    key: 'getAlbums',
    value: function getAlbums(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Album, fields, params, fetchFirstPage, '/albums');
    }
  }, {
    key: 'getDocs',
    value: function getDocs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/docs');
    }
  }, {
    key: 'getEvents',
    value: function getEvents(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Event, fields, params, fetchFirstPage, '/events');
    }
  }, {
    key: 'getFeed',
    value: function getFeed(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Post, fields, params, fetchFirstPage, '/feed');
    }
  }, {
    key: 'createFeed',
    value: function createFeed(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/feed', fields, params, Post, pathOverride);
    }
  }, {
    key: 'getFiles',
    value: function getFiles(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/files');
    }
  }, {
    key: 'getGroups',
    value: function getGroups(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Group, fields, params, fetchFirstPage, '/groups');
    }
  }, {
    key: 'createGroup',
    value: function createGroup(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/groups', fields, params, Group, pathOverride);
    }
  }, {
    key: 'getLiveVideos',
    value: function getLiveVideos(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(LiveVideo, fields, params, fetchFirstPage, '/live_videos');
    }
  }, {
    key: 'createLiveVideo',
    value: function createLiveVideo(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/live_videos', fields, params, LiveVideo, pathOverride);
    }
  }, {
    key: 'deleteMembers',
    value: function deleteMembers() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Group.prototype.__proto__ || Object.getPrototypeOf(Group.prototype), 'deleteEdge', this).call(this, '/members', params);
    }
  }, {
    key: 'createMember',
    value: function createMember(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/members', fields, params, Group, pathOverride);
    }
  }, {
    key: 'getOptedInMembers',
    value: function getOptedInMembers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(User, fields, params, fetchFirstPage, '/opted_in_members');
    }
  }, {
    key: 'createPhoto',
    value: function createPhoto(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/photos', fields, params, Photo, pathOverride);
    }
  }, {
    key: 'getPicture',
    value: function getPicture(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProfilePictureSource, fields, params, fetchFirstPage, '/picture');
    }
  }, {
    key: 'getVideos',
    value: function getVideos(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdVideo, fields, params, fetchFirstPage, '/videos');
    }
  }, {
    key: 'createVideo',
    value: function createVideo(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/videos', fields, params, AdVideo, pathOverride);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Group.prototype.__proto__ || Object.getPrototypeOf(Group.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        archived: 'archived',
        cover: 'cover',
        created_time: 'created_time',
        description: 'description',
        email: 'email',
        icon: 'icon',
        id: 'id',
        install: 'install',
        link: 'link',
        member_count: 'member_count',
        member_request_count: 'member_request_count',
        name: 'name',
        parent: 'parent',
        permissions: 'permissions',
        privacy: 'privacy',
        purpose: 'purpose',
        subdomain: 'subdomain',
        updated_time: 'updated_time',
        venue: 'venue'
      });
    }
  }, {
    key: 'JoinSetting',
    get: function get() {
      return Object.freeze({
        admin_only: 'ADMIN_ONLY',
        anyone: 'ANYONE',
        none: 'NONE'
      });
    }
  }, {
    key: 'PostPermissions',
    get: function get() {
      return Object.freeze({
        admin_only: 'ADMIN_ONLY',
        anyone: 'ANYONE',
        none: 'NONE'
      });
    }
  }, {
    key: 'Purpose',
    get: function get() {
      return Object.freeze({
        casual: 'CASUAL',
        coworkers: 'COWORKERS',
        custom: 'CUSTOM',
        for_sale: 'FOR_SALE',
        for_work: 'FOR_WORK',
        game: 'GAME',
        health_support: 'HEALTH_SUPPORT',
        jobs: 'JOBS',
        learning: 'LEARNING',
        none: 'NONE',
        parenting: 'PARENTING',
        streamer: 'STREAMER',
        work_announcement: 'WORK_ANNOUNCEMENT',
        work_demo_group: 'WORK_DEMO_GROUP',
        work_discussion: 'WORK_DISCUSSION',
        work_ephemeral: 'WORK_EPHEMERAL',
        work_feedback: 'WORK_FEEDBACK',
        work_for_sale: 'WORK_FOR_SALE',
        work_garden: 'WORK_GARDEN',
        work_integrity: 'WORK_INTEGRITY',
        work_learning: 'WORK_LEARNING',
        work_mentorship: 'WORK_MENTORSHIP',
        work_multi_company: 'WORK_MULTI_COMPANY',
        work_recruiting: 'WORK_RECRUITING',
        work_social: 'WORK_SOCIAL',
        work_stages: 'WORK_STAGES',
        work_team: 'WORK_TEAM',
        work_teamwork: 'WORK_TEAMWORK'
      });
    }
  }, {
    key: 'GroupType',
    get: function get() {
      return Object.freeze({
        casual: 'CASUAL',
        coworkers: 'COWORKERS',
        custom: 'CUSTOM',
        for_sale: 'FOR_SALE',
        for_work: 'FOR_WORK',
        game: 'GAME',
        health_support: 'HEALTH_SUPPORT',
        jobs: 'JOBS',
        learning: 'LEARNING',
        none: 'NONE',
        parenting: 'PARENTING',
        streamer: 'STREAMER',
        work_announcement: 'WORK_ANNOUNCEMENT',
        work_demo_group: 'WORK_DEMO_GROUP',
        work_discussion: 'WORK_DISCUSSION',
        work_ephemeral: 'WORK_EPHEMERAL',
        work_feedback: 'WORK_FEEDBACK',
        work_for_sale: 'WORK_FOR_SALE',
        work_garden: 'WORK_GARDEN',
        work_integrity: 'WORK_INTEGRITY',
        work_learning: 'WORK_LEARNING',
        work_mentorship: 'WORK_MENTORSHIP',
        work_multi_company: 'WORK_MULTI_COMPANY',
        work_recruiting: 'WORK_RECRUITING',
        work_social: 'WORK_SOCIAL',
        work_stages: 'WORK_STAGES',
        work_team: 'WORK_TEAM',
        work_teamwork: 'WORK_TEAMWORK'
      });
    }
  }]);
  return Group;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * UserIDForApp
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var UserIDForApp = function (_AbstractCrudObject) {
  inherits(UserIDForApp, _AbstractCrudObject);

  function UserIDForApp() {
    classCallCheck(this, UserIDForApp);
    return possibleConstructorReturn(this, (UserIDForApp.__proto__ || Object.getPrototypeOf(UserIDForApp)).apply(this, arguments));
  }

  createClass(UserIDForApp, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        app: 'app',
        id: 'id'
      });
    }
  }]);
  return UserIDForApp;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * UserIDForPage
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var UserIDForPage = function (_AbstractCrudObject) {
  inherits(UserIDForPage, _AbstractCrudObject);

  function UserIDForPage() {
    classCallCheck(this, UserIDForPage);
    return possibleConstructorReturn(this, (UserIDForPage.__proto__ || Object.getPrototypeOf(UserIDForPage)).apply(this, arguments));
  }

  createClass(UserIDForPage, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        page: 'page'
      });
    }
  }]);
  return UserIDForPage;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * PaymentEnginePayment
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var PaymentEnginePayment = function (_AbstractCrudObject) {
  inherits(PaymentEnginePayment, _AbstractCrudObject);

  function PaymentEnginePayment() {
    classCallCheck(this, PaymentEnginePayment);
    return possibleConstructorReturn(this, (PaymentEnginePayment.__proto__ || Object.getPrototypeOf(PaymentEnginePayment)).apply(this, arguments));
  }

  createClass(PaymentEnginePayment, [{
    key: 'createDispute',
    value: function createDispute(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/dispute', fields, params, PaymentEnginePayment, pathOverride);
    }
  }, {
    key: 'createRefund',
    value: function createRefund(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/refunds', fields, params, PaymentEnginePayment, pathOverride);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        actions: 'actions',
        application: 'application',
        country: 'country',
        created_time: 'created_time',
        disputes: 'disputes',
        fraud_status: 'fraud_status',
        fulfillment_status: 'fulfillment_status',
        id: 'id',
        is_from_ad: 'is_from_ad',
        is_from_page_post: 'is_from_page_post',
        items: 'items',
        payout_foreign_exchange_rate: 'payout_foreign_exchange_rate',
        phone_support_eligible: 'phone_support_eligible',
        platform: 'platform',
        refundable_amount: 'refundable_amount',
        request_id: 'request_id',
        tax: 'tax',
        tax_country: 'tax_country',
        test: 'test',
        user: 'user'
      });
    }
  }, {
    key: 'Reason',
    get: function get() {
      return Object.freeze({
        banned_user: 'BANNED_USER',
        denied_refund: 'DENIED_REFUND',
        granted_replacement_item: 'GRANTED_REPLACEMENT_ITEM'
      });
    }
  }]);
  return PaymentEnginePayment;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Permission
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Permission = function (_AbstractCrudObject) {
  inherits(Permission, _AbstractCrudObject);

  function Permission() {
    classCallCheck(this, Permission);
    return possibleConstructorReturn(this, (Permission.__proto__ || Object.getPrototypeOf(Permission)).apply(this, arguments));
  }

  createClass(Permission, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        permission: 'permission',
        status: 'status'
      });
    }
  }, {
    key: 'Status',
    get: function get() {
      return Object.freeze({
        declined: 'declined',
        expired: 'expired',
        granted: 'granted'
      });
    }
  }]);
  return Permission;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * User
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var User = function (_AbstractCrudObject) {
  inherits(User, _AbstractCrudObject);

  function User() {
    classCallCheck(this, User);
    return possibleConstructorReturn(this, (User.__proto__ || Object.getPrototypeOf(User)).apply(this, arguments));
  }

  createClass(User, [{
    key: 'deleteAccessTokens',
    value: function deleteAccessTokens() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(User.prototype.__proto__ || Object.getPrototypeOf(User.prototype), 'deleteEdge', this).call(this, '/access_tokens', params);
    }
  }, {
    key: 'createAccessToken',
    value: function createAccessToken(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/access_tokens', fields, params, User, pathOverride);
    }
  }, {
    key: 'getAccounts',
    value: function getAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/accounts');
    }
  }, {
    key: 'createAccount',
    value: function createAccount(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/accounts', fields, params, null, pathOverride);
    }
  }, {
    key: 'getAdStudies',
    value: function getAdStudies(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdStudy, fields, params, fetchFirstPage, '/ad_studies');
    }
  }, {
    key: 'createAdStudy',
    value: function createAdStudy(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/ad_studies', fields, params, AdStudy, pathOverride);
    }
  }, {
    key: 'getAdAccounts',
    value: function getAdAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdAccount, fields, params, fetchFirstPage, '/adaccounts');
    }
  }, {
    key: 'getAlbums',
    value: function getAlbums(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Album, fields, params, fetchFirstPage, '/albums');
    }
  }, {
    key: 'createApplication',
    value: function createApplication(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/applications', fields, params, User, pathOverride);
    }
  }, {
    key: 'getAppRequestFormerRecipients',
    value: function getAppRequestFormerRecipients(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AppRequestFormerRecipient, fields, params, fetchFirstPage, '/apprequestformerrecipients');
    }
  }, {
    key: 'getAppRequests',
    value: function getAppRequests(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AppRequest, fields, params, fetchFirstPage, '/apprequests');
    }
  }, {
    key: 'getAssignedAdAccounts',
    value: function getAssignedAdAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdAccount, fields, params, fetchFirstPage, '/assigned_ad_accounts');
    }
  }, {
    key: 'getAssignedApplications',
    value: function getAssignedApplications(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Application, fields, params, fetchFirstPage, '/assigned_applications');
    }
  }, {
    key: 'getAssignedBusinessAssetGroups',
    value: function getAssignedBusinessAssetGroups(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BusinessAssetGroup, fields, params, fetchFirstPage, '/assigned_business_asset_groups');
    }
  }, {
    key: 'getAssignedPages',
    value: function getAssignedPages(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/assigned_pages');
    }
  }, {
    key: 'getAssignedProductCatalogs',
    value: function getAssignedProductCatalogs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductCatalog, fields, params, fetchFirstPage, '/assigned_product_catalogs');
    }
  }, {
    key: 'getAssignedWhatsAppBusinessAccounts',
    value: function getAssignedWhatsAppBusinessAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(WhatsAppBusinessAccount, fields, params, fetchFirstPage, '/assigned_whatsapp_business_accounts');
    }
  }, {
    key: 'getBusinessUsers',
    value: function getBusinessUsers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BusinessUser, fields, params, fetchFirstPage, '/business_users');
    }
  }, {
    key: 'deleteBusinesses',
    value: function deleteBusinesses() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(User.prototype.__proto__ || Object.getPrototypeOf(User.prototype), 'deleteEdge', this).call(this, '/businesses', params);
    }
  }, {
    key: 'getBusinesses',
    value: function getBusinesses(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Business, fields, params, fetchFirstPage, '/businesses');
    }
  }, {
    key: 'createBusiness',
    value: function createBusiness(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/businesses', fields, params, Business, pathOverride);
    }
  }, {
    key: 'getConversations',
    value: function getConversations(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(UnifiedThread, fields, params, fetchFirstPage, '/conversations');
    }
  }, {
    key: 'getCustomLabels',
    value: function getCustomLabels(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(PageUserMessageThreadLabel, fields, params, fetchFirstPage, '/custom_labels');
    }
  }, {
    key: 'getEvents',
    value: function getEvents(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Event, fields, params, fetchFirstPage, '/events');
    }
  }, {
    key: 'getFeed',
    value: function getFeed(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Post, fields, params, fetchFirstPage, '/feed');
    }
  }, {
    key: 'createFeed',
    value: function createFeed(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/feed', fields, params, Post, pathOverride);
    }
  }, {
    key: 'getFriends',
    value: function getFriends(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(User, fields, params, fetchFirstPage, '/friends');
    }
  }, {
    key: 'getFundraisers',
    value: function getFundraisers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(FundraiserPersonToCharity, fields, params, fetchFirstPage, '/fundraisers');
    }
  }, {
    key: 'createFundraiser',
    value: function createFundraiser(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/fundraisers', fields, params, FundraiserPersonToCharity, pathOverride);
    }
  }, {
    key: 'getGroups',
    value: function getGroups(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Group, fields, params, fetchFirstPage, '/groups');
    }
  }, {
    key: 'getIdsForApps',
    value: function getIdsForApps(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(UserIDForApp, fields, params, fetchFirstPage, '/ids_for_apps');
    }
  }, {
    key: 'getIdsForBusiness',
    value: function getIdsForBusiness(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(UserIDForApp, fields, params, fetchFirstPage, '/ids_for_business');
    }
  }, {
    key: 'getIdsForPages',
    value: function getIdsForPages(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(UserIDForPage, fields, params, fetchFirstPage, '/ids_for_pages');
    }
  }, {
    key: 'getLikes',
    value: function getLikes(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/likes');
    }
  }, {
    key: 'getLiveVideos',
    value: function getLiveVideos(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(LiveVideo, fields, params, fetchFirstPage, '/live_videos');
    }
  }, {
    key: 'createLiveVideo',
    value: function createLiveVideo(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/live_videos', fields, params, LiveVideo, pathOverride);
    }
  }, {
    key: 'createMessengerDesktopPerformanceTrace',
    value: function createMessengerDesktopPerformanceTrace(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/messenger_desktop_performance_traces', fields, params, User, pathOverride);
    }
  }, {
    key: 'createMessengerKidsAccountsUnreadBadge',
    value: function createMessengerKidsAccountsUnreadBadge(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/messenger_kids_accounts_unread_badge', fields, params, User, pathOverride);
    }
  }, {
    key: 'getMusic',
    value: function getMusic(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/music');
    }
  }, {
    key: 'createNotification',
    value: function createNotification(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/notifications', fields, params, User, pathOverride);
    }
  }, {
    key: 'getPaymentTransactions',
    value: function getPaymentTransactions(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(PaymentEnginePayment, fields, params, fetchFirstPage, '/payment_transactions');
    }
  }, {
    key: 'deletePermissions',
    value: function deletePermissions() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(User.prototype.__proto__ || Object.getPrototypeOf(User.prototype), 'deleteEdge', this).call(this, '/permissions', params);
    }
  }, {
    key: 'getPermissions',
    value: function getPermissions(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Permission, fields, params, fetchFirstPage, '/permissions');
    }
  }, {
    key: 'getPersonalAdAccounts',
    value: function getPersonalAdAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdAccount, fields, params, fetchFirstPage, '/personal_ad_accounts');
    }
  }, {
    key: 'getPhotos',
    value: function getPhotos(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Photo, fields, params, fetchFirstPage, '/photos');
    }
  }, {
    key: 'createPhoto',
    value: function createPhoto(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/photos', fields, params, Photo, pathOverride);
    }
  }, {
    key: 'getPicture',
    value: function getPicture(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProfilePictureSource, fields, params, fetchFirstPage, '/picture');
    }
  }, {
    key: 'getPosts',
    value: function getPosts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Post, fields, params, fetchFirstPage, '/posts');
    }
  }, {
    key: 'getRichMediaDocuments',
    value: function getRichMediaDocuments(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Canvas, fields, params, fetchFirstPage, '/rich_media_documents');
    }
  }, {
    key: 'createStagingResource',
    value: function createStagingResource(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/staging_resources', fields, params, User, pathOverride);
    }
  }, {
    key: 'getVideos',
    value: function getVideos(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdVideo, fields, params, fetchFirstPage, '/videos');
    }
  }, {
    key: 'createVideo',
    value: function createVideo(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/videos', fields, params, AdVideo, pathOverride);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(User.prototype.__proto__ || Object.getPrototypeOf(User.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(User.prototype.__proto__ || Object.getPrototypeOf(User.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        about: 'about',
        age_range: 'age_range',
        birthday: 'birthday',
        client_business_id: 'client_business_id',
        community: 'community',
        cover: 'cover',
        currency: 'currency',
        education: 'education',
        email: 'email',
        favorite_athletes: 'favorite_athletes',
        favorite_teams: 'favorite_teams',
        first_name: 'first_name',
        gender: 'gender',
        hometown: 'hometown',
        id: 'id',
        inspirational_people: 'inspirational_people',
        install_type: 'install_type',
        installed: 'installed',
        is_guest_user: 'is_guest_user',
        is_work_account: 'is_work_account',
        languages: 'languages',
        last_name: 'last_name',
        link: 'link',
        local_news_megaphone_dismiss_status: 'local_news_megaphone_dismiss_status',
        local_news_subscription_status: 'local_news_subscription_status',
        locale: 'locale',
        location: 'location',
        meeting_for: 'meeting_for',
        middle_name: 'middle_name',
        name: 'name',
        name_format: 'name_format',
        payment_pricepoints: 'payment_pricepoints',
        political: 'political',
        profile_pic: 'profile_pic',
        quotes: 'quotes',
        relationship_status: 'relationship_status',
        religion: 'religion',
        shared_login_upgrade_required_by: 'shared_login_upgrade_required_by',
        short_name: 'short_name',
        significant_other: 'significant_other',
        sports: 'sports',
        supports_donate_button_in_live_video: 'supports_donate_button_in_live_video',
        third_party_id: 'third_party_id',
        timezone: 'timezone',
        token_for_business: 'token_for_business',
        updated_time: 'updated_time',
        verified: 'verified',
        video_upload_limits: 'video_upload_limits',
        website: 'website'
      });
    }
  }, {
    key: 'LocalNewsMegaphoneDismissStatus',
    get: function get() {
      return Object.freeze({
        no: 'NO',
        yes: 'YES'
      });
    }
  }, {
    key: 'LocalNewsSubscriptionStatus',
    get: function get() {
      return Object.freeze({
        status_off: 'STATUS_OFF',
        status_on: 'STATUS_ON'
      });
    }
  }, {
    key: 'Filtering',
    get: function get() {
      return Object.freeze({
        ema: 'ema',
        groups: 'groups',
        groups_social: 'groups_social'
      });
    }
  }, {
    key: 'Type',
    get: function get() {
      return Object.freeze({
        content_update: 'content_update',
        generic: 'generic'
      });
    }
  }]);
  return User;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * LiveVideoError
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var LiveVideoError = function (_AbstractCrudObject) {
  inherits(LiveVideoError, _AbstractCrudObject);

  function LiveVideoError() {
    classCallCheck(this, LiveVideoError);
    return possibleConstructorReturn(this, (LiveVideoError.__proto__ || Object.getPrototypeOf(LiveVideoError)).apply(this, arguments));
  }

  createClass(LiveVideoError, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        creation_time: 'creation_time',
        error_code: 'error_code',
        error_message: 'error_message',
        error_type: 'error_type',
        id: 'id'
      });
    }
  }]);
  return LiveVideoError;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * LiveVideoInputStream
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var LiveVideoInputStream = function (_AbstractCrudObject) {
  inherits(LiveVideoInputStream, _AbstractCrudObject);

  function LiveVideoInputStream() {
    classCallCheck(this, LiveVideoInputStream);
    return possibleConstructorReturn(this, (LiveVideoInputStream.__proto__ || Object.getPrototypeOf(LiveVideoInputStream)).apply(this, arguments));
  }

  createClass(LiveVideoInputStream, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        dash_ingest_url: 'dash_ingest_url',
        dash_preview_url: 'dash_preview_url',
        id: 'id',
        is_master: 'is_master',
        secure_stream_url: 'secure_stream_url',
        stream_health: 'stream_health',
        stream_id: 'stream_id',
        stream_url: 'stream_url'
      });
    }
  }]);
  return LiveVideoInputStream;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * VideoPoll
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var VideoPoll = function (_AbstractCrudObject) {
  inherits(VideoPoll, _AbstractCrudObject);

  function VideoPoll() {
    classCallCheck(this, VideoPoll);
    return possibleConstructorReturn(this, (VideoPoll.__proto__ || Object.getPrototypeOf(VideoPoll)).apply(this, arguments));
  }

  createClass(VideoPoll, [{
    key: 'getPollOptions',
    value: function getPollOptions(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/poll_options');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(VideoPoll.prototype.__proto__ || Object.getPrototypeOf(VideoPoll.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        close_after_voting: 'close_after_voting',
        default_open: 'default_open',
        id: 'id',
        question: 'question',
        show_gradient: 'show_gradient',
        show_results: 'show_results',
        status: 'status'
      });
    }
  }, {
    key: 'Status',
    get: function get() {
      return Object.freeze({
        closed: 'closed',
        results_open: 'results_open',
        voting_open: 'voting_open'
      });
    }
  }, {
    key: 'Action',
    get: function get() {
      return Object.freeze({
        attach_to_video: 'ATTACH_TO_VIDEO',
        close: 'CLOSE',
        delete_poll: 'DELETE_POLL',
        show_results: 'SHOW_RESULTS',
        show_voting: 'SHOW_VOTING'
      });
    }
  }]);
  return VideoPoll;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * LiveVideo
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var LiveVideo = function (_AbstractCrudObject) {
  inherits(LiveVideo, _AbstractCrudObject);

  function LiveVideo() {
    classCallCheck(this, LiveVideo);
    return possibleConstructorReturn(this, (LiveVideo.__proto__ || Object.getPrototypeOf(LiveVideo)).apply(this, arguments));
  }

  createClass(LiveVideo, [{
    key: 'getBlockedUsers',
    value: function getBlockedUsers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(User, fields, params, fetchFirstPage, '/blocked_users');
    }
  }, {
    key: 'getComments',
    value: function getComments(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Comment, fields, params, fetchFirstPage, '/comments');
    }
  }, {
    key: 'getCrosspostSharedPages',
    value: function getCrosspostSharedPages(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/crosspost_shared_pages');
    }
  }, {
    key: 'getCrosspostedBroadcasts',
    value: function getCrosspostedBroadcasts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(LiveVideo, fields, params, fetchFirstPage, '/crossposted_broadcasts');
    }
  }, {
    key: 'getErrors',
    value: function getErrors(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(LiveVideoError, fields, params, fetchFirstPage, '/errors');
    }
  }, {
    key: 'createInputStream',
    value: function createInputStream(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/input_streams', fields, params, LiveVideoInputStream, pathOverride);
    }
  }, {
    key: 'getPolls',
    value: function getPolls(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(VideoPoll, fields, params, fetchFirstPage, '/polls');
    }
  }, {
    key: 'createPoll',
    value: function createPoll(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/polls', fields, params, VideoPoll, pathOverride);
    }
  }, {
    key: 'getReactions',
    value: function getReactions(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Profile, fields, params, fetchFirstPage, '/reactions');
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(LiveVideo.prototype.__proto__ || Object.getPrototypeOf(LiveVideo.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(LiveVideo.prototype.__proto__ || Object.getPrototypeOf(LiveVideo.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        ad_break_config: 'ad_break_config',
        ad_break_failure_reason: 'ad_break_failure_reason',
        broadcast_start_time: 'broadcast_start_time',
        copyright: 'copyright',
        creation_time: 'creation_time',
        dash_ingest_url: 'dash_ingest_url',
        dash_preview_url: 'dash_preview_url',
        description: 'description',
        embed_html: 'embed_html',
        from: 'from',
        id: 'id',
        ingest_streams: 'ingest_streams',
        is_manual_mode: 'is_manual_mode',
        is_reference_only: 'is_reference_only',
        live_views: 'live_views',
        permalink_url: 'permalink_url',
        planned_start_time: 'planned_start_time',
        recommended_encoder_settings: 'recommended_encoder_settings',
        seconds_left: 'seconds_left',
        secure_stream_url: 'secure_stream_url',
        status: 'status',
        stream_url: 'stream_url',
        targeting: 'targeting',
        title: 'title',
        total_views: 'total_views',
        video: 'video'
      });
    }
  }, {
    key: 'Projection',
    get: function get() {
      return Object.freeze({
        cubemap: 'CUBEMAP',
        equirectangular: 'EQUIRECTANGULAR',
        half_equirectangular: 'HALF_EQUIRECTANGULAR'
      });
    }
  }, {
    key: 'SpatialAudioFormat',
    get: function get() {
      return Object.freeze({
        ambix_4: 'ambiX_4'
      });
    }
  }, {
    key: 'Status',
    get: function get() {
      return Object.freeze({
        live_now: 'LIVE_NOW',
        scheduled_canceled: 'SCHEDULED_CANCELED',
        scheduled_live: 'SCHEDULED_LIVE',
        scheduled_unpublished: 'SCHEDULED_UNPUBLISHED',
        unpublished: 'UNPUBLISHED'
      });
    }
  }, {
    key: 'StereoscopicMode',
    get: function get() {
      return Object.freeze({
        left_right: 'LEFT_RIGHT',
        mono: 'MONO',
        top_bottom: 'TOP_BOTTOM'
      });
    }
  }, {
    key: 'StreamType',
    get: function get() {
      return Object.freeze({
        ambient: 'AMBIENT',
        regular: 'REGULAR'
      });
    }
  }, {
    key: 'BroadcastStatus',
    get: function get() {
      return Object.freeze({
        live: 'LIVE',
        live_stopped: 'LIVE_STOPPED',
        processing: 'PROCESSING',
        scheduled_canceled: 'SCHEDULED_CANCELED',
        scheduled_expired: 'SCHEDULED_EXPIRED',
        scheduled_live: 'SCHEDULED_LIVE',
        scheduled_unpublished: 'SCHEDULED_UNPUBLISHED',
        unpublished: 'UNPUBLISHED',
        vod: 'VOD'
      });
    }
  }, {
    key: 'Source',
    get: function get() {
      return Object.freeze({
        owner: 'owner',
        target: 'target'
      });
    }
  }, {
    key: 'LiveCommentModerationSetting',
    get: function get() {
      return Object.freeze({
        default: 'DEFAULT',
        discussion: 'DISCUSSION',
        followed: 'FOLLOWED',
        follower: 'FOLLOWER',
        no_hyperlink: 'NO_HYPERLINK',
        protected_mode: 'PROTECTED_MODE',
        restricted: 'RESTRICTED',
        slow: 'SLOW',
        supporter: 'SUPPORTER',
        tagged: 'TAGGED'
      });
    }
  }, {
    key: 'PersistentStreamKeyStatus',
    get: function get() {
      return Object.freeze({
        disable: 'DISABLE',
        enable: 'ENABLE',
        regenerate: 'REGENERATE'
      });
    }
  }]);
  return LiveVideo;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * EventTicketTier
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var EventTicketTier = function (_AbstractCrudObject) {
  inherits(EventTicketTier, _AbstractCrudObject);

  function EventTicketTier() {
    classCallCheck(this, EventTicketTier);
    return possibleConstructorReturn(this, (EventTicketTier.__proto__ || Object.getPrototypeOf(EventTicketTier)).apply(this, arguments));
  }

  createClass(EventTicketTier, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        currency: 'currency',
        description: 'description',
        end_sales_time: 'end_sales_time',
        end_show_time: 'end_show_time',
        fee_settings: 'fee_settings',
        id: 'id',
        maximum_quantity: 'maximum_quantity',
        metadata: 'metadata',
        minimum_quantity: 'minimum_quantity',
        name: 'name',
        price: 'price',
        priority: 'priority',
        retailer_id: 'retailer_id',
        seating_map_image_url: 'seating_map_image_url',
        start_sales_time: 'start_sales_time',
        start_show_time: 'start_show_time',
        status: 'status',
        total_quantity: 'total_quantity'
      });
    }
  }]);
  return EventTicketTier;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Event
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Event = function (_AbstractCrudObject) {
  inherits(Event, _AbstractCrudObject);

  function Event() {
    classCallCheck(this, Event);
    return possibleConstructorReturn(this, (Event.__proto__ || Object.getPrototypeOf(Event)).apply(this, arguments));
  }

  createClass(Event, [{
    key: 'getComments',
    value: function getComments(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(NullNode, fields, params, fetchFirstPage, '/comments');
    }
  }, {
    key: 'getFeed',
    value: function getFeed(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(NullNode, fields, params, fetchFirstPage, '/feed');
    }
  }, {
    key: 'getLiveVideos',
    value: function getLiveVideos(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(NullNode, fields, params, fetchFirstPage, '/live_videos');
    }
  }, {
    key: 'createLiveVideo',
    value: function createLiveVideo(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/live_videos', fields, params, LiveVideo, pathOverride);
    }
  }, {
    key: 'getPhotos',
    value: function getPhotos(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(NullNode, fields, params, fetchFirstPage, '/photos');
    }
  }, {
    key: 'getPicture',
    value: function getPicture(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(NullNode, fields, params, fetchFirstPage, '/picture');
    }
  }, {
    key: 'getPosts',
    value: function getPosts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(NullNode, fields, params, fetchFirstPage, '/posts');
    }
  }, {
    key: 'getRoles',
    value: function getRoles(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Profile, fields, params, fetchFirstPage, '/roles');
    }
  }, {
    key: 'getTicketTiers',
    value: function getTicketTiers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(EventTicketTier, fields, params, fetchFirstPage, '/ticket_tiers');
    }
  }, {
    key: 'getVideos',
    value: function getVideos(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(NullNode, fields, params, fetchFirstPage, '/videos');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        attending_count: 'attending_count',
        can_guests_invite: 'can_guests_invite',
        category: 'category',
        cover: 'cover',
        created_time: 'created_time',
        declined_count: 'declined_count',
        description: 'description',
        discount_code_enabled: 'discount_code_enabled',
        end_time: 'end_time',
        event_times: 'event_times',
        guest_list_enabled: 'guest_list_enabled',
        id: 'id',
        interested_count: 'interested_count',
        is_canceled: 'is_canceled',
        is_draft: 'is_draft',
        is_online: 'is_online',
        is_page_owned: 'is_page_owned',
        maybe_count: 'maybe_count',
        name: 'name',
        noreply_count: 'noreply_count',
        online_event_format: 'online_event_format',
        online_event_third_party_url: 'online_event_third_party_url',
        owner: 'owner',
        parent_group: 'parent_group',
        place: 'place',
        registration_setting: 'registration_setting',
        scheduled_publish_time: 'scheduled_publish_time',
        start_time: 'start_time',
        ticket_setting: 'ticket_setting',
        ticket_uri: 'ticket_uri',
        ticket_uri_start_sales_time: 'ticket_uri_start_sales_time',
        ticketing_privacy_uri: 'ticketing_privacy_uri',
        ticketing_terms_uri: 'ticketing_terms_uri',
        timezone: 'timezone',
        type: 'type',
        updated_time: 'updated_time'
      });
    }
  }, {
    key: 'Category',
    get: function get() {
      return Object.freeze({
        classic_literature: 'CLASSIC_LITERATURE',
        comedy: 'COMEDY',
        crafts: 'CRAFTS',
        dance: 'DANCE',
        drinks: 'DRINKS',
        fitness_and_workouts: 'FITNESS_AND_WORKOUTS',
        foods: 'FOODS',
        games: 'GAMES',
        gardening: 'GARDENING',
        healthy_living_and_self_care: 'HEALTHY_LIVING_AND_SELF_CARE',
        health_and_medical: 'HEALTH_AND_MEDICAL',
        home_and_garden: 'HOME_AND_GARDEN',
        music_and_audio: 'MUSIC_AND_AUDIO',
        parties: 'PARTIES',
        professional_networking: 'PROFESSIONAL_NETWORKING',
        religions: 'RELIGIONS',
        shopping_event: 'SHOPPING_EVENT',
        social_issues: 'SOCIAL_ISSUES',
        sports: 'SPORTS',
        theater: 'THEATER',
        tv_and_movies: 'TV_AND_MOVIES',
        visual_arts: 'VISUAL_ARTS'
      });
    }
  }, {
    key: 'OnlineEventFormat',
    get: function get() {
      return Object.freeze({
        fb_live: 'fb_live',
        horizon_event: 'horizon_event',
        messenger_room: 'messenger_room',
        none: 'none',
        other: 'other',
        third_party: 'third_party'
      });
    }
  }, {
    key: 'Type',
    get: function get() {
      return Object.freeze({
        community: 'community',
        friends: 'friends',
        group: 'group',
        messenger_community: 'messenger_community',
        private: 'private',
        public: 'public',
        work_company: 'work_company'
      });
    }
  }, {
    key: 'EventStateFilter',
    get: function get() {
      return Object.freeze({
        canceled: 'canceled',
        draft: 'draft',
        published: 'published',
        scheduled_draft_for_publication: 'scheduled_draft_for_publication'
      });
    }
  }, {
    key: 'TimeFilter',
    get: function get() {
      return Object.freeze({
        past: 'past',
        upcoming: 'upcoming'
      });
    }
  }]);
  return Event;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * FantasyGame
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var FantasyGame = function (_AbstractCrudObject) {
  inherits(FantasyGame, _AbstractCrudObject);

  function FantasyGame() {
    classCallCheck(this, FantasyGame);
    return possibleConstructorReturn(this, (FantasyGame.__proto__ || Object.getPrototypeOf(FantasyGame)).apply(this, arguments));
  }

  createClass(FantasyGame, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        name: 'name'
      });
    }
  }]);
  return FantasyGame;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ImageCopyright
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ImageCopyright = function (_AbstractCrudObject) {
  inherits(ImageCopyright, _AbstractCrudObject);

  function ImageCopyright() {
    classCallCheck(this, ImageCopyright);
    return possibleConstructorReturn(this, (ImageCopyright.__proto__ || Object.getPrototypeOf(ImageCopyright)).apply(this, arguments));
  }

  createClass(ImageCopyright, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(ImageCopyright.prototype.__proto__ || Object.getPrototypeOf(ImageCopyright.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        artist: 'artist',
        copyright_monitoring_status: 'copyright_monitoring_status',
        creation_time: 'creation_time',
        creator: 'creator',
        custom_id: 'custom_id',
        description: 'description',
        filename: 'filename',
        id: 'id',
        image: 'image',
        matches_count: 'matches_count',
        original_content_creation_date: 'original_content_creation_date',
        ownership_countries: 'ownership_countries',
        tags: 'tags',
        title: 'title',
        update_time: 'update_time'
      });
    }
  }, {
    key: 'GeoOwnership',
    get: function get() {
      return Object.freeze({
        ac: 'AC',
        ad: 'AD',
        ae: 'AE',
        af: 'AF',
        ag: 'AG',
        ai: 'AI',
        al: 'AL',
        am: 'AM',
        an: 'AN',
        ao: 'AO',
        aq: 'AQ',
        ar: 'AR',
        as: 'AS',
        at: 'AT',
        au: 'AU',
        aw: 'AW',
        ax: 'AX',
        az: 'AZ',
        ba: 'BA',
        bb: 'BB',
        bd: 'BD',
        be: 'BE',
        bf: 'BF',
        bg: 'BG',
        bh: 'BH',
        bi: 'BI',
        bj: 'BJ',
        bl: 'BL',
        bm: 'BM',
        bn: 'BN',
        bo: 'BO',
        bq: 'BQ',
        br: 'BR',
        bs: 'BS',
        bt: 'BT',
        bv: 'BV',
        bw: 'BW',
        by: 'BY',
        bz: 'BZ',
        ca: 'CA',
        cc: 'CC',
        cd: 'CD',
        cf: 'CF',
        cg: 'CG',
        ch: 'CH',
        ci: 'CI',
        ck: 'CK',
        cl: 'CL',
        cm: 'CM',
        cn: 'CN',
        co: 'CO',
        cr: 'CR',
        cu: 'CU',
        cv: 'CV',
        cw: 'CW',
        cx: 'CX',
        cy: 'CY',
        cz: 'CZ',
        de: 'DE',
        dj: 'DJ',
        dk: 'DK',
        dm: 'DM',
        do: 'DO',
        dz: 'DZ',
        ec: 'EC',
        ee: 'EE',
        eg: 'EG',
        eh: 'EH',
        er: 'ER',
        es: 'ES',
        et: 'ET',
        fi: 'FI',
        fj: 'FJ',
        fk: 'FK',
        fm: 'FM',
        fo: 'FO',
        fr: 'FR',
        ga: 'GA',
        gb: 'GB',
        gd: 'GD',
        ge: 'GE',
        gf: 'GF',
        gg: 'GG',
        gh: 'GH',
        gi: 'GI',
        gl: 'GL',
        gm: 'GM',
        gn: 'GN',
        gp: 'GP',
        gq: 'GQ',
        gr: 'GR',
        gs: 'GS',
        gt: 'GT',
        gu: 'GU',
        gw: 'GW',
        gy: 'GY',
        hk: 'HK',
        hm: 'HM',
        hn: 'HN',
        hr: 'HR',
        ht: 'HT',
        hu: 'HU',
        id: 'ID',
        ie: 'IE',
        il: 'IL',
        im: 'IM',
        in: 'IN',
        io: 'IO',
        iq: 'IQ',
        ir: 'IR',
        is: 'IS',
        it: 'IT',
        je: 'JE',
        jm: 'JM',
        jo: 'JO',
        jp: 'JP',
        ke: 'KE',
        kg: 'KG',
        kh: 'KH',
        ki: 'KI',
        km: 'KM',
        kn: 'KN',
        kp: 'KP',
        kr: 'KR',
        kw: 'KW',
        ky: 'KY',
        kz: 'KZ',
        la: 'LA',
        lb: 'LB',
        lc: 'LC',
        li: 'LI',
        lk: 'LK',
        lr: 'LR',
        ls: 'LS',
        lt: 'LT',
        lu: 'LU',
        lv: 'LV',
        ly: 'LY',
        ma: 'MA',
        mc: 'MC',
        md: 'MD',
        me: 'ME',
        mf: 'MF',
        mg: 'MG',
        mh: 'MH',
        mk: 'MK',
        ml: 'ML',
        mm: 'MM',
        mn: 'MN',
        mo: 'MO',
        mp: 'MP',
        mq: 'MQ',
        mr: 'MR',
        ms: 'MS',
        mt: 'MT',
        mu: 'MU',
        mv: 'MV',
        mw: 'MW',
        mx: 'MX',
        my: 'MY',
        mz: 'MZ',
        na: 'NA',
        nc: 'NC',
        ne: 'NE',
        nf: 'NF',
        ng: 'NG',
        ni: 'NI',
        nl: 'NL',
        no: 'NO',
        np: 'NP',
        nr: 'NR',
        nu: 'NU',
        nz: 'NZ',
        om: 'OM',
        pa: 'PA',
        pe: 'PE',
        pf: 'PF',
        pg: 'PG',
        ph: 'PH',
        pk: 'PK',
        pl: 'PL',
        pm: 'PM',
        pn: 'PN',
        pr: 'PR',
        ps: 'PS',
        pt: 'PT',
        pw: 'PW',
        py: 'PY',
        qa: 'QA',
        re: 'RE',
        ro: 'RO',
        rs: 'RS',
        ru: 'RU',
        rw: 'RW',
        sa: 'SA',
        sb: 'SB',
        sc: 'SC',
        sd: 'SD',
        se: 'SE',
        sg: 'SG',
        sh: 'SH',
        si: 'SI',
        sj: 'SJ',
        sk: 'SK',
        sl: 'SL',
        sm: 'SM',
        sn: 'SN',
        so: 'SO',
        sr: 'SR',
        ss: 'SS',
        st: 'ST',
        sv: 'SV',
        sx: 'SX',
        sy: 'SY',
        sz: 'SZ',
        tc: 'TC',
        td: 'TD',
        tf: 'TF',
        tg: 'TG',
        th: 'TH',
        tj: 'TJ',
        tk: 'TK',
        tl: 'TL',
        tm: 'TM',
        tn: 'TN',
        to: 'TO',
        tp: 'TP',
        tr: 'TR',
        tt: 'TT',
        tv: 'TV',
        tw: 'TW',
        tz: 'TZ',
        ua: 'UA',
        ug: 'UG',
        um: 'UM',
        us: 'US',
        uy: 'UY',
        uz: 'UZ',
        va: 'VA',
        vc: 'VC',
        ve: 'VE',
        vg: 'VG',
        vi: 'VI',
        vn: 'VN',
        vu: 'VU',
        wf: 'WF',
        ws: 'WS',
        xk: 'XK',
        ye: 'YE',
        yt: 'YT',
        za: 'ZA',
        zm: 'ZM',
        zw: 'ZW'
      });
    }
  }]);
  return ImageCopyright;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * UserAvailableCatalogs
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var UserAvailableCatalogs = function (_AbstractCrudObject) {
  inherits(UserAvailableCatalogs, _AbstractCrudObject);

  function UserAvailableCatalogs() {
    classCallCheck(this, UserAvailableCatalogs);
    return possibleConstructorReturn(this, (UserAvailableCatalogs.__proto__ || Object.getPrototypeOf(UserAvailableCatalogs)).apply(this, arguments));
  }

  createClass(UserAvailableCatalogs, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        catalog_id: 'catalog_id',
        catalog_name: 'catalog_name',
        product_count: 'product_count',
        shop_name: 'shop_name'
      });
    }
  }]);
  return UserAvailableCatalogs;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * IGBCAdsPermission
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var IGBCAdsPermission = function (_AbstractCrudObject) {
  inherits(IGBCAdsPermission, _AbstractCrudObject);

  function IGBCAdsPermission() {
    classCallCheck(this, IGBCAdsPermission);
    return possibleConstructorReturn(this, (IGBCAdsPermission.__proto__ || Object.getPrototypeOf(IGBCAdsPermission)).apply(this, arguments));
  }

  createClass(IGBCAdsPermission, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        permission_type: 'permission_type',
        status: 'status'
      });
    }
  }]);
  return IGBCAdsPermission;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * BrandedContentShadowIGMediaID
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var BrandedContentShadowIGMediaID = function (_AbstractCrudObject) {
  inherits(BrandedContentShadowIGMediaID, _AbstractCrudObject);

  function BrandedContentShadowIGMediaID() {
    classCallCheck(this, BrandedContentShadowIGMediaID);
    return possibleConstructorReturn(this, (BrandedContentShadowIGMediaID.__proto__ || Object.getPrototypeOf(BrandedContentShadowIGMediaID)).apply(this, arguments));
  }

  createClass(BrandedContentShadowIGMediaID, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        eligibility_errors: 'eligibility_errors',
        has_permission_for_partnership_ad: 'has_permission_for_partnership_ad',
        id: 'id',
        linked_products: 'linked_products',
        owner_id: 'owner_id',
        permalink: 'permalink',
        product_suggestions: 'product_suggestions',
        recommended_campaign_objectives: 'recommended_campaign_objectives'
      });
    }
  }, {
    key: 'MediaRelationship',
    get: function get() {
      return Object.freeze({
        is_tagged: 'IS_TAGGED',
        owned: 'OWNED'
      });
    }
  }]);
  return BrandedContentShadowIGMediaID;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * BrandedContentShadowIGUserID
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var BrandedContentShadowIGUserID = function (_AbstractCrudObject) {
  inherits(BrandedContentShadowIGUserID, _AbstractCrudObject);

  function BrandedContentShadowIGUserID() {
    classCallCheck(this, BrandedContentShadowIGUserID);
    return possibleConstructorReturn(this, (BrandedContentShadowIGUserID.__proto__ || Object.getPrototypeOf(BrandedContentShadowIGUserID)).apply(this, arguments));
  }

  createClass(BrandedContentShadowIGUserID, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id'
      });
    }
  }]);
  return BrandedContentShadowIGUserID;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ShadowIGUserCatalogProductSearch
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ShadowIGUserCatalogProductSearch = function (_AbstractCrudObject) {
  inherits(ShadowIGUserCatalogProductSearch, _AbstractCrudObject);

  function ShadowIGUserCatalogProductSearch() {
    classCallCheck(this, ShadowIGUserCatalogProductSearch);
    return possibleConstructorReturn(this, (ShadowIGUserCatalogProductSearch.__proto__ || Object.getPrototypeOf(ShadowIGUserCatalogProductSearch)).apply(this, arguments));
  }

  createClass(ShadowIGUserCatalogProductSearch, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        image_url: 'image_url',
        is_checkout_flow: 'is_checkout_flow',
        merchant_id: 'merchant_id',
        product_id: 'product_id',
        product_name: 'product_name',
        product_variants: 'product_variants',
        retailer_id: 'retailer_id',
        review_status: 'review_status'
      });
    }
  }]);
  return ShadowIGUserCatalogProductSearch;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ShadowIGUserCollaborationInvites
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ShadowIGUserCollaborationInvites = function (_AbstractCrudObject) {
  inherits(ShadowIGUserCollaborationInvites, _AbstractCrudObject);

  function ShadowIGUserCollaborationInvites() {
    classCallCheck(this, ShadowIGUserCollaborationInvites);
    return possibleConstructorReturn(this, (ShadowIGUserCollaborationInvites.__proto__ || Object.getPrototypeOf(ShadowIGUserCollaborationInvites)).apply(this, arguments));
  }

  createClass(ShadowIGUserCollaborationInvites, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        caption: 'caption',
        media_id: 'media_id',
        media_owner_username: 'media_owner_username',
        media_url: 'media_url'
      });
    }
  }]);
  return ShadowIGUserCollaborationInvites;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ThreadsUser
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ThreadsUser = function (_AbstractCrudObject) {
  inherits(ThreadsUser, _AbstractCrudObject);

  function ThreadsUser() {
    classCallCheck(this, ThreadsUser);
    return possibleConstructorReturn(this, (ThreadsUser.__proto__ || Object.getPrototypeOf(ThreadsUser)).apply(this, arguments));
  }

  createClass(ThreadsUser, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        threads_user_id: 'threads_user_id',
        threads_user_profile_pic: 'threads_user_profile_pic'
      });
    }
  }]);
  return ThreadsUser;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ContentPublishingLimitResponse
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ContentPublishingLimitResponse = function (_AbstractCrudObject) {
  inherits(ContentPublishingLimitResponse, _AbstractCrudObject);

  function ContentPublishingLimitResponse() {
    classCallCheck(this, ContentPublishingLimitResponse);
    return possibleConstructorReturn(this, (ContentPublishingLimitResponse.__proto__ || Object.getPrototypeOf(ContentPublishingLimitResponse)).apply(this, arguments));
  }

  createClass(ContentPublishingLimitResponse, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        config: 'config',
        quota_usage: 'quota_usage'
      });
    }
  }]);
  return ContentPublishingLimitResponse;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * IGUserExportForCAM
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var IGUserExportForCAM = function (_AbstractCrudObject) {
  inherits(IGUserExportForCAM, _AbstractCrudObject);

  function IGUserExportForCAM() {
    classCallCheck(this, IGUserExportForCAM);
    return possibleConstructorReturn(this, (IGUserExportForCAM.__proto__ || Object.getPrototypeOf(IGUserExportForCAM)).apply(this, arguments));
  }

  createClass(IGUserExportForCAM, [{
    key: 'getBrandedContentMedia',
    value: function getBrandedContentMedia(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/branded_content_media');
    }
  }, {
    key: 'getInsights',
    value: function getInsights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/insights');
    }
  }, {
    key: 'getRecentMedia',
    value: function getRecentMedia(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/recent_media');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        age_bucket: 'age_bucket',
        biography: 'biography',
        country: 'country',
        email: 'email',
        gender: 'gender',
        has_brand_partnership_experience: 'has_brand_partnership_experience',
        id: 'id',
        is_account_verified: 'is_account_verified',
        is_paid_partnership_messages_enabled: 'is_paid_partnership_messages_enabled',
        messaging_id: 'messaging_id',
        onboarded_status: 'onboarded_status',
        past_brand_partnership_partners: 'past_brand_partnership_partners',
        portfolio_url: 'portfolio_url',
        username: 'username'
      });
    }
  }, {
    key: 'CreatorCountries',
    get: function get() {
      return Object.freeze({
        ac: 'AC',
        ad: 'AD',
        ae: 'AE',
        af: 'AF',
        ag: 'AG',
        ai: 'AI',
        al: 'AL',
        am: 'AM',
        an: 'AN',
        ao: 'AO',
        aq: 'AQ',
        ar: 'AR',
        as: 'AS',
        at: 'AT',
        au: 'AU',
        aw: 'AW',
        ax: 'AX',
        az: 'AZ',
        ba: 'BA',
        bb: 'BB',
        bd: 'BD',
        be: 'BE',
        bf: 'BF',
        bg: 'BG',
        bh: 'BH',
        bi: 'BI',
        bj: 'BJ',
        bl: 'BL',
        bm: 'BM',
        bn: 'BN',
        bo: 'BO',
        bq: 'BQ',
        br: 'BR',
        bs: 'BS',
        bt: 'BT',
        bv: 'BV',
        bw: 'BW',
        by: 'BY',
        bz: 'BZ',
        ca: 'CA',
        cc: 'CC',
        cd: 'CD',
        cf: 'CF',
        cg: 'CG',
        ch: 'CH',
        ci: 'CI',
        ck: 'CK',
        cl: 'CL',
        cm: 'CM',
        cn: 'CN',
        co: 'CO',
        cr: 'CR',
        cu: 'CU',
        cv: 'CV',
        cw: 'CW',
        cx: 'CX',
        cy: 'CY',
        cz: 'CZ',
        de: 'DE',
        dj: 'DJ',
        dk: 'DK',
        dm: 'DM',
        do: 'DO',
        dz: 'DZ',
        ec: 'EC',
        ee: 'EE',
        eg: 'EG',
        eh: 'EH',
        er: 'ER',
        es: 'ES',
        et: 'ET',
        fi: 'FI',
        fj: 'FJ',
        fk: 'FK',
        fm: 'FM',
        fo: 'FO',
        fr: 'FR',
        ga: 'GA',
        gb: 'GB',
        gd: 'GD',
        ge: 'GE',
        gf: 'GF',
        gg: 'GG',
        gh: 'GH',
        gi: 'GI',
        gl: 'GL',
        gm: 'GM',
        gn: 'GN',
        gp: 'GP',
        gq: 'GQ',
        gr: 'GR',
        gs: 'GS',
        gt: 'GT',
        gu: 'GU',
        gw: 'GW',
        gy: 'GY',
        hk: 'HK',
        hm: 'HM',
        hn: 'HN',
        hr: 'HR',
        ht: 'HT',
        hu: 'HU',
        id: 'ID',
        ie: 'IE',
        il: 'IL',
        im: 'IM',
        in: 'IN',
        io: 'IO',
        iq: 'IQ',
        ir: 'IR',
        is: 'IS',
        it: 'IT',
        je: 'JE',
        jm: 'JM',
        jo: 'JO',
        jp: 'JP',
        ke: 'KE',
        kg: 'KG',
        kh: 'KH',
        ki: 'KI',
        km: 'KM',
        kn: 'KN',
        kp: 'KP',
        kr: 'KR',
        kw: 'KW',
        ky: 'KY',
        kz: 'KZ',
        la: 'LA',
        lb: 'LB',
        lc: 'LC',
        li: 'LI',
        lk: 'LK',
        lr: 'LR',
        ls: 'LS',
        lt: 'LT',
        lu: 'LU',
        lv: 'LV',
        ly: 'LY',
        ma: 'MA',
        mc: 'MC',
        md: 'MD',
        me: 'ME',
        mf: 'MF',
        mg: 'MG',
        mh: 'MH',
        mk: 'MK',
        ml: 'ML',
        mm: 'MM',
        mn: 'MN',
        mo: 'MO',
        mp: 'MP',
        mq: 'MQ',
        mr: 'MR',
        ms: 'MS',
        mt: 'MT',
        mu: 'MU',
        mv: 'MV',
        mw: 'MW',
        mx: 'MX',
        my: 'MY',
        mz: 'MZ',
        na: 'NA',
        nc: 'NC',
        ne: 'NE',
        nf: 'NF',
        ng: 'NG',
        ni: 'NI',
        nl: 'NL',
        no: 'NO',
        np: 'NP',
        nr: 'NR',
        nu: 'NU',
        nz: 'NZ',
        om: 'OM',
        pa: 'PA',
        pe: 'PE',
        pf: 'PF',
        pg: 'PG',
        ph: 'PH',
        pk: 'PK',
        pl: 'PL',
        pm: 'PM',
        pn: 'PN',
        pr: 'PR',
        ps: 'PS',
        pt: 'PT',
        pw: 'PW',
        py: 'PY',
        qa: 'QA',
        re: 'RE',
        ro: 'RO',
        rs: 'RS',
        ru: 'RU',
        rw: 'RW',
        sa: 'SA',
        sb: 'SB',
        sc: 'SC',
        sd: 'SD',
        se: 'SE',
        sg: 'SG',
        sh: 'SH',
        si: 'SI',
        sj: 'SJ',
        sk: 'SK',
        sl: 'SL',
        sm: 'SM',
        sn: 'SN',
        so: 'SO',
        sr: 'SR',
        ss: 'SS',
        st: 'ST',
        sv: 'SV',
        sx: 'SX',
        sy: 'SY',
        sz: 'SZ',
        tc: 'TC',
        td: 'TD',
        tf: 'TF',
        tg: 'TG',
        th: 'TH',
        tj: 'TJ',
        tk: 'TK',
        tl: 'TL',
        tm: 'TM',
        tn: 'TN',
        to: 'TO',
        tr: 'TR',
        tt: 'TT',
        tv: 'TV',
        tw: 'TW',
        tz: 'TZ',
        ua: 'UA',
        ug: 'UG',
        um: 'UM',
        us: 'US',
        uy: 'UY',
        uz: 'UZ',
        va: 'VA',
        vc: 'VC',
        ve: 'VE',
        vg: 'VG',
        vi: 'VI',
        vn: 'VN',
        vu: 'VU',
        wf: 'WF',
        ws: 'WS',
        xk: 'XK',
        ye: 'YE',
        yt: 'YT',
        za: 'ZA',
        zm: 'ZM',
        zw: 'ZW'
      });
    }
  }, {
    key: 'CreatorGender',
    get: function get() {
      return Object.freeze({
        custom: 'custom',
        female: 'female',
        male: 'male',
        unknown: 'unknown'
      });
    }
  }, {
    key: 'MajorAudienceCountries',
    get: function get() {
      return Object.freeze({
        ac: 'AC',
        ad: 'AD',
        ae: 'AE',
        af: 'AF',
        ag: 'AG',
        ai: 'AI',
        al: 'AL',
        am: 'AM',
        an: 'AN',
        ao: 'AO',
        aq: 'AQ',
        ar: 'AR',
        as: 'AS',
        at: 'AT',
        au: 'AU',
        aw: 'AW',
        ax: 'AX',
        az: 'AZ',
        ba: 'BA',
        bb: 'BB',
        bd: 'BD',
        be: 'BE',
        bf: 'BF',
        bg: 'BG',
        bh: 'BH',
        bi: 'BI',
        bj: 'BJ',
        bl: 'BL',
        bm: 'BM',
        bn: 'BN',
        bo: 'BO',
        bq: 'BQ',
        br: 'BR',
        bs: 'BS',
        bt: 'BT',
        bv: 'BV',
        bw: 'BW',
        by: 'BY',
        bz: 'BZ',
        ca: 'CA',
        cc: 'CC',
        cd: 'CD',
        cf: 'CF',
        cg: 'CG',
        ch: 'CH',
        ci: 'CI',
        ck: 'CK',
        cl: 'CL',
        cm: 'CM',
        cn: 'CN',
        co: 'CO',
        cr: 'CR',
        cu: 'CU',
        cv: 'CV',
        cw: 'CW',
        cx: 'CX',
        cy: 'CY',
        cz: 'CZ',
        de: 'DE',
        dj: 'DJ',
        dk: 'DK',
        dm: 'DM',
        do: 'DO',
        dz: 'DZ',
        ec: 'EC',
        ee: 'EE',
        eg: 'EG',
        eh: 'EH',
        er: 'ER',
        es: 'ES',
        et: 'ET',
        fi: 'FI',
        fj: 'FJ',
        fk: 'FK',
        fm: 'FM',
        fo: 'FO',
        fr: 'FR',
        ga: 'GA',
        gb: 'GB',
        gd: 'GD',
        ge: 'GE',
        gf: 'GF',
        gg: 'GG',
        gh: 'GH',
        gi: 'GI',
        gl: 'GL',
        gm: 'GM',
        gn: 'GN',
        gp: 'GP',
        gq: 'GQ',
        gr: 'GR',
        gs: 'GS',
        gt: 'GT',
        gu: 'GU',
        gw: 'GW',
        gy: 'GY',
        hk: 'HK',
        hm: 'HM',
        hn: 'HN',
        hr: 'HR',
        ht: 'HT',
        hu: 'HU',
        id: 'ID',
        ie: 'IE',
        il: 'IL',
        im: 'IM',
        in: 'IN',
        io: 'IO',
        iq: 'IQ',
        ir: 'IR',
        is: 'IS',
        it: 'IT',
        je: 'JE',
        jm: 'JM',
        jo: 'JO',
        jp: 'JP',
        ke: 'KE',
        kg: 'KG',
        kh: 'KH',
        ki: 'KI',
        km: 'KM',
        kn: 'KN',
        kp: 'KP',
        kr: 'KR',
        kw: 'KW',
        ky: 'KY',
        kz: 'KZ',
        la: 'LA',
        lb: 'LB',
        lc: 'LC',
        li: 'LI',
        lk: 'LK',
        lr: 'LR',
        ls: 'LS',
        lt: 'LT',
        lu: 'LU',
        lv: 'LV',
        ly: 'LY',
        ma: 'MA',
        mc: 'MC',
        md: 'MD',
        me: 'ME',
        mf: 'MF',
        mg: 'MG',
        mh: 'MH',
        mk: 'MK',
        ml: 'ML',
        mm: 'MM',
        mn: 'MN',
        mo: 'MO',
        mp: 'MP',
        mq: 'MQ',
        mr: 'MR',
        ms: 'MS',
        mt: 'MT',
        mu: 'MU',
        mv: 'MV',
        mw: 'MW',
        mx: 'MX',
        my: 'MY',
        mz: 'MZ',
        na: 'NA',
        nc: 'NC',
        ne: 'NE',
        nf: 'NF',
        ng: 'NG',
        ni: 'NI',
        nl: 'NL',
        no: 'NO',
        np: 'NP',
        nr: 'NR',
        nu: 'NU',
        nz: 'NZ',
        om: 'OM',
        pa: 'PA',
        pe: 'PE',
        pf: 'PF',
        pg: 'PG',
        ph: 'PH',
        pk: 'PK',
        pl: 'PL',
        pm: 'PM',
        pn: 'PN',
        pr: 'PR',
        ps: 'PS',
        pt: 'PT',
        pw: 'PW',
        py: 'PY',
        qa: 'QA',
        re: 'RE',
        ro: 'RO',
        rs: 'RS',
        ru: 'RU',
        rw: 'RW',
        sa: 'SA',
        sb: 'SB',
        sc: 'SC',
        sd: 'SD',
        se: 'SE',
        sg: 'SG',
        sh: 'SH',
        si: 'SI',
        sj: 'SJ',
        sk: 'SK',
        sl: 'SL',
        sm: 'SM',
        sn: 'SN',
        so: 'SO',
        sr: 'SR',
        ss: 'SS',
        st: 'ST',
        sv: 'SV',
        sx: 'SX',
        sy: 'SY',
        sz: 'SZ',
        tc: 'TC',
        td: 'TD',
        tf: 'TF',
        tg: 'TG',
        th: 'TH',
        tj: 'TJ',
        tk: 'TK',
        tl: 'TL',
        tm: 'TM',
        tn: 'TN',
        to: 'TO',
        tr: 'TR',
        tt: 'TT',
        tv: 'TV',
        tw: 'TW',
        tz: 'TZ',
        ua: 'UA',
        ug: 'UG',
        um: 'UM',
        us: 'US',
        uy: 'UY',
        uz: 'UZ',
        va: 'VA',
        vc: 'VC',
        ve: 'VE',
        vg: 'VG',
        vi: 'VI',
        vn: 'VN',
        vu: 'VU',
        wf: 'WF',
        ws: 'WS',
        xk: 'XK',
        ye: 'YE',
        yt: 'YT',
        za: 'ZA',
        zm: 'ZM',
        zw: 'ZW'
      });
    }
  }, {
    key: 'MajorAudienceGender',
    get: function get() {
      return Object.freeze({
        custom: 'custom',
        female: 'female',
        male: 'male',
        unknown: 'unknown'
      });
    }
  }]);
  return IGUserExportForCAM;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * InstagramInsightsResult
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var InstagramInsightsResult = function (_AbstractCrudObject) {
  inherits(InstagramInsightsResult, _AbstractCrudObject);

  function InstagramInsightsResult() {
    classCallCheck(this, InstagramInsightsResult);
    return possibleConstructorReturn(this, (InstagramInsightsResult.__proto__ || Object.getPrototypeOf(InstagramInsightsResult)).apply(this, arguments));
  }

  createClass(InstagramInsightsResult, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        description: 'description',
        id: 'id',
        name: 'name',
        period: 'period',
        title: 'title',
        total_value: 'total_value',
        values: 'values'
      });
    }
  }, {
    key: 'Breakdown',
    get: function get() {
      return Object.freeze({
        action_type: 'action_type',
        follow_type: 'follow_type',
        story_navigation_action_type: 'story_navigation_action_type',
        surface_type: 'surface_type'
      });
    }
  }, {
    key: 'Metric',
    get: function get() {
      return Object.freeze({
        clips_replays_count: 'clips_replays_count',
        comments: 'comments',
        follows: 'follows',
        ig_reels_aggregated_all_plays_count: 'ig_reels_aggregated_all_plays_count',
        ig_reels_avg_watch_time: 'ig_reels_avg_watch_time',
        ig_reels_video_view_total_time: 'ig_reels_video_view_total_time',
        impressions: 'impressions',
        likes: 'likes',
        navigation: 'navigation',
        plays: 'plays',
        profile_activity: 'profile_activity',
        profile_visits: 'profile_visits',
        reach: 'reach',
        replies: 'replies',
        saved: 'saved',
        shares: 'shares',
        total_interactions: 'total_interactions',
        video_views: 'video_views',
        views: 'views'
      });
    }
  }, {
    key: 'Period',
    get: function get() {
      return Object.freeze({
        day: 'day',
        days_28: 'days_28',
        lifetime: 'lifetime',
        month: 'month',
        total_over_range: 'total_over_range',
        week: 'week'
      });
    }
  }, {
    key: 'MetricType',
    get: function get() {
      return Object.freeze({
        default: 'default',
        time_series: 'time_series',
        total_value: 'total_value'
      });
    }
  }, {
    key: 'Timeframe',
    get: function get() {
      return Object.freeze({
        last_14_days: 'last_14_days',
        last_30_days: 'last_30_days',
        last_90_days: 'last_90_days',
        prev_month: 'prev_month',
        this_month: 'this_month',
        this_week: 'this_week'
      });
    }
  }]);
  return InstagramInsightsResult;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * IGBoostMediaAd
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var IGBoostMediaAd = function (_AbstractCrudObject) {
  inherits(IGBoostMediaAd, _AbstractCrudObject);

  function IGBoostMediaAd() {
    classCallCheck(this, IGBoostMediaAd);
    return possibleConstructorReturn(this, (IGBoostMediaAd.__proto__ || Object.getPrototypeOf(IGBoostMediaAd)).apply(this, arguments));
  }

  createClass(IGBoostMediaAd, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        ad_id: 'ad_id',
        ad_status: 'ad_status',
        id: 'id'
      });
    }
  }]);
  return IGBoostMediaAd;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ShadowIGMediaCollaborators
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ShadowIGMediaCollaborators = function (_AbstractCrudObject) {
  inherits(ShadowIGMediaCollaborators, _AbstractCrudObject);

  function ShadowIGMediaCollaborators() {
    classCallCheck(this, ShadowIGMediaCollaborators);
    return possibleConstructorReturn(this, (ShadowIGMediaCollaborators.__proto__ || Object.getPrototypeOf(ShadowIGMediaCollaborators)).apply(this, arguments));
  }

  createClass(ShadowIGMediaCollaborators, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        invite_status: 'invite_status',
        username: 'username'
      });
    }
  }]);
  return ShadowIGMediaCollaborators;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * IGComment
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var IGComment = function (_AbstractCrudObject) {
  inherits(IGComment, _AbstractCrudObject);

  function IGComment() {
    classCallCheck(this, IGComment);
    return possibleConstructorReturn(this, (IGComment.__proto__ || Object.getPrototypeOf(IGComment)).apply(this, arguments));
  }

  createClass(IGComment, [{
    key: 'getReplies',
    value: function getReplies(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGComment, fields, params, fetchFirstPage, '/replies');
    }
  }, {
    key: 'createReply',
    value: function createReply(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/replies', fields, params, IGComment, pathOverride);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(IGComment.prototype.__proto__ || Object.getPrototypeOf(IGComment.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(IGComment.prototype.__proto__ || Object.getPrototypeOf(IGComment.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        from: 'from',
        hidden: 'hidden',
        id: 'id',
        legacy_instagram_comment_id: 'legacy_instagram_comment_id',
        like_count: 'like_count',
        media: 'media',
        parent_id: 'parent_id',
        text: 'text',
        timestamp: 'timestamp',
        user: 'user',
        username: 'username'
      });
    }
  }]);
  return IGComment;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ShadowIGMediaProductTags
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ShadowIGMediaProductTags = function (_AbstractCrudObject) {
  inherits(ShadowIGMediaProductTags, _AbstractCrudObject);

  function ShadowIGMediaProductTags() {
    classCallCheck(this, ShadowIGMediaProductTags);
    return possibleConstructorReturn(this, (ShadowIGMediaProductTags.__proto__ || Object.getPrototypeOf(ShadowIGMediaProductTags)).apply(this, arguments));
  }

  createClass(ShadowIGMediaProductTags, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        image_url: 'image_url',
        is_checkout: 'is_checkout',
        merchant_id: 'merchant_id',
        name: 'name',
        price_string: 'price_string',
        product_id: 'product_id',
        review_status: 'review_status',
        stripped_price_string: 'stripped_price_string',
        stripped_sale_price_string: 'stripped_sale_price_string',
        x: 'x',
        y: 'y'
      });
    }
  }]);
  return ShadowIGMediaProductTags;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * IGMedia
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var IGMedia = function (_AbstractCrudObject) {
  inherits(IGMedia, _AbstractCrudObject);

  function IGMedia() {
    classCallCheck(this, IGMedia);
    return possibleConstructorReturn(this, (IGMedia.__proto__ || Object.getPrototypeOf(IGMedia)).apply(this, arguments));
  }

  createClass(IGMedia, [{
    key: 'getBoostAdsList',
    value: function getBoostAdsList(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGBoostMediaAd, fields, params, fetchFirstPage, '/boost_ads_list');
    }
  }, {
    key: 'getBrandedContentPartnerPromote',
    value: function getBrandedContentPartnerPromote(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BrandedContentShadowIGUserID, fields, params, fetchFirstPage, '/branded_content_partner_promote');
    }
  }, {
    key: 'createBrandedContentPartnerPromote',
    value: function createBrandedContentPartnerPromote(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/branded_content_partner_promote', fields, params, BrandedContentShadowIGUserID, pathOverride);
    }
  }, {
    key: 'getChildren',
    value: function getChildren(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGMedia, fields, params, fetchFirstPage, '/children');
    }
  }, {
    key: 'getCollaborators',
    value: function getCollaborators(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ShadowIGMediaCollaborators, fields, params, fetchFirstPage, '/collaborators');
    }
  }, {
    key: 'getComments',
    value: function getComments(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGComment, fields, params, fetchFirstPage, '/comments');
    }
  }, {
    key: 'createComment',
    value: function createComment(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/comments', fields, params, IGComment, pathOverride);
    }
  }, {
    key: 'getInsights',
    value: function getInsights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(InstagramInsightsResult, fields, params, fetchFirstPage, '/insights');
    }
  }, {
    key: 'deletePartnershipAdCode',
    value: function deletePartnershipAdCode() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(IGMedia.prototype.__proto__ || Object.getPrototypeOf(IGMedia.prototype), 'deleteEdge', this).call(this, '/partnership_ad_code', params);
    }
  }, {
    key: 'createPartnershipAdCode',
    value: function createPartnershipAdCode(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/partnership_ad_code', fields, params, null, pathOverride);
    }
  }, {
    key: 'getProductTags',
    value: function getProductTags(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ShadowIGMediaProductTags, fields, params, fetchFirstPage, '/product_tags');
    }
  }, {
    key: 'createProductTag',
    value: function createProductTag(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/product_tags', fields, params, ShadowIGMediaProductTags, pathOverride);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(IGMedia.prototype.__proto__ || Object.getPrototypeOf(IGMedia.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(IGMedia.prototype.__proto__ || Object.getPrototypeOf(IGMedia.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        alt_text: 'alt_text',
        boost_eligibility_info: 'boost_eligibility_info',
        caption: 'caption',
        comments_count: 'comments_count',
        copyright_check_information: 'copyright_check_information',
        has_poll: 'has_poll',
        has_slider: 'has_slider',
        id: 'id',
        ig_id: 'ig_id',
        is_comment_enabled: 'is_comment_enabled',
        is_shared_to_feed: 'is_shared_to_feed',
        legacy_instagram_media_id: 'legacy_instagram_media_id',
        like_count: 'like_count',
        media_product_type: 'media_product_type',
        media_type: 'media_type',
        media_url: 'media_url',
        owner: 'owner',
        permalink: 'permalink',
        shortcode: 'shortcode',
        thumbnail_url: 'thumbnail_url',
        timestamp: 'timestamp',
        username: 'username',
        video_title: 'video_title',
        view_count: 'view_count'
      });
    }
  }]);
  return IGMedia;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * UserPageOneTimeOptInTokenSettings
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var UserPageOneTimeOptInTokenSettings = function (_AbstractCrudObject) {
  inherits(UserPageOneTimeOptInTokenSettings, _AbstractCrudObject);

  function UserPageOneTimeOptInTokenSettings() {
    classCallCheck(this, UserPageOneTimeOptInTokenSettings);
    return possibleConstructorReturn(this, (UserPageOneTimeOptInTokenSettings.__proto__ || Object.getPrototypeOf(UserPageOneTimeOptInTokenSettings)).apply(this, arguments));
  }

  createClass(UserPageOneTimeOptInTokenSettings, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        creation_timestamp: 'creation_timestamp',
        custom_audience_ids: 'custom_audience_ids',
        next_eligible_time: 'next_eligible_time',
        next_eligible_time_for_paid_messaging: 'next_eligible_time_for_paid_messaging',
        notification_messages_frequency: 'notification_messages_frequency',
        notification_messages_reoptin: 'notification_messages_reoptin',
        notification_messages_timezone: 'notification_messages_timezone',
        notification_messages_token: 'notification_messages_token',
        recipient_id: 'recipient_id',
        token_expiry_timestamp: 'token_expiry_timestamp',
        topic_title: 'topic_title',
        user_token_status: 'user_token_status',
        id: 'id'
      });
    }
  }]);
  return UserPageOneTimeOptInTokenSettings;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * IGShoppingProductAppeal
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var IGShoppingProductAppeal = function (_AbstractCrudObject) {
  inherits(IGShoppingProductAppeal, _AbstractCrudObject);

  function IGShoppingProductAppeal() {
    classCallCheck(this, IGShoppingProductAppeal);
    return possibleConstructorReturn(this, (IGShoppingProductAppeal.__proto__ || Object.getPrototypeOf(IGShoppingProductAppeal)).apply(this, arguments));
  }

  createClass(IGShoppingProductAppeal, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        eligible_for_appeal: 'eligible_for_appeal',
        product_appeal_status: 'product_appeal_status',
        product_id: 'product_id',
        rejection_reasons: 'rejection_reasons',
        review_status: 'review_status'
      });
    }
  }]);
  return IGShoppingProductAppeal;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ShadowIGHashtag
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ShadowIGHashtag = function (_AbstractCrudObject) {
  inherits(ShadowIGHashtag, _AbstractCrudObject);

  function ShadowIGHashtag() {
    classCallCheck(this, ShadowIGHashtag);
    return possibleConstructorReturn(this, (ShadowIGHashtag.__proto__ || Object.getPrototypeOf(ShadowIGHashtag)).apply(this, arguments));
  }

  createClass(ShadowIGHashtag, [{
    key: 'getRecentMedia',
    value: function getRecentMedia(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGMedia, fields, params, fetchFirstPage, '/recent_media');
    }
  }, {
    key: 'getTopMedia',
    value: function getTopMedia(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGMedia, fields, params, fetchFirstPage, '/top_media');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        name: 'name'
      });
    }
  }]);
  return ShadowIGHashtag;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ShadowIGScheduledMedia
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ShadowIGScheduledMedia = function (_AbstractCrudObject) {
  inherits(ShadowIGScheduledMedia, _AbstractCrudObject);

  function ShadowIGScheduledMedia() {
    classCallCheck(this, ShadowIGScheduledMedia);
    return possibleConstructorReturn(this, (ShadowIGScheduledMedia.__proto__ || Object.getPrototypeOf(ShadowIGScheduledMedia)).apply(this, arguments));
  }

  createClass(ShadowIGScheduledMedia, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        caption: 'caption',
        id: 'id',
        media_type: 'media_type',
        media_url: 'media_url',
        publish_timestamp: 'publish_timestamp',
        thumbnail_url: 'thumbnail_url'
      });
    }
  }]);
  return ShadowIGScheduledMedia;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ShadowIGUserCTXPartnerAppWelcomeMessageFlow
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ShadowIGUserCTXPartnerAppWelcomeMessageFlow = function (_AbstractCrudObject) {
  inherits(ShadowIGUserCTXPartnerAppWelcomeMessageFlow, _AbstractCrudObject);

  function ShadowIGUserCTXPartnerAppWelcomeMessageFlow() {
    classCallCheck(this, ShadowIGUserCTXPartnerAppWelcomeMessageFlow);
    return possibleConstructorReturn(this, (ShadowIGUserCTXPartnerAppWelcomeMessageFlow.__proto__ || Object.getPrototypeOf(ShadowIGUserCTXPartnerAppWelcomeMessageFlow)).apply(this, arguments));
  }

  createClass(ShadowIGUserCTXPartnerAppWelcomeMessageFlow, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        compatible_platforms: 'compatible_platforms',
        eligible_platforms: 'eligible_platforms',
        id: 'id',
        is_ig_only_flow: 'is_ig_only_flow',
        is_used_in_ad: 'is_used_in_ad',
        last_update_time: 'last_update_time',
        name: 'name',
        welcome_message_flow: 'welcome_message_flow'
      });
    }
  }]);
  return ShadowIGUserCTXPartnerAppWelcomeMessageFlow;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * IGUser
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var IGUser = function (_AbstractCrudObject) {
  inherits(IGUser, _AbstractCrudObject);

  function IGUser() {
    classCallCheck(this, IGUser);
    return possibleConstructorReturn(this, (IGUser.__proto__ || Object.getPrototypeOf(IGUser)).apply(this, arguments));
  }

  createClass(IGUser, [{
    key: 'getAgencies',
    value: function getAgencies(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Business, fields, params, fetchFirstPage, '/agencies');
    }
  }, {
    key: 'getAuthorizedAdAccounts',
    value: function getAuthorizedAdAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdAccount, fields, params, fetchFirstPage, '/authorized_adaccounts');
    }
  }, {
    key: 'createAuthorizedAdAccount',
    value: function createAuthorizedAdAccount(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/authorized_adaccounts', fields, params, IGUser, pathOverride);
    }
  }, {
    key: 'getAvailableCatalogs',
    value: function getAvailableCatalogs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(UserAvailableCatalogs, fields, params, fetchFirstPage, '/available_catalogs');
    }
  }, {
    key: 'getBrandedContentAdPermissions',
    value: function getBrandedContentAdPermissions(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGBCAdsPermission, fields, params, fetchFirstPage, '/branded_content_ad_permissions');
    }
  }, {
    key: 'createBrandedContentAdPermission',
    value: function createBrandedContentAdPermission(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/branded_content_ad_permissions', fields, params, IGBCAdsPermission, pathOverride);
    }
  }, {
    key: 'getBrandedContentAdvertisableMedias',
    value: function getBrandedContentAdvertisableMedias(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BrandedContentShadowIGMediaID, fields, params, fetchFirstPage, '/branded_content_advertisable_medias');
    }
  }, {
    key: 'deleteBrandedContentTagApproval',
    value: function deleteBrandedContentTagApproval() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(IGUser.prototype.__proto__ || Object.getPrototypeOf(IGUser.prototype), 'deleteEdge', this).call(this, '/branded_content_tag_approval', params);
    }
  }, {
    key: 'getBrandedContentTagApproval',
    value: function getBrandedContentTagApproval(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BrandedContentShadowIGUserID, fields, params, fetchFirstPage, '/branded_content_tag_approval');
    }
  }, {
    key: 'createBrandedContentTagApproval',
    value: function createBrandedContentTagApproval(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/branded_content_tag_approval', fields, params, BrandedContentShadowIGUserID, pathOverride);
    }
  }, {
    key: 'getCatalogProductSearch',
    value: function getCatalogProductSearch(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ShadowIGUserCatalogProductSearch, fields, params, fetchFirstPage, '/catalog_product_search');
    }
  }, {
    key: 'getCollaborationInvites',
    value: function getCollaborationInvites(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ShadowIGUserCollaborationInvites, fields, params, fetchFirstPage, '/collaboration_invites');
    }
  }, {
    key: 'createCollaborationInvite',
    value: function createCollaborationInvite(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/collaboration_invites', fields, params, ShadowIGUserCollaborationInvites, pathOverride);
    }
  }, {
    key: 'getConnectedThreadsUser',
    value: function getConnectedThreadsUser(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ThreadsUser, fields, params, fetchFirstPage, '/connected_threads_user');
    }
  }, {
    key: 'getContentPublishingLimit',
    value: function getContentPublishingLimit(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ContentPublishingLimitResponse, fields, params, fetchFirstPage, '/content_publishing_limit');
    }
  }, {
    key: 'getCreatorMarketPlaceCreators',
    value: function getCreatorMarketPlaceCreators(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGUserExportForCAM, fields, params, fetchFirstPage, '/creator_marketplace_creators');
    }
  }, {
    key: 'getDataset',
    value: function getDataset(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Dataset, fields, params, fetchFirstPage, '/dataset');
    }
  }, {
    key: 'createDataset',
    value: function createDataset(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/dataset', fields, params, Dataset, pathOverride);
    }
  }, {
    key: 'getInsights',
    value: function getInsights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(InstagramInsightsResult, fields, params, fetchFirstPage, '/insights');
    }
  }, {
    key: 'getInstagramBackedThreadsUser',
    value: function getInstagramBackedThreadsUser(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ThreadsUser, fields, params, fetchFirstPage, '/instagram_backed_threads_user');
    }
  }, {
    key: 'createInstagramBackedThreadsUser',
    value: function createInstagramBackedThreadsUser(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/instagram_backed_threads_user', fields, params, ThreadsUser, pathOverride);
    }
  }, {
    key: 'getLiveMedia',
    value: function getLiveMedia(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGMedia, fields, params, fetchFirstPage, '/live_media');
    }
  }, {
    key: 'getMedia',
    value: function getMedia(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGMedia, fields, params, fetchFirstPage, '/media');
    }
  }, {
    key: 'createMedia',
    value: function createMedia(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/media', fields, params, IGMedia, pathOverride);
    }
  }, {
    key: 'createMediaPublish',
    value: function createMediaPublish(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/media_publish', fields, params, IGMedia, pathOverride);
    }
  }, {
    key: 'createMention',
    value: function createMention(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/mentions', fields, params, null, pathOverride);
    }
  }, {
    key: 'getNotificationMessageTokens',
    value: function getNotificationMessageTokens(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(UserPageOneTimeOptInTokenSettings, fields, params, fetchFirstPage, '/notification_message_tokens');
    }
  }, {
    key: 'getProductAppeal',
    value: function getProductAppeal(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGShoppingProductAppeal, fields, params, fetchFirstPage, '/product_appeal');
    }
  }, {
    key: 'createProductAppeal',
    value: function createProductAppeal(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/product_appeal', fields, params, IGShoppingProductAppeal, pathOverride);
    }
  }, {
    key: 'getRecentlySearchedHashtags',
    value: function getRecentlySearchedHashtags(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ShadowIGHashtag, fields, params, fetchFirstPage, '/recently_searched_hashtags');
    }
  }, {
    key: 'getScheduledMedia',
    value: function getScheduledMedia(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ShadowIGScheduledMedia, fields, params, fetchFirstPage, '/scheduled_media');
    }
  }, {
    key: 'getStories',
    value: function getStories(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGMedia, fields, params, fetchFirstPage, '/stories');
    }
  }, {
    key: 'getTags',
    value: function getTags(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGMedia, fields, params, fetchFirstPage, '/tags');
    }
  }, {
    key: 'getUpcomingEvents',
    value: function getUpcomingEvents(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGUpcomingEvent, fields, params, fetchFirstPage, '/upcoming_events');
    }
  }, {
    key: 'createUpcomingEvent',
    value: function createUpcomingEvent(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/upcoming_events', fields, params, null, pathOverride);
    }
  }, {
    key: 'getWelcomeMessageFlows',
    value: function getWelcomeMessageFlows(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ShadowIGUserCTXPartnerAppWelcomeMessageFlow, fields, params, fetchFirstPage, '/welcome_message_flows');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        biography: 'biography',
        business_discovery: 'business_discovery',
        followers_count: 'followers_count',
        follows_count: 'follows_count',
        has_profile_pic: 'has_profile_pic',
        id: 'id',
        ig_id: 'ig_id',
        is_published: 'is_published',
        legacy_instagram_user_id: 'legacy_instagram_user_id',
        media_count: 'media_count',
        mentioned_comment: 'mentioned_comment',
        mentioned_media: 'mentioned_media',
        name: 'name',
        owner_business: 'owner_business',
        profile_picture_url: 'profile_picture_url',
        shopping_product_tag_eligibility: 'shopping_product_tag_eligibility',
        shopping_review_status: 'shopping_review_status',
        username: 'username',
        website: 'website'
      });
    }
  }]);
  return IGUser;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * LeadgenForm
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var LeadgenForm = function (_AbstractCrudObject) {
  inherits(LeadgenForm, _AbstractCrudObject);

  function LeadgenForm() {
    classCallCheck(this, LeadgenForm);
    return possibleConstructorReturn(this, (LeadgenForm.__proto__ || Object.getPrototypeOf(LeadgenForm)).apply(this, arguments));
  }

  createClass(LeadgenForm, [{
    key: 'getLeads',
    value: function getLeads(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Lead, fields, params, fetchFirstPage, '/leads');
    }
  }, {
    key: 'getTestLeads',
    value: function getTestLeads(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Lead, fields, params, fetchFirstPage, '/test_leads');
    }
  }, {
    key: 'createTestLead',
    value: function createTestLead(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/test_leads', fields, params, Lead, pathOverride);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(LeadgenForm.prototype.__proto__ || Object.getPrototypeOf(LeadgenForm.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        allow_organic_lead: 'allow_organic_lead',
        block_display_for_non_targeted_viewer: 'block_display_for_non_targeted_viewer',
        context_card: 'context_card',
        created_time: 'created_time',
        creator: 'creator',
        expired_leads_count: 'expired_leads_count',
        follow_up_action_text: 'follow_up_action_text',
        follow_up_action_url: 'follow_up_action_url',
        id: 'id',
        is_optimized_for_quality: 'is_optimized_for_quality',
        leads_count: 'leads_count',
        legal_content: 'legal_content',
        locale: 'locale',
        name: 'name',
        organic_leads_count: 'organic_leads_count',
        page: 'page',
        page_id: 'page_id',
        privacy_policy_url: 'privacy_policy_url',
        question_page_custom_headline: 'question_page_custom_headline',
        questions: 'questions',
        status: 'status',
        thank_you_page: 'thank_you_page',
        tracking_parameters: 'tracking_parameters'
      });
    }
  }, {
    key: 'Status',
    get: function get() {
      return Object.freeze({
        active: 'ACTIVE',
        archived: 'ARCHIVED',
        deleted: 'DELETED',
        draft: 'DRAFT'
      });
    }
  }, {
    key: 'Locale',
    get: function get() {
      return Object.freeze({
        ar_ar: 'AR_AR',
        cs_cz: 'CS_CZ',
        da_dk: 'DA_DK',
        de_de: 'DE_DE',
        el_gr: 'EL_GR',
        en_gb: 'EN_GB',
        en_us: 'EN_US',
        es_es: 'ES_ES',
        es_la: 'ES_LA',
        fi_fi: 'FI_FI',
        fr_fr: 'FR_FR',
        he_il: 'HE_IL',
        hi_in: 'HI_IN',
        hu_hu: 'HU_HU',
        id_id: 'ID_ID',
        it_it: 'IT_IT',
        ja_jp: 'JA_JP',
        ko_kr: 'KO_KR',
        nb_no: 'NB_NO',
        nl_nl: 'NL_NL',
        pl_pl: 'PL_PL',
        pt_br: 'PT_BR',
        pt_pt: 'PT_PT',
        ro_ro: 'RO_RO',
        ru_ru: 'RU_RU',
        sv_se: 'SV_SE',
        th_th: 'TH_TH',
        tr_tr: 'TR_TR',
        vi_vn: 'VI_VN',
        zh_cn: 'ZH_CN',
        zh_hk: 'ZH_HK',
        zh_tw: 'ZH_TW'
      });
    }
  }]);
  return LeadgenForm;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * MediaFingerprint
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var MediaFingerprint = function (_AbstractCrudObject) {
  inherits(MediaFingerprint, _AbstractCrudObject);

  function MediaFingerprint() {
    classCallCheck(this, MediaFingerprint);
    return possibleConstructorReturn(this, (MediaFingerprint.__proto__ || Object.getPrototypeOf(MediaFingerprint)).apply(this, arguments));
  }

  createClass(MediaFingerprint, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(MediaFingerprint.prototype.__proto__ || Object.getPrototypeOf(MediaFingerprint.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        duration_in_sec: 'duration_in_sec',
        fingerprint_content_type: 'fingerprint_content_type',
        fingerprint_type: 'fingerprint_type',
        id: 'id',
        metadata: 'metadata',
        title: 'title',
        universal_content_id: 'universal_content_id'
      });
    }
  }, {
    key: 'FingerprintContentType',
    get: function get() {
      return Object.freeze({
        am_songtrack: 'AM_SONGTRACK',
        episode: 'EPISODE',
        movie: 'MOVIE',
        other: 'OTHER',
        songtrack: 'SONGTRACK'
      });
    }
  }]);
  return MediaFingerprint;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * MessengerBusinessTemplate
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var MessengerBusinessTemplate = function (_AbstractCrudObject) {
  inherits(MessengerBusinessTemplate, _AbstractCrudObject);

  function MessengerBusinessTemplate() {
    classCallCheck(this, MessengerBusinessTemplate);
    return possibleConstructorReturn(this, (MessengerBusinessTemplate.__proto__ || Object.getPrototypeOf(MessengerBusinessTemplate)).apply(this, arguments));
  }

  createClass(MessengerBusinessTemplate, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(MessengerBusinessTemplate.prototype.__proto__ || Object.getPrototypeOf(MessengerBusinessTemplate.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        category: 'category',
        components: 'components',
        creation_time: 'creation_time',
        id: 'id',
        language: 'language',
        language_count: 'language_count',
        last_updated_time: 'last_updated_time',
        library_template_name: 'library_template_name',
        name: 'name',
        rejected_reason: 'rejected_reason',
        rejection_reasons: 'rejection_reasons',
        specific_rejection_reasons: 'specific_rejection_reasons',
        status: 'status'
      });
    }
  }, {
    key: 'Status',
    get: function get() {
      return Object.freeze({
        approved: 'APPROVED',
        archived: 'ARCHIVED',
        deleted: 'DELETED',
        disabled: 'DISABLED',
        in_appeal: 'IN_APPEAL',
        limit_exceeded: 'LIMIT_EXCEEDED',
        paused: 'PAUSED',
        pending: 'PENDING',
        pending_deletion: 'PENDING_DELETION',
        rejected: 'REJECTED'
      });
    }
  }]);
  return MessengerBusinessTemplate;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * MessagingFeatureReview
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var MessagingFeatureReview = function (_AbstractCrudObject) {
  inherits(MessagingFeatureReview, _AbstractCrudObject);

  function MessagingFeatureReview() {
    classCallCheck(this, MessagingFeatureReview);
    return possibleConstructorReturn(this, (MessagingFeatureReview.__proto__ || Object.getPrototypeOf(MessagingFeatureReview)).apply(this, arguments));
  }

  createClass(MessagingFeatureReview, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        feature: 'feature',
        status: 'status'
      });
    }
  }]);
  return MessagingFeatureReview;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * MessengerCallSettings
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var MessengerCallSettings = function (_AbstractCrudObject) {
  inherits(MessengerCallSettings, _AbstractCrudObject);

  function MessengerCallSettings() {
    classCallCheck(this, MessengerCallSettings);
    return possibleConstructorReturn(this, (MessengerCallSettings.__proto__ || Object.getPrototypeOf(MessengerCallSettings)).apply(this, arguments));
  }

  createClass(MessengerCallSettings, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        audio_enabled: 'audio_enabled',
        call_hours: 'call_hours',
        call_routing: 'call_routing',
        icon_enabled: 'icon_enabled',
        video: 'video'
      });
    }
  }]);
  return MessengerCallSettings;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * MessengerAdsPartialAutomatedStepList
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var MessengerAdsPartialAutomatedStepList = function (_AbstractCrudObject) {
  inherits(MessengerAdsPartialAutomatedStepList, _AbstractCrudObject);

  function MessengerAdsPartialAutomatedStepList() {
    classCallCheck(this, MessengerAdsPartialAutomatedStepList);
    return possibleConstructorReturn(this, (MessengerAdsPartialAutomatedStepList.__proto__ || Object.getPrototypeOf(MessengerAdsPartialAutomatedStepList)).apply(this, arguments));
  }

  createClass(MessengerAdsPartialAutomatedStepList, [{
    key: 'getSteps',
    value: function getSteps(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/steps');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        fblead_form: 'fblead_form',
        first_step_id: 'first_step_id',
        id: 'id',
        page: 'page',
        privacy_url: 'privacy_url',
        reminder_text: 'reminder_text',
        stop_question_message: 'stop_question_message'
      });
    }
  }]);
  return MessengerAdsPartialAutomatedStepList;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * MessengerProfile
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var MessengerProfile = function (_AbstractCrudObject) {
  inherits(MessengerProfile, _AbstractCrudObject);

  function MessengerProfile() {
    classCallCheck(this, MessengerProfile);
    return possibleConstructorReturn(this, (MessengerProfile.__proto__ || Object.getPrototypeOf(MessengerProfile)).apply(this, arguments));
  }

  createClass(MessengerProfile, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        account_linking_url: 'account_linking_url',
        commands: 'commands',
        get_started: 'get_started',
        greeting: 'greeting',
        ice_breakers: 'ice_breakers',
        persistent_menu: 'persistent_menu',
        subject_to_new_eu_privacy_rules: 'subject_to_new_eu_privacy_rules',
        whitelisted_domains: 'whitelisted_domains'
      });
    }
  }]);
  return MessengerProfile;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Persona
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Persona = function (_AbstractCrudObject) {
  inherits(Persona, _AbstractCrudObject);

  function Persona() {
    classCallCheck(this, Persona);
    return possibleConstructorReturn(this, (Persona.__proto__ || Object.getPrototypeOf(Persona)).apply(this, arguments));
  }

  createClass(Persona, [{
    key: 'delete',


    // $FlowFixMe : Support Generic Types
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Persona.prototype.__proto__ || Object.getPrototypeOf(Persona.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        name: 'name',
        profile_picture_url: 'profile_picture_url'
      });
    }
  }]);
  return Persona;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Recommendation
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Recommendation = function (_AbstractCrudObject) {
  inherits(Recommendation, _AbstractCrudObject);

  function Recommendation() {
    classCallCheck(this, Recommendation);
    return possibleConstructorReturn(this, (Recommendation.__proto__ || Object.getPrototypeOf(Recommendation)).apply(this, arguments));
  }

  createClass(Recommendation, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        created_time: 'created_time',
        has_rating: 'has_rating',
        has_review: 'has_review',
        open_graph_story: 'open_graph_story',
        rating: 'rating',
        recommendation_type: 'recommendation_type',
        review_text: 'review_text',
        reviewer: 'reviewer'
      });
    }
  }]);
  return Recommendation;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * PageSettings
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var PageSettings = function (_AbstractCrudObject) {
  inherits(PageSettings, _AbstractCrudObject);

  function PageSettings() {
    classCallCheck(this, PageSettings);
    return possibleConstructorReturn(this, (PageSettings.__proto__ || Object.getPrototypeOf(PageSettings)).apply(this, arguments));
  }

  createClass(PageSettings, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        setting: 'setting',
        value: 'value'
      });
    }
  }]);
  return PageSettings;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * StoreLocation
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var StoreLocation = function (_AbstractCrudObject) {
  inherits(StoreLocation, _AbstractCrudObject);

  function StoreLocation() {
    classCallCheck(this, StoreLocation);
    return possibleConstructorReturn(this, (StoreLocation.__proto__ || Object.getPrototypeOf(StoreLocation)).apply(this, arguments));
  }

  createClass(StoreLocation, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        full_address: 'full_address',
        hours: 'hours',
        id: 'id',
        phone_number: 'phone_number',
        pickup_options: 'pickup_options',
        price_range: 'price_range',
        store_code: 'store_code',
        zip_code: 'zip_code'
      });
    }
  }]);
  return StoreLocation;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Stories
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Stories = function (_AbstractCrudObject) {
  inherits(Stories, _AbstractCrudObject);

  function Stories() {
    classCallCheck(this, Stories);
    return possibleConstructorReturn(this, (Stories.__proto__ || Object.getPrototypeOf(Stories)).apply(this, arguments));
  }

  createClass(Stories, [{
    key: 'getInsights',
    value: function getInsights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(InsightsResult, fields, params, fetchFirstPage, '/insights');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        creation_time: 'creation_time',
        media_id: 'media_id',
        media_type: 'media_type',
        post_id: 'post_id',
        status: 'status',
        url: 'url',
        id: 'id'
      });
    }
  }, {
    key: 'Status',
    get: function get() {
      return Object.freeze({
        archived: 'ARCHIVED',
        published: 'PUBLISHED'
      });
    }
  }]);
  return Stories;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Tab
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Tab = function (_AbstractCrudObject) {
  inherits(Tab, _AbstractCrudObject);

  function Tab() {
    classCallCheck(this, Tab);
    return possibleConstructorReturn(this, (Tab.__proto__ || Object.getPrototypeOf(Tab)).apply(this, arguments));
  }

  createClass(Tab, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        application: 'application',
        custom_image_url: 'custom_image_url',
        custom_name: 'custom_name',
        id: 'id',
        image_url: 'image_url',
        is_non_connection_landing_tab: 'is_non_connection_landing_tab',
        is_permanent: 'is_permanent',
        link: 'link',
        name: 'name',
        position: 'position'
      });
    }
  }]);
  return Tab;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * PageThreadOwner
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var PageThreadOwner = function (_AbstractCrudObject) {
  inherits(PageThreadOwner, _AbstractCrudObject);

  function PageThreadOwner() {
    classCallCheck(this, PageThreadOwner);
    return possibleConstructorReturn(this, (PageThreadOwner.__proto__ || Object.getPrototypeOf(PageThreadOwner)).apply(this, arguments));
  }

  createClass(PageThreadOwner, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        thread_owner: 'thread_owner'
      });
    }
  }]);
  return PageThreadOwner;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * VideoCopyrightRule
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var VideoCopyrightRule = function (_AbstractCrudObject) {
  inherits(VideoCopyrightRule, _AbstractCrudObject);

  function VideoCopyrightRule() {
    classCallCheck(this, VideoCopyrightRule);
    return possibleConstructorReturn(this, (VideoCopyrightRule.__proto__ || Object.getPrototypeOf(VideoCopyrightRule)).apply(this, arguments));
  }

  createClass(VideoCopyrightRule, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        condition_groups: 'condition_groups',
        copyrights: 'copyrights',
        created_date: 'created_date',
        creator: 'creator',
        id: 'id',
        is_in_migration: 'is_in_migration',
        name: 'name'
      });
    }
  }, {
    key: 'Source',
    get: function get() {
      return Object.freeze({
        match_settings_dialog: 'MATCH_SETTINGS_DIALOG',
        rules_selector: 'RULES_SELECTOR',
        rules_tab: 'RULES_TAB'
      });
    }
  }]);
  return VideoCopyrightRule;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * MediaCopyrightUpdateRecord
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var MediaCopyrightUpdateRecord = function (_AbstractCrudObject) {
  inherits(MediaCopyrightUpdateRecord, _AbstractCrudObject);

  function MediaCopyrightUpdateRecord() {
    classCallCheck(this, MediaCopyrightUpdateRecord);
    return possibleConstructorReturn(this, (MediaCopyrightUpdateRecord.__proto__ || Object.getPrototypeOf(MediaCopyrightUpdateRecord)).apply(this, arguments));
  }

  createClass(MediaCopyrightUpdateRecord, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        action_types: 'action_types',
        actor: 'actor',
        actor_type: 'actor_type',
        creation_time: 'creation_time',
        id: 'id',
        ownership_countries: 'ownership_countries',
        whitelisted_accounts: 'whitelisted_accounts'
      });
    }
  }]);
  return MediaCopyrightUpdateRecord;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * VideoCopyright
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var VideoCopyright = function (_AbstractCrudObject) {
  inherits(VideoCopyright, _AbstractCrudObject);

  function VideoCopyright() {
    classCallCheck(this, VideoCopyright);
    return possibleConstructorReturn(this, (VideoCopyright.__proto__ || Object.getPrototypeOf(VideoCopyright)).apply(this, arguments));
  }

  createClass(VideoCopyright, [{
    key: 'getUpdateRecords',
    value: function getUpdateRecords(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(MediaCopyrightUpdateRecord, fields, params, fetchFirstPage, '/update_records');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(VideoCopyright.prototype.__proto__ || Object.getPrototypeOf(VideoCopyright.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        content_category: 'content_category',
        content_protect_protection_disabled_reason: 'content_protect_protection_disabled_reason',
        copyright_content_id: 'copyright_content_id',
        creator: 'creator',
        disable_protection_by_content_protect_status: 'disable_protection_by_content_protect_status',
        excluded_ownership_segments: 'excluded_ownership_segments',
        id: 'id',
        in_conflict: 'in_conflict',
        monitoring_status: 'monitoring_status',
        monitoring_type: 'monitoring_type',
        ownership_countries: 'ownership_countries',
        reference_file: 'reference_file',
        reference_file_disabled: 'reference_file_disabled',
        reference_file_disabled_by_ops: 'reference_file_disabled_by_ops',
        reference_owner_id: 'reference_owner_id',
        rule_ids: 'rule_ids',
        tags: 'tags',
        whitelisted_ids: 'whitelisted_ids'
      });
    }
  }, {
    key: 'ContentCategory',
    get: function get() {
      return Object.freeze({
        episode: 'episode',
        movie: 'movie',
        web: 'web'
      });
    }
  }, {
    key: 'MonitoringType',
    get: function get() {
      return Object.freeze({
        audio_only: 'AUDIO_ONLY',
        video_and_audio: 'VIDEO_AND_AUDIO',
        video_only: 'VIDEO_ONLY'
      });
    }
  }]);
  return VideoCopyright;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * VideoList
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var VideoList = function (_AbstractCrudObject) {
  inherits(VideoList, _AbstractCrudObject);

  function VideoList() {
    classCallCheck(this, VideoList);
    return possibleConstructorReturn(this, (VideoList.__proto__ || Object.getPrototypeOf(VideoList)).apply(this, arguments));
  }

  createClass(VideoList, [{
    key: 'getVideos',
    value: function getVideos(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdVideo, fields, params, fetchFirstPage, '/videos');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        creation_time: 'creation_time',
        description: 'description',
        id: 'id',
        last_modified: 'last_modified',
        owner: 'owner',
        season_number: 'season_number',
        thumbnail: 'thumbnail',
        title: 'title',
        videos_count: 'videos_count'
      });
    }
  }]);
  return VideoList;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Page
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Page = function (_AbstractCrudObject) {
  inherits(Page, _AbstractCrudObject);

  function Page() {
    classCallCheck(this, Page);
    return possibleConstructorReturn(this, (Page.__proto__ || Object.getPrototypeOf(Page)).apply(this, arguments));
  }

  createClass(Page, [{
    key: 'getAbTests',
    value: function getAbTests(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(PagePostExperiment, fields, params, fetchFirstPage, '/ab_tests');
    }
  }, {
    key: 'createAbTest',
    value: function createAbTest(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/ab_tests', fields, params, PagePostExperiment, pathOverride);
    }
  }, {
    key: 'createAcknowledgeOrder',
    value: function createAcknowledgeOrder(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/acknowledge_orders', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getAdsEligibility',
    value: function getAdsEligibility(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdsEligibility, fields, params, fetchFirstPage, '/ads_eligibility');
    }
  }, {
    key: 'getAdsPosts',
    value: function getAdsPosts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(PagePost, fields, params, fetchFirstPage, '/ads_posts');
    }
  }, {
    key: 'deleteAgencies',
    value: function deleteAgencies() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Page.prototype.__proto__ || Object.getPrototypeOf(Page.prototype), 'deleteEdge', this).call(this, '/agencies', params);
    }
  }, {
    key: 'getAgencies',
    value: function getAgencies(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Business, fields, params, fetchFirstPage, '/agencies');
    }
  }, {
    key: 'createAgency',
    value: function createAgency(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/agencies', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getAlbums',
    value: function getAlbums(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Album, fields, params, fetchFirstPage, '/albums');
    }
  }, {
    key: 'getArExperience',
    value: function getArExperience(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ArAdsDataContainer, fields, params, fetchFirstPage, '/ar_experience');
    }
  }, {
    key: 'deleteAssignedUsers',
    value: function deleteAssignedUsers() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Page.prototype.__proto__ || Object.getPrototypeOf(Page.prototype), 'deleteEdge', this).call(this, '/assigned_users', params);
    }
  }, {
    key: 'getAssignedUsers',
    value: function getAssignedUsers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AssignedUser, fields, params, fetchFirstPage, '/assigned_users');
    }
  }, {
    key: 'createAssignedUser',
    value: function createAssignedUser(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/assigned_users', fields, params, Page, pathOverride);
    }
  }, {
    key: 'deleteBlocked',
    value: function deleteBlocked() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Page.prototype.__proto__ || Object.getPrototypeOf(Page.prototype), 'deleteEdge', this).call(this, '/blocked', params);
    }
  }, {
    key: 'getBlocked',
    value: function getBlocked(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Profile, fields, params, fetchFirstPage, '/blocked');
    }
  }, {
    key: 'createBlocked',
    value: function createBlocked(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/blocked', fields, params, null, pathOverride);
    }
  }, {
    key: 'createBusinessDatum',
    value: function createBusinessDatum(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/business_data', fields, params, null, pathOverride);
    }
  }, {
    key: 'createBusinessMessagingFeatureStatus',
    value: function createBusinessMessagingFeatureStatus(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/business_messaging_feature_status', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getBusinessProjects',
    value: function getBusinessProjects(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BusinessProject, fields, params, fetchFirstPage, '/businessprojects');
    }
  }, {
    key: 'getCallToActions',
    value: function getCallToActions(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(PageCallToAction, fields, params, fetchFirstPage, '/call_to_actions');
    }
  }, {
    key: 'createCall',
    value: function createCall(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/calls', fields, params, null, pathOverride);
    }
  }, {
    key: 'getCanvasElements',
    value: function getCanvasElements(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CanvasBodyElement, fields, params, fetchFirstPage, '/canvas_elements');
    }
  }, {
    key: 'createCanvasElement',
    value: function createCanvasElement(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/canvas_elements', fields, params, CanvasBodyElement, pathOverride);
    }
  }, {
    key: 'getCanvases',
    value: function getCanvases(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Canvas, fields, params, fetchFirstPage, '/canvases');
    }
  }, {
    key: 'createCanvase',
    value: function createCanvase(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/canvases', fields, params, Canvas, pathOverride);
    }
  }, {
    key: 'getChatPlugin',
    value: function getChatPlugin(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ChatPlugin, fields, params, fetchFirstPage, '/chat_plugin');
    }
  }, {
    key: 'getCommerceMerchantSettings',
    value: function getCommerceMerchantSettings(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CommerceMerchantSettings, fields, params, fetchFirstPage, '/commerce_merchant_settings');
    }
  }, {
    key: 'getCommerceOrders',
    value: function getCommerceOrders(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CommerceOrder, fields, params, fetchFirstPage, '/commerce_orders');
    }
  }, {
    key: 'getCommercePayouts',
    value: function getCommercePayouts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CommercePayout, fields, params, fetchFirstPage, '/commerce_payouts');
    }
  }, {
    key: 'getCommerceTransactions',
    value: function getCommerceTransactions(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CommerceOrderTransactionDetail, fields, params, fetchFirstPage, '/commerce_transactions');
    }
  }, {
    key: 'getConversations',
    value: function getConversations(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(UnifiedThread, fields, params, fetchFirstPage, '/conversations');
    }
  }, {
    key: 'createCopyrightManualClaim',
    value: function createCopyrightManualClaim(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/copyright_manual_claims', fields, params, VideoCopyrightMatch, pathOverride);
    }
  }, {
    key: 'getCrosspostWhitelistedPages',
    value: function getCrosspostWhitelistedPages(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/crosspost_whitelisted_pages');
    }
  }, {
    key: 'getCtxOptimizationEligibility',
    value: function getCtxOptimizationEligibility(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CTXOptimizationEligibility, fields, params, fetchFirstPage, '/ctx_optimization_eligibility');
    }
  }, {
    key: 'getCustomLabels',
    value: function getCustomLabels(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(PageUserMessageThreadLabel, fields, params, fetchFirstPage, '/custom_labels');
    }
  }, {
    key: 'createCustomLabel',
    value: function createCustomLabel(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/custom_labels', fields, params, PageUserMessageThreadLabel, pathOverride);
    }
  }, {
    key: 'deleteCustomUserSettings',
    value: function deleteCustomUserSettings() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Page.prototype.__proto__ || Object.getPrototypeOf(Page.prototype), 'deleteEdge', this).call(this, '/custom_user_settings', params);
    }
  }, {
    key: 'getCustomUserSettings',
    value: function getCustomUserSettings(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CustomUserSettings, fields, params, fetchFirstPage, '/custom_user_settings');
    }
  }, {
    key: 'createCustomUserSetting',
    value: function createCustomUserSetting(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/custom_user_settings', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getDataset',
    value: function getDataset(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Dataset, fields, params, fetchFirstPage, '/dataset');
    }
  }, {
    key: 'createDataset',
    value: function createDataset(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/dataset', fields, params, Dataset, pathOverride);
    }
  }, {
    key: 'getEvents',
    value: function getEvents(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Event, fields, params, fetchFirstPage, '/events');
    }
  }, {
    key: 'createExtendThreadControl',
    value: function createExtendThreadControl(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/extend_thread_control', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getFantasyGames',
    value: function getFantasyGames(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(FantasyGame, fields, params, fetchFirstPage, '/fantasy_games');
    }
  }, {
    key: 'getFeed',
    value: function getFeed(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(PagePost, fields, params, fetchFirstPage, '/feed');
    }
  }, {
    key: 'createFeed',
    value: function createFeed(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/feed', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getGlobalBrandChildren',
    value: function getGlobalBrandChildren(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/global_brand_children');
    }
  }, {
    key: 'getImageCopyrights',
    value: function getImageCopyrights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ImageCopyright, fields, params, fetchFirstPage, '/image_copyrights');
    }
  }, {
    key: 'createImageCopyright',
    value: function createImageCopyright(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/image_copyrights', fields, params, ImageCopyright, pathOverride);
    }
  }, {
    key: 'getIndexedVideos',
    value: function getIndexedVideos(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdVideo, fields, params, fetchFirstPage, '/indexed_videos');
    }
  }, {
    key: 'getInsights',
    value: function getInsights(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(InsightsResult, fields, params, fetchFirstPage, '/insights');
    }
  }, {
    key: 'getInstagramAccounts',
    value: function getInstagramAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGUser, fields, params, fetchFirstPage, '/instagram_accounts');
    }
  }, {
    key: 'getLeadGenForms',
    value: function getLeadGenForms(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(LeadgenForm, fields, params, fetchFirstPage, '/leadgen_forms');
    }
  }, {
    key: 'createLeadGenForm',
    value: function createLeadGenForm(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/leadgen_forms', fields, params, LeadgenForm, pathOverride);
    }
  }, {
    key: 'getLikes',
    value: function getLikes(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/likes');
    }
  }, {
    key: 'getLiveVideos',
    value: function getLiveVideos(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(LiveVideo, fields, params, fetchFirstPage, '/live_videos');
    }
  }, {
    key: 'createLiveVideo',
    value: function createLiveVideo(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/live_videos', fields, params, LiveVideo, pathOverride);
    }
  }, {
    key: 'deleteLocations',
    value: function deleteLocations() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Page.prototype.__proto__ || Object.getPrototypeOf(Page.prototype), 'deleteEdge', this).call(this, '/locations', params);
    }
  }, {
    key: 'getLocations',
    value: function getLocations(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/locations');
    }
  }, {
    key: 'createLocation',
    value: function createLocation(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/locations', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getMediaFingerprints',
    value: function getMediaFingerprints(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(MediaFingerprint, fields, params, fetchFirstPage, '/media_fingerprints');
    }
  }, {
    key: 'createMediaFingerprint',
    value: function createMediaFingerprint(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/media_fingerprints', fields, params, MediaFingerprint, pathOverride);
    }
  }, {
    key: 'createMessageAttachment',
    value: function createMessageAttachment(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/message_attachments', fields, params, null, pathOverride);
    }
  }, {
    key: 'deleteMessageTemplates',
    value: function deleteMessageTemplates() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Page.prototype.__proto__ || Object.getPrototypeOf(Page.prototype), 'deleteEdge', this).call(this, '/message_templates', params);
    }
  }, {
    key: 'getMessageTemplates',
    value: function getMessageTemplates(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(MessengerBusinessTemplate, fields, params, fetchFirstPage, '/message_templates');
    }
  }, {
    key: 'createMessageTemplate',
    value: function createMessageTemplate(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/message_templates', fields, params, Page, pathOverride);
    }
  }, {
    key: 'createMessage',
    value: function createMessage(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/messages', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getMessagingFeatureReview',
    value: function getMessagingFeatureReview(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(MessagingFeatureReview, fields, params, fetchFirstPage, '/messaging_feature_review');
    }
  }, {
    key: 'getMessengerCallSettings',
    value: function getMessengerCallSettings(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(MessengerCallSettings, fields, params, fetchFirstPage, '/messenger_call_settings');
    }
  }, {
    key: 'createMessengerCallSetting',
    value: function createMessengerCallSetting(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/messenger_call_settings', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getMessengerLeadForms',
    value: function getMessengerLeadForms(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(MessengerAdsPartialAutomatedStepList, fields, params, fetchFirstPage, '/messenger_lead_forms');
    }
  }, {
    key: 'createMessengerLeadForm',
    value: function createMessengerLeadForm(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/messenger_lead_forms', fields, params, Page, pathOverride);
    }
  }, {
    key: 'deleteMessengerProfile',
    value: function deleteMessengerProfile() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Page.prototype.__proto__ || Object.getPrototypeOf(Page.prototype), 'deleteEdge', this).call(this, '/messenger_profile', params);
    }
  }, {
    key: 'getMessengerProfile',
    value: function getMessengerProfile(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(MessengerProfile, fields, params, fetchFirstPage, '/messenger_profile');
    }
  }, {
    key: 'createMessengerProfile',
    value: function createMessengerProfile(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/messenger_profile', fields, params, Page, pathOverride);
    }
  }, {
    key: 'createModerateConversation',
    value: function createModerateConversation(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/moderate_conversations', fields, params, Page, pathOverride);
    }
  }, {
    key: 'createNlpConfig',
    value: function createNlpConfig(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/nlp_configs', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getNotificationMessageTokens',
    value: function getNotificationMessageTokens(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(UserPageOneTimeOptInTokenSettings, fields, params, fetchFirstPage, '/notification_message_tokens');
    }
  }, {
    key: 'createNotificationMessagesDevSupport',
    value: function createNotificationMessagesDevSupport(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/notification_messages_dev_support', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getPageBackedInstagramAccounts',
    value: function getPageBackedInstagramAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGUser, fields, params, fetchFirstPage, '/page_backed_instagram_accounts');
    }
  }, {
    key: 'createPageBackedInstagramAccount',
    value: function createPageBackedInstagramAccount(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/page_backed_instagram_accounts', fields, params, IGUser, pathOverride);
    }
  }, {
    key: 'createPageWhatsAppNumberVerification',
    value: function createPageWhatsAppNumberVerification(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/page_whatsapp_number_verification', fields, params, Page, pathOverride);
    }
  }, {
    key: 'createPassThreadControl',
    value: function createPassThreadControl(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/pass_thread_control', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getPersonas',
    value: function getPersonas(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Persona, fields, params, fetchFirstPage, '/personas');
    }
  }, {
    key: 'createPersona',
    value: function createPersona(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/personas', fields, params, Persona, pathOverride);
    }
  }, {
    key: 'createPhotoStory',
    value: function createPhotoStory(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/photo_stories', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getPhotos',
    value: function getPhotos(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Photo, fields, params, fetchFirstPage, '/photos');
    }
  }, {
    key: 'createPhoto',
    value: function createPhoto(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/photos', fields, params, Photo, pathOverride);
    }
  }, {
    key: 'getPicture',
    value: function getPicture(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProfilePictureSource, fields, params, fetchFirstPage, '/picture');
    }
  }, {
    key: 'createPicture',
    value: function createPicture(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/picture', fields, params, ProfilePictureSource, pathOverride);
    }
  }, {
    key: 'getPosts',
    value: function getPosts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(PagePost, fields, params, fetchFirstPage, '/posts');
    }
  }, {
    key: 'getProductCatalogs',
    value: function getProductCatalogs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductCatalog, fields, params, fetchFirstPage, '/product_catalogs');
    }
  }, {
    key: 'getPublishedPosts',
    value: function getPublishedPosts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(PagePost, fields, params, fetchFirstPage, '/published_posts');
    }
  }, {
    key: 'getRatings',
    value: function getRatings(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Recommendation, fields, params, fetchFirstPage, '/ratings');
    }
  }, {
    key: 'createReleaseThreadControl',
    value: function createReleaseThreadControl(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/release_thread_control', fields, params, Page, pathOverride);
    }
  }, {
    key: 'createRequestThreadControl',
    value: function createRequestThreadControl(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/request_thread_control', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getRoles',
    value: function getRoles(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(User, fields, params, fetchFirstPage, '/roles');
    }
  }, {
    key: 'getRtbDynamicPosts',
    value: function getRtbDynamicPosts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(RTBDynamicPost, fields, params, fetchFirstPage, '/rtb_dynamic_posts');
    }
  }, {
    key: 'getScheduledPosts',
    value: function getScheduledPosts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(PagePost, fields, params, fetchFirstPage, '/scheduled_posts');
    }
  }, {
    key: 'getSecondaryReceivers',
    value: function getSecondaryReceivers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Application, fields, params, fetchFirstPage, '/secondary_receivers');
    }
  }, {
    key: 'getSettings',
    value: function getSettings(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(PageSettings, fields, params, fetchFirstPage, '/settings');
    }
  }, {
    key: 'createSetting',
    value: function createSetting(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/settings', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getShopSetupStatus',
    value: function getShopSetupStatus(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CommerceMerchantSettingsSetupStatus, fields, params, fetchFirstPage, '/shop_setup_status');
    }
  }, {
    key: 'getStoreLocations',
    value: function getStoreLocations(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(StoreLocation, fields, params, fetchFirstPage, '/store_locations');
    }
  }, {
    key: 'getStories',
    value: function getStories(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Stories, fields, params, fetchFirstPage, '/stories');
    }
  }, {
    key: 'deleteSubscribedApps',
    value: function deleteSubscribedApps() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Page.prototype.__proto__ || Object.getPrototypeOf(Page.prototype), 'deleteEdge', this).call(this, '/subscribed_apps', params);
    }
  }, {
    key: 'getSubscribedApps',
    value: function getSubscribedApps(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Application, fields, params, fetchFirstPage, '/subscribed_apps');
    }
  }, {
    key: 'createSubscribedApp',
    value: function createSubscribedApp(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/subscribed_apps', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getTabs',
    value: function getTabs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Tab, fields, params, fetchFirstPage, '/tabs');
    }
  }, {
    key: 'getTagged',
    value: function getTagged(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(PagePost, fields, params, fetchFirstPage, '/tagged');
    }
  }, {
    key: 'createTakeThreadControl',
    value: function createTakeThreadControl(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/take_thread_control', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getThreadOwner',
    value: function getThreadOwner(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(PageThreadOwner, fields, params, fetchFirstPage, '/thread_owner');
    }
  }, {
    key: 'getThreads',
    value: function getThreads(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(UnifiedThread, fields, params, fetchFirstPage, '/threads');
    }
  }, {
    key: 'createUnlinkAccount',
    value: function createUnlinkAccount(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/unlink_accounts', fields, params, Page, pathOverride);
    }
  }, {
    key: 'getVideoCopyrightRules',
    value: function getVideoCopyrightRules(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(VideoCopyrightRule, fields, params, fetchFirstPage, '/video_copyright_rules');
    }
  }, {
    key: 'createVideoCopyrightRule',
    value: function createVideoCopyrightRule(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/video_copyright_rules', fields, params, VideoCopyrightRule, pathOverride);
    }
  }, {
    key: 'createVideoCopyright',
    value: function createVideoCopyright(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/video_copyrights', fields, params, VideoCopyright, pathOverride);
    }
  }, {
    key: 'getVideoLists',
    value: function getVideoLists(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(VideoList, fields, params, fetchFirstPage, '/video_lists');
    }
  }, {
    key: 'getVideoReels',
    value: function getVideoReels(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdVideo, fields, params, fetchFirstPage, '/video_reels');
    }
  }, {
    key: 'createVideoReel',
    value: function createVideoReel(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/video_reels', fields, params, AdVideo, pathOverride);
    }
  }, {
    key: 'createVideoStory',
    value: function createVideoStory(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/video_stories', fields, params, null, pathOverride);
    }
  }, {
    key: 'getVideos',
    value: function getVideos(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdVideo, fields, params, fetchFirstPage, '/videos');
    }
  }, {
    key: 'createVideo',
    value: function createVideo(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/videos', fields, params, AdVideo, pathOverride);
    }
  }, {
    key: 'getVisitorPosts',
    value: function getVisitorPosts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(PagePost, fields, params, fetchFirstPage, '/visitor_posts');
    }
  }, {
    key: 'deleteWelcomeMessageFlows',
    value: function deleteWelcomeMessageFlows() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Page.prototype.__proto__ || Object.getPrototypeOf(Page.prototype), 'deleteEdge', this).call(this, '/welcome_message_flows', params);
    }
  }, {
    key: 'getWelcomeMessageFlows',
    value: function getWelcomeMessageFlows(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CTXPartnerAppWelcomeMessageFlow, fields, params, fetchFirstPage, '/welcome_message_flows');
    }
  }, {
    key: 'createWelcomeMessageFlow',
    value: function createWelcomeMessageFlow(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/welcome_message_flows', fields, params, null, pathOverride);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Page.prototype.__proto__ || Object.getPrototypeOf(Page.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        about: 'about',
        access_token: 'access_token',
        ad_campaign: 'ad_campaign',
        affiliation: 'affiliation',
        app_id: 'app_id',
        artists_we_like: 'artists_we_like',
        attire: 'attire',
        available_promo_offer_ids: 'available_promo_offer_ids',
        awards: 'awards',
        band_interests: 'band_interests',
        band_members: 'band_members',
        best_page: 'best_page',
        bio: 'bio',
        birthday: 'birthday',
        booking_agent: 'booking_agent',
        breaking_news_usage: 'breaking_news_usage',
        built: 'built',
        business: 'business',
        can_checkin: 'can_checkin',
        can_post: 'can_post',
        category: 'category',
        category_list: 'category_list',
        checkins: 'checkins',
        company_overview: 'company_overview',
        connected_instagram_account: 'connected_instagram_account',
        connected_page_backed_instagram_account: 'connected_page_backed_instagram_account',
        contact_address: 'contact_address',
        copyright_attribution_insights: 'copyright_attribution_insights',
        copyright_whitelisted_ig_partners: 'copyright_whitelisted_ig_partners',
        country_page_likes: 'country_page_likes',
        cover: 'cover',
        culinary_team: 'culinary_team',
        current_location: 'current_location',
        delivery_and_pickup_option_info: 'delivery_and_pickup_option_info',
        description: 'description',
        description_html: 'description_html',
        differently_open_offerings: 'differently_open_offerings',
        directed_by: 'directed_by',
        display_subtext: 'display_subtext',
        displayed_message_response_time: 'displayed_message_response_time',
        does_viewer_have_page_permission_link_ig: 'does_viewer_have_page_permission_link_ig',
        emails: 'emails',
        engagement: 'engagement',
        fan_count: 'fan_count',
        featured_video: 'featured_video',
        features: 'features',
        followers_count: 'followers_count',
        food_styles: 'food_styles',
        founded: 'founded',
        general_info: 'general_info',
        general_manager: 'general_manager',
        genre: 'genre',
        global_brand_page_name: 'global_brand_page_name',
        global_brand_root_id: 'global_brand_root_id',
        has_added_app: 'has_added_app',
        has_lead_access: 'has_lead_access',
        has_transitioned_to_new_page_experience: 'has_transitioned_to_new_page_experience',
        has_whatsapp_business_number: 'has_whatsapp_business_number',
        has_whatsapp_number: 'has_whatsapp_number',
        hometown: 'hometown',
        hours: 'hours',
        id: 'id',
        impressum: 'impressum',
        influences: 'influences',
        instagram_business_account: 'instagram_business_account',
        is_always_open: 'is_always_open',
        is_calling_eligible: 'is_calling_eligible',
        is_chain: 'is_chain',
        is_community_page: 'is_community_page',
        is_eligible_for_branded_content: 'is_eligible_for_branded_content',
        is_eligible_for_disable_connect_ig_btn_for_non_page_admin_am_web: 'is_eligible_for_disable_connect_ig_btn_for_non_page_admin_am_web',
        is_messenger_bot_get_started_enabled: 'is_messenger_bot_get_started_enabled',
        is_messenger_platform_bot: 'is_messenger_platform_bot',
        is_owned: 'is_owned',
        is_permanently_closed: 'is_permanently_closed',
        is_published: 'is_published',
        is_unclaimed: 'is_unclaimed',
        is_verified: 'is_verified',
        is_webhooks_subscribed: 'is_webhooks_subscribed',
        keywords: 'keywords',
        leadgen_tos_acceptance_time: 'leadgen_tos_acceptance_time',
        leadgen_tos_accepted: 'leadgen_tos_accepted',
        leadgen_tos_accepting_user: 'leadgen_tos_accepting_user',
        link: 'link',
        location: 'location',
        members: 'members',
        merchant_id: 'merchant_id',
        merchant_review_status: 'merchant_review_status',
        messaging_feature_status: 'messaging_feature_status',
        messenger_ads_default_icebreakers: 'messenger_ads_default_icebreakers',
        messenger_ads_default_quick_replies: 'messenger_ads_default_quick_replies',
        messenger_ads_quick_replies_type: 'messenger_ads_quick_replies_type',
        mini_shop_storefront: 'mini_shop_storefront',
        mission: 'mission',
        mpg: 'mpg',
        name: 'name',
        name_with_location_descriptor: 'name_with_location_descriptor',
        network: 'network',
        new_like_count: 'new_like_count',
        offer_eligible: 'offer_eligible',
        overall_star_rating: 'overall_star_rating',
        owner_business: 'owner_business',
        page_token: 'page_token',
        parent_page: 'parent_page',
        parking: 'parking',
        payment_options: 'payment_options',
        personal_info: 'personal_info',
        personal_interests: 'personal_interests',
        pharma_safety_info: 'pharma_safety_info',
        phone: 'phone',
        pickup_options: 'pickup_options',
        place_type: 'place_type',
        plot_outline: 'plot_outline',
        preferred_audience: 'preferred_audience',
        press_contact: 'press_contact',
        price_range: 'price_range',
        privacy_info_url: 'privacy_info_url',
        produced_by: 'produced_by',
        products: 'products',
        promotion_eligible: 'promotion_eligible',
        promotion_ineligible_reason: 'promotion_ineligible_reason',
        public_transit: 'public_transit',
        rating_count: 'rating_count',
        recipient: 'recipient',
        record_label: 'record_label',
        release_date: 'release_date',
        restaurant_services: 'restaurant_services',
        restaurant_specialties: 'restaurant_specialties',
        schedule: 'schedule',
        screenplay_by: 'screenplay_by',
        season: 'season',
        single_line_address: 'single_line_address',
        starring: 'starring',
        start_info: 'start_info',
        store_code: 'store_code',
        store_location_descriptor: 'store_location_descriptor',
        store_number: 'store_number',
        studio: 'studio',
        supports_donate_button_in_live_video: 'supports_donate_button_in_live_video',
        talking_about_count: 'talking_about_count',
        temporary_status: 'temporary_status',
        unread_message_count: 'unread_message_count',
        unread_notif_count: 'unread_notif_count',
        unseen_message_count: 'unseen_message_count',
        user_access_expire_time: 'user_access_expire_time',
        username: 'username',
        verification_status: 'verification_status',
        voip_info: 'voip_info',
        website: 'website',
        were_here_count: 'were_here_count',
        whatsapp_number: 'whatsapp_number',
        written_by: 'written_by'
      });
    }
  }, {
    key: 'Attire',
    get: function get() {
      return Object.freeze({
        casual: 'Casual',
        dressy: 'Dressy',
        unspecified: 'Unspecified'
      });
    }
  }, {
    key: 'FoodStyles',
    get: function get() {
      return Object.freeze({
        afghani: 'Afghani',
        american_new_: 'American (New)',
        american_traditional_: 'American (Traditional)',
        asian_fusion: 'Asian Fusion',
        barbeque: 'Barbeque',
        brazilian: 'Brazilian',
        breakfast: 'Breakfast',
        british: 'British',
        brunch: 'Brunch',
        buffets: 'Buffets',
        burgers: 'Burgers',
        burmese: 'Burmese',
        cajun_creole: 'Cajun/Creole',
        caribbean: 'Caribbean',
        chinese: 'Chinese',
        creperies: 'Creperies',
        cuban: 'Cuban',
        delis: 'Delis',
        diners: 'Diners',
        ethiopian: 'Ethiopian',
        fast_food: 'Fast Food',
        filipino: 'Filipino',
        fondue: 'Fondue',
        food_stands: 'Food Stands',
        french: 'French',
        german: 'German',
        greek_and_mediterranean: 'Greek and Mediterranean',
        hawaiian: 'Hawaiian',
        himalayan_nepalese: 'Himalayan/Nepalese',
        hot_dogs: 'Hot Dogs',
        indian_pakistani: 'Indian/Pakistani',
        irish: 'Irish',
        italian: 'Italian',
        japanese: 'Japanese',
        korean: 'Korean',
        latin_american: 'Latin American',
        mexican: 'Mexican',
        middle_eastern: 'Middle Eastern',
        moroccan: 'Moroccan',
        pizza: 'Pizza',
        russian: 'Russian',
        sandwiches: 'Sandwiches',
        seafood: 'Seafood',
        singaporean: 'Singaporean',
        soul_food: 'Soul Food',
        southern: 'Southern',
        spanish_basque: 'Spanish/Basque',
        steakhouses: 'Steakhouses',
        sushi_bars: 'Sushi Bars',
        taiwanese: 'Taiwanese',
        tapas_bars: 'Tapas Bars',
        tex_mex: 'Tex-Mex',
        thai: 'Thai',
        turkish: 'Turkish',
        vegan: 'Vegan',
        vegetarian: 'Vegetarian',
        vietnamese: 'Vietnamese'
      });
    }
  }, {
    key: 'GenAiProvenanceType',
    get: function get() {
      return Object.freeze({
        c2pa: 'C2PA',
        c2pa_metadata_edited: 'C2PA_METADATA_EDITED',
        explicit: 'EXPLICIT',
        explicit_animate: 'EXPLICIT_ANIMATE',
        explicit_imagine: 'EXPLICIT_IMAGINE',
        explicit_imagine_me: 'EXPLICIT_IMAGINE_ME',
        explicit_restyle: 'EXPLICIT_RESTYLE',
        invisible_watermark: 'INVISIBLE_WATERMARK',
        iptc: 'IPTC',
        iptc_metadata_edited: 'IPTC_METADATA_EDITED'
      });
    }
  }, {
    key: 'PickupOptions',
    get: function get() {
      return Object.freeze({
        curbside: 'CURBSIDE',
        in_store: 'IN_STORE',
        other: 'OTHER'
      });
    }
  }, {
    key: 'TemporaryStatus',
    get: function get() {
      return Object.freeze({
        differently_open: 'DIFFERENTLY_OPEN',
        no_data: 'NO_DATA',
        operating_as_usual: 'OPERATING_AS_USUAL',
        temporarily_closed: 'TEMPORARILY_CLOSED'
      });
    }
  }, {
    key: 'PermittedTasks',
    get: function get() {
      return Object.freeze({
        advertise: 'ADVERTISE',
        analyze: 'ANALYZE',
        cashier_role: 'CASHIER_ROLE',
        create_content: 'CREATE_CONTENT',
        global_structure_management: 'GLOBAL_STRUCTURE_MANAGEMENT',
        manage: 'MANAGE',
        manage_jobs: 'MANAGE_JOBS',
        manage_leads: 'MANAGE_LEADS',
        messaging: 'MESSAGING',
        moderate: 'MODERATE',
        moderate_community: 'MODERATE_COMMUNITY',
        pages_messaging: 'PAGES_MESSAGING',
        pages_messaging_subscriptions: 'PAGES_MESSAGING_SUBSCRIPTIONS',
        profile_plus_advertise: 'PROFILE_PLUS_ADVERTISE',
        profile_plus_analyze: 'PROFILE_PLUS_ANALYZE',
        profile_plus_create_content: 'PROFILE_PLUS_CREATE_CONTENT',
        profile_plus_facebook_access: 'PROFILE_PLUS_FACEBOOK_ACCESS',
        profile_plus_full_control: 'PROFILE_PLUS_FULL_CONTROL',
        profile_plus_global_structure_management: 'PROFILE_PLUS_GLOBAL_STRUCTURE_MANAGEMENT',
        profile_plus_manage: 'PROFILE_PLUS_MANAGE',
        profile_plus_manage_leads: 'PROFILE_PLUS_MANAGE_LEADS',
        profile_plus_messaging: 'PROFILE_PLUS_MESSAGING',
        profile_plus_moderate: 'PROFILE_PLUS_MODERATE',
        profile_plus_moderate_delegate_community: 'PROFILE_PLUS_MODERATE_DELEGATE_COMMUNITY',
        profile_plus_revenue: 'PROFILE_PLUS_REVENUE',
        read_page_mailboxes: 'READ_PAGE_MAILBOXES',
        view_monetization_insights: 'VIEW_MONETIZATION_INSIGHTS'
      });
    }
  }, {
    key: 'Tasks',
    get: function get() {
      return Object.freeze({
        advertise: 'ADVERTISE',
        analyze: 'ANALYZE',
        cashier_role: 'CASHIER_ROLE',
        create_content: 'CREATE_CONTENT',
        global_structure_management: 'GLOBAL_STRUCTURE_MANAGEMENT',
        manage: 'MANAGE',
        manage_jobs: 'MANAGE_JOBS',
        manage_leads: 'MANAGE_LEADS',
        messaging: 'MESSAGING',
        moderate: 'MODERATE',
        moderate_community: 'MODERATE_COMMUNITY',
        pages_messaging: 'PAGES_MESSAGING',
        pages_messaging_subscriptions: 'PAGES_MESSAGING_SUBSCRIPTIONS',
        profile_plus_advertise: 'PROFILE_PLUS_ADVERTISE',
        profile_plus_analyze: 'PROFILE_PLUS_ANALYZE',
        profile_plus_create_content: 'PROFILE_PLUS_CREATE_CONTENT',
        profile_plus_facebook_access: 'PROFILE_PLUS_FACEBOOK_ACCESS',
        profile_plus_full_control: 'PROFILE_PLUS_FULL_CONTROL',
        profile_plus_global_structure_management: 'PROFILE_PLUS_GLOBAL_STRUCTURE_MANAGEMENT',
        profile_plus_manage: 'PROFILE_PLUS_MANAGE',
        profile_plus_manage_leads: 'PROFILE_PLUS_MANAGE_LEADS',
        profile_plus_messaging: 'PROFILE_PLUS_MESSAGING',
        profile_plus_moderate: 'PROFILE_PLUS_MODERATE',
        profile_plus_moderate_delegate_community: 'PROFILE_PLUS_MODERATE_DELEGATE_COMMUNITY',
        profile_plus_revenue: 'PROFILE_PLUS_REVENUE',
        read_page_mailboxes: 'READ_PAGE_MAILBOXES',
        view_monetization_insights: 'VIEW_MONETIZATION_INSIGHTS'
      });
    }
  }, {
    key: 'BackdatedTimeGranularity',
    get: function get() {
      return Object.freeze({
        day: 'day',
        hour: 'hour',
        min: 'min',
        month: 'month',
        none: 'none',
        year: 'year'
      });
    }
  }, {
    key: 'Formatting',
    get: function get() {
      return Object.freeze({
        markdown: 'MARKDOWN',
        plaintext: 'PLAINTEXT'
      });
    }
  }, {
    key: 'PlaceAttachmentSetting',
    get: function get() {
      return Object.freeze({
        value_1: '1',
        value_2: '2'
      });
    }
  }, {
    key: 'PostSurfacesBlacklist',
    get: function get() {
      return Object.freeze({
        value_1: '1',
        value_2: '2',
        value_3: '3',
        value_4: '4',
        value_5: '5'
      });
    }
  }, {
    key: 'PostingToRedspace',
    get: function get() {
      return Object.freeze({
        disabled: 'disabled',
        enabled: 'enabled'
      });
    }
  }, {
    key: 'TargetSurface',
    get: function get() {
      return Object.freeze({
        story: 'STORY',
        timeline: 'TIMELINE'
      });
    }
  }, {
    key: 'UnpublishedContentType',
    get: function get() {
      return Object.freeze({
        ads_post: 'ADS_POST',
        draft: 'DRAFT',
        inline_created: 'INLINE_CREATED',
        published: 'PUBLISHED',
        reviewable_branded_content: 'REVIEWABLE_BRANDED_CONTENT',
        scheduled: 'SCHEDULED',
        scheduled_recurring: 'SCHEDULED_RECURRING'
      });
    }
  }, {
    key: 'RecommendationAction',
    get: function get() {
      return Object.freeze({
        accept_closed: 'ACCEPT_CLOSED',
        accept_new: 'ACCEPT_NEW',
        reject_closed: 'REJECT_CLOSED',
        reject_new: 'REJECT_NEW'
      });
    }
  }, {
    key: 'Category',
    get: function get() {
      return Object.freeze({
        utility: 'UTILITY'
      });
    }
  }, {
    key: 'MessagingType',
    get: function get() {
      return Object.freeze({
        message_tag: 'MESSAGE_TAG',
        response: 'RESPONSE',
        update: 'UPDATE',
        utility: 'UTILITY'
      });
    }
  }, {
    key: 'NotificationType',
    get: function get() {
      return Object.freeze({
        no_push: 'NO_PUSH',
        regular: 'REGULAR',
        silent_push: 'SILENT_PUSH'
      });
    }
  }, {
    key: 'SenderAction',
    get: function get() {
      return Object.freeze({
        mark_seen: 'MARK_SEEN',
        react: 'REACT',
        typing_off: 'TYPING_OFF',
        typing_on: 'TYPING_ON',
        unreact: 'UNREACT'
      });
    }
  }, {
    key: 'SuggestionAction',
    get: function get() {
      return Object.freeze({
        accept: 'ACCEPT',
        dismiss: 'DISMISS',
        impression: 'IMPRESSION'
      });
    }
  }, {
    key: 'Platform',
    get: function get() {
      return Object.freeze({
        instagram: 'INSTAGRAM',
        messenger: 'MESSENGER'
      });
    }
  }, {
    key: 'Actions',
    get: function get() {
      return Object.freeze({
        ban_user: 'BAN_USER',
        block_user: 'BLOCK_USER',
        move_to_spam: 'MOVE_TO_SPAM',
        unban_user: 'UNBAN_USER',
        unblock_user: 'UNBLOCK_USER'
      });
    }
  }, {
    key: 'Model',
    get: function get() {
      return Object.freeze({
        arabic: 'ARABIC',
        chinese: 'CHINESE',
        croatian: 'CROATIAN',
        custom: 'CUSTOM',
        danish: 'DANISH',
        dutch: 'DUTCH',
        english: 'ENGLISH',
        french_standard: 'FRENCH_STANDARD',
        georgian: 'GEORGIAN',
        german_standard: 'GERMAN_STANDARD',
        greek: 'GREEK',
        hebrew: 'HEBREW',
        hungarian: 'HUNGARIAN',
        irish: 'IRISH',
        italian_standard: 'ITALIAN_STANDARD',
        korean: 'KOREAN',
        norwegian_bokmal: 'NORWEGIAN_BOKMAL',
        polish: 'POLISH',
        portuguese: 'PORTUGUESE',
        romanian: 'ROMANIAN',
        spanish: 'SPANISH',
        swedish: 'SWEDISH',
        vietnamese: 'VIETNAMESE'
      });
    }
  }, {
    key: 'DeveloperAction',
    get: function get() {
      return Object.freeze({
        enable_followup_message: 'ENABLE_FOLLOWUP_MESSAGE'
      });
    }
  }, {
    key: 'SubscribedFields',
    get: function get() {
      return Object.freeze({
        affiliation: 'affiliation',
        attire: 'attire',
        awards: 'awards',
        bio: 'bio',
        birthday: 'birthday',
        business_integrity: 'business_integrity',
        call_permission_reply: 'call_permission_reply',
        call_settings_update: 'call_settings_update',
        calls: 'calls',
        category: 'category',
        checkins: 'checkins',
        comment_poll_response: 'comment_poll_response',
        company_overview: 'company_overview',
        conversations: 'conversations',
        culinary_team: 'culinary_team',
        current_location: 'current_location',
        description: 'description',
        email: 'email',
        feature_access_list: 'feature_access_list',
        feed: 'feed',
        follow: 'follow',
        founded: 'founded',
        general_info: 'general_info',
        general_manager: 'general_manager',
        group_feed: 'group_feed',
        hometown: 'hometown',
        hours: 'hours',
        inbox_labels: 'inbox_labels',
        invalid_topic_placeholder: 'invalid_topic_placeholder',
        invoice_access_bank_slip_events: 'invoice_access_bank_slip_events',
        invoice_access_invoice_change: 'invoice_access_invoice_change',
        invoice_access_invoice_draft_change: 'invoice_access_invoice_draft_change',
        invoice_access_onboarding_status_active: 'invoice_access_onboarding_status_active',
        leadgen: 'leadgen',
        leadgen_fat: 'leadgen_fat',
        live_videos: 'live_videos',
        local_delivery: 'local_delivery',
        location: 'location',
        marketing_message_delivery_failed: 'marketing_message_delivery_failed',
        marketing_message_echoes: 'marketing_message_echoes',
        marketing_messages_subscriber_upload_status: 'marketing_messages_subscriber_upload_status',
        mcom_invoice_change: 'mcom_invoice_change',
        members: 'members',
        mention: 'mention',
        merchant_review: 'merchant_review',
        message_context: 'message_context',
        message_deliveries: 'message_deliveries',
        message_echoes: 'message_echoes',
        message_edits: 'message_edits',
        message_mention: 'message_mention',
        message_reactions: 'message_reactions',
        message_reads: 'message_reads',
        message_template_status_update: 'message_template_status_update',
        messages: 'messages',
        messaging_account_linking: 'messaging_account_linking',
        messaging_appointments: 'messaging_appointments',
        messaging_checkout_updates: 'messaging_checkout_updates',
        messaging_customer_information: 'messaging_customer_information',
        messaging_direct_sends: 'messaging_direct_sends',
        messaging_fblogin_account_linking: 'messaging_fblogin_account_linking',
        messaging_feedback: 'messaging_feedback',
        messaging_game_plays: 'messaging_game_plays',
        messaging_handovers: 'messaging_handovers',
        messaging_in_thread_lead_form_submit: 'messaging_in_thread_lead_form_submit',
        messaging_integrity: 'messaging_integrity',
        messaging_optins: 'messaging_optins',
        messaging_optouts: 'messaging_optouts',
        messaging_payments: 'messaging_payments',
        messaging_policy_enforcement: 'messaging_policy_enforcement',
        messaging_postbacks: 'messaging_postbacks',
        messaging_pre_checkouts: 'messaging_pre_checkouts',
        messaging_referrals: 'messaging_referrals',
        mission: 'mission',
        name: 'name',
        page_about_story: 'page_about_story',
        page_change_proposal: 'page_change_proposal',
        page_upcoming_change: 'page_upcoming_change',
        parking: 'parking',
        payment_options: 'payment_options',
        payment_request_update: 'payment_request_update',
        personal_info: 'personal_info',
        personal_interests: 'personal_interests',
        phone: 'phone',
        picture: 'picture',
        price_range: 'price_range',
        product_review: 'product_review',
        products: 'products',
        public_transit: 'public_transit',
        publisher_subscriptions: 'publisher_subscriptions',
        ratings: 'ratings',
        registration: 'registration',
        response_feedback: 'response_feedback',
        send_cart: 'send_cart',
        standby: 'standby',
        story_poll_response: 'story_poll_response',
        story_share: 'story_share',
        user_action: 'user_action',
        video_text_question_responses: 'video_text_question_responses',
        videos: 'videos',
        website: 'website'
      });
    }
  }]);
  return Page;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * BusinessAssetGroup
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var BusinessAssetGroup = function (_AbstractCrudObject) {
  inherits(BusinessAssetGroup, _AbstractCrudObject);

  function BusinessAssetGroup() {
    classCallCheck(this, BusinessAssetGroup);
    return possibleConstructorReturn(this, (BusinessAssetGroup.__proto__ || Object.getPrototypeOf(BusinessAssetGroup)).apply(this, arguments));
  }

  createClass(BusinessAssetGroup, [{
    key: 'deleteAssignedUsers',
    value: function deleteAssignedUsers() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(BusinessAssetGroup.prototype.__proto__ || Object.getPrototypeOf(BusinessAssetGroup.prototype), 'deleteEdge', this).call(this, '/assigned_users', params);
    }
  }, {
    key: 'getAssignedUsers',
    value: function getAssignedUsers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AssignedUser, fields, params, fetchFirstPage, '/assigned_users');
    }
  }, {
    key: 'createAssignedUser',
    value: function createAssignedUser(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/assigned_users', fields, params, BusinessAssetGroup, pathOverride);
    }
  }, {
    key: 'deleteContainedAdAccounts',
    value: function deleteContainedAdAccounts() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(BusinessAssetGroup.prototype.__proto__ || Object.getPrototypeOf(BusinessAssetGroup.prototype), 'deleteEdge', this).call(this, '/contained_adaccounts', params);
    }
  }, {
    key: 'getContainedAdAccounts',
    value: function getContainedAdAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdAccount, fields, params, fetchFirstPage, '/contained_adaccounts');
    }
  }, {
    key: 'createContainedAdAccount',
    value: function createContainedAdAccount(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/contained_adaccounts', fields, params, BusinessAssetGroup, pathOverride);
    }
  }, {
    key: 'deleteContainedApplications',
    value: function deleteContainedApplications() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(BusinessAssetGroup.prototype.__proto__ || Object.getPrototypeOf(BusinessAssetGroup.prototype), 'deleteEdge', this).call(this, '/contained_applications', params);
    }
  }, {
    key: 'getContainedApplications',
    value: function getContainedApplications(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Application, fields, params, fetchFirstPage, '/contained_applications');
    }
  }, {
    key: 'createContainedApplication',
    value: function createContainedApplication(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/contained_applications', fields, params, BusinessAssetGroup, pathOverride);
    }
  }, {
    key: 'deleteContainedCustomConversions',
    value: function deleteContainedCustomConversions() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(BusinessAssetGroup.prototype.__proto__ || Object.getPrototypeOf(BusinessAssetGroup.prototype), 'deleteEdge', this).call(this, '/contained_custom_conversions', params);
    }
  }, {
    key: 'getContainedCustomConversions',
    value: function getContainedCustomConversions(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CustomConversion, fields, params, fetchFirstPage, '/contained_custom_conversions');
    }
  }, {
    key: 'createContainedCustomConversion',
    value: function createContainedCustomConversion(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/contained_custom_conversions', fields, params, BusinessAssetGroup, pathOverride);
    }
  }, {
    key: 'deleteContainedInstagramAccounts',
    value: function deleteContainedInstagramAccounts() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(BusinessAssetGroup.prototype.__proto__ || Object.getPrototypeOf(BusinessAssetGroup.prototype), 'deleteEdge', this).call(this, '/contained_instagram_accounts', params);
    }
  }, {
    key: 'getContainedInstagramAccounts',
    value: function getContainedInstagramAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(InstagramUser, fields, params, fetchFirstPage, '/contained_instagram_accounts');
    }
  }, {
    key: 'createContainedInstagramAccount',
    value: function createContainedInstagramAccount(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/contained_instagram_accounts', fields, params, BusinessAssetGroup, pathOverride);
    }
  }, {
    key: 'deleteContainedPages',
    value: function deleteContainedPages() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(BusinessAssetGroup.prototype.__proto__ || Object.getPrototypeOf(BusinessAssetGroup.prototype), 'deleteEdge', this).call(this, '/contained_pages', params);
    }
  }, {
    key: 'getContainedPages',
    value: function getContainedPages(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/contained_pages');
    }
  }, {
    key: 'createContainedPage',
    value: function createContainedPage(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/contained_pages', fields, params, BusinessAssetGroup, pathOverride);
    }
  }, {
    key: 'deleteContainedPixels',
    value: function deleteContainedPixels() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(BusinessAssetGroup.prototype.__proto__ || Object.getPrototypeOf(BusinessAssetGroup.prototype), 'deleteEdge', this).call(this, '/contained_pixels', params);
    }
  }, {
    key: 'getContainedPixels',
    value: function getContainedPixels(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdsPixel, fields, params, fetchFirstPage, '/contained_pixels');
    }
  }, {
    key: 'createContainedPixel',
    value: function createContainedPixel(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/contained_pixels', fields, params, BusinessAssetGroup, pathOverride);
    }
  }, {
    key: 'deleteContainedProductCatalogs',
    value: function deleteContainedProductCatalogs() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(BusinessAssetGroup.prototype.__proto__ || Object.getPrototypeOf(BusinessAssetGroup.prototype), 'deleteEdge', this).call(this, '/contained_product_catalogs', params);
    }
  }, {
    key: 'getContainedProductCatalogs',
    value: function getContainedProductCatalogs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductCatalog, fields, params, fetchFirstPage, '/contained_product_catalogs');
    }
  }, {
    key: 'createContainedProductCatalog',
    value: function createContainedProductCatalog(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/contained_product_catalogs', fields, params, BusinessAssetGroup, pathOverride);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(BusinessAssetGroup.prototype.__proto__ || Object.getPrototypeOf(BusinessAssetGroup.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        name: 'name',
        owner_business: 'owner_business'
      });
    }
  }, {
    key: 'AdaccountTasks',
    get: function get() {
      return Object.freeze({
        aa_analyze: 'AA_ANALYZE',
        advertise: 'ADVERTISE',
        analyze: 'ANALYZE',
        draft: 'DRAFT',
        manage: 'MANAGE'
      });
    }
  }, {
    key: 'OfflineConversionDataSetTasks',
    get: function get() {
      return Object.freeze({
        aa_analyze: 'AA_ANALYZE',
        advertise: 'ADVERTISE',
        manage: 'MANAGE',
        upload: 'UPLOAD',
        view: 'VIEW'
      });
    }
  }, {
    key: 'PageTasks',
    get: function get() {
      return Object.freeze({
        advertise: 'ADVERTISE',
        analyze: 'ANALYZE',
        cashier_role: 'CASHIER_ROLE',
        create_content: 'CREATE_CONTENT',
        global_structure_management: 'GLOBAL_STRUCTURE_MANAGEMENT',
        manage: 'MANAGE',
        manage_jobs: 'MANAGE_JOBS',
        manage_leads: 'MANAGE_LEADS',
        messaging: 'MESSAGING',
        moderate: 'MODERATE',
        moderate_community: 'MODERATE_COMMUNITY',
        pages_messaging: 'PAGES_MESSAGING',
        pages_messaging_subscriptions: 'PAGES_MESSAGING_SUBSCRIPTIONS',
        profile_plus_advertise: 'PROFILE_PLUS_ADVERTISE',
        profile_plus_analyze: 'PROFILE_PLUS_ANALYZE',
        profile_plus_create_content: 'PROFILE_PLUS_CREATE_CONTENT',
        profile_plus_facebook_access: 'PROFILE_PLUS_FACEBOOK_ACCESS',
        profile_plus_full_control: 'PROFILE_PLUS_FULL_CONTROL',
        profile_plus_global_structure_management: 'PROFILE_PLUS_GLOBAL_STRUCTURE_MANAGEMENT',
        profile_plus_manage: 'PROFILE_PLUS_MANAGE',
        profile_plus_manage_leads: 'PROFILE_PLUS_MANAGE_LEADS',
        profile_plus_messaging: 'PROFILE_PLUS_MESSAGING',
        profile_plus_moderate: 'PROFILE_PLUS_MODERATE',
        profile_plus_moderate_delegate_community: 'PROFILE_PLUS_MODERATE_DELEGATE_COMMUNITY',
        profile_plus_revenue: 'PROFILE_PLUS_REVENUE',
        read_page_mailboxes: 'READ_PAGE_MAILBOXES',
        view_monetization_insights: 'VIEW_MONETIZATION_INSIGHTS'
      });
    }
  }, {
    key: 'PixelTasks',
    get: function get() {
      return Object.freeze({
        aa_analyze: 'AA_ANALYZE',
        advertise: 'ADVERTISE',
        analyze: 'ANALYZE',
        edit: 'EDIT',
        upload: 'UPLOAD'
      });
    }
  }]);
  return BusinessAssetGroup;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * OmegaCustomerTrx
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var OmegaCustomerTrx = function (_AbstractCrudObject) {
  inherits(OmegaCustomerTrx, _AbstractCrudObject);

  function OmegaCustomerTrx() {
    classCallCheck(this, OmegaCustomerTrx);
    return possibleConstructorReturn(this, (OmegaCustomerTrx.__proto__ || Object.getPrototypeOf(OmegaCustomerTrx)).apply(this, arguments));
  }

  createClass(OmegaCustomerTrx, [{
    key: 'getCampaigns',
    value: function getCampaigns(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/campaigns');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        ad_account_ids: 'ad_account_ids',
        advertiser_name: 'advertiser_name',
        amount: 'amount',
        amount_due: 'amount_due',
        billed_amount_details: 'billed_amount_details',
        billing_period: 'billing_period',
        cdn_download_uri: 'cdn_download_uri',
        currency: 'currency',
        download_uri: 'download_uri',
        due_date: 'due_date',
        entity: 'entity',
        id: 'id',
        invoice_date: 'invoice_date',
        invoice_id: 'invoice_id',
        invoice_type: 'invoice_type',
        liability_type: 'liability_type',
        payment_status: 'payment_status',
        payment_term: 'payment_term',
        type: 'type'
      });
    }
  }, {
    key: 'Type',
    get: function get() {
      return Object.freeze({
        cm: 'CM',
        dm: 'DM',
        inv: 'INV',
        pro_forma: 'PRO_FORMA'
      });
    }
  }]);
  return OmegaCustomerTrx;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * InstagramBusinessAsset
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var InstagramBusinessAsset = function (_AbstractCrudObject) {
  inherits(InstagramBusinessAsset, _AbstractCrudObject);

  function InstagramBusinessAsset() {
    classCallCheck(this, InstagramBusinessAsset);
    return possibleConstructorReturn(this, (InstagramBusinessAsset.__proto__ || Object.getPrototypeOf(InstagramBusinessAsset)).apply(this, arguments));
  }

  createClass(InstagramBusinessAsset, [{
    key: 'deleteAgencies',
    value: function deleteAgencies() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(InstagramBusinessAsset.prototype.__proto__ || Object.getPrototypeOf(InstagramBusinessAsset.prototype), 'deleteEdge', this).call(this, '/agencies', params);
    }
  }, {
    key: 'getAgencies',
    value: function getAgencies(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Business, fields, params, fetchFirstPage, '/agencies');
    }
  }, {
    key: 'createAgency',
    value: function createAgency(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/agencies', fields, params, InstagramBusinessAsset, pathOverride);
    }
  }, {
    key: 'deleteAssignedUsers',
    value: function deleteAssignedUsers() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(InstagramBusinessAsset.prototype.__proto__ || Object.getPrototypeOf(InstagramBusinessAsset.prototype), 'deleteEdge', this).call(this, '/assigned_users', params);
    }
  }, {
    key: 'getAssignedUsers',
    value: function getAssignedUsers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AssignedUser, fields, params, fetchFirstPage, '/assigned_users');
    }
  }, {
    key: 'createAssignedUser',
    value: function createAssignedUser(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/assigned_users', fields, params, InstagramBusinessAsset, pathOverride);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        ig_user_id: 'ig_user_id',
        ig_username: 'ig_username'
      });
    }
  }, {
    key: 'PermittedTasks',
    get: function get() {
      return Object.freeze({
        advertise: 'ADVERTISE',
        analyze: 'ANALYZE',
        community_activity: 'COMMUNITY_ACTIVITY',
        content: 'CONTENT',
        messages: 'MESSAGES'
      });
    }
  }, {
    key: 'Tasks',
    get: function get() {
      return Object.freeze({
        advertise: 'ADVERTISE',
        analyze: 'ANALYZE',
        community_activity: 'COMMUNITY_ACTIVITY',
        content: 'CONTENT',
        messages: 'MESSAGES'
      });
    }
  }]);
  return InstagramBusinessAsset;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * OffsiteSignalContainerBusinessObject
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var OffsiteSignalContainerBusinessObject = function (_AbstractCrudObject) {
  inherits(OffsiteSignalContainerBusinessObject, _AbstractCrudObject);

  function OffsiteSignalContainerBusinessObject() {
    classCallCheck(this, OffsiteSignalContainerBusinessObject);
    return possibleConstructorReturn(this, (OffsiteSignalContainerBusinessObject.__proto__ || Object.getPrototypeOf(OffsiteSignalContainerBusinessObject)).apply(this, arguments));
  }

  createClass(OffsiteSignalContainerBusinessObject, [{
    key: 'getLinkedApplication',
    value: function getLinkedApplication(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdsDataset, fields, params, fetchFirstPage, '/linked_application');
    }
  }, {
    key: 'getLinkedPage',
    value: function getLinkedPage(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/linked_page');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        business: 'business',
        id: 'id',
        is_eligible_for_sharing_to_ad_account: 'is_eligible_for_sharing_to_ad_account',
        is_eligible_for_sharing_to_business: 'is_eligible_for_sharing_to_business',
        is_unavailable: 'is_unavailable',
        name: 'name',
        primary_container_id: 'primary_container_id'
      });
    }
  }]);
  return OffsiteSignalContainerBusinessObject;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CPASCollaborationRequest
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CPASCollaborationRequest = function (_AbstractCrudObject) {
  inherits(CPASCollaborationRequest, _AbstractCrudObject);

  function CPASCollaborationRequest() {
    classCallCheck(this, CPASCollaborationRequest);
    return possibleConstructorReturn(this, (CPASCollaborationRequest.__proto__ || Object.getPrototypeOf(CPASCollaborationRequest)).apply(this, arguments));
  }

  createClass(CPASCollaborationRequest, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        brands: 'brands',
        contact_email: 'contact_email',
        contact_first_name: 'contact_first_name',
        contact_last_name: 'contact_last_name',
        id: 'id',
        phone_number: 'phone_number',
        receiver_business: 'receiver_business',
        requester_agency_or_brand: 'requester_agency_or_brand',
        sender_client_business: 'sender_client_business',
        status: 'status'
      });
    }
  }, {
    key: 'RequesterAgencyOrBrand',
    get: function get() {
      return Object.freeze({
        agency: 'AGENCY',
        brand: 'BRAND',
        merchant: 'MERCHANT'
      });
    }
  }]);
  return CPASCollaborationRequest;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CPASAdvertiserPartnershipRecommendation
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CPASAdvertiserPartnershipRecommendation = function (_AbstractCrudObject) {
  inherits(CPASAdvertiserPartnershipRecommendation, _AbstractCrudObject);

  function CPASAdvertiserPartnershipRecommendation() {
    classCallCheck(this, CPASAdvertiserPartnershipRecommendation);
    return possibleConstructorReturn(this, (CPASAdvertiserPartnershipRecommendation.__proto__ || Object.getPrototypeOf(CPASAdvertiserPartnershipRecommendation)).apply(this, arguments));
  }

  createClass(CPASAdvertiserPartnershipRecommendation, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        advertiser_business_id: 'advertiser_business_id',
        brand_business_id: 'brand_business_id',
        brands: 'brands',
        countries: 'countries',
        id: 'id',
        merchant_business_id: 'merchant_business_id',
        merchant_categories: 'merchant_categories',
        status: 'status',
        status_reason: 'status_reason'
      });
    }
  }]);
  return CPASAdvertiserPartnershipRecommendation;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CPASBusinessSetupConfig
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CPASBusinessSetupConfig = function (_AbstractCrudObject) {
  inherits(CPASBusinessSetupConfig, _AbstractCrudObject);

  function CPASBusinessSetupConfig() {
    classCallCheck(this, CPASBusinessSetupConfig);
    return possibleConstructorReturn(this, (CPASBusinessSetupConfig.__proto__ || Object.getPrototypeOf(CPASBusinessSetupConfig)).apply(this, arguments));
  }

  createClass(CPASBusinessSetupConfig, [{
    key: 'getAdAccounts',
    value: function getAdAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdAccount, fields, params, fetchFirstPage, '/ad_accounts');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        accepted_collab_ads_tos: 'accepted_collab_ads_tos',
        business: 'business',
        business_capabilities_status: 'business_capabilities_status',
        capabilities_compliance_status: 'capabilities_compliance_status',
        id: 'id'
      });
    }
  }]);
  return CPASBusinessSetupConfig;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CPASMerchantConfig
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CPASMerchantConfig = function (_AbstractCrudObject) {
  inherits(CPASMerchantConfig, _AbstractCrudObject);

  function CPASMerchantConfig() {
    classCallCheck(this, CPASMerchantConfig);
    return possibleConstructorReturn(this, (CPASMerchantConfig.__proto__ || Object.getPrototypeOf(CPASMerchantConfig)).apply(this, arguments));
  }

  createClass(CPASMerchantConfig, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        accepted_tos: 'accepted_tos',
        beta_features: 'beta_features',
        business_outcomes_status: 'business_outcomes_status',
        id: 'id',
        is_test_merchant: 'is_test_merchant',
        outcomes_compliance_status: 'outcomes_compliance_status',
        qualified_to_onboard: 'qualified_to_onboard'
      });
    }
  }]);
  return CPASMerchantConfig;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * BusinessCreativeFolder
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var BusinessCreativeFolder = function (_AbstractCrudObject) {
  inherits(BusinessCreativeFolder, _AbstractCrudObject);

  function BusinessCreativeFolder() {
    classCallCheck(this, BusinessCreativeFolder);
    return possibleConstructorReturn(this, (BusinessCreativeFolder.__proto__ || Object.getPrototypeOf(BusinessCreativeFolder)).apply(this, arguments));
  }

  createClass(BusinessCreativeFolder, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        business: 'business',
        creation_time: 'creation_time',
        creative_insight_permissions: 'creative_insight_permissions',
        description: 'description',
        id: 'id',
        media_library_url: 'media_library_url',
        name: 'name',
        owner_business: 'owner_business'
      });
    }
  }]);
  return BusinessCreativeFolder;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * CreditCard
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var CreditCard = function (_AbstractCrudObject) {
  inherits(CreditCard, _AbstractCrudObject);

  function CreditCard() {
    classCallCheck(this, CreditCard);
    return possibleConstructorReturn(this, (CreditCard.__proto__ || Object.getPrototypeOf(CreditCard)).apply(this, arguments));
  }

  createClass(CreditCard, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        billing_address: 'billing_address',
        card_cobadging: 'card_cobadging',
        card_holder_name: 'card_holder_name',
        card_type: 'card_type',
        credential_id: 'credential_id',
        default_receiving_method_products: 'default_receiving_method_products',
        expiry_month: 'expiry_month',
        expiry_year: 'expiry_year',
        id: 'id',
        is_cvv_tricky_bin: 'is_cvv_tricky_bin',
        is_enabled: 'is_enabled',
        is_last_used: 'is_last_used',
        is_network_tokenized_in_india: 'is_network_tokenized_in_india',
        is_soft_disabled: 'is_soft_disabled',
        is_user_verified: 'is_user_verified',
        is_zip_verified: 'is_zip_verified',
        last4: 'last4',
        readable_card_type: 'readable_card_type',
        time_created: 'time_created',
        time_created_ts: 'time_created_ts',
        type: 'type'
      });
    }
  }]);
  return CreditCard;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * EventSourceGroup
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var EventSourceGroup = function (_AbstractCrudObject) {
  inherits(EventSourceGroup, _AbstractCrudObject);

  function EventSourceGroup() {
    classCallCheck(this, EventSourceGroup);
    return possibleConstructorReturn(this, (EventSourceGroup.__proto__ || Object.getPrototypeOf(EventSourceGroup)).apply(this, arguments));
  }

  createClass(EventSourceGroup, [{
    key: 'getSharedAccounts',
    value: function getSharedAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdAccount, fields, params, fetchFirstPage, '/shared_accounts');
    }
  }, {
    key: 'createSharedAccount',
    value: function createSharedAccount(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/shared_accounts', fields, params, EventSourceGroup, pathOverride);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(EventSourceGroup.prototype.__proto__ || Object.getPrototypeOf(EventSourceGroup.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        business: 'business',
        event_sources: 'event_sources',
        id: 'id',
        name: 'name',
        owner_business: 'owner_business'
      });
    }
  }]);
  return EventSourceGroup;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ExtendedCreditApplication
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ExtendedCreditApplication = function (_AbstractCrudObject) {
  inherits(ExtendedCreditApplication, _AbstractCrudObject);

  function ExtendedCreditApplication() {
    classCallCheck(this, ExtendedCreditApplication);
    return possibleConstructorReturn(this, (ExtendedCreditApplication.__proto__ || Object.getPrototypeOf(ExtendedCreditApplication)).apply(this, arguments));
  }

  createClass(ExtendedCreditApplication, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        billing_country: 'billing_country',
        city: 'city',
        cnpj: 'cnpj',
        country: 'country',
        display_currency: 'display_currency',
        duns_number: 'duns_number',
        id: 'id',
        invoice_email_address: 'invoice_email_address',
        is_umi: 'is_umi',
        legal_entity_name: 'legal_entity_name',
        original_online_limit: 'original_online_limit',
        phone_number: 'phone_number',
        postal_code: 'postal_code',
        product_types: 'product_types',
        proposed_credit_limit: 'proposed_credit_limit',
        registration_number: 'registration_number',
        run_id: 'run_id',
        state: 'state',
        status: 'status',
        street1: 'street1',
        street2: 'street2',
        submitter: 'submitter',
        tax_exempt_status: 'tax_exempt_status',
        tax_id: 'tax_id',
        terms: 'terms'
      });
    }
  }]);
  return ExtendedCreditApplication;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ExtendedCreditInvoiceGroup
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ExtendedCreditInvoiceGroup = function (_AbstractCrudObject) {
  inherits(ExtendedCreditInvoiceGroup, _AbstractCrudObject);

  function ExtendedCreditInvoiceGroup() {
    classCallCheck(this, ExtendedCreditInvoiceGroup);
    return possibleConstructorReturn(this, (ExtendedCreditInvoiceGroup.__proto__ || Object.getPrototypeOf(ExtendedCreditInvoiceGroup)).apply(this, arguments));
  }

  createClass(ExtendedCreditInvoiceGroup, [{
    key: 'deleteAdAccounts',
    value: function deleteAdAccounts() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(ExtendedCreditInvoiceGroup.prototype.__proto__ || Object.getPrototypeOf(ExtendedCreditInvoiceGroup.prototype), 'deleteEdge', this).call(this, '/ad_accounts', params);
    }
  }, {
    key: 'getAdAccounts',
    value: function getAdAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdAccount, fields, params, fetchFirstPage, '/ad_accounts');
    }
  }, {
    key: 'createAdAccount',
    value: function createAdAccount(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/ad_accounts', fields, params, AdAccount, pathOverride);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(ExtendedCreditInvoiceGroup.prototype.__proto__ || Object.getPrototypeOf(ExtendedCreditInvoiceGroup.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(ExtendedCreditInvoiceGroup.prototype.__proto__ || Object.getPrototypeOf(ExtendedCreditInvoiceGroup.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        auto_enroll: 'auto_enroll',
        bill_to_address: 'bill_to_address',
        customer_po_number: 'customer_po_number',
        email: 'email',
        emails: 'emails',
        id: 'id',
        liable_address: 'liable_address',
        name: 'name',
        sold_to_address: 'sold_to_address'
      });
    }
  }]);
  return ExtendedCreditInvoiceGroup;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ExtendedCreditAllocationConfig
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ExtendedCreditAllocationConfig = function (_AbstractCrudObject) {
  inherits(ExtendedCreditAllocationConfig, _AbstractCrudObject);

  function ExtendedCreditAllocationConfig() {
    classCallCheck(this, ExtendedCreditAllocationConfig);
    return possibleConstructorReturn(this, (ExtendedCreditAllocationConfig.__proto__ || Object.getPrototypeOf(ExtendedCreditAllocationConfig)).apply(this, arguments));
  }

  createClass(ExtendedCreditAllocationConfig, [{
    key: 'delete',


    // $FlowFixMe : Support Generic Types
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(ExtendedCreditAllocationConfig.prototype.__proto__ || Object.getPrototypeOf(ExtendedCreditAllocationConfig.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(ExtendedCreditAllocationConfig.prototype.__proto__ || Object.getPrototypeOf(ExtendedCreditAllocationConfig.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        currency_amount: 'currency_amount',
        id: 'id',
        liability_type: 'liability_type',
        owning_business: 'owning_business',
        owning_credential: 'owning_credential',
        partition_type: 'partition_type',
        receiving_business: 'receiving_business',
        receiving_credential: 'receiving_credential',
        request_status: 'request_status',
        send_bill_to: 'send_bill_to'
      });
    }
  }, {
    key: 'LiabilityType',
    get: function get() {
      return Object.freeze({
        msa: 'MSA',
        normal: 'Normal',
        sequential: 'Sequential'
      });
    }
  }, {
    key: 'PartitionType',
    get: function get() {
      return Object.freeze({
        auth: 'AUTH',
        fixed: 'FIXED',
        fixed_without_partition: 'FIXED_WITHOUT_PARTITION'
      });
    }
  }, {
    key: 'SendBillTo',
    get: function get() {
      return Object.freeze({
        advertiser: 'Advertiser',
        agency: 'Agency'
      });
    }
  }]);
  return ExtendedCreditAllocationConfig;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ExtendedCredit
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ExtendedCredit = function (_AbstractCrudObject) {
  inherits(ExtendedCredit, _AbstractCrudObject);

  function ExtendedCredit() {
    classCallCheck(this, ExtendedCredit);
    return possibleConstructorReturn(this, (ExtendedCredit.__proto__ || Object.getPrototypeOf(ExtendedCredit)).apply(this, arguments));
  }

  createClass(ExtendedCredit, [{
    key: 'getExtendedCreditInvoiceGroups',
    value: function getExtendedCreditInvoiceGroups(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ExtendedCreditInvoiceGroup, fields, params, fetchFirstPage, '/extended_credit_invoice_groups');
    }
  }, {
    key: 'createExtendedCreditInvoiceGroup',
    value: function createExtendedCreditInvoiceGroup(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/extended_credit_invoice_groups', fields, params, ExtendedCreditInvoiceGroup, pathOverride);
    }
  }, {
    key: 'getOwningCreditAllocationConfigs',
    value: function getOwningCreditAllocationConfigs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ExtendedCreditAllocationConfig, fields, params, fetchFirstPage, '/owning_credit_allocation_configs');
    }
  }, {
    key: 'createOwningCreditAllocationConfig',
    value: function createOwningCreditAllocationConfig(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/owning_credit_allocation_configs', fields, params, ExtendedCreditAllocationConfig, pathOverride);
    }
  }, {
    key: 'createWhatsAppCreditAttach',
    value: function createWhatsAppCreditAttach(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/whatsapp_credit_attach', fields, params, null, pathOverride);
    }
  }, {
    key: 'createWhatsAppCreditSharing',
    value: function createWhatsAppCreditSharing(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/whatsapp_credit_sharing', fields, params, null, pathOverride);
    }
  }, {
    key: 'createWhatsAppCreditSharingAndAttach',
    value: function createWhatsAppCreditSharingAndAttach(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/whatsapp_credit_sharing_and_attach', fields, params, ExtendedCreditAllocationConfig, pathOverride);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        allocated_amount: 'allocated_amount',
        balance: 'balance',
        credit_available: 'credit_available',
        credit_type: 'credit_type',
        id: 'id',
        is_access_revoked: 'is_access_revoked',
        is_automated_experience: 'is_automated_experience',
        legal_entity_name: 'legal_entity_name',
        liable_address: 'liable_address',
        liable_biz_name: 'liable_biz_name',
        max_balance: 'max_balance',
        online_max_balance: 'online_max_balance',
        owner_business: 'owner_business',
        owner_business_name: 'owner_business_name',
        partition_from: 'partition_from',
        receiving_credit_allocation_config: 'receiving_credit_allocation_config',
        send_bill_to_address: 'send_bill_to_address',
        send_bill_to_biz_name: 'send_bill_to_biz_name',
        sold_to_address: 'sold_to_address'
      });
    }
  }]);
  return ExtendedCredit;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * BusinessImage
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var BusinessImage = function (_AbstractCrudObject) {
  inherits(BusinessImage, _AbstractCrudObject);

  function BusinessImage() {
    classCallCheck(this, BusinessImage);
    return possibleConstructorReturn(this, (BusinessImage.__proto__ || Object.getPrototypeOf(BusinessImage)).apply(this, arguments));
  }

  createClass(BusinessImage, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        business: 'business',
        creation_time: 'creation_time',
        hash: 'hash',
        height: 'height',
        id: 'id',
        media_library_url: 'media_library_url',
        name: 'name',
        url: 'url',
        url_128: 'url_128',
        width: 'width'
      });
    }
  }, {
    key: 'ValidationAdPlacements',
    get: function get() {
      return Object.freeze({
        audience_network_instream_video: 'AUDIENCE_NETWORK_INSTREAM_VIDEO',
        audience_network_instream_video_mobile: 'AUDIENCE_NETWORK_INSTREAM_VIDEO_MOBILE',
        audience_network_rewarded_video: 'AUDIENCE_NETWORK_REWARDED_VIDEO',
        desktop_feed_standard: 'DESKTOP_FEED_STANDARD',
        facebook_story_mobile: 'FACEBOOK_STORY_MOBILE',
        facebook_story_sticker_mobile: 'FACEBOOK_STORY_STICKER_MOBILE',
        instagram_standard: 'INSTAGRAM_STANDARD',
        instagram_story: 'INSTAGRAM_STORY',
        instant_article_standard: 'INSTANT_ARTICLE_STANDARD',
        instream_banner_desktop: 'INSTREAM_BANNER_DESKTOP',
        instream_banner_mobile: 'INSTREAM_BANNER_MOBILE',
        instream_video_desktop: 'INSTREAM_VIDEO_DESKTOP',
        instream_video_image: 'INSTREAM_VIDEO_IMAGE',
        instream_video_mobile: 'INSTREAM_VIDEO_MOBILE',
        messenger_mobile_inbox_media: 'MESSENGER_MOBILE_INBOX_MEDIA',
        messenger_mobile_story_media: 'MESSENGER_MOBILE_STORY_MEDIA',
        mobile_feed_standard: 'MOBILE_FEED_STANDARD',
        mobile_fullwidth: 'MOBILE_FULLWIDTH',
        mobile_interstitial: 'MOBILE_INTERSTITIAL',
        mobile_medium_rectangle: 'MOBILE_MEDIUM_RECTANGLE',
        mobile_native: 'MOBILE_NATIVE',
        right_column_standard: 'RIGHT_COLUMN_STANDARD',
        suggested_video_mobile: 'SUGGESTED_VIDEO_MOBILE'
      });
    }
  }]);
  return BusinessImage;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * BusinessAssetSharingAgreement
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var BusinessAssetSharingAgreement = function (_AbstractCrudObject) {
  inherits(BusinessAssetSharingAgreement, _AbstractCrudObject);

  function BusinessAssetSharingAgreement() {
    classCallCheck(this, BusinessAssetSharingAgreement);
    return possibleConstructorReturn(this, (BusinessAssetSharingAgreement.__proto__ || Object.getPrototypeOf(BusinessAssetSharingAgreement)).apply(this, arguments));
  }

  createClass(BusinessAssetSharingAgreement, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(BusinessAssetSharingAgreement.prototype.__proto__ || Object.getPrototypeOf(BusinessAssetSharingAgreement.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        initiator: 'initiator',
        recipient: 'recipient',
        relationship_type: 'relationship_type',
        request_status: 'request_status',
        request_type: 'request_type'
      });
    }
  }, {
    key: 'RequestStatus',
    get: function get() {
      return Object.freeze({
        approve: 'APPROVE',
        canceled: 'CANCELED',
        decline: 'DECLINE',
        expired: 'EXPIRED',
        in_progress: 'IN_PROGRESS',
        mma_direct_assets_approved: 'MMA_DIRECT_ASSETS_APPROVED',
        mma_direct_assets_declined: 'MMA_DIRECT_ASSETS_DECLINED',
        mma_direct_assets_expired: 'MMA_DIRECT_ASSETS_EXPIRED',
        mma_direct_assets_pending: 'MMA_DIRECT_ASSETS_PENDING',
        pending: 'PENDING',
        pending_email_verification: 'PENDING_EMAIL_VERIFICATION',
        pending_integrity_review: 'PENDING_INTEGRITY_REVIEW'
      });
    }
  }]);
  return BusinessAssetSharingAgreement;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * FundingSourceDetailsCoupon
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var FundingSourceDetailsCoupon = function (_AbstractCrudObject) {
  inherits(FundingSourceDetailsCoupon, _AbstractCrudObject);

  function FundingSourceDetailsCoupon() {
    classCallCheck(this, FundingSourceDetailsCoupon);
    return possibleConstructorReturn(this, (FundingSourceDetailsCoupon.__proto__ || Object.getPrototypeOf(FundingSourceDetailsCoupon)).apply(this, arguments));
  }

  createClass(FundingSourceDetailsCoupon, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        amount: 'amount',
        campaign_ids: 'campaign_ids',
        child_ad_account_id: 'child_ad_account_id',
        child_bm_id: 'child_bm_id',
        coupon_id: 'coupon_id',
        coupon_tiering: 'coupon_tiering',
        currency: 'currency',
        display_amount: 'display_amount',
        expiration: 'expiration',
        original_amount: 'original_amount',
        original_display_amount: 'original_display_amount',
        start_date: 'start_date',
        vendor_id: 'vendor_id'
      });
    }
  }]);
  return FundingSourceDetailsCoupon;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ManagedPartnerBusiness
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ManagedPartnerBusiness = function (_AbstractCrudObject) {
  inherits(ManagedPartnerBusiness, _AbstractCrudObject);

  function ManagedPartnerBusiness() {
    classCallCheck(this, ManagedPartnerBusiness);
    return possibleConstructorReturn(this, (ManagedPartnerBusiness.__proto__ || Object.getPrototypeOf(ManagedPartnerBusiness)).apply(this, arguments));
  }

  createClass(ManagedPartnerBusiness, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        ad_account: 'ad_account',
        catalog_segment: 'catalog_segment',
        extended_credit: 'extended_credit',
        page: 'page',
        seller_business_info: 'seller_business_info',
        seller_business_status: 'seller_business_status',
        template: 'template'
      });
    }
  }, {
    key: 'PartitionType',
    get: function get() {
      return Object.freeze({
        auth: 'AUTH',
        fixed: 'FIXED',
        fixed_without_partition: 'FIXED_WITHOUT_PARTITION'
      });
    }
  }, {
    key: 'SurveyBusinessType',
    get: function get() {
      return Object.freeze({
        advertiser: 'ADVERTISER',
        agency: 'AGENCY',
        app_developer: 'APP_DEVELOPER',
        publisher: 'PUBLISHER'
      });
    }
  }, {
    key: 'TimezoneId',
    get: function get() {
      return Object.freeze({
        value_0: '0',
        value_1: '1',
        value_2: '2',
        value_3: '3',
        value_4: '4',
        value_5: '5',
        value_6: '6',
        value_7: '7',
        value_8: '8',
        value_9: '9',
        value_10: '10',
        value_11: '11',
        value_12: '12',
        value_13: '13',
        value_14: '14',
        value_15: '15',
        value_16: '16',
        value_17: '17',
        value_18: '18',
        value_19: '19',
        value_20: '20',
        value_21: '21',
        value_22: '22',
        value_23: '23',
        value_24: '24',
        value_25: '25',
        value_26: '26',
        value_27: '27',
        value_28: '28',
        value_29: '29',
        value_30: '30',
        value_31: '31',
        value_32: '32',
        value_33: '33',
        value_34: '34',
        value_35: '35',
        value_36: '36',
        value_37: '37',
        value_38: '38',
        value_39: '39',
        value_40: '40',
        value_41: '41',
        value_42: '42',
        value_43: '43',
        value_44: '44',
        value_45: '45',
        value_46: '46',
        value_47: '47',
        value_48: '48',
        value_49: '49',
        value_50: '50',
        value_51: '51',
        value_52: '52',
        value_53: '53',
        value_54: '54',
        value_55: '55',
        value_56: '56',
        value_57: '57',
        value_58: '58',
        value_59: '59',
        value_60: '60',
        value_61: '61',
        value_62: '62',
        value_63: '63',
        value_64: '64',
        value_65: '65',
        value_66: '66',
        value_67: '67',
        value_68: '68',
        value_69: '69',
        value_70: '70',
        value_71: '71',
        value_72: '72',
        value_73: '73',
        value_74: '74',
        value_75: '75',
        value_76: '76',
        value_77: '77',
        value_78: '78',
        value_79: '79',
        value_80: '80',
        value_81: '81',
        value_82: '82',
        value_83: '83',
        value_84: '84',
        value_85: '85',
        value_86: '86',
        value_87: '87',
        value_88: '88',
        value_89: '89',
        value_90: '90',
        value_91: '91',
        value_92: '92',
        value_93: '93',
        value_94: '94',
        value_95: '95',
        value_96: '96',
        value_97: '97',
        value_98: '98',
        value_99: '99',
        value_100: '100',
        value_101: '101',
        value_102: '102',
        value_103: '103',
        value_104: '104',
        value_105: '105',
        value_106: '106',
        value_107: '107',
        value_108: '108',
        value_109: '109',
        value_110: '110',
        value_111: '111',
        value_112: '112',
        value_113: '113',
        value_114: '114',
        value_115: '115',
        value_116: '116',
        value_117: '117',
        value_118: '118',
        value_119: '119',
        value_120: '120',
        value_121: '121',
        value_122: '122',
        value_123: '123',
        value_124: '124',
        value_125: '125',
        value_126: '126',
        value_127: '127',
        value_128: '128',
        value_129: '129',
        value_130: '130',
        value_131: '131',
        value_132: '132',
        value_133: '133',
        value_134: '134',
        value_135: '135',
        value_136: '136',
        value_137: '137',
        value_138: '138',
        value_139: '139',
        value_140: '140',
        value_141: '141',
        value_142: '142',
        value_143: '143',
        value_144: '144',
        value_145: '145',
        value_146: '146',
        value_147: '147',
        value_148: '148',
        value_149: '149',
        value_150: '150',
        value_151: '151',
        value_152: '152',
        value_153: '153',
        value_154: '154',
        value_155: '155',
        value_156: '156',
        value_157: '157',
        value_158: '158',
        value_159: '159',
        value_160: '160',
        value_161: '161',
        value_162: '162',
        value_163: '163',
        value_164: '164',
        value_165: '165',
        value_166: '166',
        value_167: '167',
        value_168: '168',
        value_169: '169',
        value_170: '170',
        value_171: '171',
        value_172: '172',
        value_173: '173',
        value_174: '174',
        value_175: '175',
        value_176: '176',
        value_177: '177',
        value_178: '178',
        value_179: '179',
        value_180: '180',
        value_181: '181',
        value_182: '182',
        value_183: '183',
        value_184: '184',
        value_185: '185',
        value_186: '186',
        value_187: '187',
        value_188: '188',
        value_189: '189',
        value_190: '190',
        value_191: '191',
        value_192: '192',
        value_193: '193',
        value_194: '194',
        value_195: '195',
        value_196: '196',
        value_197: '197',
        value_198: '198',
        value_199: '199',
        value_200: '200',
        value_201: '201',
        value_202: '202',
        value_203: '203',
        value_204: '204',
        value_205: '205',
        value_206: '206',
        value_207: '207',
        value_208: '208',
        value_209: '209',
        value_210: '210',
        value_211: '211',
        value_212: '212',
        value_213: '213',
        value_214: '214',
        value_215: '215',
        value_216: '216',
        value_217: '217',
        value_218: '218',
        value_219: '219',
        value_220: '220',
        value_221: '221',
        value_222: '222',
        value_223: '223',
        value_224: '224',
        value_225: '225',
        value_226: '226',
        value_227: '227',
        value_228: '228',
        value_229: '229',
        value_230: '230',
        value_231: '231',
        value_232: '232',
        value_233: '233',
        value_234: '234',
        value_235: '235',
        value_236: '236',
        value_237: '237',
        value_238: '238',
        value_239: '239',
        value_240: '240',
        value_241: '241',
        value_242: '242',
        value_243: '243',
        value_244: '244',
        value_245: '245',
        value_246: '246',
        value_247: '247',
        value_248: '248',
        value_249: '249',
        value_250: '250',
        value_251: '251',
        value_252: '252',
        value_253: '253',
        value_254: '254',
        value_255: '255',
        value_256: '256',
        value_257: '257',
        value_258: '258',
        value_259: '259',
        value_260: '260',
        value_261: '261',
        value_262: '262',
        value_263: '263',
        value_264: '264',
        value_265: '265',
        value_266: '266',
        value_267: '267',
        value_268: '268',
        value_269: '269',
        value_270: '270',
        value_271: '271',
        value_272: '272',
        value_273: '273',
        value_274: '274',
        value_275: '275',
        value_276: '276',
        value_277: '277',
        value_278: '278',
        value_279: '279',
        value_280: '280',
        value_281: '281',
        value_282: '282',
        value_283: '283',
        value_284: '284',
        value_285: '285',
        value_286: '286',
        value_287: '287',
        value_288: '288',
        value_289: '289',
        value_290: '290',
        value_291: '291',
        value_292: '292',
        value_293: '293',
        value_294: '294',
        value_295: '295',
        value_296: '296',
        value_297: '297',
        value_298: '298',
        value_299: '299',
        value_300: '300',
        value_301: '301',
        value_302: '302',
        value_303: '303',
        value_304: '304',
        value_305: '305',
        value_306: '306',
        value_307: '307',
        value_308: '308',
        value_309: '309',
        value_310: '310',
        value_311: '311',
        value_312: '312',
        value_313: '313',
        value_314: '314',
        value_315: '315',
        value_316: '316',
        value_317: '317',
        value_318: '318',
        value_319: '319',
        value_320: '320',
        value_321: '321',
        value_322: '322',
        value_323: '323',
        value_324: '324',
        value_325: '325',
        value_326: '326',
        value_327: '327',
        value_328: '328',
        value_329: '329',
        value_330: '330',
        value_331: '331',
        value_332: '332',
        value_333: '333',
        value_334: '334',
        value_335: '335',
        value_336: '336',
        value_337: '337',
        value_338: '338',
        value_339: '339',
        value_340: '340',
        value_341: '341',
        value_342: '342',
        value_343: '343',
        value_344: '344',
        value_345: '345',
        value_346: '346',
        value_347: '347',
        value_348: '348',
        value_349: '349',
        value_350: '350',
        value_351: '351',
        value_352: '352',
        value_353: '353',
        value_354: '354',
        value_355: '355',
        value_356: '356',
        value_357: '357',
        value_358: '358',
        value_359: '359',
        value_360: '360',
        value_361: '361',
        value_362: '362',
        value_363: '363',
        value_364: '364',
        value_365: '365',
        value_366: '366',
        value_367: '367',
        value_368: '368',
        value_369: '369',
        value_370: '370',
        value_371: '371',
        value_372: '372',
        value_373: '373',
        value_374: '374',
        value_375: '375',
        value_376: '376',
        value_377: '377',
        value_378: '378',
        value_379: '379',
        value_380: '380',
        value_381: '381',
        value_382: '382',
        value_383: '383',
        value_384: '384',
        value_385: '385',
        value_386: '386',
        value_387: '387',
        value_388: '388',
        value_389: '389',
        value_390: '390',
        value_391: '391',
        value_392: '392',
        value_393: '393',
        value_394: '394',
        value_395: '395',
        value_396: '396',
        value_397: '397',
        value_398: '398',
        value_399: '399',
        value_400: '400',
        value_401: '401',
        value_402: '402',
        value_403: '403',
        value_404: '404',
        value_405: '405',
        value_406: '406',
        value_407: '407',
        value_408: '408',
        value_409: '409',
        value_410: '410',
        value_411: '411',
        value_412: '412',
        value_413: '413',
        value_414: '414',
        value_415: '415',
        value_416: '416',
        value_417: '417',
        value_418: '418',
        value_419: '419',
        value_420: '420',
        value_421: '421',
        value_422: '422',
        value_423: '423',
        value_424: '424',
        value_425: '425',
        value_426: '426',
        value_427: '427',
        value_428: '428',
        value_429: '429',
        value_430: '430',
        value_431: '431',
        value_432: '432',
        value_433: '433',
        value_434: '434',
        value_435: '435',
        value_436: '436',
        value_437: '437',
        value_438: '438',
        value_439: '439',
        value_440: '440',
        value_441: '441',
        value_442: '442',
        value_443: '443',
        value_444: '444',
        value_445: '445',
        value_446: '446',
        value_447: '447',
        value_448: '448',
        value_449: '449',
        value_450: '450',
        value_451: '451',
        value_452: '452',
        value_453: '453',
        value_454: '454',
        value_455: '455',
        value_456: '456',
        value_457: '457',
        value_458: '458',
        value_459: '459',
        value_460: '460',
        value_461: '461',
        value_462: '462',
        value_463: '463',
        value_464: '464',
        value_465: '465',
        value_466: '466',
        value_467: '467',
        value_468: '468',
        value_469: '469',
        value_470: '470',
        value_471: '471',
        value_472: '472',
        value_473: '473',
        value_474: '474',
        value_475: '475',
        value_476: '476',
        value_477: '477',
        value_478: '478',
        value_479: '479',
        value_480: '480'
      });
    }
  }, {
    key: 'Vertical',
    get: function get() {
      return Object.freeze({
        advertising: 'ADVERTISING',
        automotive: 'AUTOMOTIVE',
        consumer_packaged_goods: 'CONSUMER_PACKAGED_GOODS',
        ecommerce: 'ECOMMERCE',
        education: 'EDUCATION',
        energy_and_utilities: 'ENERGY_AND_UTILITIES',
        entertainment_and_media: 'ENTERTAINMENT_AND_MEDIA',
        financial_services: 'FINANCIAL_SERVICES',
        gaming: 'GAMING',
        government_and_politics: 'GOVERNMENT_AND_POLITICS',
        health: 'HEALTH',
        luxury: 'LUXURY',
        marketing: 'MARKETING',
        non_profit: 'NON_PROFIT',
        not_set: 'NOT_SET',
        organizations_and_associations: 'ORGANIZATIONS_AND_ASSOCIATIONS',
        other: 'OTHER',
        professional_services: 'PROFESSIONAL_SERVICES',
        restaurant: 'RESTAURANT',
        retail: 'RETAIL',
        technology: 'TECHNOLOGY',
        telecom: 'TELECOM',
        travel: 'TRAVEL'
      });
    }
  }]);
  return ManagedPartnerBusiness;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * OpenBridgeConfiguration
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var OpenBridgeConfiguration = function (_AbstractCrudObject) {
  inherits(OpenBridgeConfiguration, _AbstractCrudObject);

  function OpenBridgeConfiguration() {
    classCallCheck(this, OpenBridgeConfiguration);
    return possibleConstructorReturn(this, (OpenBridgeConfiguration.__proto__ || Object.getPrototypeOf(OpenBridgeConfiguration)).apply(this, arguments));
  }

  createClass(OpenBridgeConfiguration, [{
    key: 'delete',


    // $FlowFixMe : Support Generic Types
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(OpenBridgeConfiguration.prototype.__proto__ || Object.getPrototypeOf(OpenBridgeConfiguration.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(OpenBridgeConfiguration.prototype.__proto__ || Object.getPrototypeOf(OpenBridgeConfiguration.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        active: 'active',
        blocked_event_types: 'blocked_event_types',
        blocked_websites: 'blocked_websites',
        browser_agent: 'browser_agent',
        cloud_provider: 'cloud_provider',
        cloud_region: 'cloud_region',
        destination_id: 'destination_id',
        endpoint: 'endpoint',
        event_enrichment_state: 'event_enrichment_state',
        fallback_domain: 'fallback_domain',
        first_party_domain: 'first_party_domain',
        host_business_id: 'host_business_id',
        id: 'id',
        instance_id: 'instance_id',
        instance_version: 'instance_version',
        is_sgw_instance: 'is_sgw_instance',
        is_sgw_pixel_from_meta_pixel: 'is_sgw_pixel_from_meta_pixel',
        partner_name: 'partner_name',
        pixel_id: 'pixel_id',
        sgw_account_id: 'sgw_account_id',
        sgw_instance_url: 'sgw_instance_url',
        sgw_pixel_id: 'sgw_pixel_id'
      });
    }
  }, {
    key: 'EventEnrichmentState',
    get: function get() {
      return Object.freeze({
        no: 'NO',
        not_initialized: 'NOT_INITIALIZED',
        yes: 'YES'
      });
    }
  }]);
  return OpenBridgeConfiguration;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * PartnerAccountLinking
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var PartnerAccountLinking = function (_AbstractCrudObject) {
  inherits(PartnerAccountLinking, _AbstractCrudObject);

  function PartnerAccountLinking() {
    classCallCheck(this, PartnerAccountLinking);
    return possibleConstructorReturn(this, (PartnerAccountLinking.__proto__ || Object.getPrototypeOf(PartnerAccountLinking)).apply(this, arguments));
  }

  createClass(PartnerAccountLinking, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        adaccount: 'adaccount',
        app: 'app',
        business: 'business',
        externalidentifier: 'externalidentifier',
        externalidentifieruri: 'externalidentifieruri',
        id: 'id',
        partnername: 'partnername',
        pixel: 'pixel'
      });
    }
  }]);
  return PartnerAccountLinking;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * BusinessAdAccountRequest
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var BusinessAdAccountRequest = function (_AbstractCrudObject) {
  inherits(BusinessAdAccountRequest, _AbstractCrudObject);

  function BusinessAdAccountRequest() {
    classCallCheck(this, BusinessAdAccountRequest);
    return possibleConstructorReturn(this, (BusinessAdAccountRequest.__proto__ || Object.getPrototypeOf(BusinessAdAccountRequest)).apply(this, arguments));
  }

  createClass(BusinessAdAccountRequest, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        ad_account: 'ad_account',
        id: 'id'
      });
    }
  }]);
  return BusinessAdAccountRequest;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * BusinessApplicationRequest
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var BusinessApplicationRequest = function (_AbstractCrudObject) {
  inherits(BusinessApplicationRequest, _AbstractCrudObject);

  function BusinessApplicationRequest() {
    classCallCheck(this, BusinessApplicationRequest);
    return possibleConstructorReturn(this, (BusinessApplicationRequest.__proto__ || Object.getPrototypeOf(BusinessApplicationRequest)).apply(this, arguments));
  }

  createClass(BusinessApplicationRequest, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        application: 'application',
        id: 'id'
      });
    }
  }]);
  return BusinessApplicationRequest;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * BusinessPageRequest
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var BusinessPageRequest = function (_AbstractCrudObject) {
  inherits(BusinessPageRequest, _AbstractCrudObject);

  function BusinessPageRequest() {
    classCallCheck(this, BusinessPageRequest);
    return possibleConstructorReturn(this, (BusinessPageRequest.__proto__ || Object.getPrototypeOf(BusinessPageRequest)).apply(this, arguments));
  }

  createClass(BusinessPageRequest, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        id: 'id',
        page: 'page'
      });
    }
  }]);
  return BusinessPageRequest;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * BusinessRoleRequest
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var BusinessRoleRequest = function (_AbstractCrudObject) {
  inherits(BusinessRoleRequest, _AbstractCrudObject);

  function BusinessRoleRequest() {
    classCallCheck(this, BusinessRoleRequest);
    return possibleConstructorReturn(this, (BusinessRoleRequest.__proto__ || Object.getPrototypeOf(BusinessRoleRequest)).apply(this, arguments));
  }

  createClass(BusinessRoleRequest, [{
    key: 'delete',


    // $FlowFixMe : Support Generic Types
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(BusinessRoleRequest.prototype.__proto__ || Object.getPrototypeOf(BusinessRoleRequest.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(BusinessRoleRequest.prototype.__proto__ || Object.getPrototypeOf(BusinessRoleRequest.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        created_by: 'created_by',
        created_time: 'created_time',
        email: 'email',
        expiration_time: 'expiration_time',
        expiry_time: 'expiry_time',
        finance_role: 'finance_role',
        id: 'id',
        invite_link: 'invite_link',
        invited_user_type: 'invited_user_type',
        ip_role: 'ip_role',
        owner: 'owner',
        role: 'role',
        status: 'status',
        tasks: 'tasks',
        updated_by: 'updated_by',
        updated_time: 'updated_time'
      });
    }
  }, {
    key: 'Role',
    get: function get() {
      return Object.freeze({
        admin: 'ADMIN',
        ads_rights_reviewer: 'ADS_RIGHTS_REVIEWER',
        default: 'DEFAULT',
        developer: 'DEVELOPER',
        employee: 'EMPLOYEE',
        finance_analyst: 'FINANCE_ANALYST',
        finance_edit: 'FINANCE_EDIT',
        finance_editor: 'FINANCE_EDITOR',
        finance_view: 'FINANCE_VIEW',
        manage: 'MANAGE',
        partner_center_admin: 'PARTNER_CENTER_ADMIN',
        partner_center_analyst: 'PARTNER_CENTER_ANALYST',
        partner_center_education: 'PARTNER_CENTER_EDUCATION',
        partner_center_marketing: 'PARTNER_CENTER_MARKETING',
        partner_center_operations: 'PARTNER_CENTER_OPERATIONS'
      });
    }
  }, {
    key: 'Tasks',
    get: function get() {
      return Object.freeze({
        admin: 'ADMIN',
        ads_rights_reviewer: 'ADS_RIGHTS_REVIEWER',
        default: 'DEFAULT',
        developer: 'DEVELOPER',
        employee: 'EMPLOYEE',
        finance_analyst: 'FINANCE_ANALYST',
        finance_edit: 'FINANCE_EDIT',
        finance_editor: 'FINANCE_EDITOR',
        finance_view: 'FINANCE_VIEW',
        manage: 'MANAGE',
        partner_center_admin: 'PARTNER_CENTER_ADMIN',
        partner_center_analyst: 'PARTNER_CENTER_ANALYST',
        partner_center_education: 'PARTNER_CENTER_EDUCATION',
        partner_center_marketing: 'PARTNER_CENTER_MARKETING',
        partner_center_operations: 'PARTNER_CENTER_OPERATIONS'
      });
    }
  }]);
  return BusinessRoleRequest;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * WhatsAppBusinessPreVerifiedPhoneNumber
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var WhatsAppBusinessPreVerifiedPhoneNumber = function (_AbstractCrudObject) {
  inherits(WhatsAppBusinessPreVerifiedPhoneNumber, _AbstractCrudObject);

  function WhatsAppBusinessPreVerifiedPhoneNumber() {
    classCallCheck(this, WhatsAppBusinessPreVerifiedPhoneNumber);
    return possibleConstructorReturn(this, (WhatsAppBusinessPreVerifiedPhoneNumber.__proto__ || Object.getPrototypeOf(WhatsAppBusinessPreVerifiedPhoneNumber)).apply(this, arguments));
  }

  createClass(WhatsAppBusinessPreVerifiedPhoneNumber, [{
    key: 'getPartners',
    value: function getPartners(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Business, fields, params, fetchFirstPage, '/partners');
    }
  }, {
    key: 'createRequestCode',
    value: function createRequestCode(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/request_code', fields, params, null, pathOverride);
    }
  }, {
    key: 'createVerifyCode',
    value: function createVerifyCode(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/verify_code', fields, params, null, pathOverride);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'delete',
    value: function _delete(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(WhatsAppBusinessPreVerifiedPhoneNumber.prototype.__proto__ || Object.getPrototypeOf(WhatsAppBusinessPreVerifiedPhoneNumber.prototype), 'delete', this).call(this, params);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        code_verification_status: 'code_verification_status',
        code_verification_time: 'code_verification_time',
        id: 'id',
        owner_business: 'owner_business',
        phone_number: 'phone_number',
        verification_expiry_time: 'verification_expiry_time'
      });
    }
  }, {
    key: 'CodeVerificationStatus',
    get: function get() {
      return Object.freeze({
        expired: 'EXPIRED',
        not_verified: 'NOT_VERIFIED',
        verified: 'VERIFIED'
      });
    }
  }]);
  return WhatsAppBusinessPreVerifiedPhoneNumber;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ResellerGuidance
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ResellerGuidance = function (_AbstractCrudObject) {
  inherits(ResellerGuidance, _AbstractCrudObject);

  function ResellerGuidance() {
    classCallCheck(this, ResellerGuidance);
    return possibleConstructorReturn(this, (ResellerGuidance.__proto__ || Object.getPrototypeOf(ResellerGuidance)).apply(this, arguments));
  }

  createClass(ResellerGuidance, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        ad_account_first_spend_date: 'ad_account_first_spend_date',
        ad_account_id: 'ad_account_id',
        adopted_guidance_l7d: 'adopted_guidance_l7d',
        advertiser_name: 'advertiser_name',
        attributed_to_reseller_l7d: 'attributed_to_reseller_l7d',
        available_guidance: 'available_guidance',
        guidance_adoption_rate_l7d: 'guidance_adoption_rate_l7d',
        nurtured_by_reseller_l7d: 'nurtured_by_reseller_l7d',
        planning_agency_name: 'planning_agency_name',
        recommendation_time: 'recommendation_time',
        reporting_ds: 'reporting_ds',
        reseller: 'reseller',
        revenue_l30d: 'revenue_l30d',
        ultimate_advertiser_name: 'ultimate_advertiser_name'
      });
    }
  }]);
  return ResellerGuidance;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * WhatsAppBusinessPartnerClientVerificationSubmission
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var WhatsAppBusinessPartnerClientVerificationSubmission = function (_AbstractCrudObject) {
  inherits(WhatsAppBusinessPartnerClientVerificationSubmission, _AbstractCrudObject);

  function WhatsAppBusinessPartnerClientVerificationSubmission() {
    classCallCheck(this, WhatsAppBusinessPartnerClientVerificationSubmission);
    return possibleConstructorReturn(this, (WhatsAppBusinessPartnerClientVerificationSubmission.__proto__ || Object.getPrototypeOf(WhatsAppBusinessPartnerClientVerificationSubmission)).apply(this, arguments));
  }

  createClass(WhatsAppBusinessPartnerClientVerificationSubmission, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        client_business_id: 'client_business_id',
        id: 'id',
        rejection_reasons: 'rejection_reasons',
        submitted_info: 'submitted_info',
        submitted_time: 'submitted_time',
        update_time: 'update_time',
        verification_status: 'verification_status'
      });
    }
  }, {
    key: 'RejectionReasons',
    get: function get() {
      return Object.freeze({
        address_not_matching: 'ADDRESS_NOT_MATCHING',
        business_not_eligible: 'BUSINESS_NOT_ELIGIBLE',
        legal_name_not_found_in_documents: 'LEGAL_NAME_NOT_FOUND_IN_DOCUMENTS',
        legal_name_not_matching: 'LEGAL_NAME_NOT_MATCHING',
        malformed_documents: 'MALFORMED_DOCUMENTS',
        none: 'NONE',
        website_not_matching: 'WEBSITE_NOT_MATCHING'
      });
    }
  }, {
    key: 'VerificationStatus',
    get: function get() {
      return Object.freeze({
        approved: 'APPROVED',
        discarded: 'DISCARDED',
        failed: 'FAILED',
        pending: 'PENDING',
        revoked: 'REVOKED'
      });
    }
  }]);
  return WhatsAppBusinessPartnerClientVerificationSubmission;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * SystemUser
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var SystemUser = function (_AbstractCrudObject) {
  inherits(SystemUser, _AbstractCrudObject);

  function SystemUser() {
    classCallCheck(this, SystemUser);
    return possibleConstructorReturn(this, (SystemUser.__proto__ || Object.getPrototypeOf(SystemUser)).apply(this, arguments));
  }

  createClass(SystemUser, [{
    key: 'getAssignedAdAccounts',
    value: function getAssignedAdAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdAccount, fields, params, fetchFirstPage, '/assigned_ad_accounts');
    }
  }, {
    key: 'getAssignedBusinessAssetGroups',
    value: function getAssignedBusinessAssetGroups(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BusinessAssetGroup, fields, params, fetchFirstPage, '/assigned_business_asset_groups');
    }
  }, {
    key: 'getAssignedPages',
    value: function getAssignedPages(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/assigned_pages');
    }
  }, {
    key: 'getAssignedProductCatalogs',
    value: function getAssignedProductCatalogs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductCatalog, fields, params, fetchFirstPage, '/assigned_product_catalogs');
    }
  }, {
    key: 'getAssignedWhatsAppBusinessAccounts',
    value: function getAssignedWhatsAppBusinessAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(WhatsAppBusinessAccount, fields, params, fetchFirstPage, '/assigned_whatsapp_business_accounts');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        created_by: 'created_by',
        created_time: 'created_time',
        finance_permission: 'finance_permission',
        id: 'id',
        ip_permission: 'ip_permission',
        name: 'name'
      });
    }
  }, {
    key: 'Role',
    get: function get() {
      return Object.freeze({
        admin: 'ADMIN',
        ads_rights_reviewer: 'ADS_RIGHTS_REVIEWER',
        default: 'DEFAULT',
        developer: 'DEVELOPER',
        employee: 'EMPLOYEE',
        finance_analyst: 'FINANCE_ANALYST',
        finance_edit: 'FINANCE_EDIT',
        finance_editor: 'FINANCE_EDITOR',
        finance_view: 'FINANCE_VIEW',
        manage: 'MANAGE',
        partner_center_admin: 'PARTNER_CENTER_ADMIN',
        partner_center_analyst: 'PARTNER_CENTER_ANALYST',
        partner_center_education: 'PARTNER_CENTER_EDUCATION',
        partner_center_marketing: 'PARTNER_CENTER_MARKETING',
        partner_center_operations: 'PARTNER_CENTER_OPERATIONS'
      });
    }
  }]);
  return SystemUser;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * ThirdPartyMeasurementReportDataset
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var ThirdPartyMeasurementReportDataset = function (_AbstractCrudObject) {
  inherits(ThirdPartyMeasurementReportDataset, _AbstractCrudObject);

  function ThirdPartyMeasurementReportDataset() {
    classCallCheck(this, ThirdPartyMeasurementReportDataset);
    return possibleConstructorReturn(this, (ThirdPartyMeasurementReportDataset.__proto__ || Object.getPrototypeOf(ThirdPartyMeasurementReportDataset)).apply(this, arguments));
  }

  createClass(ThirdPartyMeasurementReportDataset, [{
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        category: 'category',
        id: 'id',
        partner: 'partner',
        product: 'product',
        schema: 'schema'
      });
    }
  }]);
  return ThirdPartyMeasurementReportDataset;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Business
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Business = function (_AbstractCrudObject) {
  inherits(Business, _AbstractCrudObject);

  function Business() {
    classCallCheck(this, Business);
    return possibleConstructorReturn(this, (Business.__proto__ || Object.getPrototypeOf(Business)).apply(this, arguments));
  }

  createClass(Business, [{
    key: 'createAccessToken',
    value: function createAccessToken(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/access_token', fields, params, Business, pathOverride);
    }
  }, {
    key: 'getAdAccountInfos',
    value: function getAdAccountInfos(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ALMAdAccountInfo, fields, params, fetchFirstPage, '/ad_account_infos');
    }
  }, {
    key: 'deleteAdAccounts',
    value: function deleteAdAccounts() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Business.prototype.__proto__ || Object.getPrototypeOf(Business.prototype), 'deleteEdge', this).call(this, '/ad_accounts', params);
    }
  }, {
    key: 'getAdCustomDerivedMetrics',
    value: function getAdCustomDerivedMetrics(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdCustomDerivedMetrics, fields, params, fetchFirstPage, '/ad_custom_derived_metrics');
    }
  }, {
    key: 'createAdReviewRequest',
    value: function createAdReviewRequest(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/ad_review_requests', fields, params, null, pathOverride);
    }
  }, {
    key: 'getAdStudies',
    value: function getAdStudies(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdStudy, fields, params, fetchFirstPage, '/ad_studies');
    }
  }, {
    key: 'createAdStudy',
    value: function createAdStudy(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/ad_studies', fields, params, AdStudy, pathOverride);
    }
  }, {
    key: 'createAdAccount',
    value: function createAdAccount(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/adaccount', fields, params, AdAccount, pathOverride);
    }
  }, {
    key: 'createAddPhoneNumber',
    value: function createAddPhoneNumber(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/add_phone_numbers', fields, params, Business, pathOverride);
    }
  }, {
    key: 'createAdNetworkApplication',
    value: function createAdNetworkApplication(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/adnetwork_applications', fields, params, Application, pathOverride);
    }
  }, {
    key: 'getAdNetworkAnalytics',
    value: function getAdNetworkAnalytics(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdNetworkAnalyticsSyncQueryResult, fields, params, fetchFirstPage, '/adnetworkanalytics');
    }
  }, {
    key: 'createAdNetworkAnalytic',
    value: function createAdNetworkAnalytic(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/adnetworkanalytics', fields, params, Business, pathOverride);
    }
  }, {
    key: 'getAdNetworkAnalyticsResults',
    value: function getAdNetworkAnalyticsResults(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdNetworkAnalyticsAsyncQueryResult, fields, params, fetchFirstPage, '/adnetworkanalytics_results');
    }
  }, {
    key: 'getAdsDataset',
    value: function getAdsDataset(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdsDataset, fields, params, fetchFirstPage, '/ads_dataset');
    }
  }, {
    key: 'createAdsDataSet',
    value: function createAdsDataSet(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/ads_dataset', fields, params, Business, pathOverride);
    }
  }, {
    key: 'getAdsReportingMmmReports',
    value: function getAdsReportingMmmReports(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdsReportBuilderMMMReport, fields, params, fetchFirstPage, '/ads_reporting_mmm_reports');
    }
  }, {
    key: 'getAdsReportingMmmSchedulers',
    value: function getAdsReportingMmmSchedulers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdsReportBuilderMMMReportScheduler, fields, params, fetchFirstPage, '/ads_reporting_mmm_schedulers');
    }
  }, {
    key: 'getAdsPixels',
    value: function getAdsPixels(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdsPixel, fields, params, fetchFirstPage, '/adspixels');
    }
  }, {
    key: 'createAdsPixel',
    value: function createAdsPixel(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/adspixels', fields, params, AdsPixel, pathOverride);
    }
  }, {
    key: 'deleteAgencies',
    value: function deleteAgencies() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Business.prototype.__proto__ || Object.getPrototypeOf(Business.prototype), 'deleteEdge', this).call(this, '/agencies', params);
    }
  }, {
    key: 'getAgencies',
    value: function getAgencies(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Business, fields, params, fetchFirstPage, '/agencies');
    }
  }, {
    key: 'getAnPlacements',
    value: function getAnPlacements(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdPlacement, fields, params, fetchFirstPage, '/an_placements');
    }
  }, {
    key: 'createBlockListDraft',
    value: function createBlockListDraft(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/block_list_drafts', fields, params, Business, pathOverride);
    }
  }, {
    key: 'createBmReviewRequest',
    value: function createBmReviewRequest(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/bm_review_requests', fields, params, null, pathOverride);
    }
  }, {
    key: 'getBusinessAssetGroups',
    value: function getBusinessAssetGroups(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BusinessAssetGroup, fields, params, fetchFirstPage, '/business_asset_groups');
    }
  }, {
    key: 'getBusinessInvoices',
    value: function getBusinessInvoices(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(OmegaCustomerTrx, fields, params, fetchFirstPage, '/business_invoices');
    }
  }, {
    key: 'getBusinessUsers',
    value: function getBusinessUsers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BusinessUser, fields, params, fetchFirstPage, '/business_users');
    }
  }, {
    key: 'createBusinessUser',
    value: function createBusinessUser(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/business_users', fields, params, BusinessUser, pathOverride);
    }
  }, {
    key: 'getBusinessProjects',
    value: function getBusinessProjects(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BusinessProject, fields, params, fetchFirstPage, '/businessprojects');
    }
  }, {
    key: 'createClaimCustomConversion',
    value: function createClaimCustomConversion(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/claim_custom_conversions', fields, params, CustomConversion, pathOverride);
    }
  }, {
    key: 'getClientAdAccounts',
    value: function getClientAdAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdAccount, fields, params, fetchFirstPage, '/client_ad_accounts');
    }
  }, {
    key: 'getClientApps',
    value: function getClientApps(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Application, fields, params, fetchFirstPage, '/client_apps');
    }
  }, {
    key: 'createClientApp',
    value: function createClientApp(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/client_apps', fields, params, Business, pathOverride);
    }
  }, {
    key: 'getClientInstagramAssets',
    value: function getClientInstagramAssets(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(InstagramBusinessAsset, fields, params, fetchFirstPage, '/client_instagram_assets');
    }
  }, {
    key: 'getClientOffsiteSignalContainerBusinessObjects',
    value: function getClientOffsiteSignalContainerBusinessObjects(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(OffsiteSignalContainerBusinessObject, fields, params, fetchFirstPage, '/client_offsite_signal_container_business_objects');
    }
  }, {
    key: 'getClientPages',
    value: function getClientPages(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/client_pages');
    }
  }, {
    key: 'createClientPage',
    value: function createClientPage(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/client_pages', fields, params, Business, pathOverride);
    }
  }, {
    key: 'getClientPixels',
    value: function getClientPixels(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdsPixel, fields, params, fetchFirstPage, '/client_pixels');
    }
  }, {
    key: 'getClientProductCatalogs',
    value: function getClientProductCatalogs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductCatalog, fields, params, fetchFirstPage, '/client_product_catalogs');
    }
  }, {
    key: 'getClientWhatsAppBusinessAccounts',
    value: function getClientWhatsAppBusinessAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(WhatsAppBusinessAccount, fields, params, fetchFirstPage, '/client_whatsapp_business_accounts');
    }
  }, {
    key: 'deleteClients',
    value: function deleteClients() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Business.prototype.__proto__ || Object.getPrototypeOf(Business.prototype), 'deleteEdge', this).call(this, '/clients', params);
    }
  }, {
    key: 'getClients',
    value: function getClients(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Business, fields, params, fetchFirstPage, '/clients');
    }
  }, {
    key: 'getCollaborativeAdsCollaborationRequests',
    value: function getCollaborativeAdsCollaborationRequests(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CPASCollaborationRequest, fields, params, fetchFirstPage, '/collaborative_ads_collaboration_requests');
    }
  }, {
    key: 'createCollaborativeAdsCollaborationRequest',
    value: function createCollaborativeAdsCollaborationRequest(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/collaborative_ads_collaboration_requests', fields, params, CPASCollaborationRequest, pathOverride);
    }
  }, {
    key: 'getCollaborativeAdsSuggestedPartners',
    value: function getCollaborativeAdsSuggestedPartners(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CPASAdvertiserPartnershipRecommendation, fields, params, fetchFirstPage, '/collaborative_ads_suggested_partners');
    }
  }, {
    key: 'getCommerceMerchantSettings',
    value: function getCommerceMerchantSettings(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CommerceMerchantSettings, fields, params, fetchFirstPage, '/commerce_merchant_settings');
    }
  }, {
    key: 'getCpasBusinessSetupConfig',
    value: function getCpasBusinessSetupConfig(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CPASBusinessSetupConfig, fields, params, fetchFirstPage, '/cpas_business_setup_config');
    }
  }, {
    key: 'createCpasBusinessSetupConfig',
    value: function createCpasBusinessSetupConfig(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/cpas_business_setup_config', fields, params, CPASBusinessSetupConfig, pathOverride);
    }
  }, {
    key: 'getCpasMerchantConfig',
    value: function getCpasMerchantConfig(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CPASMerchantConfig, fields, params, fetchFirstPage, '/cpas_merchant_config');
    }
  }, {
    key: 'createCreativeFolder',
    value: function createCreativeFolder(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/creative_folders', fields, params, BusinessCreativeFolder, pathOverride);
    }
  }, {
    key: 'getCreditCards',
    value: function getCreditCards(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(CreditCard, fields, params, fetchFirstPage, '/creditcards');
    }
  }, {
    key: 'createCustomConversion',
    value: function createCustomConversion(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/customconversions', fields, params, CustomConversion, pathOverride);
    }
  }, {
    key: 'getEventSourceGroups',
    value: function getEventSourceGroups(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(EventSourceGroup, fields, params, fetchFirstPage, '/event_source_groups');
    }
  }, {
    key: 'createEventSourceGroup',
    value: function createEventSourceGroup(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/event_source_groups', fields, params, EventSourceGroup, pathOverride);
    }
  }, {
    key: 'getExtendedCreditApplications',
    value: function getExtendedCreditApplications(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ExtendedCreditApplication, fields, params, fetchFirstPage, '/extendedcreditapplications');
    }
  }, {
    key: 'getExtendedCredits',
    value: function getExtendedCredits(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ExtendedCredit, fields, params, fetchFirstPage, '/extendedcredits');
    }
  }, {
    key: 'createImage',
    value: function createImage(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/images', fields, params, BusinessImage, pathOverride);
    }
  }, {
    key: 'getInitiatedAudienceSharingRequests',
    value: function getInitiatedAudienceSharingRequests(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BusinessAssetSharingAgreement, fields, params, fetchFirstPage, '/initiated_audience_sharing_requests');
    }
  }, {
    key: 'deleteInstagramAccounts',
    value: function deleteInstagramAccounts() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Business.prototype.__proto__ || Object.getPrototypeOf(Business.prototype), 'deleteEdge', this).call(this, '/instagram_accounts', params);
    }
  }, {
    key: 'getInstagramAccounts',
    value: function getInstagramAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGUser, fields, params, fetchFirstPage, '/instagram_accounts');
    }
  }, {
    key: 'getInstagramBusinessAccounts',
    value: function getInstagramBusinessAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGUser, fields, params, fetchFirstPage, '/instagram_business_accounts');
    }
  }, {
    key: 'deleteManagedBusinesses',
    value: function deleteManagedBusinesses() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Business.prototype.__proto__ || Object.getPrototypeOf(Business.prototype), 'deleteEdge', this).call(this, '/managed_businesses', params);
    }
  }, {
    key: 'createManagedBusiness',
    value: function createManagedBusiness(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/managed_businesses', fields, params, Business, pathOverride);
    }
  }, {
    key: 'getManagedPartnerAdsFundingSourceDetails',
    value: function getManagedPartnerAdsFundingSourceDetails(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(FundingSourceDetailsCoupon, fields, params, fetchFirstPage, '/managed_partner_ads_funding_source_details');
    }
  }, {
    key: 'createManagedPartnerBusinessSetup',
    value: function createManagedPartnerBusinessSetup(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/managed_partner_business_setup', fields, params, Business, pathOverride);
    }
  }, {
    key: 'deleteManagedPartnerBusinesses',
    value: function deleteManagedPartnerBusinesses() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Business.prototype.__proto__ || Object.getPrototypeOf(Business.prototype), 'deleteEdge', this).call(this, '/managed_partner_businesses', params);
    }
  }, {
    key: 'createManagedPartnerBusiness',
    value: function createManagedPartnerBusiness(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/managed_partner_businesses', fields, params, ManagedPartnerBusiness, pathOverride);
    }
  }, {
    key: 'createOnboardPartnersToMmLite',
    value: function createOnboardPartnersToMmLite(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/onboard_partners_to_mm_lite', fields, params, null, pathOverride);
    }
  }, {
    key: 'getOpenBridgeConfigurations',
    value: function getOpenBridgeConfigurations(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(OpenBridgeConfiguration, fields, params, fetchFirstPage, '/openbridge_configurations');
    }
  }, {
    key: 'createOpenBridgeConfiguration',
    value: function createOpenBridgeConfiguration(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/openbridge_configurations', fields, params, OpenBridgeConfiguration, pathOverride);
    }
  }, {
    key: 'getOwnedAdAccounts',
    value: function getOwnedAdAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdAccount, fields, params, fetchFirstPage, '/owned_ad_accounts');
    }
  }, {
    key: 'createOwnedAdAccount',
    value: function createOwnedAdAccount(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/owned_ad_accounts', fields, params, Business, pathOverride);
    }
  }, {
    key: 'getOwnedApps',
    value: function getOwnedApps(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Application, fields, params, fetchFirstPage, '/owned_apps');
    }
  }, {
    key: 'createOwnedApp',
    value: function createOwnedApp(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/owned_apps', fields, params, Business, pathOverride);
    }
  }, {
    key: 'deleteOwnedBusinesses',
    value: function deleteOwnedBusinesses() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Business.prototype.__proto__ || Object.getPrototypeOf(Business.prototype), 'deleteEdge', this).call(this, '/owned_businesses', params);
    }
  }, {
    key: 'getOwnedBusinesses',
    value: function getOwnedBusinesses(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Business, fields, params, fetchFirstPage, '/owned_businesses');
    }
  }, {
    key: 'createOwnedBusiness',
    value: function createOwnedBusiness(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/owned_businesses', fields, params, Business, pathOverride);
    }
  }, {
    key: 'getOwnedInstagramAccounts',
    value: function getOwnedInstagramAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(IGUser, fields, params, fetchFirstPage, '/owned_instagram_accounts');
    }
  }, {
    key: 'getOwnedInstagramAssets',
    value: function getOwnedInstagramAssets(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(InstagramBusinessAsset, fields, params, fetchFirstPage, '/owned_instagram_assets');
    }
  }, {
    key: 'getOwnedOffsiteSignalContainerBusinessObjects',
    value: function getOwnedOffsiteSignalContainerBusinessObjects(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(OffsiteSignalContainerBusinessObject, fields, params, fetchFirstPage, '/owned_offsite_signal_container_business_objects');
    }
  }, {
    key: 'getOwnedPages',
    value: function getOwnedPages(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Page, fields, params, fetchFirstPage, '/owned_pages');
    }
  }, {
    key: 'createOwnedPage',
    value: function createOwnedPage(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/owned_pages', fields, params, Business, pathOverride);
    }
  }, {
    key: 'getOwnedPixels',
    value: function getOwnedPixels(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdsPixel, fields, params, fetchFirstPage, '/owned_pixels');
    }
  }, {
    key: 'getOwnedProductCatalogs',
    value: function getOwnedProductCatalogs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProductCatalog, fields, params, fetchFirstPage, '/owned_product_catalogs');
    }
  }, {
    key: 'createOwnedProductCatalog',
    value: function createOwnedProductCatalog(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/owned_product_catalogs', fields, params, ProductCatalog, pathOverride);
    }
  }, {
    key: 'getOwnedWhatsAppBusinessAccounts',
    value: function getOwnedWhatsAppBusinessAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(WhatsAppBusinessAccount, fields, params, fetchFirstPage, '/owned_whatsapp_business_accounts');
    }
  }, {
    key: 'deletePages',
    value: function deletePages() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Business.prototype.__proto__ || Object.getPrototypeOf(Business.prototype), 'deleteEdge', this).call(this, '/pages', params);
    }
  }, {
    key: 'getPartnerAccountLinking',
    value: function getPartnerAccountLinking(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(PartnerAccountLinking, fields, params, fetchFirstPage, '/partner_account_linking');
    }
  }, {
    key: 'createPartnerPremiumOptIOn',
    value: function createPartnerPremiumOptIOn(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/partner_premium_options', fields, params, null, pathOverride);
    }
  }, {
    key: 'getPassbackAttributionMetadataConfigs',
    value: function getPassbackAttributionMetadataConfigs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/passback_attribution_metadata_configs');
    }
  }, {
    key: 'getPendingClientAdAccounts',
    value: function getPendingClientAdAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BusinessAdAccountRequest, fields, params, fetchFirstPage, '/pending_client_ad_accounts');
    }
  }, {
    key: 'getPendingClientApps',
    value: function getPendingClientApps(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BusinessApplicationRequest, fields, params, fetchFirstPage, '/pending_client_apps');
    }
  }, {
    key: 'getPendingClientPages',
    value: function getPendingClientPages(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BusinessPageRequest, fields, params, fetchFirstPage, '/pending_client_pages');
    }
  }, {
    key: 'getPendingOwnedAdAccounts',
    value: function getPendingOwnedAdAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BusinessAdAccountRequest, fields, params, fetchFirstPage, '/pending_owned_ad_accounts');
    }
  }, {
    key: 'getPendingOwnedPages',
    value: function getPendingOwnedPages(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BusinessPageRequest, fields, params, fetchFirstPage, '/pending_owned_pages');
    }
  }, {
    key: 'getPendingSharedOffsiteSignalContainerBusinessObjects',
    value: function getPendingSharedOffsiteSignalContainerBusinessObjects(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(OffsiteSignalContainerBusinessObject, fields, params, fetchFirstPage, '/pending_shared_offsite_signal_container_business_objects');
    }
  }, {
    key: 'getPendingUsers',
    value: function getPendingUsers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BusinessRoleRequest, fields, params, fetchFirstPage, '/pending_users');
    }
  }, {
    key: 'getPicture',
    value: function getPicture(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ProfilePictureSource, fields, params, fetchFirstPage, '/picture');
    }
  }, {
    key: 'createPixelTo',
    value: function createPixelTo(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/pixel_tos', fields, params, null, pathOverride);
    }
  }, {
    key: 'getPreVerifiedNumbers',
    value: function getPreVerifiedNumbers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(WhatsAppBusinessPreVerifiedPhoneNumber, fields, params, fetchFirstPage, '/preverified_numbers');
    }
  }, {
    key: 'getReceivedAudienceSharingRequests',
    value: function getReceivedAudienceSharingRequests(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(BusinessAssetSharingAgreement, fields, params, fetchFirstPage, '/received_audience_sharing_requests');
    }
  }, {
    key: 'getResellerGuidances',
    value: function getResellerGuidances(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ResellerGuidance, fields, params, fetchFirstPage, '/reseller_guidances');
    }
  }, {
    key: 'getSelfCertifiedWhatsAppBusinessSubmissions',
    value: function getSelfCertifiedWhatsAppBusinessSubmissions(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(WhatsAppBusinessPartnerClientVerificationSubmission, fields, params, fetchFirstPage, '/self_certified_whatsapp_business_submissions');
    }
  }, {
    key: 'createSelfCertifyWhatsAppBusiness',
    value: function createSelfCertifyWhatsAppBusiness(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/self_certify_whatsapp_business', fields, params, Business, pathOverride);
    }
  }, {
    key: 'createSetupManagedPartnerAdAccount',
    value: function createSetupManagedPartnerAdAccount(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/setup_managed_partner_adaccounts', fields, params, Business, pathOverride);
    }
  }, {
    key: 'deleteSharePreVerifiedNumbers',
    value: function deleteSharePreVerifiedNumbers() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Business.prototype.__proto__ || Object.getPrototypeOf(Business.prototype), 'deleteEdge', this).call(this, '/share_preverified_numbers', params);
    }
  }, {
    key: 'createSharePreVerifiedNumber',
    value: function createSharePreVerifiedNumber(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/share_preverified_numbers', fields, params, Business, pathOverride);
    }
  }, {
    key: 'createSystemUserAccessToken',
    value: function createSystemUserAccessToken(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/system_user_access_tokens', fields, params, Business, pathOverride);
    }
  }, {
    key: 'getSystemUsers',
    value: function getSystemUsers(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(SystemUser, fields, params, fetchFirstPage, '/system_users');
    }
  }, {
    key: 'createSystemUser',
    value: function createSystemUser(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/system_users', fields, params, SystemUser, pathOverride);
    }
  }, {
    key: 'getThirdPartyMeasurementReportDataset',
    value: function getThirdPartyMeasurementReportDataset(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(ThirdPartyMeasurementReportDataset, fields, params, fetchFirstPage, '/third_party_measurement_report_dataset');
    }
  }, {
    key: 'createVideo',
    value: function createVideo(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/videos', fields, params, AdVideo, pathOverride);
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Business.prototype.__proto__ || Object.getPrototypeOf(Business.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        block_offline_analytics: 'block_offline_analytics',
        collaborative_ads_managed_partner_business_info: 'collaborative_ads_managed_partner_business_info',
        collaborative_ads_managed_partner_eligibility: 'collaborative_ads_managed_partner_eligibility',
        collaborative_ads_partner_premium_options: 'collaborative_ads_partner_premium_options',
        created_by: 'created_by',
        created_time: 'created_time',
        extended_updated_time: 'extended_updated_time',
        id: 'id',
        is_hidden: 'is_hidden',
        link: 'link',
        marketing_messages_onboarding_status: 'marketing_messages_onboarding_status',
        name: 'name',
        payment_account_id: 'payment_account_id',
        primary_page: 'primary_page',
        profile_picture_uri: 'profile_picture_uri',
        timezone_id: 'timezone_id',
        two_factor_type: 'two_factor_type',
        updated_by: 'updated_by',
        updated_time: 'updated_time',
        user_access_expire_time: 'user_access_expire_time',
        verification_status: 'verification_status',
        vertical: 'vertical',
        vertical_id: 'vertical_id',
        whatsapp_business_manager_messaging_limit: 'whatsapp_business_manager_messaging_limit'
      });
    }
  }, {
    key: 'VerificationStatus',
    get: function get() {
      return Object.freeze({
        expired: 'expired',
        failed: 'failed',
        ineligible: 'ineligible',
        not_verified: 'not_verified',
        pending: 'pending',
        pending_need_more_info: 'pending_need_more_info',
        pending_submission: 'pending_submission',
        rejected: 'rejected',
        revoked: 'revoked',
        verified: 'verified'
      });
    }
  }, {
    key: 'WhatsappBusinessManagerMessagingLimit',
    get: function get() {
      return Object.freeze({
        tier_100k: 'TIER_100K',
        tier_10k: 'TIER_10K',
        tier_250: 'TIER_250',
        tier_2k: 'TIER_2K',
        tier_unlimited: 'TIER_UNLIMITED',
        untiered: 'UNTIERED'
      });
    }
  }, {
    key: 'TwoFactorType',
    get: function get() {
      return Object.freeze({
        admin_required: 'admin_required',
        all_required: 'all_required',
        none: 'none'
      });
    }
  }, {
    key: 'Vertical',
    get: function get() {
      return Object.freeze({
        advertising: 'ADVERTISING',
        automotive: 'AUTOMOTIVE',
        consumer_packaged_goods: 'CONSUMER_PACKAGED_GOODS',
        ecommerce: 'ECOMMERCE',
        education: 'EDUCATION',
        energy_and_utilities: 'ENERGY_AND_UTILITIES',
        entertainment_and_media: 'ENTERTAINMENT_AND_MEDIA',
        financial_services: 'FINANCIAL_SERVICES',
        gaming: 'GAMING',
        government_and_politics: 'GOVERNMENT_AND_POLITICS',
        health: 'HEALTH',
        luxury: 'LUXURY',
        marketing: 'MARKETING',
        non_profit: 'NON_PROFIT',
        not_set: 'NOT_SET',
        organizations_and_associations: 'ORGANIZATIONS_AND_ASSOCIATIONS',
        other: 'OTHER',
        professional_services: 'PROFESSIONAL_SERVICES',
        restaurant: 'RESTAURANT',
        retail: 'RETAIL',
        technology: 'TECHNOLOGY',
        telecom: 'TELECOM',
        travel: 'TRAVEL'
      });
    }
  }, {
    key: 'PermittedTasks',
    get: function get() {
      return Object.freeze({
        advertise: 'ADVERTISE',
        analyze: 'ANALYZE',
        cashier_role: 'CASHIER_ROLE',
        create_content: 'CREATE_CONTENT',
        global_structure_management: 'GLOBAL_STRUCTURE_MANAGEMENT',
        manage: 'MANAGE',
        manage_jobs: 'MANAGE_JOBS',
        manage_leads: 'MANAGE_LEADS',
        messaging: 'MESSAGING',
        moderate: 'MODERATE',
        moderate_community: 'MODERATE_COMMUNITY',
        pages_messaging: 'PAGES_MESSAGING',
        pages_messaging_subscriptions: 'PAGES_MESSAGING_SUBSCRIPTIONS',
        profile_plus_advertise: 'PROFILE_PLUS_ADVERTISE',
        profile_plus_analyze: 'PROFILE_PLUS_ANALYZE',
        profile_plus_create_content: 'PROFILE_PLUS_CREATE_CONTENT',
        profile_plus_facebook_access: 'PROFILE_PLUS_FACEBOOK_ACCESS',
        profile_plus_full_control: 'PROFILE_PLUS_FULL_CONTROL',
        profile_plus_global_structure_management: 'PROFILE_PLUS_GLOBAL_STRUCTURE_MANAGEMENT',
        profile_plus_manage: 'PROFILE_PLUS_MANAGE',
        profile_plus_manage_leads: 'PROFILE_PLUS_MANAGE_LEADS',
        profile_plus_messaging: 'PROFILE_PLUS_MESSAGING',
        profile_plus_moderate: 'PROFILE_PLUS_MODERATE',
        profile_plus_moderate_delegate_community: 'PROFILE_PLUS_MODERATE_DELEGATE_COMMUNITY',
        profile_plus_revenue: 'PROFILE_PLUS_REVENUE',
        read_page_mailboxes: 'READ_PAGE_MAILBOXES',
        view_monetization_insights: 'VIEW_MONETIZATION_INSIGHTS'
      });
    }
  }, {
    key: 'SurveyBusinessType',
    get: function get() {
      return Object.freeze({
        advertiser: 'ADVERTISER',
        agency: 'AGENCY',
        app_developer: 'APP_DEVELOPER',
        publisher: 'PUBLISHER'
      });
    }
  }, {
    key: 'TimezoneId',
    get: function get() {
      return Object.freeze({
        value_0: '0',
        value_1: '1',
        value_2: '2',
        value_3: '3',
        value_4: '4',
        value_5: '5',
        value_6: '6',
        value_7: '7',
        value_8: '8',
        value_9: '9',
        value_10: '10',
        value_11: '11',
        value_12: '12',
        value_13: '13',
        value_14: '14',
        value_15: '15',
        value_16: '16',
        value_17: '17',
        value_18: '18',
        value_19: '19',
        value_20: '20',
        value_21: '21',
        value_22: '22',
        value_23: '23',
        value_24: '24',
        value_25: '25',
        value_26: '26',
        value_27: '27',
        value_28: '28',
        value_29: '29',
        value_30: '30',
        value_31: '31',
        value_32: '32',
        value_33: '33',
        value_34: '34',
        value_35: '35',
        value_36: '36',
        value_37: '37',
        value_38: '38',
        value_39: '39',
        value_40: '40',
        value_41: '41',
        value_42: '42',
        value_43: '43',
        value_44: '44',
        value_45: '45',
        value_46: '46',
        value_47: '47',
        value_48: '48',
        value_49: '49',
        value_50: '50',
        value_51: '51',
        value_52: '52',
        value_53: '53',
        value_54: '54',
        value_55: '55',
        value_56: '56',
        value_57: '57',
        value_58: '58',
        value_59: '59',
        value_60: '60',
        value_61: '61',
        value_62: '62',
        value_63: '63',
        value_64: '64',
        value_65: '65',
        value_66: '66',
        value_67: '67',
        value_68: '68',
        value_69: '69',
        value_70: '70',
        value_71: '71',
        value_72: '72',
        value_73: '73',
        value_74: '74',
        value_75: '75',
        value_76: '76',
        value_77: '77',
        value_78: '78',
        value_79: '79',
        value_80: '80',
        value_81: '81',
        value_82: '82',
        value_83: '83',
        value_84: '84',
        value_85: '85',
        value_86: '86',
        value_87: '87',
        value_88: '88',
        value_89: '89',
        value_90: '90',
        value_91: '91',
        value_92: '92',
        value_93: '93',
        value_94: '94',
        value_95: '95',
        value_96: '96',
        value_97: '97',
        value_98: '98',
        value_99: '99',
        value_100: '100',
        value_101: '101',
        value_102: '102',
        value_103: '103',
        value_104: '104',
        value_105: '105',
        value_106: '106',
        value_107: '107',
        value_108: '108',
        value_109: '109',
        value_110: '110',
        value_111: '111',
        value_112: '112',
        value_113: '113',
        value_114: '114',
        value_115: '115',
        value_116: '116',
        value_117: '117',
        value_118: '118',
        value_119: '119',
        value_120: '120',
        value_121: '121',
        value_122: '122',
        value_123: '123',
        value_124: '124',
        value_125: '125',
        value_126: '126',
        value_127: '127',
        value_128: '128',
        value_129: '129',
        value_130: '130',
        value_131: '131',
        value_132: '132',
        value_133: '133',
        value_134: '134',
        value_135: '135',
        value_136: '136',
        value_137: '137',
        value_138: '138',
        value_139: '139',
        value_140: '140',
        value_141: '141',
        value_142: '142',
        value_143: '143',
        value_144: '144',
        value_145: '145',
        value_146: '146',
        value_147: '147',
        value_148: '148',
        value_149: '149',
        value_150: '150',
        value_151: '151',
        value_152: '152',
        value_153: '153',
        value_154: '154',
        value_155: '155',
        value_156: '156',
        value_157: '157',
        value_158: '158',
        value_159: '159',
        value_160: '160',
        value_161: '161',
        value_162: '162',
        value_163: '163',
        value_164: '164',
        value_165: '165',
        value_166: '166',
        value_167: '167',
        value_168: '168',
        value_169: '169',
        value_170: '170',
        value_171: '171',
        value_172: '172',
        value_173: '173',
        value_174: '174',
        value_175: '175',
        value_176: '176',
        value_177: '177',
        value_178: '178',
        value_179: '179',
        value_180: '180',
        value_181: '181',
        value_182: '182',
        value_183: '183',
        value_184: '184',
        value_185: '185',
        value_186: '186',
        value_187: '187',
        value_188: '188',
        value_189: '189',
        value_190: '190',
        value_191: '191',
        value_192: '192',
        value_193: '193',
        value_194: '194',
        value_195: '195',
        value_196: '196',
        value_197: '197',
        value_198: '198',
        value_199: '199',
        value_200: '200',
        value_201: '201',
        value_202: '202',
        value_203: '203',
        value_204: '204',
        value_205: '205',
        value_206: '206',
        value_207: '207',
        value_208: '208',
        value_209: '209',
        value_210: '210',
        value_211: '211',
        value_212: '212',
        value_213: '213',
        value_214: '214',
        value_215: '215',
        value_216: '216',
        value_217: '217',
        value_218: '218',
        value_219: '219',
        value_220: '220',
        value_221: '221',
        value_222: '222',
        value_223: '223',
        value_224: '224',
        value_225: '225',
        value_226: '226',
        value_227: '227',
        value_228: '228',
        value_229: '229',
        value_230: '230',
        value_231: '231',
        value_232: '232',
        value_233: '233',
        value_234: '234',
        value_235: '235',
        value_236: '236',
        value_237: '237',
        value_238: '238',
        value_239: '239',
        value_240: '240',
        value_241: '241',
        value_242: '242',
        value_243: '243',
        value_244: '244',
        value_245: '245',
        value_246: '246',
        value_247: '247',
        value_248: '248',
        value_249: '249',
        value_250: '250',
        value_251: '251',
        value_252: '252',
        value_253: '253',
        value_254: '254',
        value_255: '255',
        value_256: '256',
        value_257: '257',
        value_258: '258',
        value_259: '259',
        value_260: '260',
        value_261: '261',
        value_262: '262',
        value_263: '263',
        value_264: '264',
        value_265: '265',
        value_266: '266',
        value_267: '267',
        value_268: '268',
        value_269: '269',
        value_270: '270',
        value_271: '271',
        value_272: '272',
        value_273: '273',
        value_274: '274',
        value_275: '275',
        value_276: '276',
        value_277: '277',
        value_278: '278',
        value_279: '279',
        value_280: '280',
        value_281: '281',
        value_282: '282',
        value_283: '283',
        value_284: '284',
        value_285: '285',
        value_286: '286',
        value_287: '287',
        value_288: '288',
        value_289: '289',
        value_290: '290',
        value_291: '291',
        value_292: '292',
        value_293: '293',
        value_294: '294',
        value_295: '295',
        value_296: '296',
        value_297: '297',
        value_298: '298',
        value_299: '299',
        value_300: '300',
        value_301: '301',
        value_302: '302',
        value_303: '303',
        value_304: '304',
        value_305: '305',
        value_306: '306',
        value_307: '307',
        value_308: '308',
        value_309: '309',
        value_310: '310',
        value_311: '311',
        value_312: '312',
        value_313: '313',
        value_314: '314',
        value_315: '315',
        value_316: '316',
        value_317: '317',
        value_318: '318',
        value_319: '319',
        value_320: '320',
        value_321: '321',
        value_322: '322',
        value_323: '323',
        value_324: '324',
        value_325: '325',
        value_326: '326',
        value_327: '327',
        value_328: '328',
        value_329: '329',
        value_330: '330',
        value_331: '331',
        value_332: '332',
        value_333: '333',
        value_334: '334',
        value_335: '335',
        value_336: '336',
        value_337: '337',
        value_338: '338',
        value_339: '339',
        value_340: '340',
        value_341: '341',
        value_342: '342',
        value_343: '343',
        value_344: '344',
        value_345: '345',
        value_346: '346',
        value_347: '347',
        value_348: '348',
        value_349: '349',
        value_350: '350',
        value_351: '351',
        value_352: '352',
        value_353: '353',
        value_354: '354',
        value_355: '355',
        value_356: '356',
        value_357: '357',
        value_358: '358',
        value_359: '359',
        value_360: '360',
        value_361: '361',
        value_362: '362',
        value_363: '363',
        value_364: '364',
        value_365: '365',
        value_366: '366',
        value_367: '367',
        value_368: '368',
        value_369: '369',
        value_370: '370',
        value_371: '371',
        value_372: '372',
        value_373: '373',
        value_374: '374',
        value_375: '375',
        value_376: '376',
        value_377: '377',
        value_378: '378',
        value_379: '379',
        value_380: '380',
        value_381: '381',
        value_382: '382',
        value_383: '383',
        value_384: '384',
        value_385: '385',
        value_386: '386',
        value_387: '387',
        value_388: '388',
        value_389: '389',
        value_390: '390',
        value_391: '391',
        value_392: '392',
        value_393: '393',
        value_394: '394',
        value_395: '395',
        value_396: '396',
        value_397: '397',
        value_398: '398',
        value_399: '399',
        value_400: '400',
        value_401: '401',
        value_402: '402',
        value_403: '403',
        value_404: '404',
        value_405: '405',
        value_406: '406',
        value_407: '407',
        value_408: '408',
        value_409: '409',
        value_410: '410',
        value_411: '411',
        value_412: '412',
        value_413: '413',
        value_414: '414',
        value_415: '415',
        value_416: '416',
        value_417: '417',
        value_418: '418',
        value_419: '419',
        value_420: '420',
        value_421: '421',
        value_422: '422',
        value_423: '423',
        value_424: '424',
        value_425: '425',
        value_426: '426',
        value_427: '427',
        value_428: '428',
        value_429: '429',
        value_430: '430',
        value_431: '431',
        value_432: '432',
        value_433: '433',
        value_434: '434',
        value_435: '435',
        value_436: '436',
        value_437: '437',
        value_438: '438',
        value_439: '439',
        value_440: '440',
        value_441: '441',
        value_442: '442',
        value_443: '443',
        value_444: '444',
        value_445: '445',
        value_446: '446',
        value_447: '447',
        value_448: '448',
        value_449: '449',
        value_450: '450',
        value_451: '451',
        value_452: '452',
        value_453: '453',
        value_454: '454',
        value_455: '455',
        value_456: '456',
        value_457: '457',
        value_458: '458',
        value_459: '459',
        value_460: '460',
        value_461: '461',
        value_462: '462',
        value_463: '463',
        value_464: '464',
        value_465: '465',
        value_466: '466',
        value_467: '467',
        value_468: '468',
        value_469: '469',
        value_470: '470',
        value_471: '471',
        value_472: '472',
        value_473: '473',
        value_474: '474',
        value_475: '475',
        value_476: '476',
        value_477: '477',
        value_478: '478',
        value_479: '479',
        value_480: '480'
      });
    }
  }, {
    key: 'PagePermittedTasks',
    get: function get() {
      return Object.freeze({
        advertise: 'ADVERTISE',
        analyze: 'ANALYZE',
        cashier_role: 'CASHIER_ROLE',
        create_content: 'CREATE_CONTENT',
        global_structure_management: 'GLOBAL_STRUCTURE_MANAGEMENT',
        manage: 'MANAGE',
        manage_jobs: 'MANAGE_JOBS',
        manage_leads: 'MANAGE_LEADS',
        messaging: 'MESSAGING',
        moderate: 'MODERATE',
        moderate_community: 'MODERATE_COMMUNITY',
        pages_messaging: 'PAGES_MESSAGING',
        pages_messaging_subscriptions: 'PAGES_MESSAGING_SUBSCRIPTIONS',
        profile_plus_advertise: 'PROFILE_PLUS_ADVERTISE',
        profile_plus_analyze: 'PROFILE_PLUS_ANALYZE',
        profile_plus_create_content: 'PROFILE_PLUS_CREATE_CONTENT',
        profile_plus_facebook_access: 'PROFILE_PLUS_FACEBOOK_ACCESS',
        profile_plus_full_control: 'PROFILE_PLUS_FULL_CONTROL',
        profile_plus_global_structure_management: 'PROFILE_PLUS_GLOBAL_STRUCTURE_MANAGEMENT',
        profile_plus_manage: 'PROFILE_PLUS_MANAGE',
        profile_plus_manage_leads: 'PROFILE_PLUS_MANAGE_LEADS',
        profile_plus_messaging: 'PROFILE_PLUS_MESSAGING',
        profile_plus_moderate: 'PROFILE_PLUS_MODERATE',
        profile_plus_moderate_delegate_community: 'PROFILE_PLUS_MODERATE_DELEGATE_COMMUNITY',
        profile_plus_revenue: 'PROFILE_PLUS_REVENUE',
        read_page_mailboxes: 'READ_PAGE_MAILBOXES',
        view_monetization_insights: 'VIEW_MONETIZATION_INSIGHTS'
      });
    }
  }, {
    key: 'BusinessVertical',
    get: function get() {
      return Object.freeze({
        adult_products_and_services: 'ADULT_PRODUCTS_AND_SERVICES',
        alcohol_and_tobacco: 'ALCOHOL_AND_TOBACCO',
        automotive_dealers: 'AUTOMOTIVE_DEALERS',
        body_parts_fluids: 'BODY_PARTS_FLUIDS',
        business_and_utility: 'BUSINESS_AND_UTILITY',
        content_and_apps: 'CONTENT_AND_APPS',
        creators_and_celebrities: 'CREATORS_AND_CELEBRITIES',
        dating: 'DATING',
        drugs: 'DRUGS',
        endangered_species: 'ENDANGERED_SPECIES',
        firearms: 'FIREARMS',
        fraudulent_misleading_offensive: 'FRAUDULENT_MISLEADING_OFFENSIVE',
        gambling: 'GAMBLING',
        grocery_and_convenience_store: 'GROCERY_AND_CONVENIENCE_STORE',
        hazardous_goods_and_materials: 'HAZARDOUS_GOODS_AND_MATERIALS',
        home: 'HOME',
        home_and_auto_manufacturing: 'HOME_AND_AUTO_MANUFACTURING',
        lifestyle: 'LIFESTYLE',
        live_non_endangered_species: 'LIVE_NON_ENDANGERED_SPECIES',
        loans_debt_collection_bail_bonds: 'LOANS_DEBT_COLLECTION_BAIL_BONDS',
        local_events: 'LOCAL_EVENTS',
        medical_healthcare: 'MEDICAL_HEALTHCARE',
        multilevel_marketing: 'MULTILEVEL_MARKETING',
        non_profit_and_religious_orgs: 'NON_PROFIT_AND_RELIGIOUS_ORGS',
        professional: 'PROFESSIONAL',
        real_virtual_fake_currency: 'REAL_VIRTUAL_FAKE_CURRENCY',
        restaurants: 'RESTAURANTS',
        retail: 'RETAIL',
        transportation_and_accommodation: 'TRANSPORTATION_AND_ACCOMMODATION'
      });
    }
  }, {
    key: 'SubverticalV2',
    get: function get() {
      return Object.freeze({
        accounting_and_tax: 'ACCOUNTING_AND_TAX',
        activities_and_leisure: 'ACTIVITIES_AND_LEISURE',
        air: 'AIR',
        apparel_and_accessories: 'APPAREL_AND_ACCESSORIES',
        arts_and_heritage_and_education: 'ARTS_AND_HERITAGE_AND_EDUCATION',
        ar_or_vr_gaming: 'AR_OR_VR_GAMING',
        audio_streaming: 'AUDIO_STREAMING',
        auto: 'AUTO',
        auto_insurance: 'AUTO_INSURANCE',
        auto_rental: 'AUTO_RENTAL',
        baby: 'BABY',
        ballot_initiative_or_referendum: 'BALLOT_INITIATIVE_OR_REFERENDUM',
        beauty: 'BEAUTY',
        beauty_and_fashion: 'BEAUTY_AND_FASHION',
        beer_and_wine_and_liquor_and_malt_beverages: 'BEER_AND_WINE_AND_LIQUOR_AND_MALT_BEVERAGES',
        bookstores: 'BOOKSTORES',
        broadcast_television: 'BROADCAST_TELEVISION',
        business_consultants: 'BUSINESS_CONSULTANTS',
        buying_agency: 'BUYING_AGENCY',
        cable_and_satellite: 'CABLE_AND_SATELLITE',
        cable_television: 'CABLE_TELEVISION',
        call_center_and_messaging_services: 'CALL_CENTER_AND_MESSAGING_SERVICES',
        candidate_or_politician: 'CANDIDATE_OR_POLITICIAN',
        career: 'CAREER',
        career_and_tech: 'CAREER_AND_TECH',
        casual_dining: 'CASUAL_DINING',
        chronic_conditions_and_medical_causes: 'CHRONIC_CONDITIONS_AND_MEDICAL_CAUSES',
        civic_influencers: 'CIVIC_INFLUENCERS',
        clinical_trials: 'CLINICAL_TRIALS',
        coffee: 'COFFEE',
        computer_and_software_and_hardware: 'COMPUTER_AND_SOFTWARE_AND_HARDWARE',
        console_and_cross_platform_gaming: 'CONSOLE_AND_CROSS_PLATFORM_GAMING',
        consulting: 'CONSULTING',
        consumer_electronics: 'CONSUMER_ELECTRONICS',
        counseling_and_psychotherapy: 'COUNSELING_AND_PSYCHOTHERAPY',
        creative_agency: 'CREATIVE_AGENCY',
        credit_and_financing_and_mortages: 'CREDIT_AND_FINANCING_AND_MORTAGES',
        cruises_and_marine: 'CRUISES_AND_MARINE',
        culture_and_lifestyle: 'CULTURE_AND_LIFESTYLE',
        data_analytics_and_data_management: 'DATA_ANALYTICS_AND_DATA_MANAGEMENT',
        dating_and_technology_apps: 'DATING_AND_TECHNOLOGY_APPS',
        department_store: 'DEPARTMENT_STORE',
        desktop_software: 'DESKTOP_SOFTWARE',
        dieting_and_fitness_programs: 'DIETING_AND_FITNESS_PROGRAMS',
        digital_native_education_or_training: 'DIGITAL_NATIVE_EDUCATION_OR_TRAINING',
        drinking_places: 'DRINKING_PLACES',
        education_resources: 'EDUCATION_RESOURCES',
        ed_tech: 'ED_TECH',
        elearning_and_massive_online_open_courses: 'ELEARNING_AND_MASSIVE_ONLINE_OPEN_COURSES',
        election_commission: 'ELECTION_COMMISSION',
        electronics_and_appliances: 'ELECTRONICS_AND_APPLIANCES',
        engineering_and_design: 'ENGINEERING_AND_DESIGN',
        environment_and_animal_welfare: 'ENVIRONMENT_AND_ANIMAL_WELFARE',
        esports: 'ESPORTS',
        events: 'EVENTS',
        farming_and_ranching: 'FARMING_AND_RANCHING',
        file_storage_and_cloud_and_data_services: 'FILE_STORAGE_AND_CLOUD_AND_DATA_SERVICES',
        finance: 'FINANCE',
        fin_tech: 'FIN_TECH',
        fishing_and_hunting_and_forestry_and_logging: 'FISHING_AND_HUNTING_AND_FORESTRY_AND_LOGGING',
        fitness: 'FITNESS',
        food: 'FOOD',
        footwear: 'FOOTWEAR',
        for_profit_colleges_and_universities: 'FOR_PROFIT_COLLEGES_AND_UNIVERSITIES',
        full_service_agency: 'FULL_SERVICE_AGENCY',
        government_controlled_entity: 'GOVERNMENT_CONTROLLED_ENTITY',
        government_department_or_agency: 'GOVERNMENT_DEPARTMENT_OR_AGENCY',
        government_official: 'GOVERNMENT_OFFICIAL',
        government_owned_media: 'GOVERNMENT_OWNED_MEDIA',
        grocery_and_drug_and_convenience: 'GROCERY_AND_DRUG_AND_CONVENIENCE',
        head_of_state: 'HEAD_OF_STATE',
        health_insurance: 'HEALTH_INSURANCE',
        health_systems_and_practitioners: 'HEALTH_SYSTEMS_AND_PRACTITIONERS',
        health_tech: 'HEALTH_TECH',
        home_and_furniture_and_office: 'HOME_AND_FURNITURE_AND_OFFICE',
        home_improvement: 'HOME_IMPROVEMENT',
        home_insurance: 'HOME_INSURANCE',
        home_tech: 'HOME_TECH',
        hotel_and_accomodation: 'HOTEL_AND_ACCOMODATION',
        household_goods_durable: 'HOUSEHOLD_GOODS_DURABLE',
        household_goods_non_durable: 'HOUSEHOLD_GOODS_NON_DURABLE',
        hr_and_financial_management: 'HR_AND_FINANCIAL_MANAGEMENT',
        humanitarian_or_disaster_relief: 'HUMANITARIAN_OR_DISASTER_RELIEF',
        independent_expenditure_group: 'INDEPENDENT_EXPENDITURE_GROUP',
        insurance_tech: 'INSURANCE_TECH',
        international_organizaton: 'INTERNATIONAL_ORGANIZATON',
        investment_bank_and_brokerage: 'INVESTMENT_BANK_AND_BROKERAGE',
        issue_advocacy: 'ISSUE_ADVOCACY',
        legal: 'LEGAL',
        life_insurance: 'LIFE_INSURANCE',
        logistics_and_transportation_and_fleet_management: 'LOGISTICS_AND_TRANSPORTATION_AND_FLEET_MANAGEMENT',
        manufacturing: 'MANUFACTURING',
        medical_devices_and_supplies_and_equipment: 'MEDICAL_DEVICES_AND_SUPPLIES_AND_EQUIPMENT',
        medspa_and_elective_surgeries_and_alternative_medicine: 'MEDSPA_AND_ELECTIVE_SURGERIES_AND_ALTERNATIVE_MEDICINE',
        mining_and_quarrying: 'MINING_AND_QUARRYING',
        mobile_gaming: 'MOBILE_GAMING',
        movies: 'MOVIES',
        museums_and_parks_and_libraries: 'MUSEUMS_AND_PARKS_AND_LIBRARIES',
        music: 'MUSIC',
        network_security_products: 'NETWORK_SECURITY_PRODUCTS',
        news_and_current_events: 'NEWS_AND_CURRENT_EVENTS',
        non_prescription: 'NON_PRESCRIPTION',
        not_for_profit_colleges_and_universities: 'NOT_FOR_PROFIT_COLLEGES_AND_UNIVERSITIES',
        office: 'OFFICE',
        office_or_business_supplies: 'OFFICE_OR_BUSINESS_SUPPLIES',
        oil_and_gas_and_consumable_fuel: 'OIL_AND_GAS_AND_CONSUMABLE_FUEL',
        online_only_publications: 'ONLINE_ONLY_PUBLICATIONS',
        package_or_freight_delivery: 'PACKAGE_OR_FREIGHT_DELIVERY',
        party_independent_expenditure_group_us: 'PARTY_INDEPENDENT_EXPENDITURE_GROUP_US',
        payment_processing_and_gateway_solutions: 'PAYMENT_PROCESSING_AND_GATEWAY_SOLUTIONS',
        pc_gaming: 'PC_GAMING',
        people: 'PEOPLE',
        personal_care: 'PERSONAL_CARE',
        pet: 'PET',
        photography_and_filming_services: 'PHOTOGRAPHY_AND_FILMING_SERVICES',
        pizza: 'PIZZA',
        planning_agency: 'PLANNING_AGENCY',
        political_party_or_committee: 'POLITICAL_PARTY_OR_COMMITTEE',
        prescription: 'PRESCRIPTION',
        professional_associations: 'PROFESSIONAL_ASSOCIATIONS',
        property_and_casualty: 'PROPERTY_AND_CASUALTY',
        quick_service: 'QUICK_SERVICE',
        radio: 'RADIO',
        railroads: 'RAILROADS',
        real_estate: 'REAL_ESTATE',
        real_money_gaming: 'REAL_MONEY_GAMING',
        recreational: 'RECREATIONAL',
        religious: 'RELIGIOUS',
        reseller: 'RESELLER',
        residential_and_long_term_care_facilities_and_outpatient_care_centers: 'RESIDENTIAL_AND_LONG_TERM_CARE_FACILITIES_AND_OUTPATIENT_CARE_CENTERS',
        retail_and_credit_union_and_commercial_bank: 'RETAIL_AND_CREDIT_UNION_AND_COMMERCIAL_BANK',
        ride_sharing_or_taxi_services: 'RIDE_SHARING_OR_TAXI_SERVICES',
        safety_services: 'SAFETY_SERVICES',
        scholarly: 'SCHOLARLY',
        school_and_early_children_edcation: 'SCHOOL_AND_EARLY_CHILDREN_EDCATION',
        social_media: 'SOCIAL_MEDIA',
        software_as_a_service: 'SOFTWARE_AS_A_SERVICE',
        sporting: 'SPORTING',
        sporting_and_outdoor: 'SPORTING_AND_OUTDOOR',
        sports: 'SPORTS',
        superstores: 'SUPERSTORES',
        t1_automotive_manufacturer: 'T1_AUTOMOTIVE_MANUFACTURER',
        t1_motorcycle: 'T1_MOTORCYCLE',
        t2_dealer_associations: 'T2_DEALER_ASSOCIATIONS',
        t3_auto_agency: 'T3_AUTO_AGENCY',
        t3_auto_resellers: 'T3_AUTO_RESELLERS',
        t3_dealer_groups: 'T3_DEALER_GROUPS',
        t3_franchise_dealer: 'T3_FRANCHISE_DEALER',
        t3_independent_dealer: 'T3_INDEPENDENT_DEALER',
        t3_parts_and_services: 'T3_PARTS_AND_SERVICES',
        t3_portals: 'T3_PORTALS',
        telecommunications_equipment_and_accessories: 'TELECOMMUNICATIONS_EQUIPMENT_AND_ACCESSORIES',
        telephone_service_providers_and_carriers: 'TELEPHONE_SERVICE_PROVIDERS_AND_CARRIERS',
        ticketing: 'TICKETING',
        tobacco: 'TOBACCO',
        tourism_and_travel_services: 'TOURISM_AND_TRAVEL_SERVICES',
        tourism_board: 'TOURISM_BOARD',
        toy_and_hobby: 'TOY_AND_HOBBY',
        trade_school: 'TRADE_SCHOOL',
        travel_agencies_and_guides_and_otas: 'TRAVEL_AGENCIES_AND_GUIDES_AND_OTAS',
        utilities_and_energy_equipment_and_services: 'UTILITIES_AND_ENERGY_EQUIPMENT_AND_SERVICES',
        veterinary_clinics_and_services: 'VETERINARY_CLINICS_AND_SERVICES',
        video_streaming: 'VIDEO_STREAMING',
        virtual_services: 'VIRTUAL_SERVICES',
        vitamins_or_wellness: 'VITAMINS_OR_WELLNESS',
        warehousing_and_storage: 'WAREHOUSING_AND_STORAGE',
        water_and_soft_drink_and_baverage: 'WATER_AND_SOFT_DRINK_AND_BAVERAGE',
        website_designers_or_graphic_designers: 'WEBSITE_DESIGNERS_OR_GRAPHIC_DESIGNERS',
        wholesale: 'WHOLESALE',
        wireless_services: 'WIRELESS_SERVICES'
      });
    }
  }, {
    key: 'VerticalV2',
    get: function get() {
      return Object.freeze({
        advertising_and_marketing: 'ADVERTISING_AND_MARKETING',
        agriculture: 'AGRICULTURE',
        automotive: 'AUTOMOTIVE',
        banking_and_credit_cards: 'BANKING_AND_CREDIT_CARDS',
        business_to_business: 'BUSINESS_TO_BUSINESS',
        consumer_packaged_goods: 'CONSUMER_PACKAGED_GOODS',
        ecommerce: 'ECOMMERCE',
        education: 'EDUCATION',
        energy_and_natural_resources_and_utilities: 'ENERGY_AND_NATURAL_RESOURCES_AND_UTILITIES',
        entertainment_and_media: 'ENTERTAINMENT_AND_MEDIA',
        gaming: 'GAMING',
        government: 'GOVERNMENT',
        healthcare_and_pharmaceuticals_and_biotech: 'HEALTHCARE_AND_PHARMACEUTICALS_AND_BIOTECH',
        insurance: 'INSURANCE',
        non_profit: 'NON_PROFIT',
        organizations_and_associations: 'ORGANIZATIONS_AND_ASSOCIATIONS',
        politics: 'POLITICS',
        professional_services: 'PROFESSIONAL_SERVICES',
        publishing: 'PUBLISHING',
        restaurants: 'RESTAURANTS',
        retail: 'RETAIL',
        technology: 'TECHNOLOGY',
        telecom: 'TELECOM',
        travel: 'TRAVEL'
      });
    }
  }, {
    key: 'ActionSource',
    get: function get() {
      return Object.freeze({
        physical_store: 'PHYSICAL_STORE',
        website: 'WEBSITE'
      });
    }
  }]);
  return Business;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * DACheck
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var DACheck = function (_AbstractCrudObject) {
  inherits(DACheck, _AbstractCrudObject);

  function DACheck() {
    classCallCheck(this, DACheck);
    return possibleConstructorReturn(this, (DACheck.__proto__ || Object.getPrototypeOf(DACheck)).apply(this, arguments));
  }

  createClass(DACheck, null, [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        action_uri: 'action_uri',
        description: 'description',
        key: 'key',
        result: 'result',
        title: 'title',
        user_message: 'user_message'
      });
    }
  }, {
    key: 'ConnectionMethod',
    get: function get() {
      return Object.freeze({
        all: 'ALL',
        app: 'APP',
        browser: 'BROWSER',
        server: 'SERVER'
      });
    }
  }]);
  return DACheck;
}(AbstractCrudObject);

/*
* Copyright (c) Meta Platforms, Inc. and affiliates.
* All rights reserved.
*
* This source code is licensed under the license found in the
* LICENSE file in the root directory of this source tree.
*
* 
*/

/**
 * Application
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */

var Application = function (_AbstractCrudObject) {
  inherits(Application, _AbstractCrudObject);

  function Application() {
    classCallCheck(this, Application);
    return possibleConstructorReturn(this, (Application.__proto__ || Object.getPrototypeOf(Application)).apply(this, arguments));
  }

  createClass(Application, [{
    key: 'deleteAccounts',
    value: function deleteAccounts() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Application.prototype.__proto__ || Object.getPrototypeOf(Application.prototype), 'deleteEdge', this).call(this, '/accounts', params);
    }
  }, {
    key: 'getAccounts',
    value: function getAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/accounts');
    }
  }, {
    key: 'createAccount',
    value: function createAccount(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/accounts', fields, params, null, pathOverride);
    }
  }, {
    key: 'createActivity',
    value: function createActivity(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/activities', fields, params, null, pathOverride);
    }
  }, {
    key: 'getAdPlacementGroups',
    value: function getAdPlacementGroups(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/ad_placement_groups');
    }
  }, {
    key: 'getAdNetworkPlacements',
    value: function getAdNetworkPlacements(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdPlacement, fields, params, fetchFirstPage, '/adnetwork_placements');
    }
  }, {
    key: 'getAdNetworkAnalytics',
    value: function getAdNetworkAnalytics(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdNetworkAnalyticsSyncQueryResult, fields, params, fetchFirstPage, '/adnetworkanalytics');
    }
  }, {
    key: 'createAdNetworkAnalytic',
    value: function createAdNetworkAnalytic(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/adnetworkanalytics', fields, params, Application, pathOverride);
    }
  }, {
    key: 'getAdNetworkAnalyticsResults',
    value: function getAdNetworkAnalyticsResults(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdNetworkAnalyticsAsyncQueryResult, fields, params, fetchFirstPage, '/adnetworkanalytics_results');
    }
  }, {
    key: 'getAemAttribution',
    value: function getAemAttribution(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/aem_attribution');
    }
  }, {
    key: 'getAemConversionConfigs',
    value: function getAemConversionConfigs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/aem_conversion_configs');
    }
  }, {
    key: 'getAemConversionFilter',
    value: function getAemConversionFilter(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/aem_conversion_filter');
    }
  }, {
    key: 'createAemConversion',
    value: function createAemConversion(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/aem_conversions', fields, params, null, pathOverride);
    }
  }, {
    key: 'createAemSkanReadiness',
    value: function createAemSkanReadiness(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/aem_skan_readiness', fields, params, null, pathOverride);
    }
  }, {
    key: 'getAgencies',
    value: function getAgencies(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Business, fields, params, fetchFirstPage, '/agencies');
    }
  }, {
    key: 'createAggregateRevenue',
    value: function createAggregateRevenue(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/aggregate_revenue', fields, params, null, pathOverride);
    }
  }, {
    key: 'getAndroidDialogConfigs',
    value: function getAndroidDialogConfigs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/android_dialog_configs');
    }
  }, {
    key: 'getAppCapiSettings',
    value: function getAppCapiSettings(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/app_capi_settings');
    }
  }, {
    key: 'getAppEventTypes',
    value: function getAppEventTypes(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/app_event_types');
    }
  }, {
    key: 'createAppIndexing',
    value: function createAppIndexing(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/app_indexing', fields, params, Application, pathOverride);
    }
  }, {
    key: 'createAppIndexingSession',
    value: function createAppIndexingSession(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/app_indexing_session', fields, params, Application, pathOverride);
    }
  }, {
    key: 'getAppInstalledGroups',
    value: function getAppInstalledGroups(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Group, fields, params, fetchFirstPage, '/app_installed_groups');
    }
  }, {
    key: 'createAppPushDeviceToken',
    value: function createAppPushDeviceToken(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/app_push_device_token', fields, params, Application, pathOverride);
    }
  }, {
    key: 'getAppAssets',
    value: function getAppAssets(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/appassets');
    }
  }, {
    key: 'createAsset',
    value: function createAsset(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/assets', fields, params, Application, pathOverride);
    }
  }, {
    key: 'getAuthorizedAdAccounts',
    value: function getAuthorizedAdAccounts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdAccount, fields, params, fetchFirstPage, '/authorized_adaccounts');
    }
  }, {
    key: 'getButtonAutoDetectionDeviceSelection',
    value: function getButtonAutoDetectionDeviceSelection(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/button_auto_detection_device_selection');
    }
  }, {
    key: 'getCloudbridgeSettings',
    value: function getCloudbridgeSettings(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/cloudbridge_settings');
    }
  }, {
    key: 'createCodelessEventMapping',
    value: function createCodelessEventMapping(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/codeless_event_mappings', fields, params, Application, pathOverride);
    }
  }, {
    key: 'getConnectedClientBusinesses',
    value: function getConnectedClientBusinesses(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(Business, fields, params, fetchFirstPage, '/connected_client_businesses');
    }
  }, {
    key: 'getDaChecks',
    value: function getDaChecks(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(DACheck, fields, params, fetchFirstPage, '/da_checks');
    }
  }, {
    key: 'createDomainReport',
    value: function createDomainReport(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/domain_reports', fields, params, null, pathOverride);
    }
  }, {
    key: 'getIapPurchases',
    value: function getIapPurchases(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/iap_purchases');
    }
  }, {
    key: 'getIosDialogConfigs',
    value: function getIosDialogConfigs(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/ios_dialog_configs');
    }
  }, {
    key: 'getLinkedDataset',
    value: function getLinkedDataset(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AdsDataset, fields, params, fetchFirstPage, '/linked_dataset');
    }
  }, {
    key: 'createMmpAuditing',
    value: function createMmpAuditing(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/mmp_auditing', fields, params, null, pathOverride);
    }
  }, {
    key: 'getMobileSdkGk',
    value: function getMobileSdkGk(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/mobile_sdk_gk');
    }
  }, {
    key: 'getMonetizedDigitalStoreObjects',
    value: function getMonetizedDigitalStoreObjects(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/monetized_digital_store_objects');
    }
  }, {
    key: 'createMonetizedDigitalStoreObject',
    value: function createMonetizedDigitalStoreObject(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/monetized_digital_store_objects', fields, params, null, pathOverride);
    }
  }, {
    key: 'getObjectTypes',
    value: function getObjectTypes(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(NullNode, fields, params, fetchFirstPage, '/object_types');
    }
  }, {
    key: 'getObjects',
    value: function getObjects(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(NullNode, fields, params, fetchFirstPage, '/objects');
    }
  }, {
    key: 'createOccludesPopup',
    value: function createOccludesPopup(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/occludespopups', fields, params, null, pathOverride);
    }
  }, {
    key: 'getPermissions',
    value: function getPermissions(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/permissions');
    }
  }, {
    key: 'getProducts',
    value: function getProducts(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/products');
    }
  }, {
    key: 'getPurchases',
    value: function getPurchases(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/purchases');
    }
  }, {
    key: 'getRoles',
    value: function getRoles(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/roles');
    }
  }, {
    key: 'getServerDomainInfos',
    value: function getServerDomainInfos(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/server_domain_infos');
    }
  }, {
    key: 'getSgwDatasetStatus',
    value: function getSgwDatasetStatus(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/sgw_dataset_status');
    }
  }, {
    key: 'getSgwInstallDeferralLink',
    value: function getSgwInstallDeferralLink(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/sgw_install_deferral_link');
    }
  }, {
    key: 'getSubscribedDomains',
    value: function getSubscribedDomains(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/subscribed_domains');
    }
  }, {
    key: 'getSubscribedDomainsPhishing',
    value: function getSubscribedDomainsPhishing(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/subscribed_domains_phishing');
    }
  }, {
    key: 'deleteSubscriptions',
    value: function deleteSubscriptions() {
      var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      return get$1(Application.prototype.__proto__ || Object.getPrototypeOf(Application.prototype), 'deleteEdge', this).call(this, '/subscriptions', params);
    }
  }, {
    key: 'getSubscriptions',
    value: function getSubscriptions(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/subscriptions');
    }
  }, {
    key: 'createSubscription',
    value: function createSubscription(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/subscriptions', fields, params, null, pathOverride);
    }
  }, {
    key: 'createUpload',
    value: function createUpload(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/uploads', fields, params, null, pathOverride);
    }
  }, {
    key: 'createWhatsAppBusinessSolution',
    value: function createWhatsAppBusinessSolution(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var pathOverride = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      return this.createEdge('/whatsapp_business_solution', fields, params, Application, pathOverride);
    }
  }, {
    key: 'getWhatsAppBusinessSolutions',
    value: function getWhatsAppBusinessSolutions(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var fetchFirstPage = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      return this.getEdge(AbstractObject, fields, params, fetchFirstPage, '/whatsapp_business_solutions');
    }
  }, {
    key: 'get',
    value: function get(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return this.read(fields, params);
    }

    // $FlowFixMe : Support Generic Types

  }, {
    key: 'update',
    value: function update(fields) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      // $FlowFixMe : Support Generic Types
      return get$1(Application.prototype.__proto__ || Object.getPrototypeOf(Application.prototype), 'update', this).call(this, params);
    }
  }], [{
    key: 'Fields',
    get: function get() {
      return Object.freeze({
        aam_rules: 'aam_rules',
        an_ad_space_limit: 'an_ad_space_limit',
        an_platforms: 'an_platforms',
        android_key_hash: 'android_key_hash',
        android_sdk_error_categories: 'android_sdk_error_categories',
        app_domains: 'app_domains',
        app_events_config: 'app_events_config',
        app_events_feature_bitmask: 'app_events_feature_bitmask',
        app_events_session_timeout: 'app_events_session_timeout',
        app_install_tracked: 'app_install_tracked',
        app_name: 'app_name',
        app_signals_binding_ios: 'app_signals_binding_ios',
        app_type: 'app_type',
        auth_dialog_data_help_url: 'auth_dialog_data_help_url',
        auth_dialog_headline: 'auth_dialog_headline',
        auth_dialog_perms_explanation: 'auth_dialog_perms_explanation',
        auth_referral_default_activity_privacy: 'auth_referral_default_activity_privacy',
        auth_referral_enabled: 'auth_referral_enabled',
        auth_referral_extended_