 /*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @flow
 */

import {AbstractCrudObject} from './../abstract-crud-object';

/**
 * AdAccountAdVolume
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */
export default class AdAccountAdVolume extends AbstractCrudObject {
  static get Fields (): Object {
    return Object.freeze({
      actor_id: 'actor_id',
      actor_name: 'actor_name',
      ad_limit_scope_business: 'ad_limit_scope_business',
      ad_limit_scope_business_manager_id: 'ad_limit_scope_business_manager_id',
      ad_limit_set_by_page_admin: 'ad_limit_set_by_page_admin',
      ads_running_or_in_review_count: 'ads_running_or_in_review_count',
      ads_running_or_in_review_count_subject_to_limit_set_by_page: 'ads_running_or_in_review_count_subject_to_limit_set_by_page',
      current_account_ads_running_or_in_review_count: 'current_account_ads_running_or_in_review_count',
      future_limit_activation_date: 'future_limit_activation_date',
      future_limit_on_ads_running_or_in_review: 'future_limit_on_ads_running_or_in_review',
      limit_on_ads_running_or_in_review: 'limit_on_ads_running_or_in_review',
      recommendations: 'recommendations',
    });
  }

  static get RecommendationType (): Object {
    return Object.freeze({
      aac_creation_package: 'AAC_CREATION_PACKAGE',
      ab_test: 'AB_TEST',
      account_error: 'ACCOUNT_ERROR',
      account_needs_credit: 'ACCOUNT_NEEDS_CREDIT',
      account_spend_limit: 'ACCOUNT_SPEND_LIMIT',
      account_spend_limit_duplication: 'ACCOUNT_SPEND_LIMIT_DUPLICATION',
      aco_toggle: 'ACO_TOGGLE',
      adset_budget_sharing: 'ADSET_BUDGET_SHARING',
      ads_reporting: 'ADS_REPORTING',
      ads_status: 'ADS_STATUS',
      advanced_campaign_budget: 'ADVANCED_CAMPAIGN_BUDGET',
      advantage_app_campaign: 'ADVANTAGE_APP_CAMPAIGN',
      advantage_campaign_budget_duplication: 'ADVANTAGE_CAMPAIGN_BUDGET_DUPLICATION',
      advantage_custom_audience: 'ADVANTAGE_CUSTOM_AUDIENCE',
      advantage_custom_audience_duplication: 'ADVANTAGE_CUSTOM_AUDIENCE_DUPLICATION',
      advantage_custom_audience_upsell: 'ADVANTAGE_CUSTOM_AUDIENCE_UPSELL',
      advantage_detailed_targeting: 'ADVANTAGE_DETAILED_TARGETING',
      advantage_lookalike_audience: 'ADVANTAGE_LOOKALIKE_AUDIENCE',
      advantage_lookalike_duplication: 'ADVANTAGE_LOOKALIKE_DUPLICATION',
      advantage_plus_app_campaign: 'ADVANTAGE_PLUS_APP_CAMPAIGN',
      advantage_plus_app_campaign_precreate: 'ADVANTAGE_PLUS_APP_CAMPAIGN_PRECREATE',
      advantage_plus_audience: 'ADVANTAGE_PLUS_AUDIENCE',
      advantage_plus_audience_duplication: 'ADVANTAGE_PLUS_AUDIENCE_DUPLICATION',
      advantage_plus_audience_friction: 'ADVANTAGE_PLUS_AUDIENCE_FRICTION',
      advantage_plus_audience_toggle: 'ADVANTAGE_PLUS_AUDIENCE_TOGGLE',
      advantage_plus_audience_v2: 'ADVANTAGE_PLUS_AUDIENCE_V2',
      advantage_plus_campaign_budget: 'ADVANTAGE_PLUS_CAMPAIGN_BUDGET',
      advantage_plus_catalog_ads: 'ADVANTAGE_PLUS_CATALOG_ADS',
      advantage_plus_catalog_ads_v2: 'ADVANTAGE_PLUS_CATALOG_ADS_V2',
      advantage_plus_creative: 'ADVANTAGE_PLUS_CREATIVE',
      advantage_plus_creative_catalog: 'ADVANTAGE_PLUS_CREATIVE_CATALOG',
      advantage_plus_creative_se: 'ADVANTAGE_PLUS_CREATIVE_SE',
      advantage_plus_lead_campaign: 'ADVANTAGE_PLUS_LEAD_CAMPAIGN',
      advantage_plus_placements_duplication: 'ADVANTAGE_PLUS_PLACEMENTS_DUPLICATION',
      advantage_plus_placements_friction: 'ADVANTAGE_PLUS_PLACEMENTS_FRICTION',
      advantage_plus_placements_v2_duplication: 'ADVANTAGE_PLUS_PLACEMENTS_V2_DUPLICATION',
      advantage_shopping_campaign: 'ADVANTAGE_SHOPPING_CAMPAIGN',
      advantage_shopping_campaign_fragmentation: 'ADVANTAGE_SHOPPING_CAMPAIGN_FRAGMENTATION',
      ad_account_placement_controls_upsell: 'AD_ACCOUNT_PLACEMENT_CONTROLS_UPSELL',
      ad_lift_recall_goal: 'AD_LIFT_RECALL_GOAL',
      ad_lift_recall_goal_precreate: 'AD_LIFT_RECALL_GOAL_PRECREATE',
      ad_lift_recall_optimization_goal: 'AD_LIFT_RECALL_OPTIMIZATION_GOAL',
      ad_objective: 'AD_OBJECTIVE',
      ad_set_budget_sharing_guidance: 'AD_SET_BUDGET_SHARING_GUIDANCE',
      aem_v2_ineligible: 'AEM_V2_INELIGIBLE',
      aggregated_bid_limited: 'AGGREGATED_BID_LIMITED',
      aggregated_budget_limited: 'AGGREGATED_BUDGET_LIMITED',
      aggregated_cost_limited: 'AGGREGATED_COST_LIMITED',
      ai_generated_icebreakers: 'AI_GENERATED_ICEBREAKERS',
      ama_upsell: 'AMA_UPSELL',
      aplusc_add_overlays: 'APLUSC_ADD_OVERLAYS',
      aplusc_biz_ai_agent: 'APLUSC_BIZ_AI_AGENT',
      aplusc_dynamic_description: 'APLUSC_DYNAMIC_DESCRIPTION',
      aplusc_flexible_media: 'APLUSC_FLEXIBLE_MEDIA',
      aplusc_image_background_generation: 'APLUSC_IMAGE_BACKGROUND_GENERATION',
      aplusc_music: 'APLUSC_MUSIC',
      aplusc_relevant_comments: 'APLUSC_RELEVANT_COMMENTS',
      aplusc_standard_enhancements_bundle: 'APLUSC_STANDARD_ENHANCEMENTS_BUNDLE',
      aplusc_text_improvements: 'APLUSC_TEXT_IMPROVEMENTS',
      aplusc_video_expansion: 'APLUSC_VIDEO_EXPANSION',
      aplusc_visual_touchups: 'APLUSC_VISUAL_TOUCHUPS',
      aplus_c_catalog_duplication: 'APLUS_C_CATALOG_DUPLICATION',
      app_aem_v2_installation_promotion: 'APP_AEM_V2_INSTALLATION_PROMOTION',
      app_engaged_view_conversions_duplication: 'APP_ENGAGED_VIEW_CONVERSIONS_DUPLICATION',
      asc_automation: 'ASC_AUTOMATION',
      asc_budget_optimization: 'ASC_BUDGET_OPTIMIZATION',
      asc_creation_package: 'ASC_CREATION_PACKAGE',
      asc_fragmentation_v2: 'ASC_FRAGMENTATION_V2',
      asc_precreate: 'ASC_PRECREATE',
      aspect_ratio: 'ASPECT_RATIO',
      atleast_6_placements: 'ATLEAST_6_PLACEMENTS',
      auction_overlap: 'AUCTION_OVERLAP',
      auction_overlap_consolidation: 'AUCTION_OVERLAP_CONSOLIDATION',
      audience_expansion: 'AUDIENCE_EXPANSION',
      audience_expansion_georadius: 'AUDIENCE_EXPANSION_GEORADIUS',
      audience_expansion_lookalike: 'AUDIENCE_EXPANSION_LOOKALIKE',
      audience_expansion_retargeting: 'AUDIENCE_EXPANSION_RETARGETING',
      audience_learning_limited: 'AUDIENCE_LEARNING_LIMITED',
      autobid_to_manual_bid: 'AUTOBID_TO_MANUAL_BID',
      autoflow_opt_in: 'AUTOFLOW_OPT_IN',
      autoflow_opt_in_fallback_duplication_flow: 'AUTOFLOW_OPT_IN_FALLBACK_DUPLICATION_FLOW',
      autoflow_opt_in_v2: 'AUTOFLOW_OPT_IN_V2',
      automatic_placements: 'AUTOMATIC_PLACEMENTS',
      automatic_placements_v2: 'AUTOMATIC_PLACEMENTS_V2',
      automatic_placements_v3: 'AUTOMATIC_PLACEMENTS_V3',
      automatic_placements_v4: 'AUTOMATIC_PLACEMENTS_V4',
      auto_bid: 'AUTO_BID',
      auto_cat_selection_enhancement: 'AUTO_CAT_SELECTION_ENHANCEMENT',
      b2p_messaging_upsell: 'B2P_MESSAGING_UPSELL',
      background_generation: 'BACKGROUND_GENERATION',
      bid_limited_sensitive: 'BID_LIMITED_SENSITIVE',
      bid_limited_starving: 'BID_LIMITED_STARVING',
      blended_ads: 'BLENDED_ADS',
      blended_ads_duplication: 'BLENDED_ADS_DUPLICATION',
      blended_ads_for_shops_ads_duplication: 'BLENDED_ADS_FOR_SHOPS_ADS_DUPLICATION',
      bpbaa_with_capi_upsell: 'BPBAA_WITH_CAPI_UPSELL',
      broadgeo_am_upsell_guidance: 'BROADGEO_AM_UPSELL_GUIDANCE',
      broad_targeting: 'BROAD_TARGETING',
      budget_amortization: 'BUDGET_AMORTIZATION',
      budget_limited: 'BUDGET_LIMITED',
      budget_reallocation: 'BUDGET_REALLOCATION',
      budget_seasonal_guidance: 'BUDGET_SEASONAL_GUIDANCE',
      business_ai_agent_upsell: 'BUSINESS_AI_AGENT_UPSELL',
      call_ads_dayparting_l3_recommendation: 'CALL_ADS_DAYPARTING_L3_RECOMMENDATION',
      campaign_consolidation_with_flex: 'CAMPAIGN_CONSOLIDATION_WITH_FLEX',
      campaign_guidance_navigator_reels_tips: 'CAMPAIGN_GUIDANCE_NAVIGATOR_REELS_TIPS',
      campaign_spend_limit: 'CAMPAIGN_SPEND_LIMIT',
      capi: 'CAPI',
      capi_crm_funnel: 'CAPI_CRM_FUNNEL',
      capi_crm_guidance: 'CAPI_CRM_GUIDANCE',
      capi_crm_guidance_v2: 'CAPI_CRM_GUIDANCE_V2',
      capi_crm_setup: 'CAPI_CRM_SETUP',
      capi_event_coverage: 'CAPI_EVENT_COVERAGE',
      capi_penetration: 'CAPI_PENETRATION',
      capi_performance_match_key: 'CAPI_PERFORMANCE_MATCH_KEY',
      capi_performance_match_key_v2: 'CAPI_PERFORMANCE_MATCH_KEY_V2',
      cash_rewards_opt_in: 'CASH_REWARDS_OPT_IN',
      catalog_dynamic_media: 'CATALOG_DYNAMIC_MEDIA',
      catalog_match_rate: 'CATALOG_MATCH_RATE',
      commerce_shops_ads_duplication: 'COMMERCE_SHOPS_ADS_DUPLICATION',
      connected_sources: 'CONNECTED_SOURCES',
      connected_sources_duplication: 'CONNECTED_SOURCES_DUPLICATION',
      connect_facebook_page_to_instagram: 'CONNECT_FACEBOOK_PAGE_TO_INSTAGRAM',
      connect_facebook_page_to_whatsapp: 'CONNECT_FACEBOOK_PAGE_TO_WHATSAPP',
      conversion_leads_optimization: 'CONVERSION_LEADS_OPTIMIZATION',
      conversion_leads_optimization_duplication: 'CONVERSION_LEADS_OPTIMIZATION_DUPLICATION',
      conversion_leads_optimization_integrated: 'CONVERSION_LEADS_OPTIMIZATION_INTEGRATED',
      conversion_leads_optimization_v2: 'CONVERSION_LEADS_OPTIMIZATION_V2',
      conversion_lead_ads: 'CONVERSION_LEAD_ADS',
      cost_goal: 'COST_GOAL',
      cost_goal_budget_limited: 'COST_GOAL_BUDGET_LIMITED',
      cost_goal_cpa_limited: 'COST_GOAL_CPA_LIMITED',
      cost_per_result: 'COST_PER_RESULT',
      creation_package_upgrade_to_asc: 'CREATION_PACKAGE_UPGRADE_TO_ASC',
      creation_package_upgrade_to_ctx: 'CREATION_PACKAGE_UPGRADE_TO_CTX',
      creation_package_upgrade_to_tla: 'CREATION_PACKAGE_UPGRADE_TO_TLA',
      creation_package_upgrade_to_tmc: 'CREATION_PACKAGE_UPGRADE_TO_TMC',
      creative_badge: 'CREATIVE_BADGE',
      creative_diversity: 'CREATIVE_DIVERSITY',
      creative_fatigue: 'CREATIVE_FATIGUE',
      creative_fatigue_duplication: 'CREATIVE_FATIGUE_DUPLICATION',
      creative_fatigue_hourly: 'CREATIVE_FATIGUE_HOURLY',
      creative_limited: 'CREATIVE_LIMITED',
      creative_limited_duplication: 'CREATIVE_LIMITED_DUPLICATION',
      creative_limited_hourly: 'CREATIVE_LIMITED_HOURLY',
      creator_ads_pa_conversion: 'CREATOR_ADS_PA_CONVERSION',
      cta: 'CTA',
      ctd_leads_optimization: 'CTD_LEADS_OPTIMIZATION',
      ctd_purchase_optimization: 'CTD_PURCHASE_OPTIMIZATION',
      ctm_ad_objective_growth: 'CTM_AD_OBJECTIVE_GROWTH',
      ctm_leads_optimization_upsell: 'CTM_LEADS_OPTIMIZATION_UPSELL',
      ctm_lo_odax_phase_2: 'CTM_LO_ODAX_PHASE_2',
      ctm_po_odax_phase_2: 'CTM_PO_ODAX_PHASE_2',
      ctm_vo_odax_phase_2: 'CTM_VO_ODAX_PHASE_2',
      ctx_budget_optimization: 'CTX_BUDGET_OPTIMIZATION',
      ctx_creation_package: 'CTX_CREATION_PACKAGE',
      ctx_creation_package_v2: 'CTX_CREATION_PACKAGE_V2',
      ctx_creative_low_outcome_warning: 'CTX_CREATIVE_LOW_OUTCOME_WARNING',
      ctx_cta_upgrade_in_duplication: 'CTX_CTA_UPGRADE_IN_DUPLICATION',
      ctx_ctmpo_upgrade: 'CTX_CTMPO_UPGRADE',
      ctx_ctwalo_upgrade: 'CTX_CTWALO_UPGRADE',
      ctx_ctwapo_upgrade: 'CTX_CTWAPO_UPGRADE',
      ctx_guidance: 'CTX_GUIDANCE',
      ctx_hvs: 'CTX_HVS',
      ctx_hvs_v2: 'CTX_HVS_V2',
      ctx_multi_message_destination: 'CTX_MULTI_MESSAGE_DESTINATION',
      ctx_precreate: 'CTX_PRECREATE',
      ctx_product_extension_duplication: 'CTX_PRODUCT_EXTENSION_DUPLICATION',
      ctx_sabr_cbo: 'CTX_SABR_CBO',
      ctx_sabr_non_cbo: 'CTX_SABR_NON_CBO',
      ctx_smart_defaulting: 'CTX_SMART_DEFAULTING',
      ctx_value_optimization_ctm_po_to_vo: 'CTX_VALUE_OPTIMIZATION_CTM_PO_TO_VO',
      ctx_zo_cbo: 'CTX_ZO_CBO',
      ctx_zo_non_cbo: 'CTX_ZO_NON_CBO',
      custom_audience_relaxation: 'CUSTOM_AUDIENCE_RELAXATION',
      da_advantage_plus_creative_info_labels: 'DA_ADVANTAGE_PLUS_CREATIVE_INFO_LABELS',
      da_duplication_product_tags: 'DA_DUPLICATION_PRODUCT_TAGS',
      dead_link: 'DEAD_LINK',
      defragmentation_acb: 'DEFRAGMENTATION_ACB',
      defragmentation_acb_duplication: 'DEFRAGMENTATION_ACB_DUPLICATION',
      defragmentation_using_value_rules_test_v2: 'DEFRAGMENTATION_USING_VALUE_RULES_TEST_V2',
      delivery_dependent_creative_limited: 'DELIVERY_DEPENDENT_CREATIVE_LIMITED',
      delivery_error: 'DELIVERY_ERROR',
      delivery_error_v2: 'DELIVERY_ERROR_V2',
      delivery_warning: 'DELIVERY_WARNING',
      dynamic_advantage_campaign_budget: 'DYNAMIC_ADVANTAGE_CAMPAIGN_BUDGET',
      ecosystem_bid_reduce_l1_cardinality: 'ECOSYSTEM_BID_REDUCE_L1_CARDINALITY',
      email_capture_upsell_guidance: 'EMAIL_CAPTURE_UPSELL_GUIDANCE',
      enable_whats_app_ads_data_sharing: 'ENABLE_WHATS_APP_ADS_DATA_SHARING',
      engaged_view_conversions_creation: 'ENGAGED_VIEW_CONVERSIONS_CREATION',
      evc_app_duplication_upgrade: 'EVC_APP_DUPLICATION_UPGRADE',
      evc_web_duplication_upgrade: 'EVC_WEB_DUPLICATION_UPGRADE',
      f2_conversion_location: 'F2_CONVERSION_LOCATION',
      fragmentation: 'FRAGMENTATION',
      fragmentation_resolution_update: 'FRAGMENTATION_RESOLUTION_UPDATE',
      fragmentation_v2: 'FRAGMENTATION_V2',
      fragmentation_v3: 'FRAGMENTATION_V3',
      fragmentation_v4: 'FRAGMENTATION_V4',
      generative_uncrop_duplication: 'GENERATIVE_UNCROP_DUPLICATION',
      gen_ai_mvp: 'GEN_AI_MVP',
      ges_test: 'GES_TEST',
      guidance_center_code_gen: 'GUIDANCE_CENTER_CODE_GEN',
      heuristic_default_duration: 'HEURISTIC_DEFAULT_DURATION',
      high_cost: 'HIGH_COST',
      historical_benchmark: 'HISTORICAL_BENCHMARK',
      iaa_roas_optimization: 'IAA_ROAS_OPTIMIZATION',
      ig_multi_ads: 'IG_MULTI_ADS',
      ig_surfaces_manual_placements: 'IG_SURFACES_MANUAL_PLACEMENTS',
      incremental_attribution: 'INCREMENTAL_ATTRIBUTION',
      instant_forms_leads: 'INSTANT_FORMS_LEADS',
      in_app_ad_impression_roas_android: 'IN_APP_AD_IMPRESSION_ROAS_ANDROID',
      landing_page_view: 'LANDING_PAGE_VIEW',
      landing_page_view_optimization_goal: 'LANDING_PAGE_VIEW_OPTIMIZATION_GOAL',
      landing_page_view_optimization_goal_v2: 'LANDING_PAGE_VIEW_OPTIMIZATION_GOAL_V2',
      landing_page_view_precreate: 'LANDING_PAGE_VIEW_PRECREATE',
      lead_ads_dfca_lookalike_adoption: 'LEAD_ADS_DFCA_LOOKALIKE_ADOPTION',
      lead_ads_guidance: 'LEAD_ADS_GUIDANCE',
      learning_limited: 'LEARNING_LIMITED',
      learning_pause_friction: 'LEARNING_PAUSE_FRICTION',
      learning_phase_budget_edits: 'LEARNING_PHASE_BUDGET_EDITS',
      live_video_ads: 'LIVE_VIDEO_ADS',
      low_budget_utilization: 'LOW_BUDGET_UTILIZATION',
      low_outcome: 'LOW_OUTCOME',
      marketing_messages: 'MARKETING_MESSAGES',
      merlin_guidance: 'MERLIN_GUIDANCE',
      messaging_events: 'MESSAGING_EVENTS',
      messaging_events_precreate: 'MESSAGING_EVENTS_PRECREATE',
      messaging_partners: 'MESSAGING_PARTNERS',
      messaging_partners_precreate: 'MESSAGING_PARTNERS_PRECREATE',
      messaging_partners_v2: 'MESSAGING_PARTNERS_V2',
      meta_verified_ads_performance_guidance: 'META_VERIFIED_ADS_PERFORMANCE_GUIDANCE',
      missing_or_invalid_parameters: 'MISSING_OR_INVALID_PARAMETERS',
      mixed_formats: 'MIXED_FORMATS',
      mixed_formats_v2: 'MIXED_FORMATS_V2',
      mixed_formats_v3: 'MIXED_FORMATS_V3',
      mixed_pa_combine_adsets: 'MIXED_PA_COMBINE_ADSETS',
      mmt_carousel_to_video: 'MMT_CAROUSEL_TO_VIDEO',
      mobile_first_creative: 'MOBILE_FIRST_CREATIVE',
      mobile_first_video: 'MOBILE_FIRST_VIDEO',
      mr_aemv2sub_kconsolidation: 'MR_AEMV2SUB_KCONSOLIDATION',
      multi_advertiser_ads: 'MULTI_ADVERTISER_ADS',
      multi_text: 'MULTI_TEXT',
      music: 'MUSIC',
      music_v2: 'MUSIC_V2',
      narrow_website_custom_audience: 'NARROW_WEBSITE_CUSTOM_AUDIENCE',
      not_applicable: 'NOT_APPLICABLE',
      no_delivery_status: 'NO_DELIVERY_STATUS',
      offsite_conversion: 'OFFSITE_CONVERSION',
      offsite_conversion_ar: 'OFFSITE_CONVERSION_AR',
      offsite_conversion_based_on_signals: 'OFFSITE_CONVERSION_BASED_ON_SIGNALS',
      offsite_conversion_leads_optimization: 'OFFSITE_CONVERSION_LEADS_OPTIMIZATION',
      offsite_conversion_v2: 'OFFSITE_CONVERSION_V2',
      omni_optimization: 'OMNI_OPTIMIZATION',
      optimal_bau: 'OPTIMAL_BAU',
      outcome_forecaster_budget_recommendation: 'OUTCOME_FORECASTER_BUDGET_RECOMMENDATION',
      outcome_forecaster_shadow_logging: 'OUTCOME_FORECASTER_SHADOW_LOGGING',
      partnership_ads: 'PARTNERSHIP_ADS',
      partnership_ads_dynamic_header: 'PARTNERSHIP_ADS_DYNAMIC_HEADER',
      payment_method: 'PAYMENT_METHOD',
      performant_creative_reels_opt_in: 'PERFORMANT_CREATIVE_REELS_OPT_IN',
      performant_creative_reels_opt_in_v2: 'PERFORMANT_CREATIVE_REELS_OPT_IN_V2',
      pfr_l1_inline_mmt: 'PFR_L1_INLINE_MMT',
      pixelless_lpv_optimization_goal: 'PIXELLESS_LPV_OPTIMIZATION_GOAL',
      pixel_optimization_aam: 'PIXEL_OPTIMIZATION_AAM',
      pixel_optimization_aam_precreate: 'PIXEL_OPTIMIZATION_AAM_PRECREATE',
      pixel_optimization_hie: 'PIXEL_OPTIMIZATION_HIE',
      pixel_optimization_hie_precreate: 'PIXEL_OPTIMIZATION_HIE_PRECREATE',
      pixel_optimization_hie_v2: 'PIXEL_OPTIMIZATION_HIE_V2',
      pixel_setup: 'PIXEL_SETUP',
      pixel_setup_precreate: 'PIXEL_SETUP_PRECREATE',
      pixel_upsell: 'PIXEL_UPSELL',
      pixel_upsell_v2: 'PIXEL_UPSELL_V2',
      placements_liquidity_automatic_guidance: 'PLACEMENTS_LIQUIDITY_AUTOMATIC_GUIDANCE',
      predictive_creative_limited: 'PREDICTIVE_CREATIVE_LIMITED',
      predictive_creative_limited_hourly: 'PREDICTIVE_CREATIVE_LIMITED_HOURLY',
      preparing_status: 'PREPARING_STATUS',
      product_extensions_guidance: 'PRODUCT_EXTENSIONS_GUIDANCE',
      product_set_boosting: 'PRODUCT_SET_BOOSTING',
      promo_ads_upsell_guidance: 'PROMO_ADS_UPSELL_GUIDANCE',
      purchase_optimization: 'PURCHASE_OPTIMIZATION',
      rapid_learning_limited: 'RAPID_LEARNING_LIMITED',
      rapid_learning_phase: 'RAPID_LEARNING_PHASE',
      reach_optimization_goal: 'REACH_OPTIMIZATION_GOAL',
      reach_optimization_goal_precreate: 'REACH_OPTIMIZATION_GOAL_PRECREATE',
      reels_duplication_upsell: 'REELS_DUPLICATION_UPSELL',
      reels_music_duplication: 'REELS_MUSIC_DUPLICATION',
      reels_pc_and_mobile_first_creative: 'REELS_PC_AND_MOBILE_FIRST_CREATIVE',
      reels_pc_recommendation: 'REELS_PC_RECOMMENDATION',
      reels_pc_recommendation_v2: 'REELS_PC_RECOMMENDATION_V2',
      reels_performant_creative: 'REELS_PERFORMANT_CREATIVE',
      reels_placement: 'REELS_PLACEMENT',
      revert: 'REVERT',
      review_creative_duplicated_rejected_ads: 'REVIEW_CREATIVE_DUPLICATED_REJECTED_ADS',
      sabr_default_duration: 'SABR_DEFAULT_DURATION',
      sales_conversion: 'SALES_CONVERSION',
      saved_audience: 'SAVED_AUDIENCE',
      scale_good_campaign: 'SCALE_GOOD_CAMPAIGN',
      scale_good_campaign_duplication: 'SCALE_GOOD_CAMPAIGN_DUPLICATION',
      scale_good_campaign_smb: 'SCALE_GOOD_CAMPAIGN_SMB',
      scale_good_campaign_v2: 'SCALE_GOOD_CAMPAIGN_V2',
      scale_good_campaign_v2_duplication: 'SCALE_GOOD_CAMPAIGN_V2_DUPLICATION',
      scale_good_ctx_campaign: 'SCALE_GOOD_CTX_CAMPAIGN',
      scale_good_ctx_campaigns_duplication: 'SCALE_GOOD_CTX_CAMPAIGNS_DUPLICATION',
      seasonal_campaigns: 'SEASONAL_CAMPAIGNS',
      semantic_based_audience_duplication: 'SEMANTIC_BASED_AUDIENCE_DUPLICATION',
      semantic_based_audience_expansion: 'SEMANTIC_BASED_AUDIENCE_EXPANSION',
      setup_pixel: 'SETUP_PIXEL',
      shops_ads: 'SHOPS_ADS',
      shops_ads_duplication: 'SHOPS_ADS_DUPLICATION',
      shops_ads_saoff: 'SHOPS_ADS_SAOFF',
      shops_ads_traffic_cap_settings: 'SHOPS_ADS_TRAFFIC_CAP_SETTINGS',
      shop_ads_v2: 'SHOP_ADS_V2',
      signals_down_funnel_event_optimization: 'SIGNALS_DOWN_FUNNEL_EVENT_OPTIMIZATION',
      signals_growth_capi: 'SIGNALS_GROWTH_CAPI',
      signals_growth_capi_precreate: 'SIGNALS_GROWTH_CAPI_PRECREATE',
      signals_growth_capi_table: 'SIGNALS_GROWTH_CAPI_TABLE',
      signals_growth_capi_v2: 'SIGNALS_GROWTH_CAPI_V2',
      signals_vo_using_co_model: 'SIGNALS_VO_USING_CO_MODEL',
      similar_advertiser_budget_recommendation: 'SIMILAR_ADVERTISER_BUDGET_RECOMMENDATION',
      site_extensions_duplication: 'SITE_EXTENSIONS_DUPLICATION',
      site_extensions_guidance: 'SITE_EXTENSIONS_GUIDANCE',
      six_plus_manual_placements: 'SIX_PLUS_MANUAL_PLACEMENTS',
      six_plus_placements_duplication: 'SIX_PLUS_PLACEMENTS_DUPLICATION',
      spend_limit: 'SPEND_LIMIT',
      syd_test_mode: 'SYD_TEST_MODE',
      tailored_lead_ad_campaign: 'TAILORED_LEAD_AD_CAMPAIGN',
      tailored_messages_campaign: 'TAILORED_MESSAGES_CAMPAIGN',
      targeting_creative_fragmentation: 'TARGETING_CREATIVE_FRAGMENTATION',
      threeco_web_plus_app_upsell: 'THREECO_WEB_PLUS_APP_UPSELL',
      tla_creation_package: 'TLA_CREATION_PACKAGE',
      top_adsets_with_ads_under_cap: 'TOP_ADSETS_WITH_ADS_UNDER_CAP',
      top_campaigns_with_ads_under_cap: 'TOP_CAMPAIGNS_WITH_ADS_UNDER_CAP',
      two_p_guidance_card_aaa: 'TWO_P_GUIDANCE_CARD_AAA',
      two_p_guidance_card_auto_placement: 'TWO_P_GUIDANCE_CARD_AUTO_PLACEMENT',
      two_p_guidance_card_cbo_off: 'TWO_P_GUIDANCE_CARD_CBO_OFF',
      two_p_guidance_card_ctm_preflight: 'TWO_P_GUIDANCE_CARD_CTM_PREFLIGHT',
      uncrop_image: 'UNCROP_IMAGE',
      uneconomical_ads_throttling: 'UNECONOMICAL_ADS_THROTTLING',
      unified_inbox: 'UNIFIED_INBOX',
      unused_budget: 'UNUSED_BUDGET',
      upper_funnel_to_lead_instant_form: 'UPPER_FUNNEL_TO_LEAD_INSTANT_FORM',
      value_co_campaigns_low_purchase_dq: 'VALUE_CO_CAMPAIGNS_LOW_PURCHASE_DQ',
      value_diagnostics_guidance: 'VALUE_DIAGNOSTICS_GUIDANCE',
      value_optimization_goal: 'VALUE_OPTIMIZATION_GOAL',
      value_rules_guidance: 'VALUE_RULES_GUIDANCE',
      video_length: 'VIDEO_LENGTH',
      video_views_upsell: 'VIDEO_VIEWS_UPSELL',
      video_views_upsell_precreate: 'VIDEO_VIEWS_UPSELL_PRECREATE',
      vo_in_app_purchase: 'VO_IN_APP_PURCHASE',
      vo_vt_1d_defaulting: 'VO_VT_1D_DEFAULTING',
      wa_messaging_partners: 'WA_MESSAGING_PARTNERS',
      wa_messaging_partners_precreate: 'WA_MESSAGING_PARTNERS_PRECREATE',
      wa_messaging_partners_v2: 'WA_MESSAGING_PARTNERS_V2',
      website_and_calls_upsell: 'WEBSITE_AND_CALLS_UPSELL',
      website_and_instant_form_l2: 'WEBSITE_AND_INSTANT_FORM_L2',
      web_engaged_view_conversions: 'WEB_ENGAGED_VIEW_CONVERSIONS',
      wtwa_upsell_in_duplication: 'WTWA_UPSELL_IN_DUPLICATION',
      wtwa_upsell_in_syd_and_am_table: 'WTWA_UPSELL_IN_SYD_AND_AM_TABLE',
      yi_test: 'YI_TEST',
      zero_conversion: 'ZERO_CONVERSION',
      zero_impression: 'ZERO_IMPRESSION',
      zero_outcome_budget: 'ZERO_OUTCOME_BUDGET',
    });
  }
}
