 /*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @flow
 */

import {AbstractCrudObject} from './../abstract-crud-object';
import Cursor from './../cursor';
import AdsInsights from './ads-insights';
import FacebookAdsApi from './../api';

/**
 * AdReportRun
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */
export default class AdReportRun extends AbstractCrudObject {
  static get Fields (): Object {
    return Object.freeze({
      account_id: 'account_id',
      async_percent_completion: 'async_percent_completion',
      async_report_url: 'async_report_url',
      async_status: 'async_status',
      date_start: 'date_start',
      date_stop: 'date_stop',
      emails: 'emails',
      error_code: 'error_code',
      friendly_name: 'friendly_name',
      id: 'id',
      is_async_export: 'is_async_export',
      is_bookmarked: 'is_bookmarked',
      is_running: 'is_running',
      schedule_id: 'schedule_id',
      time_completed: 'time_completed',
      time_ref: 'time_ref',
    });
  }


  getInsights (fields: Array<string>, params: Object = {}, fetchFirstPage: boolean = true): Cursor | Promise<*> {
    return this.getEdge(
      AdsInsights,
      fields,
      params,
      fetchFirstPage,
      '/insights'
    );
  }

  
  get (fields: Array<string>, params: Object = {}): AdReportRun {
    // $FlowFixMe : Support Generic Types
    return this.read(
      fields,
      params
    );
  }

  constructor(
    id: number | ?string = null,
    data: Object = {},
    parentId: ?string,
    api: ?FacebookAdsApi,
  ) {
    super();
    this.id = data.report_run_id;
  }
}
