 /*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @flow
 */

import {AbstractCrudObject} from './../abstract-crud-object';

/**
 * AdCustomDerivedMetrics
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */
export default class AdCustomDerivedMetrics extends AbstractCrudObject {
  static get Fields (): Object {
    return Object.freeze({
      ad_account_id: 'ad_account_id',
      business: 'business',
      creation_time: 'creation_time',
      creator: 'creator',
      custom_derived_metric_type: 'custom_derived_metric_type',
      deletion_time: 'deletion_time',
      deletor: 'deletor',
      description: 'description',
      format_type: 'format_type',
      formula: 'formula',
      has_attribution_windows: 'has_attribution_windows',
      has_inline_attribution_window: 'has_inline_attribution_window',
      id: 'id',
      name: 'name',
      permission: 'permission',
      saved_report_id: 'saved_report_id',
      scope: 'scope',
    });
  }

  static get Scope (): Object {
    return Object.freeze({
      account: 'ACCOUNT',
      business: 'BUSINESS',
      business_asset_group: 'BUSINESS_ASSET_GROUP',
    });
  }

  
  get (fields: Array<string>, params: Object = {}): AdCustomDerivedMetrics {
    // $FlowFixMe : Support Generic Types
    return this.read(
      fields,
      params
    );
  }
}
