 /*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @flow
 */

import {AbstractCrudObject} from './../abstract-crud-object';

/**
 * MessagingAppsInfo
 * @extends AbstractCrudObject
 * @see {@link https://developers.facebook.com/docs/marketing-api/}
 */
export default class MessagingAppsInfo extends AbstractCrudObject {
  static get Fields (): Object {
    return Object.freeze({
      ctd_support_only_for_ig_app: 'ctd_support_only_for_ig_app',
      has_instagram_messaging_permission: 'has_instagram_messaging_permission',
      has_messenger_messaging_permission: 'has_messenger_messaging_permission',
      id: 'id',
      name: 'name',
    });
  }

}
